/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.repository.upc.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.nosql.NosqlClient;
import com.ohaotian.plugin.nosql.bo.NosqlAddSingleReqBO;
import com.ohaotian.plugin.nosql.bo.NosqlAddSingleRsqBO;
import com.ohaotian.plugin.nosql.bo.NosqlBO;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsindexMappingUpcBO;
import com.tydic.dyc.pro.base.common.mybatis.LambdaQueryWrapperX;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.dao.CommUpcDetailsInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommUpcInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommUpcPicInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommUpcPriceChangeRecordMapper;
import com.tydic.dyc.pro.dmc.po.CommUpcDetailsInfoPO;
import com.tydic.dyc.pro.dmc.po.CommUpcInfoPO;
import com.tydic.dyc.pro.dmc.po.CommUpcPicInfoPO;
import com.tydic.dyc.pro.dmc.po.CommUpcPriceChangeRecordPO;
import com.tydic.dyc.pro.dmc.repository.upc.api.DycProCommUpcRepository;
import com.tydic.dyc.pro.dmc.repository.upc.dto.DycProCommUpcDetailsInfoDTO;
import com.tydic.dyc.pro.dmc.repository.upc.dto.DycProCommUpcInfoDTO;
import com.tydic.dyc.pro.dmc.repository.upc.dto.DycProCommUpcPicInfoDTO;
import com.tydic.dyc.pro.dmc.repository.upc.dto.DycProCommUpcPriceChangeRecordDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class DycProCommUpcRepositoryImpl
implements DycProCommUpcRepository {
    private static final Logger log = LoggerFactory.getLogger(DycProCommUpcRepositoryImpl.class);
    @Autowired
    private CommUpcInfoMapper commUpcInfoMapper;
    @Autowired
    private CommUpcDetailsInfoMapper commUpcDetailsInfoMapper;
    @Autowired
    private CommUpcPicInfoMapper commUpcPicInfoMapper;
    @Autowired
    private CommUpcPriceChangeRecordMapper commUpcPriceChangeRecordMapper;
    @Autowired
    private NosqlClient nosqlClient;
    @Value(value="${ucc.es.upc.index:dyc_pro_upc}")
    private String upcIndexName;

    @Override
    public DycProCommUpcInfoDTO getUpcMainInfoOneByCondition(DycProCommUpcInfoDTO upcInfoDto) {
        CommUpcInfoPO commUpcInfoPO = (CommUpcInfoPO)this.commUpcInfoMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(null != upcInfoDto.getExtUpcId(), CommUpcInfoPO::getExtUpcId, (Object)upcInfoDto.getExtUpcId())).eq(null != upcInfoDto.getUpcId(), CommUpcInfoPO::getUpcId, (Object)upcInfoDto.getUpcId()));
        if (null == commUpcInfoPO) {
            return null;
        }
        DycProCommUpcInfoDTO dycProCommUpcInfoDTO = new DycProCommUpcInfoDTO();
        BeanUtils.copyProperties((Object)commUpcInfoPO, (Object)dycProCommUpcInfoDTO);
        return dycProCommUpcInfoDTO;
    }

    @Override
    public List<DycProCommUpcInfoDTO> qryUpcInfoAll(DycProCommUpcInfoDTO reqDTO) {
        LambdaQueryWrapperX queryWrapper = new LambdaQueryWrapperX();
        queryWrapper.eqIfPresent(CommUpcInfoPO::getDelFlag, (Object)DycProCommConstants.DelFlag.NO).inIfPresent(CommUpcInfoPO::getUpcId, reqDTO.getUpcIds()).eqIfPresent(CommUpcInfoPO::getUpcStatus, (Object)reqDTO.getUpcStatus()).eqIfPresent(CommUpcInfoPO::getSkuId, (Object)reqDTO.getSkuId());
        List commUpcInfoPOS = this.commUpcInfoMapper.selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)commUpcInfoPOS)) {
            return JSON.parseArray((String)JSON.toJSONString((Object)commUpcInfoPOS), DycProCommUpcInfoDTO.class);
        }
        return Collections.emptyList();
    }

    @Override
    public Long addUpcAllInfo(DycProCommUpcInfoDTO upcInfoDto) {
        Long upcId = Sequence.getInstance().nextId();
        CommUpcInfoPO addUpcInfoPO = new CommUpcInfoPO();
        BeanUtils.copyProperties((Object)upcInfoDto, (Object)addUpcInfoPO);
        addUpcInfoPO.setUpcId(upcId);
        addUpcInfoPO.setDelFlag(DycProCommConstants.DelFlag.NO);
        addUpcInfoPO.setCreateTime(new Date());
        this.commUpcInfoMapper.insert((Object)addUpcInfoPO);
        if (null != upcInfoDto.getUpcDetails()) {
            CommUpcDetailsInfoPO addUpcDetailsInfoPO = new CommUpcDetailsInfoPO();
            BeanUtils.copyProperties((Object)upcInfoDto.getUpcDetails(), (Object)addUpcDetailsInfoPO);
            addUpcDetailsInfoPO.setDetailId(Long.valueOf(Sequence.getInstance().nextId()));
            addUpcDetailsInfoPO.setUpcId(upcId);
            this.commUpcDetailsInfoMapper.insert((Object)addUpcDetailsInfoPO);
        }
        if (!CollectionUtils.isEmpty(upcInfoDto.getUpcPicInfoList())) {
            ArrayList<CommUpcPicInfoPO> addUpcPicPoList = new ArrayList<CommUpcPicInfoPO>();
            for (DycProCommUpcPicInfoDTO upcPicInfoDTO : upcInfoDto.getUpcPicInfoList()) {
                CommUpcPicInfoPO upcPicInfoPO = new CommUpcPicInfoPO();
                BeanUtils.copyProperties((Object)upcPicInfoDTO, (Object)upcPicInfoPO);
                upcPicInfoPO.setUpcId(upcId);
                upcPicInfoPO.setPicId(Long.valueOf(Sequence.getInstance().nextId()));
                addUpcPicPoList.add(upcPicInfoPO);
            }
            this.commUpcPicInfoMapper.insertBatch(addUpcPicPoList);
        }
        DycProEsindexMappingUpcBO dycProEsindexMappingUpcBO = (DycProEsindexMappingUpcBO)JSON.parseObject((String)JSON.toJSONString((Object)addUpcInfoPO), DycProEsindexMappingUpcBO.class);
        this.sysnAddUpcInfo(dycProEsindexMappingUpcBO);
        return upcId;
    }

    @Override
    public void addUpcInfo(DycProCommUpcInfoDTO upcInfoDto) {
        Long upcId = Sequence.getInstance().nextId();
        CommUpcInfoPO addUpcInfoPO = new CommUpcInfoPO();
        BeanUtils.copyProperties((Object)upcInfoDto, (Object)addUpcInfoPO);
        addUpcInfoPO.setUpcId(upcId);
        addUpcInfoPO.setDelFlag(DycProCommConstants.DelFlag.NO);
        addUpcInfoPO.setUpcStatus(DycProCommConstants.UpcStatus.DRAFT);
        addUpcInfoPO.setCreateTime(new Date());
        this.commUpcInfoMapper.insert((Object)addUpcInfoPO);
    }

    @Override
    public void updateUpcInfo(DycProCommUpcInfoDTO upcInfoDto) {
        CommUpcInfoPO addUpcInfoPO = new CommUpcInfoPO();
        BeanUtils.copyProperties((Object)upcInfoDto, (Object)addUpcInfoPO);
        addUpcInfoPO.setUpdateTime(new Date());
        this.commUpcInfoMapper.updateById((Object)addUpcInfoPO);
    }

    @Override
    public RspPage<DycProCommUpcInfoDTO> qryUpcInfoListPage(DycProCommUpcInfoDTO reqDTO) {
        RspPage rspPage = new RspPage();
        Page pg = new Page((long)reqDTO.getPageNo(), (long)reqDTO.getPageSize());
        LambdaQueryWrapperX queryWrapper = new LambdaQueryWrapperX();
        queryWrapper.eqIfPresent(CommUpcInfoPO::getDelFlag, (Object)DycProCommConstants.DelFlag.NO).eqIfPresent(CommUpcInfoPO::getCreateUserId, (Object)reqDTO.getCreateUserId()).eqIfPresent(CommUpcInfoPO::getUpcId, (Object)reqDTO.getUpcId()).eqIfPresent(CommUpcInfoPO::getSupplierId, (Object)reqDTO.getSupplierId()).eqIfPresent(CommUpcInfoPO::getUpcStatus, (Object)reqDTO.getUpcStatus()).likeIfPresent(CommUpcInfoPO::getSkuCode, reqDTO.getSkuCode()).likeIfPresent(CommUpcInfoPO::getSkuName, reqDTO.getSkuName()).likeIfPresent(CommUpcInfoPO::getUpcName, reqDTO.getUpcName()).likeIfPresent(CommUpcInfoPO::getSupplierName, reqDTO.getSupplierName()).likeIfPresent(CommUpcInfoPO::getMCode, reqDTO.getMCode()).likeIfPresent(CommUpcInfoPO::getCreateUserName, reqDTO.getCreateUserName()).inIfPresent(CommUpcInfoPO::getUpcStatus, reqDTO.getUpcStatusList()).geIfPresent(CommUpcInfoPO::getCreateTime, (Object)reqDTO.getCreateStartTime()).leIfPresent(CommUpcInfoPO::getCreateTime, (Object)reqDTO.getCreateEndTime()).orderByDesc(CommUpcInfoPO::getCreateTime);
        Page result = (Page)this.commUpcInfoMapper.selectPage((IPage)pg, (Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)result.getRecords())) {
            rspPage.setRows(JSON.parseArray((String)JSON.toJSONString((Object)result.getRecords()), DycProCommUpcInfoDTO.class));
        }
        rspPage.setPageNo((int)result.getCurrent());
        rspPage.setTotal((int)result.getPages());
        rspPage.setRecordsTotal((int)result.getTotal());
        return rspPage;
    }

    public void sysnAddUpcInfo(DycProEsindexMappingUpcBO mappingUpcBO) {
        NosqlAddSingleReqBO nosqlAddSingleReqBO = new NosqlAddSingleReqBO();
        nosqlAddSingleReqBO.setIndex(this.upcIndexName);
        NosqlBO nosqlBO = new NosqlBO();
        nosqlBO.setId(String.valueOf(mappingUpcBO.getUpcId()));
        nosqlBO.setObject((Object)mappingUpcBO);
        nosqlAddSingleReqBO.setNosqlBO(nosqlBO);
        log.debug("upcEs\u540c\u6b65\u65b0\u589e\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)nosqlAddSingleReqBO));
        NosqlAddSingleRsqBO nosqlAddSingleRsqBO = this.nosqlClient.addSingle(nosqlAddSingleReqBO);
        log.debug("upcEs\u540c\u6b65\u65b0\u589e\u63a5\u53e3\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)nosqlAddSingleRsqBO));
        if (!"0000".equals(nosqlAddSingleRsqBO.getRespCode())) {
            throw new ZTBusinessException("upcEs\u540c\u6b65\u65b0\u589e\u540c\u6b65nosql\u5f02\u5e38:" + nosqlAddSingleRsqBO.getRespDesc());
        }
    }

    @Override
    public DycProCommUpcInfoDTO getUpcDetails(DycProCommUpcInfoDTO upcInfoDto) {
        List resultUpcPicInfo;
        DycProCommUpcInfoDTO upcInfoDTO = new DycProCommUpcInfoDTO();
        CommUpcInfoPO resultUpcInfo = (CommUpcInfoPO)this.commUpcInfoMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(CommUpcInfoPO::getUpcId, (Object)upcInfoDto.getUpcId()));
        BeanUtils.copyProperties((Object)resultUpcInfo, (Object)upcInfoDTO);
        CommUpcDetailsInfoPO resultUpcDetailsInfo = (CommUpcDetailsInfoPO)this.commUpcDetailsInfoMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(CommUpcDetailsInfoPO::getUpcId, (Object)upcInfoDto.getUpcId()));
        if (!ObjectUtils.isEmpty((Object)resultUpcDetailsInfo)) {
            upcInfoDTO.setUpcDetails((DycProCommUpcDetailsInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)resultUpcDetailsInfo), DycProCommUpcDetailsInfoDTO.class));
        }
        if (!CollectionUtils.isEmpty((Collection)(resultUpcPicInfo = this.commUpcPicInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(CommUpcPicInfoPO::getUpcId, (Object)upcInfoDto.getUpcId()))))) {
            upcInfoDTO.setUpcPicInfoList(JSON.parseArray((String)JSON.toJSONString((Object)resultUpcPicInfo), DycProCommUpcPicInfoDTO.class));
        }
        return upcInfoDTO;
    }

    @Override
    public List<DycProCommUpcPriceChangeRecordDTO> getUpcPriceChangeRecordList(DycProCommUpcPriceChangeRecordDTO upcPriceChangeRecordDto) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(CommUpcPriceChangeRecordPO::getUpcId, (Object)upcPriceChangeRecordDto.getUpcId());
        List pos = this.commUpcPriceChangeRecordMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)pos)) {
            return null;
        }
        return JSONArray.parseArray((String)JSON.toJSONString((Object)pos), DycProCommUpcPriceChangeRecordDTO.class);
    }
}

