/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.mq.consumer;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.dyc.pro.dmc.service.api.DycProCommAddCheckRecordForConsumerService;
import com.tydic.dyc.pro.dmc.service.api.DycProCommExecCheckRuleForConsumerService;
import com.tydic.dyc.pro.dmc.service.api.DycProCommUpdateCheckRecordForConsumerService;
import com.tydic.dyc.pro.dmc.service.api.DycProCommUpdateCheckResultForConsumerService;
import com.tydic.dyc.pro.dmc.service.bo.DycProCommAddCheckRecordForConsumerReqBO;
import com.tydic.dyc.pro.dmc.service.bo.DycProCommAddCheckRecordForConsumerRspBO;
import com.tydic.dyc.pro.dmc.service.bo.DycProCommExecCheckRuleForConsumerReqBO;
import com.tydic.dyc.pro.dmc.service.bo.DycProCommUpdateCheckRecordForConsumerReqBO;
import com.tydic.dyc.pro.dmc.service.bo.DycProCommUpdateCheckRecordForConsumerRspBO;
import com.tydic.dyc.pro.dmc.service.bo.DycProCommUpdateCheckResultForConsumerReqBO;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

public class DycProCommExecCheckRuleConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(DycProCommExecCheckRuleConsumer.class);
    @Autowired
    private DycProCommExecCheckRuleForConsumerService dycProCommExecCheckRuleForConsumerService;
    @Autowired
    private DycProCommUpdateCheckResultForConsumerService dycProCommUpdateCheckResultForConsumerService;
    @Autowired
    private DycProCommAddCheckRecordForConsumerService dycProCommAddCheckRecordForConsumerService;
    @Autowired
    private DycProCommUpdateCheckRecordForConsumerService dycProCommUpdateCheckRecordForConsumerService;
    @Value(value="${comm.checkrule.topic}")
    private String commCheckRuleTopic;
    @Value(value="${comm.checkrule.tag}")
    private String commCheckRuleTag;
    @Resource(name="dycProCmmCheckRuleMqServiceProvider")
    private ProxyMessageProducer dycProCmmCheckRuleMqServiceProvider;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        log.info("\u68c0\u6d4b\u6536\u5230\u6d88\u606f{}", (Object)message.getContent());
        DycProCommExecCheckRuleForConsumerReqBO reqBO = (DycProCommExecCheckRuleForConsumerReqBO)JSONObject.parseObject((String)message.getContent(), DycProCommExecCheckRuleForConsumerReqBO.class);
        try {
            if ("addCheckRecord".equals(reqBO.getType())) {
                DycProCommUpdateCheckRecordForConsumerReqBO updateCheckRecordForConsumerReqBO = new DycProCommUpdateCheckRecordForConsumerReqBO();
                updateCheckRecordForConsumerReqBO.setCheckObjId(reqBO.getExecCheckRuleParamBO().getCheckObjId());
                updateCheckRecordForConsumerReqBO.setCheckRuleType(reqBO.getExecCheckRuleParamBO().getCheckRuleType());
                DycProCommUpdateCheckRecordForConsumerRspBO dycProCommUpdateCheckRecordForConsumerRspBO = this.dycProCommUpdateCheckRecordForConsumerService.updateCheckRecord(updateCheckRecordForConsumerReqBO);
                DycProCommAddCheckRecordForConsumerReqBO dycProCommAddCheckRecordForConsumerReqBO = new DycProCommAddCheckRecordForConsumerReqBO();
                dycProCommAddCheckRecordForConsumerReqBO.setExecCheckRuleParamBO(reqBO.getExecCheckRuleParamBO());
                dycProCommAddCheckRecordForConsumerReqBO.setCheckSnIds(dycProCommUpdateCheckRecordForConsumerRspBO.getCheckSnIds());
                DycProCommAddCheckRecordForConsumerRspBO rspBO = this.dycProCommAddCheckRecordForConsumerService.addCheckRecordForConsumer(dycProCommAddCheckRecordForConsumerReqBO);
                if (rspBO != null && !CollectionUtils.isEmpty(rspBO.getCheckRecordForConsumerBOs())) {
                    rspBO.getCheckRecordForConsumerBOs().forEach(dycProCommCheckRecordForConsumerBO -> {
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("type", (Object)"execRule");
                        jsonObject.put("checkRecordForConsumerBO", dycProCommCheckRecordForConsumerBO);
                        jsonObject.put("checkRuleNum", (Object)rspBO.getCheckRecordForConsumerBOs().size());
                        jsonObject.put("checkSnIds", dycProCommUpdateCheckRecordForConsumerRspBO.getCheckSnIds());
                        this.dycProCmmCheckRuleMqServiceProvider.send(new ProxyMessage(this.commCheckRuleTopic, this.commCheckRuleTag, jsonObject.toJSONString()));
                    });
                }
            } else if ("execRule".equals(reqBO.getType())) {
                this.dycProCommExecCheckRuleForConsumerService.dealCheckRuleExec(reqBO);
                DycProCommUpdateCheckResultForConsumerReqBO resultForConsumerReqBO = new DycProCommUpdateCheckResultForConsumerReqBO();
                resultForConsumerReqBO.setCheckRecordForConsumerBO(reqBO.getCheckRecordForConsumerBO());
                resultForConsumerReqBO.setCheckRuleNum(reqBO.getCheckRuleNum());
                resultForConsumerReqBO.setCheckSnIds(reqBO.getCheckSnIds());
                this.dycProCommUpdateCheckResultForConsumerService.updateCheckResult(resultForConsumerReqBO);
            }
        }
        catch (Exception e) {
            log.error("\u5546\u54c1\u68c0\u6d4b\u6d88\u8d39\u8005\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }
}

