/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.sync.upc.impl;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.nosql.NosqlClient;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingSkuBO;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingSkuInUpcBO;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsindexMappingUpcBO;
import com.tydic.dyc.pro.dmc.dao.CommSkuInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommSkuPicInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommSkuPriceInfoMapper;
import com.tydic.dyc.pro.dmc.repository.sku.api.DycProCommSkuRepository;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuHandleDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuQryDTO;
import com.tydic.dyc.pro.dmc.repository.upc.api.DycProCommUpcRepository;
import com.tydic.dyc.pro.dmc.repository.upc.dto.DycProCommUpcInfoDTO;
import com.tydic.dyc.pro.dmc.sync.upc.api.DycProCommSyncExtUpcInfoService;
import com.tydic.dyc.pro.dmc.sync.upc.bo.DycProCommSyncExtUpcInfoReqBO;
import com.tydic.dyc.pro.dmc.sync.upc.bo.DycProCommSyncExtUpcInfoRspBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.sync.upc.api.DycProCommSyncExtUpcInfoService"})
public class DycProCommSyncExtUpcInfoServiceImpl
implements DycProCommSyncExtUpcInfoService {
    private static final Logger log = LoggerFactory.getLogger(DycProCommSyncExtUpcInfoServiceImpl.class);
    @Autowired
    private DycProCommUpcRepository dycProCommUpcRepository;
    @Autowired
    private DycProCommSkuRepository dycProCommSkuRepository;
    @Autowired
    private NosqlClient nosqlClient;
    @Value(value="${ucc.es.upc.index:dyc_pro_upc}")
    private String upcIndexName;
    @Autowired
    private CommSkuInfoMapper commSkuInfoMapper;
    @Autowired
    private CommSkuPriceInfoMapper commSkuPriceInfoMapper;
    @Autowired
    private CommSkuPicInfoMapper commSkuPicInfoMapper;

    @Override
    @PostMapping(value={"syncExtUpcInfo"})
    public DycProCommSyncExtUpcInfoRspBO syncExtUpcInfo(@RequestBody DycProCommSyncExtUpcInfoReqBO reqBO) {
        if (reqBO.getSyncEsSwitch().booleanValue()) {
            return this.fullSynchronization(reqBO);
        }
        this.paramVerify(reqBO);
        DycProCommUpcInfoDTO queryUpcInfoDto = new DycProCommUpcInfoDTO();
        queryUpcInfoDto.setExtUpcId(reqBO.getExtUpcId());
        DycProCommUpcInfoDTO queryUpcInfoResultDto = this.dycProCommUpcRepository.getUpcMainInfoOneByCondition(queryUpcInfoDto);
        DycProCommUpcInfoDTO upcInfo = new DycProCommUpcInfoDTO();
        if (null == queryUpcInfoResultDto) {
            DycProCommUpcInfoDTO addUpcInfoDto = (DycProCommUpcInfoDTO)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), DycProCommUpcInfoDTO.class);
            Long upcId = this.dycProCommUpcRepository.addUpcAllInfo(addUpcInfoDto);
            BeanUtils.copyProperties((Object)reqBO, (Object)upcInfo);
            upcInfo.setUpcId(upcId);
        } else {
            upcInfo = queryUpcInfoResultDto;
        }
        if (reqBO.getSkuId() != null) {
            DycProCommSkuHandleDTO skuHandleDto = new DycProCommSkuHandleDTO();
            skuHandleDto.setSkuId(reqBO.getSkuId());
            skuHandleDto.setUpcId(upcInfo.getUpcId());
            upcInfo.setCreateTime(new Date());
            skuHandleDto.setUpcInfo(upcInfo);
            this.dycProCommSkuRepository.updateSkuUpcInfoBySkuIdAndSyncNosql(skuHandleDto);
        }
        return new DycProCommSyncExtUpcInfoRspBO();
    }

    private DycProCommSyncExtUpcInfoRspBO fullSynchronization(DycProCommSyncExtUpcInfoReqBO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getUpcIds())) {
            throw new ZTBusinessException("[upcIds]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DycProCommUpcInfoDTO queryUpcInfoDto = new DycProCommUpcInfoDTO();
        queryUpcInfoDto.setUpcIds(reqBO.getUpcIds());
        List dycProCommUpcInfoDTOS = this.dycProCommUpcRepository.qryUpcInfoAll(queryUpcInfoDto);
        if (dycProCommUpcInfoDTOS != null && !dycProCommUpcInfoDTOS.isEmpty()) {
            List collect = dycProCommUpcInfoDTOS.stream().map(DycProCommUpcInfoDTO::getUpcId).collect(Collectors.toList());
            DycProCommSkuQryDTO dto = new DycProCommSkuQryDTO();
            dto.setUpcIds(collect);
            List skuBOS = this.dycProCommSkuRepository.qrySkuList(dto);
            Map<Long, List<DycProEsIndexMappingSkuBO>> upcSkuMap = skuBOS.stream().collect(Collectors.groupingBy(DycProEsIndexMappingSkuBO::getUpcId));
            ArrayList<DycProEsindexMappingUpcBO> mappingUpcBOList = new ArrayList<DycProEsindexMappingUpcBO>();
            for (DycProCommUpcInfoDTO dycProCommUpcInfoDTO : dycProCommUpcInfoDTOS) {
                DycProEsindexMappingUpcBO dycProEsindexMappingUpcBO = new DycProEsindexMappingUpcBO();
                BeanUtils.copyProperties((Object)dycProCommUpcInfoDTO, (Object)dycProEsindexMappingUpcBO);
                if (StringUtils.isNotBlank((String)dycProEsindexMappingUpcBO.getManageCatalogPath())) {
                    String[] split = dycProEsindexMappingUpcBO.getManageCatalogPath().split("-");
                    ArrayList<Long> manageCatalogIdList = new ArrayList<Long>();
                    for (String s : split) {
                        String trimmed;
                        if (s == null || (trimmed = s.trim()).isEmpty()) continue;
                        try {
                            manageCatalogIdList.add(Long.valueOf(trimmed));
                        }
                        catch (NumberFormatException e) {
                            throw new ZTBusinessException("sku\u6807\u51c6\u5546\u54c1\u4fe1\u606f\u540c\u6b65nosql\u5f02\u5e38: \u975e\u6570\u5b57\u5b57\u7b26\u4e32:" + s);
                        }
                    }
                    dycProEsindexMappingUpcBO.setManageCatalogIdList(manageCatalogIdList);
                }
                if (upcSkuMap.containsKey(dycProCommUpcInfoDTO.getUpcId())) {
                    List<DycProEsIndexMappingSkuBO> skuInfoList = upcSkuMap.get(dycProCommUpcInfoDTO.getUpcId());
                    dycProEsindexMappingUpcBO.setSkuNum(Integer.valueOf(skuInfoList.size()));
                    dycProEsindexMappingUpcBO.setSupplierIdList(skuInfoList.stream().map(DycProEsIndexMappingSkuBO::getSupplierId).distinct().collect(Collectors.toList()));
                    List skuList = JSON.parseArray((String)JSON.toJSONString(upcSkuMap.get(dycProCommUpcInfoDTO.getUpcId())), DycProEsIndexMappingSkuInUpcBO.class);
                    dycProEsindexMappingUpcBO.setSkuList(skuList);
                } else {
                    dycProEsindexMappingUpcBO.setSkuNum(Integer.valueOf(0));
                }
                mappingUpcBOList.add(dycProEsindexMappingUpcBO);
            }
            this.dycProCommSkuRepository.sysnAddUpcInfo(mappingUpcBOList);
        }
        return new DycProCommSyncExtUpcInfoRspBO();
    }

    private void paramVerify(DycProCommSyncExtUpcInfoReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)reqBO.getExtUpcId())) {
            throw new ZTBusinessException("\u5916\u90e8\u6807\u51c6\u5546\u54c1id[extUpcId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)reqBO.getUpcCode())) {
            throw new ZTBusinessException("\u6807\u51c6\u5546\u54c1\u7f16\u7801[upcCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)reqBO.getUpcName())) {
            throw new ZTBusinessException("\u6807\u51c6\u5546\u54c1\u540d\u79f0[upcName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

