/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.ecs.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.tydic.dyc.pro.base.bo.DycProBaseManagePageRspBO;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingSkuBO;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainAgrStatus;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainAgrType;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommCheckSenceEnum;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtil;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilGetSkuDetailForJdReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilGetSkuDetailForJdResultBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilGetSkuDetailForJdRspBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilGetSkuDetailReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilGetSkuDetailRspBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilGetSkuImageForJdReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilGetSkuImageForJdResultBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilGetSkuImageForJdRspBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilGetSkuImageReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilGetSkuImageResultBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilGetSkuImageRspBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilGetSkuPriceForJdReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilGetSkuPriceForJdResultBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilGetSkuPriceForJdRspBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilGetSkuPriceReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilGetSkuPriceResultBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilGetSkuPriceRspBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilSkuInfoBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilSkuParamBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilSkuParamForJdBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilSkuPicBO;
import com.tydic.dyc.pro.dmc.dao.AgrCooperationCatalogMapper;
import com.tydic.dyc.pro.dmc.dao.AgrItemMapper;
import com.tydic.dyc.pro.dmc.dao.AgrMainMapper;
import com.tydic.dyc.pro.dmc.dao.CommSkuInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommSkuPriceInfoMapper;
import com.tydic.dyc.pro.dmc.ecs.constants.ECommoditySyncConstant;
import com.tydic.dyc.pro.dmc.ecs.service.api.DycProCommDealWaitMsgService;
import com.tydic.dyc.pro.dmc.ecs.service.bo.DycProCommDealSkuMsgForCheckParamBO;
import com.tydic.dyc.pro.dmc.ecs.service.bo.DycProCommDealSkuMsgRspBO;
import com.tydic.dyc.pro.dmc.ecs.service.bo.DycProCommDealWaitMsgReqBO;
import com.tydic.dyc.pro.dmc.ecs.service.bo.DycProCommDealWaitMsgRspBO;
import com.tydic.dyc.pro.dmc.po.AgrCooperationCatalogPO;
import com.tydic.dyc.pro.dmc.po.AgrItemPO;
import com.tydic.dyc.pro.dmc.po.AgrMainPO;
import com.tydic.dyc.pro.dmc.po.CommSkuInfoPO;
import com.tydic.dyc.pro.dmc.repository.checkrule.api.DycProCommCheckRecordRepository;
import com.tydic.dyc.pro.dmc.repository.extSkuMsgRecord.api.DycProCommExtSkuMessageRecordsRepository;
import com.tydic.dyc.pro.dmc.repository.extSkuMsgRecord.dto.DycProCommExtSkuMessageRecordsDTO;
import com.tydic.dyc.pro.dmc.repository.extSkuMsgRecord.dto.DycProCommExtSkuMessageRecordsQueryDTO;
import com.tydic.dyc.pro.dmc.repository.managecatalog.api.DycProCommManageCatalogRepository;
import com.tydic.dyc.pro.dmc.repository.managecatalog.dto.DycProCommManageCatalogDTO;
import com.tydic.dyc.pro.dmc.repository.managecatalog.dto.DycProCommPropertyTemplateInfoDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.api.DycProCommPriceRuleInfoRepository;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommSkuPriceInfoDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommSkuPriceInfoHandleDTO;
import com.tydic.dyc.pro.dmc.repository.sensitiveword.api.DycProCommSensitiveWordInfoRepository;
import com.tydic.dyc.pro.dmc.repository.sensitiveword.dto.DycProCommSensitiveWordInfoDTO;
import com.tydic.dyc.pro.dmc.repository.sku.api.DycProCommSkuRepository;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuDetailsInfoDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuPicInfoDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuQryDTO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycProCommDealWaitMsgServiceImpl
implements DycProCommDealWaitMsgService {
    @Value(value="${is.need.image-text.check}")
    private String isNeedImageTextCheck;
    @Value(value="${is.need.price.check}")
    private String isNeedPriceCheck;
    @Value(value="${call.esb.url.getSkuDetail}")
    private String callEsbUrlGetSkuDetail;
    @Value(value="${call.esb.url.getSkuImage}")
    private String callEsbUrlGetSkuImage;
    @Value(value="${call.esb.url.getSkuPrice}")
    private String callEsbUrlGetSkuPrice;
    @Value(value="${call.esb.url.getSkuVisitorPrice}")
    private String callEsbUrlGetSkuVisitorPrice;
    @Value(value="${jd.sku.img.url.prex}")
    private String jdSkuImgPrex;
    @Autowired
    private DycProCommExtSkuMessageRecordsRepository dycProCommExtSkuMessageRecordsRepository;
    @Autowired
    private DycProCommSkuRepository dycProCommSkuRepository;
    @Autowired
    private DycProCommManageCatalogRepository dycProCommManageCatalogRepository;
    @Autowired
    private DycProCommSensitiveWordInfoRepository dycProCommSensitiveWordInfoRepository;
    @Autowired
    private DycProCommCheckRecordRepository dycProCommCheckRecordRepository;
    @Autowired
    private DycProCommPriceRuleInfoRepository dycProCommPriceRuleInfoRepository;
    @Autowired
    private AgrMainMapper agrMainMapper;
    @Autowired
    private AgrItemMapper agrItemMapper;
    @Autowired
    private AgrCooperationCatalogMapper agrCooperationCatalogMapper;
    @Autowired
    private CommSkuInfoMapper commSkuInfoMapper;
    @Autowired
    private CommSkuPriceInfoMapper commSkuPriceInfoMapper;

    @Override
    public DycProCommDealWaitMsgRspBO dealWaitMsg(DycProCommDealWaitMsgReqBO reqBO) {
        DycProCommExtSkuMessageRecordsDTO infoChangeWaitRecordDto = null;
        DycProCommExtSkuMessageRecordsDTO priceChangeWaitRecordDto = null;
        ArrayList<DycProCommDealSkuMsgForCheckParamBO> dealSkuMsgForCheckParamBOS = new ArrayList<DycProCommDealSkuMsgForCheckParamBO>();
        DycProCommExtSkuMessageRecordsQueryDTO qryRecordsDto = new DycProCommExtSkuMessageRecordsQueryDTO();
        qryRecordsDto.setSupplierHsn(reqBO.getSupplierHsn());
        qryRecordsDto.setMessageStatus(ECommoditySyncConstant.MessageStatus.WAITING);
        qryRecordsDto.setExtSkuId(reqBO.getExtSkuId());
        List waitRecordsDtoList = this.dycProCommExtSkuMessageRecordsRepository.selectMessageRecordsByCondition(qryRecordsDto);
        if (!CollectionUtils.isEmpty((Collection)waitRecordsDtoList)) {
            for (DycProCommExtSkuMessageRecordsDTO msgRecord : waitRecordsDtoList) {
                if ("16".equals(msgRecord.getMessageType())) {
                    infoChangeWaitRecordDto = new DycProCommExtSkuMessageRecordsDTO();
                    BeanUtils.copyProperties((Object)msgRecord, (Object)infoChangeWaitRecordDto);
                    continue;
                }
                if (!"2".equals(msgRecord.getMessageType())) continue;
                priceChangeWaitRecordDto = new DycProCommExtSkuMessageRecordsDTO();
                BeanUtils.copyProperties((Object)msgRecord, (Object)priceChangeWaitRecordDto);
            }
        }
        ArrayList<DycProCommExtSkuMessageRecordsDTO> dealMsgResultList = new ArrayList<DycProCommExtSkuMessageRecordsDTO>();
        if (null != infoChangeWaitRecordDto) {
            DycProCommExtSkuMessageRecordsDTO recordsResult;
            DycProCommDealSkuMsgRspBO dealInfoChangeMsgRspBo = new DycProCommDealSkuMsgRspBO();
            dealInfoChangeMsgRspBo = "jd".equals(reqBO.getSupplierHsn()) || "jdvop".equals(reqBO.getSupplierHsn()) ? this.dealInfoChangeMsgForJd(reqBO) : this.dealInfoChangeMsg(reqBO);
            if ("0000".equals(dealInfoChangeMsgRspBo.getRespCode())) {
                recordsResult = this.setMsgDealResultSuccess(infoChangeWaitRecordDto);
                dealMsgResultList.add(recordsResult);
                DycProCommDealSkuMsgForCheckParamBO dealSkuMsgForCheckParamBO = new DycProCommDealSkuMsgForCheckParamBO();
                dealSkuMsgForCheckParamBO.setCheckSceneCode(DmcCommCheckSenceEnum.CHANGE_GOODS.getCode());
                dealSkuMsgForCheckParamBO.setCheckObjId(dealInfoChangeMsgRspBo.getSkuInfo().getSkuId());
                dealSkuMsgForCheckParamBOS.add(dealSkuMsgForCheckParamBO);
            } else {
                recordsResult = this.setMsgDealResultFail(infoChangeWaitRecordDto, dealInfoChangeMsgRspBo.getRespDesc());
                dealMsgResultList.add(recordsResult);
            }
        }
        if (null != priceChangeWaitRecordDto) {
            DycProCommDealSkuMsgRspBO dealPriceChangeMsgRspBo = new DycProCommDealSkuMsgRspBO();
            DycProCommSkuQryDTO reqDto = new DycProCommSkuQryDTO();
            reqDto.setSkuId(reqBO.getSkuId());
            DycProBaseManagePageRspBO esSkuInfoList = this.dycProCommSkuRepository.qryEsSkuListPage(reqDto);
            DycProEsIndexMappingSkuBO esSkuInfo = (DycProEsIndexMappingSkuBO)esSkuInfoList.getRows().get(0);
            BigDecimal oldSupplierPrice = ((DycProEsIndexMappingSkuBO)esSkuInfoList.getRows().get(0)).getSupplierPrice();
            dealPriceChangeMsgRspBo = "jd".equals(reqBO.getSupplierHsn()) || "jdvop".equals(reqBO.getSupplierHsn()) ? this.dealPriceChangeMsgForJd(reqBO, esSkuInfo) : this.dealPriceChangeMsg(reqBO, esSkuInfo);
            if ("0000".equals(dealPriceChangeMsgRspBo.getRespCode())) {
                DycProCommExtSkuMessageRecordsDTO recordsResult = this.setMsgDealResultSuccess(priceChangeWaitRecordDto);
                dealMsgResultList.add(recordsResult);
                DycProCommDealSkuMsgForCheckParamBO dealSkuMsgForCheckParamBO = new DycProCommDealSkuMsgForCheckParamBO();
                dealSkuMsgForCheckParamBO.setCheckSceneCode(DmcCommCheckSenceEnum.CHANGE_GOODS_PRICE.getCode());
                dealSkuMsgForCheckParamBO.setCheckObjId(dealPriceChangeMsgRspBo.getSkuInfo().getSkuId());
                dealSkuMsgForCheckParamBOS.add(dealSkuMsgForCheckParamBO);
            } else {
                DycProCommExtSkuMessageRecordsDTO recordsResult = this.setMsgDealResultFail(priceChangeWaitRecordDto, dealPriceChangeMsgRspBo.getRespDesc());
                dealMsgResultList.add(recordsResult);
            }
        }
        if (!CollectionUtils.isEmpty(dealMsgResultList)) {
            this.dycProCommExtSkuMessageRecordsRepository.batchUpdateMessageRecordsByIds(dealMsgResultList);
        }
        DycProCommDealWaitMsgRspBO rspBO = new DycProCommDealWaitMsgRspBO();
        rspBO.setRespDesc("0000");
        rspBO.setRespDesc("\u7b49\u5f85\u6d88\u606f\u5904\u7406\u5b8c\u6210");
        rspBO.setDealSkuMsgForCheckParamBOS(dealSkuMsgForCheckParamBOS);
        return rspBO;
    }

    private DycProCommDealSkuMsgRspBO dealPriceChangeMsgForJd(DycProCommDealWaitMsgReqBO reqBO, DycProEsIndexMappingSkuBO esSkuInfo) {
        DycProCommDealSkuMsgRspBO dealMsgRspBO = new DycProCommDealSkuMsgRspBO();
        DycProBaseCallEsbUtilGetSkuPriceForJdReqBO callEsbUtilGetSkuPriceReqBO = new DycProBaseCallEsbUtilGetSkuPriceForJdReqBO();
        callEsbUtilGetSkuPriceReqBO.setHsn(reqBO.getSupplierHsn());
        callEsbUtilGetSkuPriceReqBO.setSku(reqBO.getExtSkuId());
        callEsbUtilGetSkuPriceReqBO.setUrl(this.callEsbUrlGetSkuPrice);
        DycProBaseCallEsbUtilGetSkuPriceForJdRspBO getSkuPriceResult = DycProBaseCallEsbUtil.getSkuPriceForJd((DycProBaseCallEsbUtilGetSkuPriceForJdReqBO)callEsbUtilGetSkuPriceReqBO);
        if (!getSkuPriceResult.getSuccess().booleanValue() || !"0000".equals(getSkuPriceResult.getResultCode())) {
            dealMsgRspBO.setRespCode(getSkuPriceResult.getResultCode());
            dealMsgRspBO.setRespDesc(getSkuPriceResult.getResultMessage());
            return dealMsgRspBO;
        }
        DycProBaseCallEsbUtilGetSkuPriceReqBO callEsbUtilGetSkuVisitorPriceReqBO = new DycProBaseCallEsbUtilGetSkuPriceReqBO();
        ArrayList<String> extSkus = new ArrayList<String>();
        extSkus.add(reqBO.getExtSkuId());
        callEsbUtilGetSkuVisitorPriceReqBO.setHsn(reqBO.getSupplierHsn());
        callEsbUtilGetSkuVisitorPriceReqBO.setSku(extSkus);
        callEsbUtilGetSkuVisitorPriceReqBO.setUrl(this.callEsbUrlGetSkuVisitorPrice);
        DycProBaseCallEsbUtilGetSkuPriceRspBO getSkuVisitorPriceResult = DycProBaseCallEsbUtil.getSkuVisitorsPrice((DycProBaseCallEsbUtilGetSkuPriceReqBO)callEsbUtilGetSkuVisitorPriceReqBO);
        if (!getSkuVisitorPriceResult.getSuccess().booleanValue() || !"0000".equals(getSkuVisitorPriceResult.getResultCode())) {
            dealMsgRspBO.setRespCode(getSkuVisitorPriceResult.getResultCode());
            dealMsgRspBO.setRespDesc(getSkuVisitorPriceResult.getResultMessage());
            return dealMsgRspBO;
        }
        DycProCommDealSkuMsgRspBO verifyRspBO = this.skuPriceVerifyForJd(getSkuPriceResult, getSkuVisitorPriceResult, reqBO, esSkuInfo);
        if ("0000".equals(verifyRspBO.getRespCode())) {
            this.dycProCommSkuRepository.updateSkuPriceInfoAndSyncNosql(verifyRspBO.getSkuInfo());
            dealMsgRspBO.setRespCode("0000");
            dealMsgRspBO.setRespDesc("\u4ef7\u683c\u53d8\u66f4\u6d88\u606f\u5904\u7406\u5b8c\u6210");
            DycProCommSkuDTO skuInfo = new DycProCommSkuDTO();
            BeanUtils.copyProperties((Object)verifyRspBO.getSkuInfo(), (Object)skuInfo);
            dealMsgRspBO.setSkuInfo(skuInfo);
            return dealMsgRspBO;
        }
        dealMsgRspBO.setRespCode(verifyRspBO.getRespCode());
        dealMsgRspBO.setRespDesc(verifyRspBO.getRespDesc());
        return dealMsgRspBO;
    }

    private DycProCommDealSkuMsgRspBO skuPriceVerifyForJd(DycProBaseCallEsbUtilGetSkuPriceForJdRspBO getSkuPriceResult, DycProBaseCallEsbUtilGetSkuPriceRspBO getSkuVisitorPriceResult, DycProCommDealWaitMsgReqBO reqBO, DycProEsIndexMappingSkuBO esSkuInfo) {
        DycProCommDealSkuMsgRspBO verifyResult = new DycProCommDealSkuMsgRspBO();
        DycProCommSkuDTO skuInfoDto = new DycProCommSkuDTO();
        DycProCommSkuPriceInfoDTO skuPriceInfoDTO = new DycProCommSkuPriceInfoDTO();
        skuInfoDto.setSkuId(reqBO.getSkuId());
        skuInfoDto.setSupplierId(esSkuInfo.getSupplierId());
        if (CollectionUtils.isEmpty((Collection)getSkuPriceResult.getResult())) {
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u65e0\u4ef7\u683c\u4fe1\u606f");
            return verifyResult;
        }
        skuPriceInfoDTO.setSkuId(reqBO.getSkuId());
        skuPriceInfoDTO.setPriority(Integer.valueOf(0));
        BigDecimal supplierPrice = ((DycProBaseCallEsbUtilGetSkuPriceForJdResultBO)getSkuPriceResult.getResult().get(0)).getPrice();
        skuPriceInfoDTO.setSupplierPrice(supplierPrice);
        BigDecimal marketPrice = ((DycProBaseCallEsbUtilGetSkuPriceForJdResultBO)getSkuPriceResult.getResult().get(0)).getJdPrice();
        skuPriceInfoDTO.setMarketPrice(marketPrice);
        if (ECommoditySyncConstant.TradeMode.MATCH.equals(esSkuInfo.getTradeMode())) {
            skuPriceInfoDTO.setSalePrice(supplierPrice);
        } else {
            DycProCommSkuPriceInfoHandleDTO handleDTO = new DycProCommSkuPriceInfoHandleDTO();
            handleDTO.setSupplierPrice(skuPriceInfoDTO.getSupplierPrice());
            handleDTO.setMarketPrice(skuPriceInfoDTO.getMarketPrice());
            handleDTO.setSupplierId(reqBO.getSupplierId());
            handleDTO.setAgrId(reqBO.getAgrId());
            handleDTO.setSkuId(reqBO.getSkuId());
            handleDTO.setManageCatalogPath(esSkuInfo.getManageCatalogPath());
            handleDTO.setPriceRuleType(Integer.valueOf(2));
            DycProCommSkuPriceInfoDTO computeSkuPriceResultDto = this.dycProCommPriceRuleInfoRepository.computeSkuPrice(handleDTO);
            if (null != computeSkuPriceResultDto) {
                skuPriceInfoDTO.setSalePrice(computeSkuPriceResultDto.getSalePrice());
                skuPriceInfoDTO.setPriceRuleId(computeSkuPriceResultDto.getPriceRuleId());
                skuPriceInfoDTO.setPriceRiseType(computeSkuPriceResultDto.getPriceRiseType());
                skuPriceInfoDTO.setPriceRiseRate(computeSkuPriceResultDto.getPriceRiseRate());
                skuPriceInfoDTO.setLadderPriceRule(computeSkuPriceResultDto.getLadderPriceRule());
            }
        }
        skuPriceInfoDTO.setCreateTime(new Date());
        skuPriceInfoDTO.setEffDate(new Date());
        BigDecimal discountRate = supplierPrice.divide(marketPrice, 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
        skuPriceInfoDTO.setDiscountRate(discountRate);
        skuPriceInfoDTO.setChngReason("\u7535\u5546\u53d8\u4ef7");
        if (CollectionUtils.isEmpty((Collection)getSkuVisitorPriceResult.getResult())) {
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u65e0\u6e38\u5ba2\u4ef7\u683c\u4fe1\u606f");
            return verifyResult;
        }
        skuPriceInfoDTO.setVisitorPrice(BigDecimal.valueOf(((DycProBaseCallEsbUtilGetSkuPriceResultBO)getSkuVisitorPriceResult.getResult().get(0)).getVisitorsPrice()));
        skuInfoDto.setPriceInfo(skuPriceInfoDTO);
        verifyResult.setRespCode("0000");
        verifyResult.setRespDesc("\u5b8c\u6574\u6027\u6821\u9a8c\u6210\u529f");
        verifyResult.setSkuInfo(skuInfoDto);
        return verifyResult;
    }

    private DycProCommDealSkuMsgRspBO dealPriceChangeMsg(DycProCommDealWaitMsgReqBO reqBO, DycProEsIndexMappingSkuBO esSkuInfo) {
        DycProCommDealSkuMsgRspBO dealMsgRspBO = new DycProCommDealSkuMsgRspBO();
        DycProBaseCallEsbUtilGetSkuPriceReqBO callEsbUtilGetSkuPriceReqBO = new DycProBaseCallEsbUtilGetSkuPriceReqBO();
        callEsbUtilGetSkuPriceReqBO.setHsn(reqBO.getSupplierHsn());
        ArrayList<String> sku = new ArrayList<String>();
        sku.add(reqBO.getExtSkuId());
        callEsbUtilGetSkuPriceReqBO.setSku(sku);
        callEsbUtilGetSkuPriceReqBO.setUrl(this.callEsbUrlGetSkuPrice);
        DycProBaseCallEsbUtilGetSkuPriceRspBO getSkuPriceResult = DycProBaseCallEsbUtil.getSkuPrice((DycProBaseCallEsbUtilGetSkuPriceReqBO)callEsbUtilGetSkuPriceReqBO);
        if (!getSkuPriceResult.getSuccess().booleanValue() || !"0000".equals(getSkuPriceResult.getResultCode())) {
            dealMsgRspBO.setRespCode(getSkuPriceResult.getResultCode());
            dealMsgRspBO.setRespDesc(getSkuPriceResult.getResultMessage());
            return dealMsgRspBO;
        }
        DycProBaseCallEsbUtilGetSkuPriceReqBO callEsbUtilGetSkuVisitorPriceReqBO = new DycProBaseCallEsbUtilGetSkuPriceReqBO();
        callEsbUtilGetSkuVisitorPriceReqBO.setHsn(reqBO.getSupplierHsn());
        callEsbUtilGetSkuVisitorPriceReqBO.setSku(sku);
        callEsbUtilGetSkuVisitorPriceReqBO.setUrl(this.callEsbUrlGetSkuVisitorPrice);
        DycProBaseCallEsbUtilGetSkuPriceRspBO getSkuVisitorPriceResult = DycProBaseCallEsbUtil.getSkuVisitorsPrice((DycProBaseCallEsbUtilGetSkuPriceReqBO)callEsbUtilGetSkuVisitorPriceReqBO);
        if (!getSkuVisitorPriceResult.getSuccess().booleanValue() || !"0000".equals(getSkuVisitorPriceResult.getResultCode())) {
            dealMsgRspBO.setRespCode(getSkuVisitorPriceResult.getResultCode());
            dealMsgRspBO.setRespDesc(getSkuVisitorPriceResult.getResultMessage());
            return dealMsgRspBO;
        }
        DycProBaseCallEsbUtilGetSkuPriceForJdRspBO getSkuJdPriceResult = null;
        DycProCommDealSkuMsgRspBO verifyRspBO = this.skuPriceVerify(getSkuPriceResult, getSkuVisitorPriceResult, getSkuJdPriceResult, reqBO, esSkuInfo);
        if ("0000".equals(verifyRspBO.getRespCode())) {
            this.dycProCommSkuRepository.updateSkuPriceInfoAndSyncNosql(verifyRspBO.getSkuInfo());
            dealMsgRspBO.setRespCode("0000");
            dealMsgRspBO.setRespDesc("\u4ef7\u683c\u53d8\u66f4\u6d88\u606f\u5904\u7406\u5b8c\u6210");
            DycProCommSkuDTO skuInfo = new DycProCommSkuDTO();
            BeanUtils.copyProperties((Object)verifyRspBO.getSkuInfo(), (Object)skuInfo);
            dealMsgRspBO.setSkuInfo(skuInfo);
            return dealMsgRspBO;
        }
        dealMsgRspBO.setRespCode(verifyRspBO.getRespCode());
        dealMsgRspBO.setRespDesc(verifyRspBO.getRespDesc());
        return dealMsgRspBO;
    }

    private DycProCommDealSkuMsgRspBO skuPriceVerify(DycProBaseCallEsbUtilGetSkuPriceRspBO getSkuPriceResult, DycProBaseCallEsbUtilGetSkuPriceRspBO getSkuVisitorPriceResult, DycProBaseCallEsbUtilGetSkuPriceForJdRspBO getSkuJdPriceResult, DycProCommDealWaitMsgReqBO reqBO, DycProEsIndexMappingSkuBO esSkuInfo) {
        DycProCommDealSkuMsgRspBO verifyResult = new DycProCommDealSkuMsgRspBO();
        DycProCommSkuDTO skuInfoDto = new DycProCommSkuDTO();
        DycProCommSkuPriceInfoDTO skuPriceInfoDTO = new DycProCommSkuPriceInfoDTO();
        skuInfoDto.setSkuId(reqBO.getSkuId());
        skuInfoDto.setSupplierId(esSkuInfo.getSupplierId());
        if (CollectionUtils.isEmpty((Collection)getSkuPriceResult.getResult())) {
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u65e0\u4ef7\u683c\u4fe1\u606f");
            return verifyResult;
        }
        skuPriceInfoDTO.setSkuId(reqBO.getSkuId());
        skuPriceInfoDTO.setPriority(Integer.valueOf(0));
        skuPriceInfoDTO.setSupplierPrice(BigDecimal.valueOf(((DycProBaseCallEsbUtilGetSkuPriceResultBO)getSkuPriceResult.getResult().get(0)).getPrice()));
        skuPriceInfoDTO.setMarketPrice(BigDecimal.valueOf(((DycProBaseCallEsbUtilGetSkuPriceResultBO)getSkuPriceResult.getResult().get(0)).getEcPrice()));
        if (ECommoditySyncConstant.TradeMode.MATCH.equals(esSkuInfo.getTradeMode())) {
            skuPriceInfoDTO.setSalePrice(BigDecimal.valueOf(((DycProBaseCallEsbUtilGetSkuPriceResultBO)getSkuPriceResult.getResult().get(0)).getPrice()));
        } else {
            DycProCommSkuPriceInfoHandleDTO handleDTO = new DycProCommSkuPriceInfoHandleDTO();
            handleDTO.setSupplierPrice(skuPriceInfoDTO.getSupplierPrice());
            handleDTO.setMarketPrice(skuPriceInfoDTO.getMarketPrice());
            handleDTO.setSupplierId(reqBO.getSupplierId());
            handleDTO.setAgrId(reqBO.getAgrId());
            handleDTO.setSkuId(reqBO.getSkuId());
            handleDTO.setManageCatalogPath(esSkuInfo.getManageCatalogPath());
            handleDTO.setPriceRuleType(Integer.valueOf(2));
            DycProCommSkuPriceInfoDTO computeSkuPriceResultDto = this.dycProCommPriceRuleInfoRepository.computeSkuPrice(handleDTO);
            if (null != computeSkuPriceResultDto) {
                skuPriceInfoDTO.setSalePrice(computeSkuPriceResultDto.getSalePrice());
                skuPriceInfoDTO.setPriceRuleId(computeSkuPriceResultDto.getPriceRuleId());
                skuPriceInfoDTO.setPriceRiseType(computeSkuPriceResultDto.getPriceRiseType());
                skuPriceInfoDTO.setPriceRiseRate(computeSkuPriceResultDto.getPriceRiseRate());
                skuPriceInfoDTO.setLadderPriceRule(computeSkuPriceResultDto.getLadderPriceRule());
            }
        }
        skuPriceInfoDTO.setCreateTime(new Date());
        skuPriceInfoDTO.setEffDate(new Date());
        skuPriceInfoDTO.setDiscountRate(new BigDecimal(new DecimalFormat("0.0000").format(((DycProBaseCallEsbUtilGetSkuPriceResultBO)getSkuPriceResult.getResult().get(0)).getPrice() / ((DycProBaseCallEsbUtilGetSkuPriceResultBO)getSkuPriceResult.getResult().get(0)).getEcPrice() * 100.0)));
        skuPriceInfoDTO.setChngReason("\u7535\u5546\u53d8\u4ef7");
        if (CollectionUtils.isEmpty((Collection)getSkuVisitorPriceResult.getResult())) {
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u65e0\u6e38\u5ba2\u4ef7\u683c\u4fe1\u606f");
            return verifyResult;
        }
        skuPriceInfoDTO.setVisitorPrice(BigDecimal.valueOf(((DycProBaseCallEsbUtilGetSkuPriceResultBO)getSkuVisitorPriceResult.getResult().get(0)).getVisitorsPrice()));
        skuInfoDto.setPriceInfo(skuPriceInfoDTO);
        verifyResult.setRespCode("0000");
        verifyResult.setRespDesc("\u5b8c\u6574\u6027\u6821\u9a8c\u6210\u529f");
        verifyResult.setSkuInfo(skuInfoDto);
        return verifyResult;
    }

    private DycProCommDealSkuMsgRspBO dealInfoChangeMsg(DycProCommDealWaitMsgReqBO reqBO) {
        DycProCommDealSkuMsgRspBO dealMsgRspBO = new DycProCommDealSkuMsgRspBO();
        DycProBaseCallEsbUtilGetSkuDetailReqBO callEsbUtilGetSkuDetailReqBO = new DycProBaseCallEsbUtilGetSkuDetailReqBO();
        callEsbUtilGetSkuDetailReqBO.setHsn(reqBO.getSupplierHsn());
        ArrayList<String> sku = new ArrayList<String>();
        sku.add(reqBO.getExtSkuId());
        callEsbUtilGetSkuDetailReqBO.setSku(sku);
        callEsbUtilGetSkuDetailReqBO.setUrl(this.callEsbUrlGetSkuDetail);
        DycProBaseCallEsbUtilGetSkuDetailRspBO getSkuDetailResult = DycProBaseCallEsbUtil.getSkuDetail((DycProBaseCallEsbUtilGetSkuDetailReqBO)callEsbUtilGetSkuDetailReqBO);
        if (!getSkuDetailResult.getSuccess().booleanValue() || !"0000".equals(getSkuDetailResult.getResultCode())) {
            dealMsgRspBO.setRespCode(getSkuDetailResult.getResultCode());
            dealMsgRspBO.setRespDesc(getSkuDetailResult.getResultMessage());
            return dealMsgRspBO;
        }
        DycProBaseCallEsbUtilGetSkuImageReqBO callEsbUtilGetSkuImageReqBO = new DycProBaseCallEsbUtilGetSkuImageReqBO();
        callEsbUtilGetSkuImageReqBO.setHsn(reqBO.getSupplierHsn());
        callEsbUtilGetSkuImageReqBO.setSku(sku);
        callEsbUtilGetSkuImageReqBO.setUrl(this.callEsbUrlGetSkuImage);
        DycProBaseCallEsbUtilGetSkuImageRspBO getSkuImageResult = DycProBaseCallEsbUtil.getSkuImage((DycProBaseCallEsbUtilGetSkuImageReqBO)callEsbUtilGetSkuImageReqBO);
        if (!getSkuImageResult.getSuccess().booleanValue() || !"0000".equals(getSkuImageResult.getResultCode())) {
            dealMsgRspBO.setRespCode(getSkuImageResult.getResultCode());
            dealMsgRspBO.setRespDesc(getSkuImageResult.getResultMessage());
            return dealMsgRspBO;
        }
        DycProBaseCallEsbUtilSkuInfoBO esbSkuInfoBO = (DycProBaseCallEsbUtilSkuInfoBO)getSkuDetailResult.getResult().getSkuGroup().get(0);
        DycProBaseCallEsbUtilGetSkuPriceForJdRspBO getSkuJdPriceResult = null;
        DycProCommDealSkuMsgRspBO verifyRspBO = this.skuInfoVerify(getSkuDetailResult, getSkuImageResult, getSkuJdPriceResult, reqBO);
        if ("0000".equals(verifyRspBO.getRespCode())) {
            DycProEsIndexMappingSkuBO esIndexMappingSkuBO = this.dycProCommSkuRepository.updateSkuCompleteInfoAndSyncNosql(verifyRspBO.getSkuInfo());
            dealMsgRspBO.setRespCode("0000");
            dealMsgRspBO.setRespDesc("\u4fe1\u606f\u53d8\u66f4\u6d88\u606f\u5904\u7406\u5b8c\u6210");
            DycProCommSkuDTO skuInfo = new DycProCommSkuDTO();
            BeanUtils.copyProperties((Object)verifyRspBO.getSkuInfo(), (Object)skuInfo);
            dealMsgRspBO.setSkuInfo(skuInfo);
            dealMsgRspBO.setEsSkuInfo(esIndexMappingSkuBO);
            return dealMsgRspBO;
        }
        dealMsgRspBO.setRespCode(verifyRspBO.getRespCode());
        dealMsgRspBO.setRespDesc(verifyRspBO.getRespDesc());
        return dealMsgRspBO;
    }

    private DycProCommDealSkuMsgRspBO skuInfoVerify(DycProBaseCallEsbUtilGetSkuDetailRspBO getSkuDetailResult, DycProBaseCallEsbUtilGetSkuImageRspBO getSkuImageResult, DycProBaseCallEsbUtilGetSkuPriceForJdRspBO getSkuJdPriceResult, DycProCommDealWaitMsgReqBO reqBO) {
        CommSkuInfoPO existSkuInfoPo;
        DycProCommDealSkuMsgRspBO verifyResult = new DycProCommDealSkuMsgRspBO();
        DycProCommSkuDTO skuInfoDto = new DycProCommSkuDTO();
        DycProCommSkuDetailsInfoDTO skuDetailsInfoDTO = new DycProCommSkuDetailsInfoDTO();
        ArrayList<DycProCommSkuPicInfoDTO> skuPicInfoList = new ArrayList<DycProCommSkuPicInfoDTO>();
        DycProBaseCallEsbUtilSkuInfoBO esbSkuInfoBO = (DycProBaseCallEsbUtilSkuInfoBO)getSkuDetailResult.getResult().getSkuGroup().get(0);
        skuInfoDto.setSkuId(reqBO.getSkuId());
        if (StringUtils.isBlank((String)esbSkuInfoBO.getSku())) {
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u65e0sku\u7f16\u53f7\u4fe1\u606f");
            return verifyResult;
        }
        skuInfoDto.setExtSkuId(esbSkuInfoBO.getSku());
        if (StringUtils.isBlank((String)esbSkuInfoBO.getName())) {
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u65e0sku\u540d\u79f0\u4fe1\u606f");
            return verifyResult;
        }
        List sensitiveWordInfoDTOS = this.dycProCommSensitiveWordInfoRepository.verifySensitiveWord(esbSkuInfoBO.getName());
        if (CollectionUtils.isEmpty((Collection)sensitiveWordInfoDTOS)) {
            if (esbSkuInfoBO.getName().contains("  ")) {
                verifyResult.setRespCode("1000");
                verifyResult.setRespDesc("sku\u540d\u79f0\u5305\u542b\u8fde\u7eed\u4e24\u4e2a\u7a7a\u683c");
                return verifyResult;
            }
        } else {
            StringBuilder sensitiveWords = new StringBuilder();
            for (DycProCommSensitiveWordInfoDTO sensitiveWordDto : sensitiveWordInfoDTOS) {
                sensitiveWords.append("[").append(sensitiveWordDto.getSensitiveWordName()).append("]");
            }
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("sku\u540d\u79f0\u5b58\u5728\u654f\u611f\u8bcd\uff1a" + sensitiveWords.toString());
            return verifyResult;
        }
        skuInfoDto.setSkuShortName(esbSkuInfoBO.getName());
        String manageCatalogPath = "";
        if (StringUtils.isBlank((String)getSkuDetailResult.getResult().getBrandName())) {
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u65e0\u54c1\u724c\u4fe1\u606f");
            return verifyResult;
        }
        skuInfoDto.setBrandName(getSkuDetailResult.getResult().getBrandName());
        if (StringUtils.isBlank((String)esbSkuInfoBO.getSaleUnit())) {
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u65e0\u9500\u552e\u8ba1\u91cf\u5355\u4f4d\u4fe1\u606f");
            return verifyResult;
        }
        skuInfoDto.setSaleMeasureName(esbSkuInfoBO.getSaleUnit());
        skuInfoDto.setSettleMeasureName(esbSkuInfoBO.getSaleUnit());
        skuInfoDto.setSaleMeasureRate(new BigDecimal(1));
        if (StringUtils.isBlank((String)esbSkuInfoBO.getSpec())) {
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u65e0\u89c4\u683c\u4fe1\u606f");
            return verifyResult;
        }
        skuInfoDto.setSpec(esbSkuInfoBO.getSpec());
        if (StringUtils.isBlank((String)esbSkuInfoBO.getModel())) {
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u65e0\u578b\u53f7\u4fe1\u606f");
            return verifyResult;
        }
        skuInfoDto.setModel(esbSkuInfoBO.getModel());
        if (StringUtils.isBlank((String)getSkuDetailResult.getResult().getWareNum())) {
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u65e0\u5305\u88c5\u5355\u4f4d\u6570\u91cf\u4fe1\u606f");
            return verifyResult;
        }
        skuInfoDto.setWareNum(getSkuDetailResult.getResult().getWareNum());
        if (StringUtils.isBlank((String)getSkuDetailResult.getResult().getWare())) {
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u65e0\u5305\u88c5\u5355\u4f4d\u4fe1\u606f");
            return verifyResult;
        }
        skuInfoDto.setWare(getSkuDetailResult.getResult().getWare());
        if (StringUtils.isBlank((String)esbSkuInfoBO.getShortName())) {
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u65e0\u5546\u54c1\u77ed\u540d\u79f0\u4fe1\u606f");
            return verifyResult;
        }
        List sensitiveWordInfoDTOS2 = this.dycProCommSensitiveWordInfoRepository.verifySensitiveWord(esbSkuInfoBO.getShortName());
        if (CollectionUtils.isEmpty((Collection)sensitiveWordInfoDTOS2)) {
            if (esbSkuInfoBO.getShortName().contains("  ")) {
                verifyResult.setRespCode("1000");
                verifyResult.setRespDesc("sku\u77ed\u540d\u79f0\u5305\u542b\u8fde\u7eed\u4e24\u4e2a\u7a7a\u683c");
                return verifyResult;
            }
        } else {
            StringBuilder sensitiveWords = new StringBuilder();
            for (DycProCommSensitiveWordInfoDTO sensitiveWordDto : sensitiveWordInfoDTOS2) {
                sensitiveWords.append("[").append(sensitiveWordDto.getSensitiveWordName()).append("]");
            }
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("sku\u77ed\u540d\u79f0\u5b58\u5728\u654f\u611f\u8bcd\uff1a" + sensitiveWords.toString());
            return verifyResult;
        }
        skuInfoDto.setSkuName(esbSkuInfoBO.getShortName() + " " + skuInfoDto.getBrandName() + " " + skuInfoDto.getModel() + " " + skuInfoDto.getSpec() + " " + skuInfoDto.getWare() + " " + skuInfoDto.getWareNum());
        if (StringUtils.isBlank((String)esbSkuInfoBO.getAgrCode())) {
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u65e0\u6240\u5c5e\u534f\u8bae\u7f16\u53f7\u4fe1\u606f");
            return verifyResult;
        }
        LambdaQueryWrapper mainQryWrapper = new LambdaQueryWrapper();
        mainQryWrapper.eq(AgrMainPO::getAgrCode, (Object)esbSkuInfoBO.getAgrCode());
        mainQryWrapper.eq(AgrMainPO::getAgrStatus, (Object)Integer.parseInt(DmcAgrMainAgrStatus.ACTIVE.getCode()));
        AgrMainPO agrMainPO = (AgrMainPO)this.agrMainMapper.selectOne((Wrapper)mainQryWrapper);
        if (null == agrMainPO) {
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u6240\u5c5e\u534f\u8bae\u7f16\u53f7\u4e0d\u5b58\u5728");
            return verifyResult;
        }
        if (!agrMainPO.getSupplierId().equals(reqBO.getSupplierId())) {
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u6240\u5c5e\u534f\u8bae\u7f16\u53f7\u4e0d\u5b58\u5728");
            return verifyResult;
        }
        skuInfoDto.setAgrId(agrMainPO.getAgrId());
        skuInfoDto.setTradeMode(agrMainPO.getTradeMode());
        if (CollectionUtils.isEmpty((Collection)getSkuDetailResult.getResult().getCategory())) {
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u7535\u5546\u5546\u54c1\u4fe1\u606f\u65e0\u7c7b\u76ee\u4fe1\u606f");
            return verifyResult;
        }
        List categoryList = getSkuDetailResult.getResult().getCategory();
        DycProCommManageCatalogDTO manageCatalogDTO = new DycProCommManageCatalogDTO();
        manageCatalogDTO.setManageCatalogId(Long.valueOf((String)categoryList.get(categoryList.size() - 1)));
        manageCatalogDTO.setDelFlag(ECommoditySyncConstant.DelFlag.NO);
        DycProCommManageCatalogDTO dycProCommManageCatalogDTO = this.dycProCommManageCatalogRepository.queryManageCatalogOne(manageCatalogDTO);
        if (null == dycProCommManageCatalogDTO) {
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u7535\u5546\u5546\u54c1\u7c7b\u76ee\u4fe1\u606f\u6821\u9a8c\u5931\u8d25\uff1a\u8be5[" + (String)categoryList.get(categoryList.size() - 1) + "]\u7c7b\u76ee\u4e0d\u5b58\u5728");
            return verifyResult;
        }
        skuInfoDto.setPurchaseType(dycProCommManageCatalogDTO.getPurchaseType());
        skuInfoDto.setMaterialType(dycProCommManageCatalogDTO.getMaterialType());
        skuInfoDto.setAgrType(agrMainPO.getAgrType());
        manageCatalogPath = dycProCommManageCatalogDTO.getManageCatalogPath();
        String[] split = manageCatalogPath.split("-");
        Map<String, String> manageCatalogPathMap = IntStream.range(0, split.length).boxed().collect(Collectors.toMap(i -> split[i], i -> split[i], (a, b) -> b));
        for (String category : categoryList) {
            if (manageCatalogPathMap.containsKey(category)) continue;
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u7535\u5546\u5546\u54c1\u7c7b\u76ee\u4fe1\u606f\u6821\u9a8c\u5931\u8d25\uff1a\u8be5[" + category + "]\u7c7b\u76ee\u4e0d\u5b58\u5728");
            return verifyResult;
        }
        if (agrMainPO.getAgrType().equals(Integer.parseInt(DmcAgrMainAgrType.JCXY.getCode()))) {
            LambdaQueryWrapper cooperationQryWrapper = new LambdaQueryWrapper();
            cooperationQryWrapper.eq(AgrCooperationCatalogPO::getAgrObjPrimaryId, (Object)agrMainPO.getAgrObjPrimaryId());
            cooperationQryWrapper.eq(AgrCooperationCatalogPO::getManageCatalogId, (Object)Long.valueOf((String)categoryList.get(categoryList.size() - 1)));
            AgrCooperationCatalogPO agrCooperationCatalogPO = (AgrCooperationCatalogPO)this.agrCooperationCatalogMapper.selectOne((Wrapper)cooperationQryWrapper);
            if (null == agrCooperationCatalogPO) {
                verifyResult.setRespCode("1000");
                verifyResult.setRespDesc("\u7535\u5546\u5546\u54c1\u7c7b\u76ee\u4fe1\u606f\u6821\u9a8c\u5931\u8d25\uff1a\u8be5[" + (String)categoryList.get(categoryList.size() - 1) + "]\u7c7b\u76ee\u4e0d\u5728\u7b7e\u7ea6\u7c7b\u76ee\u4e2d");
                return verifyResult;
            }
        }
        DycProCommPropertyTemplateInfoDTO queryPropertyTemplateInfoDTO = new DycProCommPropertyTemplateInfoDTO();
        queryPropertyTemplateInfoDTO.setManageCatalogId(Long.valueOf((String)categoryList.get(categoryList.size() - 1)));
        DycProCommPropertyTemplateInfoDTO propertyTemplateInfoDTO = this.dycProCommManageCatalogRepository.queryPropertyTemplateOneByCondition(queryPropertyTemplateInfoDTO);
        if (null != propertyTemplateInfoDTO) {
            skuInfoDto.setPropertyTemplateId(propertyTemplateInfoDTO.getPropertyTemplateId());
        }
        if (!(existSkuInfoPo = (CommSkuInfoPO)this.commSkuInfoMapper.selectById((Serializable)reqBO.getSkuId())).getAgrId().equals(agrMainPO.getAgrId())) {
            boolean existOtherFlag = false;
            HashMap agrInfoMap = new HashMap();
            HashMap<String, AgrMainPO> skuAgrMap = new HashMap<String, AgrMainPO>();
            HashMap<String, AgrItemPO> skuAgrItemMap = new HashMap<String, AgrItemPO>();
            LambdaQueryWrapper itemQryWrapper = new LambdaQueryWrapper();
            itemQryWrapper.eq(AgrItemPO::getSkuCode, (Object)reqBO.getExtSkuId());
            List agrItemPOs = this.agrItemMapper.selectList((Wrapper)itemQryWrapper);
            if (!CollectionUtils.isEmpty((Collection)agrItemPOs)) {
                List agrIds = agrItemPOs.stream().map(AgrItemPO::getAgrId).collect(Collectors.toList());
                LambdaQueryWrapper agrQryWrapper = new LambdaQueryWrapper();
                agrQryWrapper.in(AgrMainPO::getAgrId, agrIds);
                agrQryWrapper.eq(AgrMainPO::getAgrStatus, (Object)Integer.parseInt(DmcAgrMainAgrStatus.ACTIVE.getCode()));
                agrQryWrapper.eq(AgrMainPO::getSupplierId, (Object)reqBO.getSupplierId());
                List agrMainPOs = this.agrMainMapper.selectList((Wrapper)agrQryWrapper);
                if (!CollectionUtils.isEmpty((Collection)agrMainPOs)) {
                    agrMainPOs.forEach(agrMainPO1 -> agrInfoMap.put(agrMainPO1.getAgrId(), agrMainPO1));
                }
                for (AgrItemPO agrItemPO : agrItemPOs) {
                    AgrMainPO agrMainPO2 = (AgrMainPO)agrInfoMap.get(agrItemPO.getAgrId());
                    if (agrMainPO2 == null) continue;
                    if (agrMainPO2.getAgrId().equals(agrMainPO.getAgrId())) {
                        skuAgrItemMap.put(agrItemPO.getSkuCode(), agrItemPO);
                        skuAgrMap.put(agrItemPO.getSkuCode(), agrMainPO2);
                        continue;
                    }
                    existOtherFlag = true;
                }
            }
            if (agrMainPO.getAgrType().equals(Integer.parseInt(DmcAgrMainAgrType.DSXY.getCode()))) {
                if (skuAgrMap.get(reqBO.getExtSkuId()) == null) {
                    verifyResult.setRespCode("1000");
                    verifyResult.setRespDesc("\u5546\u54c1\u4e0d\u5728\u7b7e\u7ea6\u534f\u8bae\u5185");
                    return verifyResult;
                }
                skuInfoDto.setAgrItemId(((AgrItemPO)skuAgrItemMap.get(reqBO.getExtSkuId())).getAgrItemId());
                DycProCommSkuPriceInfoDTO skuPriceInfoDTO = new DycProCommSkuPriceInfoDTO();
                skuPriceInfoDTO.setFixedPrice(((AgrItemPO)skuAgrItemMap.get(reqBO.getExtSkuId())).getSupplyPrice());
                skuInfoDto.setPriceInfo(skuPriceInfoDTO);
            } else if (existOtherFlag) {
                verifyResult.setRespCode("1000");
                verifyResult.setRespDesc("\u5546\u54c1\u5c5e\u4e8e\u56fa\u5b9a\u4ef7\u534f\u8bae");
                return verifyResult;
            }
        }
        if (StringUtils.isBlank((String)getSkuDetailResult.getResult().getProductArea())) {
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u65e0\u4ea7\u5730\u4fe1\u606f");
            return verifyResult;
        }
        skuInfoDto.setProductArea(getSkuDetailResult.getResult().getProductArea());
        skuInfoDto.setJdSku(esbSkuInfoBO.getJdSku());
        skuInfoDto.setJdDiscountRate(esbSkuInfoBO.getJdDiscountRate());
        skuInfoDto.setSameSkuUrl(esbSkuInfoBO.getSameSkuUrl());
        skuInfoDto.setEanCode(esbSkuInfoBO.getUpc());
        if (StringUtils.isNotBlank((String)esbSkuInfoBO.getMoq())) {
            skuInfoDto.setMinQuantity(new BigDecimal(esbSkuInfoBO.getMoq()));
        } else {
            skuInfoDto.setMinQuantity(new BigDecimal(1));
        }
        if (null == getSkuDetailResult.getResult().getTax()) {
            skuInfoDto.setRate(new BigDecimal(0));
        } else {
            skuInfoDto.setRate(new BigDecimal(getSkuDetailResult.getResult().getTax()));
        }
        skuInfoDto.setSupplierId(reqBO.getSupplierId());
        skuInfoDto.setSupplierName(reqBO.getSupplierName());
        skuInfoDto.setSkuSource(ECommoditySyncConstant.SkuSource.E_SKU);
        skuInfoDto.setIsHaveGift(ECommoditySyncConstant.IsHaveGift.NO);
        skuDetailsInfoDTO.setPackageRemark(getSkuDetailResult.getResult().getWareQD());
        skuDetailsInfoDTO.setSkuPcDetailUrl(getSkuDetailResult.getResult().getIntroduction());
        JSONArray propertyInst = new JSONArray();
        JSONObject property = new JSONObject();
        property.put("propertyName", (Object)"\u5546\u54c1\u77ed\u540d\u79f0");
        property.put("propertyValue", (Object)esbSkuInfoBO.getShortName());
        property.put("propertyShowOrder", (Object)0);
        propertyInst.add((Object)property);
        JSONObject property1 = new JSONObject();
        property1.put("propertyName", (Object)"\u89c4\u683c");
        property1.put("propertyValue", (Object)skuInfoDto.getSpec());
        property1.put("propertyShowOrder", (Object)0);
        propertyInst.add((Object)property1);
        JSONObject property2 = new JSONObject();
        property2.put("propertyName", (Object)"\u578b\u53f7");
        property2.put("propertyValue", (Object)skuInfoDto.getModel());
        property2.put("propertyShowOrder", (Object)0);
        propertyInst.add((Object)property2);
        JSONObject property3 = new JSONObject();
        property3.put("propertyName", (Object)"\u54c1\u724c");
        property3.put("propertyValue", (Object)skuInfoDto.getBrandName());
        property3.put("propertyShowOrder", (Object)0);
        propertyInst.add((Object)property3);
        JSONObject property4 = new JSONObject();
        property4.put("propertyName", (Object)"\u5305\u88c5\u5355\u4f4d");
        property4.put("propertyValue", (Object)skuInfoDto.getWare());
        property4.put("propertyShowOrder", (Object)0);
        propertyInst.add((Object)property4);
        JSONObject property5 = new JSONObject();
        property5.put("propertyName", (Object)"\u5305\u88c5\u5355\u4f4d\u6570\u91cf");
        property5.put("propertyValue", (Object)skuInfoDto.getWareNum());
        property5.put("propertyShowOrder", (Object)0);
        propertyInst.add((Object)property5);
        JSONObject property6 = new JSONObject();
        property6.put("propertyName", (Object)"69\u7801");
        property6.put("propertyValue", (Object)skuInfoDto.getEanCode());
        property6.put("propertyShowOrder", (Object)0);
        propertyInst.add((Object)property6);
        JSONObject property7 = new JSONObject();
        property7.put("propertyName", (Object)"\u4eac\u4e1c\u81ea\u8425\u5546\u54c1");
        property7.put("propertyValue", (Object)skuInfoDto.getJdSku());
        property7.put("propertyShowOrder", (Object)0);
        propertyInst.add((Object)property7);
        JSONObject property8 = new JSONObject();
        property8.put("propertyName", (Object)"\u4eac\u4e1c\u6298\u6263\u7387");
        property8.put("propertyValue", (Object)skuInfoDto.getJdDiscountRate());
        property8.put("propertyShowOrder", (Object)0);
        propertyInst.add((Object)property8);
        JSONObject property9 = new JSONObject();
        property9.put("propertyName", (Object)"\u4e09\u65b9\u540c\u54c1\u94fe\u63a5\uff08\u4e0d\u5c11\u4e8e3\u4e2a\uff09");
        property9.put("propertyValue", (Object)skuInfoDto.getSameSkuUrl());
        property9.put("propertyShowOrder", (Object)0);
        propertyInst.add((Object)property9);
        if (!CollectionUtils.isEmpty((Collection)esbSkuInfoBO.getParam())) {
            for (DycProBaseCallEsbUtilSkuParamBO esbSkuParamBo : esbSkuInfoBO.getParam()) {
                JSONObject property0 = new JSONObject();
                property0.put("propertyName", (Object)esbSkuParamBo.getAttrName());
                property0.put("propertyValue", (Object)esbSkuParamBo.getAttrValue());
                property0.put("propertySource", (Object)"\u7535\u5546\u63a8\u9001");
                property0.put("propertyShowOrder", (Object)esbSkuParamBo.getAttrSeq());
                propertyInst.add((Object)property0);
            }
        }
        skuDetailsInfoDTO.setPropertyInstInfo(propertyInst.toJSONString());
        skuInfoDto.setSkuDetails(skuDetailsInfoDTO);
        if (CollectionUtils.isEmpty((Collection)getSkuImageResult.getResult())) {
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u65e0\u56fe\u7247\u4fe1\u606f");
            return verifyResult;
        }
        int showOrder = 1;
        for (DycProBaseCallEsbUtilSkuPicBO dycProBaseCallEsbUtilSkuPicBO : ((DycProBaseCallEsbUtilGetSkuImageResultBO)getSkuImageResult.getResult().get(0)).getSkuPic()) {
            DycProCommSkuPicInfoDTO skuPicInfoDTO = new DycProCommSkuPicInfoDTO();
            skuPicInfoDTO.setPicUrl(dycProBaseCallEsbUtilSkuPicBO.getImgpath());
            if (dycProBaseCallEsbUtilSkuPicBO.getIsPrimary().equals(1)) {
                skuPicInfoDTO.setPicType(ECommoditySyncConstant.PicType.MAIN_IMG);
                skuPicInfoDTO.setShowOrder(Integer.valueOf(1));
            } else {
                skuPicInfoDTO.setPicType(ECommoditySyncConstant.PicType.DETAIL_IMG);
                skuPicInfoDTO.setShowOrder(Integer.valueOf(showOrder));
                ++showOrder;
            }
            skuPicInfoList.add(skuPicInfoDTO);
        }
        skuInfoDto.setSkuPicInfoList(skuPicInfoList);
        verifyResult.setRespCode("0000");
        verifyResult.setRespDesc("\u5b8c\u6574\u6027\u6821\u9a8c\u6210\u529f");
        verifyResult.setSkuInfo(skuInfoDto);
        return verifyResult;
    }

    private DycProCommDealSkuMsgRspBO dealInfoChangeMsgForJd(DycProCommDealWaitMsgReqBO reqBO) {
        DycProCommDealSkuMsgRspBO dealMsgRspBO = new DycProCommDealSkuMsgRspBO();
        DycProBaseCallEsbUtilGetSkuDetailForJdReqBO callEsbUtilGetSkuDetailReqBO = new DycProBaseCallEsbUtilGetSkuDetailForJdReqBO();
        callEsbUtilGetSkuDetailReqBO.setHsn(reqBO.getSupplierHsn());
        callEsbUtilGetSkuDetailReqBO.setSku(reqBO.getExtSkuId());
        callEsbUtilGetSkuDetailReqBO.setUrl(this.callEsbUrlGetSkuDetail);
        callEsbUtilGetSkuDetailReqBO.setQueryExts("wareNum,ware,agrCode,model,shortName,seoModel");
        DycProBaseCallEsbUtilGetSkuDetailForJdRspBO getSkuDetailResult = DycProBaseCallEsbUtil.getSkuDetailForJd((DycProBaseCallEsbUtilGetSkuDetailForJdReqBO)callEsbUtilGetSkuDetailReqBO);
        if (!getSkuDetailResult.getSuccess().booleanValue() || !"0000".equals(getSkuDetailResult.getResultCode())) {
            dealMsgRspBO.setRespCode(getSkuDetailResult.getResultCode());
            dealMsgRspBO.setRespDesc(getSkuDetailResult.getResultMessage());
            return dealMsgRspBO;
        }
        DycProBaseCallEsbUtilGetSkuImageForJdReqBO callEsbUtilGetSkuImageReqBO = new DycProBaseCallEsbUtilGetSkuImageForJdReqBO();
        callEsbUtilGetSkuImageReqBO.setHsn(reqBO.getSupplierHsn());
        callEsbUtilGetSkuImageReqBO.setSku(reqBO.getExtSkuId());
        callEsbUtilGetSkuImageReqBO.setUrl(this.callEsbUrlGetSkuImage);
        DycProBaseCallEsbUtilGetSkuImageForJdRspBO getSkuImageResult = DycProBaseCallEsbUtil.getSkuImageForJd((DycProBaseCallEsbUtilGetSkuImageForJdReqBO)callEsbUtilGetSkuImageReqBO);
        if (!getSkuImageResult.getSuccess().booleanValue() || !"0000".equals(getSkuImageResult.getResultCode())) {
            dealMsgRspBO.setRespCode(getSkuImageResult.getResultCode());
            dealMsgRspBO.setRespDesc(getSkuImageResult.getResultMessage());
            return dealMsgRspBO;
        }
        DycProCommDealSkuMsgRspBO verifyRspBO = this.skuInfoVerifyForJd(getSkuDetailResult, getSkuImageResult, reqBO);
        if ("0000".equals(verifyRspBO.getRespCode())) {
            DycProEsIndexMappingSkuBO esIndexMappingSkuBO = this.dycProCommSkuRepository.updateSkuCompleteInfoAndSyncNosql(verifyRspBO.getSkuInfo());
            dealMsgRspBO.setRespCode("0000");
            dealMsgRspBO.setRespDesc("\u4fe1\u606f\u53d8\u66f4\u6d88\u606f\u5904\u7406\u5b8c\u6210");
            DycProCommSkuDTO skuInfo = new DycProCommSkuDTO();
            BeanUtils.copyProperties((Object)verifyRspBO.getSkuInfo(), (Object)skuInfo);
            dealMsgRspBO.setSkuInfo(skuInfo);
            dealMsgRspBO.setEsSkuInfo(esIndexMappingSkuBO);
            return dealMsgRspBO;
        }
        dealMsgRspBO.setRespCode(verifyRspBO.getRespCode());
        dealMsgRspBO.setRespDesc(verifyRspBO.getRespDesc());
        return dealMsgRspBO;
    }

    private DycProCommDealSkuMsgRspBO skuInfoVerifyForJd(DycProBaseCallEsbUtilGetSkuDetailForJdRspBO getSkuDetailResult, DycProBaseCallEsbUtilGetSkuImageForJdRspBO getSkuImageResult, DycProCommDealWaitMsgReqBO reqBO) {
        CommSkuInfoPO existSkuInfoPo;
        DycProCommDealSkuMsgRspBO verifyResult = new DycProCommDealSkuMsgRspBO();
        DycProCommSkuDTO skuInfoDto = new DycProCommSkuDTO();
        DycProCommSkuDetailsInfoDTO skuDetailsInfoDTO = new DycProCommSkuDetailsInfoDTO();
        ArrayList<DycProCommSkuPicInfoDTO> skuPicInfoList = new ArrayList<DycProCommSkuPicInfoDTO>();
        DycProBaseCallEsbUtilGetSkuDetailForJdResultBO esbSkuInfoBO = getSkuDetailResult.getResult();
        skuInfoDto.setSkuId(reqBO.getSkuId());
        if (null == esbSkuInfoBO.getSku()) {
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u65e0sku\u7f16\u53f7\u4fe1\u606f");
            return verifyResult;
        }
        skuInfoDto.setExtSkuId(String.valueOf(esbSkuInfoBO.getSku()));
        if (StringUtils.isBlank((String)esbSkuInfoBO.getName())) {
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u65e0sku\u540d\u79f0\u4fe1\u606f");
            return verifyResult;
        }
        List sensitiveWordInfoDTOS = this.dycProCommSensitiveWordInfoRepository.verifySensitiveWord(esbSkuInfoBO.getName());
        if (CollectionUtils.isEmpty((Collection)sensitiveWordInfoDTOS)) {
            skuInfoDto.setSkuShortName(esbSkuInfoBO.getName());
            if (esbSkuInfoBO.getName().contains("  ")) {
                verifyResult.setRespCode("1000");
                verifyResult.setRespDesc("sku\u540d\u79f0\u5305\u542b\u8fde\u7eed\u4e24\u4e2a\u7a7a\u683c");
                return verifyResult;
            }
        } else {
            StringBuilder sensitiveWords = new StringBuilder();
            for (DycProCommSensitiveWordInfoDTO sensitiveWordDto : sensitiveWordInfoDTOS) {
                sensitiveWords.append("[").append(sensitiveWordDto.getSensitiveWordName()).append("]");
            }
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("sku\u540d\u79f0\u5b58\u5728\u654f\u611f\u8bcd\uff1a" + sensitiveWords.toString());
            return verifyResult;
        }
        String manageCatalogPath = "";
        if (StringUtils.isBlank((String)getSkuDetailResult.getResult().getBrandName())) {
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u65e0\u54c1\u724c\u4fe1\u606f");
            return verifyResult;
        }
        skuInfoDto.setBrandName(getSkuDetailResult.getResult().getBrandName());
        if (StringUtils.isBlank((String)esbSkuInfoBO.getSaleUnit())) {
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u65e0\u9500\u552e\u8ba1\u91cf\u5355\u4f4d\u4fe1\u606f");
            return verifyResult;
        }
        skuInfoDto.setSaleMeasureName(esbSkuInfoBO.getSaleUnit());
        skuInfoDto.setSettleMeasureName(esbSkuInfoBO.getSaleUnit());
        skuInfoDto.setSaleMeasureRate(new BigDecimal(1));
        if (StringUtils.isBlank((String)esbSkuInfoBO.getSeoModel())) {
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u65e0\u89c4\u683c\u4fe1\u606f");
            return verifyResult;
        }
        skuInfoDto.setSpec(esbSkuInfoBO.getSeoModel());
        if (StringUtils.isBlank((String)esbSkuInfoBO.getModel())) {
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u65e0\u578b\u53f7\u4fe1\u606f");
            return verifyResult;
        }
        skuInfoDto.setModel(esbSkuInfoBO.getModel());
        if (StringUtils.isBlank((String)getSkuDetailResult.getResult().getWareNum())) {
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u65e0\u5305\u88c5\u5355\u4f4d\u6570\u91cf\u4fe1\u606f");
            return verifyResult;
        }
        skuInfoDto.setWareNum(getSkuDetailResult.getResult().getWareNum());
        if (StringUtils.isBlank((String)getSkuDetailResult.getResult().getWare())) {
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u65e0\u5305\u88c5\u5355\u4f4d\u4fe1\u606f");
            return verifyResult;
        }
        skuInfoDto.setWare(getSkuDetailResult.getResult().getWare());
        if (StringUtils.isBlank((String)esbSkuInfoBO.getShortName())) {
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u65e0\u5546\u54c1\u77ed\u540d\u79f0\u4fe1\u606f");
            return verifyResult;
        }
        List sensitiveWordInfoDTOS2 = this.dycProCommSensitiveWordInfoRepository.verifySensitiveWord(esbSkuInfoBO.getShortName());
        if (CollectionUtils.isEmpty((Collection)sensitiveWordInfoDTOS2)) {
            if (esbSkuInfoBO.getShortName().contains("  ")) {
                verifyResult.setRespCode("1000");
                verifyResult.setRespDesc("sku\u77ed\u540d\u79f0\u5305\u542b\u8fde\u7eed\u4e24\u4e2a\u7a7a\u683c");
                return verifyResult;
            }
        } else {
            StringBuilder sensitiveWords = new StringBuilder();
            for (DycProCommSensitiveWordInfoDTO sensitiveWordDto : sensitiveWordInfoDTOS2) {
                sensitiveWords.append("[").append(sensitiveWordDto.getSensitiveWordName()).append("]");
            }
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("sku\u77ed\u540d\u79f0\u5b58\u5728\u654f\u611f\u8bcd\uff1a" + sensitiveWords.toString());
            return verifyResult;
        }
        skuInfoDto.setSkuName(esbSkuInfoBO.getShortName() + " " + skuInfoDto.getBrandName() + " " + skuInfoDto.getModel() + " " + skuInfoDto.getSpec() + " " + skuInfoDto.getWare() + " " + skuInfoDto.getWareNum());
        if (StringUtils.isBlank((String)esbSkuInfoBO.getAgrCode())) {
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u65e0\u6240\u5c5e\u534f\u8bae\u7f16\u53f7\u4fe1\u606f");
            return verifyResult;
        }
        LambdaQueryWrapper mainQryWrapper = new LambdaQueryWrapper();
        mainQryWrapper.eq(AgrMainPO::getAgrCode, (Object)esbSkuInfoBO.getAgrCode());
        mainQryWrapper.eq(AgrMainPO::getAgrStatus, (Object)Integer.parseInt(DmcAgrMainAgrStatus.ACTIVE.getCode()));
        AgrMainPO agrMainPO = (AgrMainPO)this.agrMainMapper.selectOne((Wrapper)mainQryWrapper);
        if (null == agrMainPO) {
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u6240\u5c5e\u534f\u8bae\u7f16\u53f7\u4e0d\u5b58\u5728");
            return verifyResult;
        }
        if (!agrMainPO.getSupplierId().equals(reqBO.getSupplierId())) {
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u6240\u5c5e\u534f\u8bae\u7f16\u53f7\u4e0d\u5b58\u5728");
            return verifyResult;
        }
        skuInfoDto.setAgrId(agrMainPO.getAgrId());
        skuInfoDto.setTradeMode(agrMainPO.getTradeMode());
        if (CollectionUtils.isEmpty((Collection)getSkuDetailResult.getResult().getCategory())) {
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u7535\u5546\u5546\u54c1\u4fe1\u606f\u65e0\u7c7b\u76ee\u4fe1\u606f");
            return verifyResult;
        }
        List categoryList = getSkuDetailResult.getResult().getCategory();
        DycProCommManageCatalogDTO manageCatalogDTO = new DycProCommManageCatalogDTO();
        manageCatalogDTO.setManageCatalogId(Long.valueOf((String)categoryList.get(categoryList.size() - 1)));
        manageCatalogDTO.setDelFlag(ECommoditySyncConstant.DelFlag.NO);
        DycProCommManageCatalogDTO dycProCommManageCatalogDTO = this.dycProCommManageCatalogRepository.queryManageCatalogOne(manageCatalogDTO);
        if (null == dycProCommManageCatalogDTO) {
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u7535\u5546\u5546\u54c1\u7c7b\u76ee\u4fe1\u606f\u6821\u9a8c\u5931\u8d25\uff1a\u8be5[" + (String)categoryList.get(categoryList.size() - 1) + "]\u7c7b\u76ee\u4e0d\u5b58\u5728");
            return verifyResult;
        }
        skuInfoDto.setPurchaseType(dycProCommManageCatalogDTO.getPurchaseType());
        skuInfoDto.setMaterialType(dycProCommManageCatalogDTO.getMaterialType());
        skuInfoDto.setAgrType(agrMainPO.getAgrType());
        manageCatalogPath = dycProCommManageCatalogDTO.getManageCatalogPath();
        String[] split = manageCatalogPath.split("-");
        Map<String, String> manageCatalogPathMap = IntStream.range(0, split.length).boxed().collect(Collectors.toMap(i -> split[i], i -> split[i], (a, b) -> b));
        for (String category : categoryList) {
            if (manageCatalogPathMap.containsKey(category)) continue;
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u7535\u5546\u5546\u54c1\u7c7b\u76ee\u4fe1\u606f\u6821\u9a8c\u5931\u8d25\uff1a\u8be5[" + category + "]\u7c7b\u76ee\u4e0d\u5b58\u5728");
            return verifyResult;
        }
        if (agrMainPO.getAgrType().equals(Integer.parseInt(DmcAgrMainAgrType.JCXY.getCode()))) {
            LambdaQueryWrapper cooperationQryWrapper = new LambdaQueryWrapper();
            cooperationQryWrapper.eq(AgrCooperationCatalogPO::getAgrObjPrimaryId, (Object)agrMainPO.getAgrObjPrimaryId());
            cooperationQryWrapper.eq(AgrCooperationCatalogPO::getManageCatalogId, (Object)Long.valueOf((String)categoryList.get(categoryList.size() - 1)));
            AgrCooperationCatalogPO agrCooperationCatalogPO = (AgrCooperationCatalogPO)this.agrCooperationCatalogMapper.selectOne((Wrapper)cooperationQryWrapper);
            if (null == agrCooperationCatalogPO) {
                verifyResult.setRespCode("1000");
                verifyResult.setRespDesc("\u7535\u5546\u5546\u54c1\u7c7b\u76ee\u4fe1\u606f\u6821\u9a8c\u5931\u8d25\uff1a\u8be5[" + (String)categoryList.get(categoryList.size() - 1) + "]\u7c7b\u76ee\u4e0d\u5728\u7b7e\u7ea6\u7c7b\u76ee\u4e2d");
                return verifyResult;
            }
        }
        DycProCommPropertyTemplateInfoDTO queryPropertyTemplateInfoDTO = new DycProCommPropertyTemplateInfoDTO();
        queryPropertyTemplateInfoDTO.setManageCatalogId(Long.valueOf((String)categoryList.get(categoryList.size() - 1)));
        DycProCommPropertyTemplateInfoDTO propertyTemplateInfoDTO = this.dycProCommManageCatalogRepository.queryPropertyTemplateOneByCondition(queryPropertyTemplateInfoDTO);
        if (null != propertyTemplateInfoDTO) {
            skuInfoDto.setPropertyTemplateId(propertyTemplateInfoDTO.getPropertyTemplateId());
        }
        if (!(existSkuInfoPo = (CommSkuInfoPO)this.commSkuInfoMapper.selectById((Serializable)reqBO.getSkuId())).getAgrId().equals(agrMainPO.getAgrId())) {
            boolean existOtherFlag = false;
            HashMap agrInfoMap = new HashMap();
            HashMap<String, AgrMainPO> skuAgrMap = new HashMap<String, AgrMainPO>();
            HashMap<String, AgrItemPO> skuAgrItemMap = new HashMap<String, AgrItemPO>();
            LambdaQueryWrapper itemQryWrapper = new LambdaQueryWrapper();
            itemQryWrapper.eq(AgrItemPO::getSkuCode, (Object)reqBO.getExtSkuId());
            List agrItemPOs = this.agrItemMapper.selectList((Wrapper)itemQryWrapper);
            if (!CollectionUtils.isEmpty((Collection)agrItemPOs)) {
                List agrIds = agrItemPOs.stream().map(AgrItemPO::getAgrId).collect(Collectors.toList());
                LambdaQueryWrapper agrQryWrapper = new LambdaQueryWrapper();
                agrQryWrapper.in(AgrMainPO::getAgrId, agrIds);
                agrQryWrapper.eq(AgrMainPO::getAgrStatus, (Object)Integer.parseInt(DmcAgrMainAgrStatus.ACTIVE.getCode()));
                agrQryWrapper.eq(AgrMainPO::getSupplierId, (Object)reqBO.getSupplierId());
                List agrMainPOs = this.agrMainMapper.selectList((Wrapper)agrQryWrapper);
                if (!CollectionUtils.isEmpty((Collection)agrMainPOs)) {
                    agrMainPOs.forEach(agrMainPO1 -> agrInfoMap.put(agrMainPO1.getAgrId(), agrMainPO1));
                }
                for (AgrItemPO agrItemPO : agrItemPOs) {
                    AgrMainPO agrMainPO2 = (AgrMainPO)agrInfoMap.get(agrItemPO.getAgrId());
                    if (agrMainPO2 == null) continue;
                    if (agrMainPO2.getAgrId().equals(agrMainPO.getAgrId())) {
                        skuAgrItemMap.put(agrItemPO.getSkuCode(), agrItemPO);
                        skuAgrMap.put(agrItemPO.getSkuCode(), agrMainPO2);
                        continue;
                    }
                    existOtherFlag = true;
                }
            }
            if (agrMainPO.getAgrType().equals(Integer.parseInt(DmcAgrMainAgrType.DSXY.getCode()))) {
                if (skuAgrMap.get(reqBO.getExtSkuId()) == null) {
                    verifyResult.setRespCode("1000");
                    verifyResult.setRespDesc("\u5546\u54c1\u4e0d\u5728\u7b7e\u7ea6\u534f\u8bae\u5185");
                    return verifyResult;
                }
                skuInfoDto.setAgrItemId(((AgrItemPO)skuAgrItemMap.get(reqBO.getExtSkuId())).getAgrItemId());
                DycProCommSkuPriceInfoDTO skuPriceInfoDTO = new DycProCommSkuPriceInfoDTO();
                skuPriceInfoDTO.setFixedPrice(((AgrItemPO)skuAgrItemMap.get(reqBO.getExtSkuId())).getSupplyPrice());
                skuInfoDto.setPriceInfo(skuPriceInfoDTO);
            } else if (existOtherFlag) {
                verifyResult.setRespCode("1000");
                verifyResult.setRespDesc("\u5546\u54c1\u5c5e\u4e8e\u56fa\u5b9a\u4ef7\u534f\u8bae");
                return verifyResult;
            }
        }
        if (StringUtils.isBlank((String)esbSkuInfoBO.getProductArea())) {
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u65e0\u4ea7\u5730\u4fe1\u606f");
            return verifyResult;
        }
        skuInfoDto.setProductArea(esbSkuInfoBO.getProductArea());
        skuInfoDto.setJdSku(esbSkuInfoBO.getJdSku());
        skuInfoDto.setJdDiscountRate(esbSkuInfoBO.getJdDiscountRate());
        skuInfoDto.setSameSkuUrl(esbSkuInfoBO.getSameSkuUrl());
        skuInfoDto.setEanCode(esbSkuInfoBO.getUpc());
        if (StringUtils.isNotBlank((String)esbSkuInfoBO.getLowestBuy())) {
            skuInfoDto.setMinQuantity(new BigDecimal(esbSkuInfoBO.getLowestBuy()));
        } else {
            skuInfoDto.setMinQuantity(new BigDecimal(1));
        }
        if (null == getSkuDetailResult.getResult().getTaxInfo()) {
            skuInfoDto.setRate(new BigDecimal(0));
        } else {
            skuInfoDto.setRate(new BigDecimal(getSkuDetailResult.getResult().getTaxInfo()));
        }
        skuInfoDto.setSupplierId(reqBO.getSupplierId());
        skuInfoDto.setSupplierName(reqBO.getSupplierName());
        skuInfoDto.setSkuSource(ECommoditySyncConstant.SkuSource.E_SKU);
        skuInfoDto.setIsHaveGift(ECommoditySyncConstant.IsHaveGift.NO);
        skuDetailsInfoDTO.setPackageRemark(getSkuDetailResult.getResult().getWareQD());
        skuDetailsInfoDTO.setSkuPcDetailUrl(getSkuDetailResult.getResult().getIntroduction());
        JSONArray propertyInst = new JSONArray();
        JSONObject property = new JSONObject();
        property.put("propertyName", (Object)"\u5546\u54c1\u77ed\u540d\u79f0");
        property.put("propertyValue", (Object)esbSkuInfoBO.getShortName());
        property.put("propertyShowOrder", (Object)0);
        propertyInst.add((Object)property);
        JSONObject property1 = new JSONObject();
        property1.put("propertyName", (Object)"\u89c4\u683c");
        property1.put("propertyValue", (Object)skuInfoDto.getSpec());
        property1.put("propertyShowOrder", (Object)0);
        propertyInst.add((Object)property1);
        JSONObject property2 = new JSONObject();
        property2.put("propertyName", (Object)"\u578b\u53f7");
        property2.put("propertyValue", (Object)skuInfoDto.getModel());
        property2.put("propertyShowOrder", (Object)0);
        propertyInst.add((Object)property2);
        JSONObject property3 = new JSONObject();
        property3.put("propertyName", (Object)"\u54c1\u724c");
        property3.put("propertyValue", (Object)skuInfoDto.getBrandName());
        property3.put("propertyShowOrder", (Object)0);
        propertyInst.add((Object)property3);
        JSONObject property4 = new JSONObject();
        property4.put("propertyName", (Object)"\u5305\u88c5\u5355\u4f4d");
        property4.put("propertyValue", (Object)skuInfoDto.getWare());
        property4.put("propertyShowOrder", (Object)0);
        propertyInst.add((Object)property4);
        JSONObject property5 = new JSONObject();
        property5.put("propertyName", (Object)"\u5305\u88c5\u5355\u4f4d\u6570\u91cf");
        property5.put("propertyValue", (Object)skuInfoDto.getWareNum());
        property5.put("propertyShowOrder", (Object)0);
        propertyInst.add((Object)property5);
        JSONObject property6 = new JSONObject();
        property6.put("propertyName", (Object)"69\u7801");
        property6.put("propertyValue", (Object)skuInfoDto.getEanCode());
        property6.put("propertyShowOrder", (Object)0);
        propertyInst.add((Object)property6);
        JSONObject property7 = new JSONObject();
        property7.put("propertyName", (Object)"\u4eac\u4e1c\u81ea\u8425\u5546\u54c1");
        property7.put("propertyValue", (Object)skuInfoDto.getJdSku());
        property7.put("propertyShowOrder", (Object)0);
        propertyInst.add((Object)property7);
        JSONObject property8 = new JSONObject();
        property8.put("propertyName", (Object)"\u4eac\u4e1c\u6298\u6263\u7387");
        property8.put("propertyValue", (Object)skuInfoDto.getJdDiscountRate());
        property8.put("propertyShowOrder", (Object)0);
        propertyInst.add((Object)property8);
        JSONObject property9 = new JSONObject();
        property9.put("propertyName", (Object)"\u4e09\u65b9\u540c\u54c1\u94fe\u63a5\uff08\u4e0d\u5c11\u4e8e3\u4e2a\uff09");
        property9.put("propertyValue", (Object)skuInfoDto.getSameSkuUrl());
        property9.put("propertyShowOrder", (Object)0);
        propertyInst.add((Object)property9);
        if (!CollectionUtils.isEmpty((Collection)esbSkuInfoBO.getParamJson())) {
            for (DycProBaseCallEsbUtilSkuParamForJdBO esbSkuParamBo : esbSkuInfoBO.getParamJson()) {
                JSONObject property0 = new JSONObject();
                property.put("propertyName", (Object)esbSkuParamBo.getName());
                property.put("propertyValue", (Object)esbSkuParamBo.getValue());
                property.put("propertySource", (Object)"\u7535\u5546\u63a8\u9001");
                propertyInst.add((Object)property0);
            }
        }
        skuDetailsInfoDTO.setPropertyInstInfo(propertyInst.toJSONString());
        skuInfoDto.setSkuDetails(skuDetailsInfoDTO);
        if (CollectionUtils.isEmpty((Collection)getSkuImageResult.getResult())) {
            verifyResult.setRespCode("1000");
            verifyResult.setRespDesc("\u65e0\u56fe\u7247\u4fe1\u606f");
            return verifyResult;
        }
        int showOrder = 1;
        for (DycProBaseCallEsbUtilGetSkuImageForJdResultBO esbSkuPicBO : getSkuImageResult.getResult()) {
            DycProCommSkuPicInfoDTO skuPicInfoDTO = new DycProCommSkuPicInfoDTO();
            skuPicInfoDTO.setPicUrl(this.jdSkuImgPrex + esbSkuPicBO.getPath());
            if (esbSkuPicBO.getIsPrimary().equals(1)) {
                skuPicInfoDTO.setPicType(ECommoditySyncConstant.PicType.MAIN_IMG);
                skuPicInfoDTO.setShowOrder(Integer.valueOf(1));
            } else {
                skuPicInfoDTO.setPicType(ECommoditySyncConstant.PicType.DETAIL_IMG);
                skuPicInfoDTO.setShowOrder(Integer.valueOf(showOrder));
                ++showOrder;
            }
            skuPicInfoList.add(skuPicInfoDTO);
        }
        skuInfoDto.setSkuPicInfoList(skuPicInfoList);
        verifyResult.setRespCode("0000");
        verifyResult.setRespDesc("\u5b8c\u6574\u6027\u6821\u9a8c\u6210\u529f");
        verifyResult.setSkuInfo(skuInfoDto);
        return verifyResult;
    }

    private DycProCommExtSkuMessageRecordsDTO setMsgDealResultSuccess(DycProCommExtSkuMessageRecordsDTO recordsDTO) {
        DycProCommExtSkuMessageRecordsDTO dealRecordsResult = new DycProCommExtSkuMessageRecordsDTO();
        BeanUtils.copyProperties((Object)recordsDTO, (Object)dealRecordsResult);
        dealRecordsResult.setMessageStatus(ECommoditySyncConstant.MessageStatus.SUCCESS);
        dealRecordsResult.setMessageDealTime(new Date());
        dealRecordsResult.setCurrentTurn(Integer.valueOf(dealRecordsResult.getCurrentTurn() + 1));
        return dealRecordsResult;
    }

    private DycProCommExtSkuMessageRecordsDTO setMsgDealResultFail(DycProCommExtSkuMessageRecordsDTO recordsDTO, String failReason) {
        DycProCommExtSkuMessageRecordsDTO dealRecordsResult = new DycProCommExtSkuMessageRecordsDTO();
        BeanUtils.copyProperties((Object)recordsDTO, (Object)dealRecordsResult);
        dealRecordsResult.setMessageStatus(ECommoditySyncConstant.MessageStatus.FAIL);
        dealRecordsResult.setFailType(ECommoditySyncConstant.FailType.MSG_ERROR);
        dealRecordsResult.setMessageDealTime(new Date());
        dealRecordsResult.setCurrentTurn(Integer.valueOf(dealRecordsResult.getCurrentTurn() + 1));
        dealRecordsResult.setFailReason(failReason);
        return dealRecordsResult;
    }
}

