/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.ecs.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.tydic.dyc.pro.dmc.ecs.service.api.DycProCommReceivePriceChangeMsgService;
import com.tydic.dyc.pro.dmc.ecs.service.bo.DycProCommReceiveMsgReqBO;
import com.tydic.dyc.pro.dmc.ecs.service.bo.DycProCommReceiveMsgRspBO;
import com.tydic.dyc.pro.dmc.repository.extSkuMsgRecord.api.DycProCommExtSkuMessageRecordsRepository;
import com.tydic.dyc.pro.dmc.repository.extSkuMsgRecord.dto.DycProCommExtSkuMessageRecordsDTO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"COMMODITY_SYNC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.ecs.service.api.DycProCommReceivePriceChangeMsgService"})
public class DycProCommReceivePriceChangeMsgServiceImpl
implements DycProCommReceivePriceChangeMsgService {
    @Autowired
    private DycProCommExtSkuMessageRecordsRepository dycProCommExtSkuMessageRecordsRepository;

    @Override
    @PostMapping(value={"receivePriceChangeMsg"})
    public DycProCommReceiveMsgRspBO receivePriceChangeMsg(@RequestBody DycProCommReceiveMsgReqBO reqBO) {
        DycProCommReceiveMsgRspBO respBO = this.receivePriceChangeMsgParamVerify(reqBO);
        if (!"0000".equals(respBO.getRespCode())) {
            return respBO;
        }
        ArrayList<DycProCommExtSkuMessageRecordsDTO> RecordsList = new ArrayList<DycProCommExtSkuMessageRecordsDTO>();
        JSONArray resultObjects = reqBO.getResult();
        for (int i = 0; i < resultObjects.size(); ++i) {
            DycProCommExtSkuMessageRecordsDTO dycProCommExtSkuMessageRecordsDTO = new DycProCommExtSkuMessageRecordsDTO();
            dycProCommExtSkuMessageRecordsDTO.setExtSkuId(resultObjects.getJSONObject(i).getJSONObject("result").getString("skuId"));
            dycProCommExtSkuMessageRecordsDTO.setMessageId(resultObjects.getJSONObject(i).getString("id"));
            try {
                dycProCommExtSkuMessageRecordsDTO.setPushTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(resultObjects.getJSONObject(i).getString("time")));
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            dycProCommExtSkuMessageRecordsDTO.setMessageType(String.valueOf(resultObjects.getJSONObject(i).getInteger("type")));
            dycProCommExtSkuMessageRecordsDTO.setTraceId(reqBO.getTraceId());
            dycProCommExtSkuMessageRecordsDTO.setSupplierHsn(reqBO.getHsn());
            RecordsList.add(dycProCommExtSkuMessageRecordsDTO);
        }
        this.dycProCommExtSkuMessageRecordsRepository.addExtSkuMessageRecords(RecordsList);
        return respBO;
    }

    private DycProCommReceiveMsgRspBO receivePriceChangeMsgParamVerify(DycProCommReceiveMsgReqBO reqBO) {
        DycProCommReceiveMsgRspBO respBO = new DycProCommReceiveMsgRspBO();
        if (StringUtils.isBlank((String)reqBO.getHsn())) {
            respBO.setRespCode("1000");
            respBO.setRespDesc("\u7535\u5546\u8bc6\u522b\u7f16\u7801");
        } else if (StringUtils.isBlank((String)reqBO.getTraceId())) {
            respBO.setRespCode("1000");
            respBO.setRespDesc("\u6d88\u606f\u6c60\u6d41\u6c34id");
        } else if (null == reqBO.getResult()) {
            respBO.setRespCode("1000");
            respBO.setRespDesc("\u6d88\u606f\u4f53");
        } else {
            respBO.setRespCode("0000");
            respBO.setRespDesc("\u6210\u529f");
        }
        return respBO;
    }
}

