/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.shop.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.dmc.constant.DycProShopConstants;
import com.tydic.dyc.pro.dmc.repository.shopmanage.api.DycProShopRepository;
import com.tydic.dyc.pro.dmc.repository.shopmanage.dto.DycProShopInfoDTO;
import com.tydic.dyc.pro.dmc.repository.shopmanage.dto.DycProShopStatusChangeDTO;
import com.tydic.dyc.pro.dmc.service.shop.api.DycProShopSubmitApplyService;
import com.tydic.dyc.pro.dmc.service.shop.bo.DycProShopSubmitShopApplyReqBO;
import com.tydic.dyc.pro.dmc.service.shop.bo.DycProShopSubmitShopApplyRspBO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.shop.api.DycProShopSubmitApplyService"})
public class DycProShopSubmitApplyServiceImpl
implements DycProShopSubmitApplyService {
    private static final Logger log = LoggerFactory.getLogger(DycProShopSubmitApplyServiceImpl.class);
    @Autowired
    private DycProShopRepository dycProShopRepository;

    @PostMapping(value={"createShopApply"})
    public DycProShopSubmitShopApplyRspBO createShopApply(@RequestBody DycProShopSubmitShopApplyReqBO reqBO) {
        DycProShopSubmitShopApplyRspBO rspBO = new DycProShopSubmitShopApplyRspBO();
        this.validateParam(reqBO);
        log.info("\u5e97\u94fa\u521b\u5efa\u5ba1\u6279\u670d\u52a1\u5165\u53c2 DycProShopSubmitShopApplyReqBO :" + JSON.toJSON((Object)reqBO));
        if ("1".equals(reqBO.getBusiType())) {
            DycProShopInfoDTO createShopInfoDTO = (DycProShopInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), DycProShopInfoDTO.class);
            DycProShopInfoDTO dycProShopInfoDTO = this.dycProShopRepository.queryShopMainInfo(createShopInfoDTO);
            if (null != dycProShopInfoDTO.getShopStatus() && !DycProShopConstants.ShopStatusType.DRAFT.equals(dycProShopInfoDTO.getShopStatus()) && !DycProShopConstants.ShopStatusType.REJECTED.equals(dycProShopInfoDTO.getShopStatus())) {
                rspBO.setRespDesc("\u5e97\u94fa\u72b6\u6001\u5f02\u5e38\u3010" + dycProShopInfoDTO.getShopStatus() + "\u3011");
            }
            createShopInfoDTO.setShopStatus(DycProShopConstants.ShopStatusType.DRAFT);
            if (null == createShopInfoDTO.getShopId()) {
                DycProShopInfoDTO addShopInfoDTO = this.dycProShopRepository.addShopDetail(createShopInfoDTO);
                rspBO.setShopApplyId(addShopInfoDTO.getShopId());
            } else {
                this.dycProShopRepository.updateShopDetail(createShopInfoDTO);
                rspBO.setShopApplyId(createShopInfoDTO.getShopId());
            }
        } else if ("2".equals(reqBO.getBusiType())) {
            DycProShopInfoDTO createShopInfoDTO = (DycProShopInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), DycProShopInfoDTO.class);
            DycProShopInfoDTO addShopInfoDTO = this.dycProShopRepository.addShopChangeDetail(createShopInfoDTO);
            rspBO.setShopApplyId(addShopInfoDTO.getChngApplyId());
        } else {
            rspBO.setRespDesc("\u672a\u77e5\u7684\u4e1a\u52a1\u7c7b\u578b\u3010" + reqBO.getBusiType() + "\u3011");
            throw new ZTBusinessException("\u672a\u77e5\u7684\u4e1a\u52a1\u7c7b\u578b\u3010" + reqBO.getBusiType() + "\u3011");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"commitShopApply"})
    public DycProShopSubmitShopApplyRspBO commitShopApply(@RequestBody DycProShopSubmitShopApplyReqBO reqBO) {
        DycProShopSubmitShopApplyRspBO rspBO = new DycProShopSubmitShopApplyRspBO();
        this.validateCommitParam(reqBO);
        DycProShopStatusChangeDTO statusChangeDTO = (DycProShopStatusChangeDTO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), DycProShopStatusChangeDTO.class);
        statusChangeDTO.setSourceShopStatus(DycProShopConstants.ShopStatusType.DRAFT);
        statusChangeDTO.setTargetShopStatus(DycProShopConstants.ShopStatusType.APPROVAL);
        if ("1".equals(reqBO.getBusiType())) {
            this.dycProShopRepository.changeShopStatus(statusChangeDTO);
            rspBO.setShopApplyId(reqBO.getShopId());
        } else if ("2".equals(reqBO.getBusiType())) {
            this.dycProShopRepository.changeShopChngStatus(statusChangeDTO);
            rspBO.setShopApplyId(reqBO.getChngApplyId());
        } else {
            rspBO.setRespDesc("\u672a\u77e5\u7684\u4e1a\u52a1\u7c7b\u578b\u3010" + reqBO.getBusiType() + "\u3011");
            throw new ZTBusinessException("\u672a\u77e5\u7684\u4e1a\u52a1\u7c7b\u578b\u3010" + reqBO.getBusiType() + "\u3011");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validateParam(DycProShopSubmitShopApplyReqBO reqBO) {
        if (null == reqBO.getShopId() && null == reqBO.getSupplierId()) {
            throw new ZTBusinessException("\u975e\u4f9b\u5e94\u5546\uff0c\u4e0d\u80fd\u65b0\u589e\u5e97\u94fa\uff01");
        }
    }

    private void validateCommitParam(DycProShopSubmitShopApplyReqBO reqBO) {
        if (null == reqBO.getShopId()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010shopId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

