/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.consult.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.dictionary.enums.PublicProcInstBusiType;
import com.tydic.dyc.pro.base.core.dictionary.utils.DictionaryFrameworkUtils;
import com.tydic.dyc.pro.base.core.flow.repository.api.DycProPublicProcInstRepository;
import com.tydic.dyc.pro.base.core.flow.repository.dto.DycProPublicProcInstDTO;
import com.tydic.dyc.pro.dmc.constant.DycProSscConstants;
import com.tydic.dyc.pro.dmc.repository.api.DycProSscConsultRepository;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultQryDTO;
import com.tydic.dyc.pro.dmc.service.consult.api.DycProSscQueryConsultDetailService;
import com.tydic.dyc.pro.dmc.service.consult.bo.DycProSscConsultItemInfoBO;
import com.tydic.dyc.pro.dmc.service.consult.bo.DycProSscConsultProgressBO;
import com.tydic.dyc.pro.dmc.service.consult.bo.DycProSscQueryConsultDetailReqBO;
import com.tydic.dyc.pro.dmc.service.consult.bo.DycProSscQueryConsultDetailRspBO;
import java.math.RoundingMode;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.consult.api.DycProSscQueryConsultDetailService"})
public class DycProSscQueryConsultDetailServiceImpl
implements DycProSscQueryConsultDetailService {
    @Autowired
    private DycProSscConsultRepository dycProSscConsultRepository;
    @Autowired
    private DycProPublicProcInstRepository dycProPublicProcInstRepository;

    @Override
    @PostMapping(value={"queryConsultDetail"})
    public DycProSscQueryConsultDetailRspBO queryConsultDetail(@RequestBody DycProSscQueryConsultDetailReqBO reqBO) {
        this.validateParam(reqBO);
        DycProSscConsultQryDTO queryDTO = new DycProSscConsultQryDTO();
        queryDTO.setConsultId(reqBO.getConsultId());
        DycProSscConsultDTO dycProSscConsultDTO = this.dycProSscConsultRepository.queryConsultDetailById(queryDTO);
        DycProSscQueryConsultDetailRspBO rspBO = (DycProSscQueryConsultDetailRspBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)dycProSscConsultDTO), DycProSscQueryConsultDetailRspBO.class));
        if (rspBO.getAllowMissingItems() != null) {
            rspBO.setAllowMissingItemsStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcSscConsultAllowMissingItems", (String)rspBO.getAllowMissingItems().toString()));
        }
        if (rspBO.getProductScopeType() != null) {
            rspBO.setProductScopeTypeStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcSscConsultProductScopeType", (String)rspBO.getProductScopeType().toString()));
        }
        if (rspBO.getConsultStatus() != null) {
            if (DycProSscConstants.ConsultType.CONSULT_TYPE_XJ.equals(rspBO.getConsultType())) {
                rspBO.setConsultStatusStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcSscConsultStatus", (String)rspBO.getConsultStatus().toString()));
            } else if (DycProSscConstants.ConsultType.CONSULT_TYPE_JJ.equals(rspBO.getConsultType())) {
                rspBO.setConsultStatusStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcSscConsultStatusJJ", (String)rspBO.getConsultStatus().toString()));
            } else if (DycProSscConstants.ConsultType.CONSULT_TYPE_YJ.equals(rspBO.getConsultType())) {
                rspBO.setConsultStatusStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcSscConsultStatusYJ", (String)rspBO.getConsultStatus().toString()));
            } else {
                rspBO.setConsultStatusStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcSscConsultStatus", (String)rspBO.getConsultStatus().toString()));
            }
        }
        if (rspBO.getConsultItemInfoList() != null) {
            for (DycProSscConsultItemInfoBO dycProSscConsultItemInfoBO : rspBO.getConsultItemInfoList()) {
                if (dycProSscConsultItemInfoBO.getTaxRate() == null) continue;
                int taxRateInt = dycProSscConsultItemInfoBO.getTaxRate().setScale(0, RoundingMode.DOWN).intValue();
                dycProSscConsultItemInfoBO.setTaxRateInt(String.valueOf(taxRateInt));
            }
        }
        if (rspBO.getConsultProgressList() != null) {
            for (DycProSscConsultProgressBO dycProSscConsultProgressBO : rspBO.getConsultProgressList()) {
                if (dycProSscConsultProgressBO.getCurrentQuoteTurn() == null) continue;
                dycProSscConsultProgressBO.setCurrentQuoteTurnStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcSscConsultQuoteTurn", (String)String.valueOf(dycProSscConsultProgressBO.getCurrentQuoteTurn())));
            }
        }
        DycProPublicProcInstDTO qryPublicProcInst = new DycProPublicProcInstDTO();
        qryPublicProcInst.setObjId(reqBO.getConsultId());
        if (DycProSscConstants.ConsultType.CONSULT_TYPE_XJ.equals(rspBO.getConsultType())) {
            qryPublicProcInst.setBusiType(PublicProcInstBusiType.CONSULT_INQUIRY_APPROVE.getCode());
        } else if (DycProSscConstants.ConsultType.CONSULT_TYPE_JJ.equals(rspBO.getConsultType())) {
            qryPublicProcInst.setBusiType(PublicProcInstBusiType.CONSULT_BIDDING_APPROVE.getCode());
        } else {
            return rspBO;
        }
        DycProPublicProcInstDTO dycProPublicProcInstDTO = this.dycProPublicProcInstRepository.queryFlowMainByObjLastOne(qryPublicProcInst);
        if (null != dycProPublicProcInstDTO) {
            rspBO.setProcInstId(dycProPublicProcInstDTO.getProcInstId());
        }
        if (DycProSscConstants.ConsultType.CONSULT_TYPE_XJ.equals(rspBO.getConsultType())) {
            qryPublicProcInst.setBusiType(PublicProcInstBusiType.CONSULT_INQUIRY_RESULT_APPROVE.getCode());
        } else if (DycProSscConstants.ConsultType.CONSULT_TYPE_JJ.equals(rspBO.getConsultType())) {
            qryPublicProcInst.setBusiType(PublicProcInstBusiType.CONSULT_BIDDING_RESULT_APPROVE.getCode());
        } else {
            return rspBO;
        }
        DycProPublicProcInstDTO dycProPublicProcInstDTO2 = this.dycProPublicProcInstRepository.queryFlowMainByObjLastOne(qryPublicProcInst);
        if (null != dycProPublicProcInstDTO2) {
            rspBO.setResultProcInstId(dycProPublicProcInstDTO2.getProcInstId());
        }
        Date now = new Date(System.currentTimeMillis());
        rspBO.setSysDateTime(now);
        return rspBO;
    }

    private void validateParam(DycProSscQueryConsultDetailReqBO reqBO) {
        if (null == reqBO.getConsultId()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010consultId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

