/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.consult.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.dictionary.utils.DictionaryFrameworkUtils;
import com.tydic.dyc.pro.dmc.constant.DycProSscConstants;
import com.tydic.dyc.pro.dmc.repository.api.DycProSscConsultRepository;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultQuoteInfoDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultQuoteItemInfoDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscQryConsultAndItemAndSupplierListDTO;
import com.tydic.dyc.pro.dmc.service.consult.api.DycProSscQryConsultAndItemAndSupplierListService;
import com.tydic.dyc.pro.dmc.service.consult.bo.DycProSscQryConsultAndItemAndSupplierListBO;
import com.tydic.dyc.pro.dmc.service.consult.bo.DycProSscQryConsultAndItemAndSupplierListReqBO;
import com.tydic.dyc.pro.dmc.service.consult.bo.DycProSscQryConsultAndItemAndSupplierListRspBO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.consult.api.DycProSscQryConsultAndItemAndSupplierListService"})
public class DycProSscQryConsultAndItemAndSupplierListServiceImpl
implements DycProSscQryConsultAndItemAndSupplierListService {
    @Autowired
    private DycProSscConsultRepository dycProSscConsultRepository;

    @Override
    @PostMapping(value={"qryConsultAndItemAndSupplierList"})
    public DycProSscQryConsultAndItemAndSupplierListRspBO qryConsultAndItemAndSupplierList(@RequestBody DycProSscQryConsultAndItemAndSupplierListReqBO reqBO) {
        List dycProSscQryConsultAndItemAndSupplierListDTOS;
        this.validateParam(reqBO);
        DycProSscQryConsultAndItemAndSupplierListRspBO rsp = new DycProSscQryConsultAndItemAndSupplierListRspBO();
        DycProSscConsultDTO consultDTO = new DycProSscConsultDTO();
        consultDTO.setConsultId(reqBO.getConsultId());
        DycProSscConsultDTO dycProSscConsultDTO = this.dycProSscConsultRepository.queryConsultBaseInfo(consultDTO);
        DycProSscConsultQuoteItemInfoDTO qryDTO = (DycProSscConsultQuoteItemInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycProSscConsultQuoteItemInfoDTO.class);
        if (null == reqBO.getQuoteTurn()) {
            qryDTO.setQuoteTurn(dycProSscConsultDTO.getCurrentQuoteTurn());
        }
        if (null != reqBO.getSkuNameOrCode()) {
            qryDTO.setConsultSkuCode(reqBO.getSkuNameOrCode());
            qryDTO.setConsultSkuName(reqBO.getSkuNameOrCode());
        }
        if (!CollectionUtils.isEmpty((Collection)(dycProSscQryConsultAndItemAndSupplierListDTOS = this.dycProSscConsultRepository.qryConsultAndItemAndSupplierList(qryDTO)))) {
            if (reqBO.getAllSupplier() != null && reqBO.getAllSupplier().equals("1")) {
                List filteredList = dycProSscQryConsultAndItemAndSupplierListDTOS.stream().collect(Collectors.groupingBy(dto -> dto.getConsultItemId(), Collectors.minBy(Comparator.comparing(DycProSscQryConsultAndItemAndSupplierListDTO::getQuotePrice)))).values().stream().map(optional -> {
                    DycProSscQryConsultAndItemAndSupplierListDTO dto = (DycProSscQryConsultAndItemAndSupplierListDTO)optional.get();
                    dto.setQuoteDesc(null);
                    return dto;
                }).collect(Collectors.toList());
                rsp.setRows(JSON.parseArray((String)JSON.toJSONString(filteredList), DycProSscQryConsultAndItemAndSupplierListBO.class));
            } else {
                rsp.setRows(JSON.parseArray((String)JSON.toJSONString((Object)dycProSscQryConsultAndItemAndSupplierListDTOS), DycProSscQryConsultAndItemAndSupplierListBO.class));
            }
        }
        DycProSscConsultQuoteInfoDTO qryQuoteDTO = new DycProSscConsultQuoteInfoDTO();
        qryQuoteDTO.setDelFlag(DycProSscConstants.DEL_FLAG.UN_DELETE);
        qryQuoteDTO.setQuoteTurn(qryDTO.getQuoteTurn());
        qryQuoteDTO.setConsultId(dycProSscConsultDTO.getConsultId());
        qryQuoteDTO.setQuoteStatus(DycProSscConstants.QuoteStatus.HAS_QUOTE);
        List dycProSscConsultQuoteInfoDTOS = this.dycProSscConsultRepository.queryConsultQuoteInfoList(qryQuoteDTO);
        if (!CollectionUtils.isEmpty((Collection)dycProSscConsultQuoteInfoDTOS)) {
            DycProSscConsultQuoteInfoDTO dycProSscConsultQuoteInfoDTO = (DycProSscConsultQuoteInfoDTO)dycProSscConsultQuoteInfoDTOS.get(0);
            rsp.setQuoteTotalAmount(dycProSscConsultQuoteInfoDTO.getQuoteTotalAmount());
            rsp.setDropFee(dycProSscConsultQuoteInfoDTO.getDropFee());
            rsp.setDiscountRate(dycProSscConsultQuoteInfoDTO.getDiscountRate());
            rsp.setQuoteTime(dycProSscConsultQuoteInfoDTO.getQuoteTime());
            rsp.setQuoteTurn(dycProSscConsultQuoteInfoDTO.getQuoteTurn());
        } else {
            rsp.setQuoteTurn(dycProSscConsultDTO.getCurrentQuoteTurn());
        }
        if (null != rsp.getQuoteTurn()) {
            rsp.setQuoteTurnStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcSscConsultQuoteTurn", (String)String.valueOf(rsp.getQuoteTurn())));
        }
        rsp.setConsultTotalPrice(dycProSscConsultDTO.getConsultTotalPrice());
        if (DycProSscConstants.ConsultType.CONSULT_TYPE_YJ.equals(dycProSscConsultDTO.getConsultType()) && null != rsp.getRows() && !rsp.getRows().isEmpty()) {
            rsp.getRows().forEach(dto -> {
                BigDecimal temp = dto.getSalePrice();
                dto.setSalePrice(dto.getPredictPrice());
                dto.setPredictPrice(temp);
                temp = dto.getSalePriceAll();
                dto.setSalePriceAll(dto.getPredictTotalPrice());
                dto.setPredictTotalPrice(temp);
            });
            rsp.setSalePriceAllTotal(dycProSscConsultDTO.getConsultTotalPrice());
        }
        return rsp;
    }

    private void validateParam(DycProSscQryConsultAndItemAndSupplierListReqBO reqBO) {
        if (null == reqBO.getConsultId()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010consultId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

