/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.consult.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.dmc.constant.DycProSscConstants;
import com.tydic.dyc.pro.dmc.repository.api.DycProSscConsultRepository;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultCreateQuoteTurnDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultQryDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultSupplierInfoDTO;
import com.tydic.dyc.pro.dmc.service.consult.api.DycProSscCutPointService;
import com.tydic.dyc.pro.dmc.service.consult.api.DycProSscSubmitQuoteTurnService;
import com.tydic.dyc.pro.dmc.service.consult.bo.DycProSscCutPointReqBO;
import com.tydic.dyc.pro.dmc.service.consult.bo.DycProSscSubmitQuoteTurnReqBO;
import com.tydic.dyc.pro.dmc.service.consult.bo.DycProSscSubmitQuoteTurnRspBO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.consult.api.DycProSscSubmitQuoteTurnService"})
public class DycProSscSubmitQuoteTurnServiceImpl
implements DycProSscSubmitQuoteTurnService {
    private static final Logger log = LoggerFactory.getLogger(DycProSscSubmitQuoteTurnServiceImpl.class);
    @Autowired
    private DycProSscConsultRepository dycProSscConsultRepository;
    @Autowired
    private DycProSscCutPointService dycProSscCutPointService;

    @Override
    @PostMapping(value={"submitQuoteTurn"})
    public DycProSscSubmitQuoteTurnRspBO submitQuoteTurn(@RequestBody DycProSscSubmitQuoteTurnReqBO reqBO) {
        DycProSscCutPointReqBO dycProSscCutPointReqBO;
        if (null == reqBO.getConsultId()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010\u534f\u5546\u5355\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getQuoteEndTime()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010\u672c\u8f6e\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if ("1".equals(reqBO.getStayTurn())) {
            DycProSscConsultDTO consultUpdateDTO = new DycProSscConsultDTO();
            consultUpdateDTO.setConsultId(reqBO.getConsultId());
            consultUpdateDTO.setConsultStatus(DycProSscConstants.ConsultStatus.QUOTING);
            consultUpdateDTO.setQuoteEndTime(reqBO.getQuoteEndTime());
            this.dycProSscConsultRepository.updateConsultBaseInfoById(consultUpdateDTO);
            return new DycProSscSubmitQuoteTurnRspBO();
        }
        DycProSscConsultCreateQuoteTurnDTO createQuoteTurnDTO = (DycProSscConsultCreateQuoteTurnDTO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycProSscConsultCreateQuoteTurnDTO.class);
        this.dycProSscConsultRepository.createQuoteTurn(createQuoteTurnDTO);
        log.info("submitQuoteTurn reqBO =" + JSON.toJSONString((Object)((Object)reqBO)));
        DycProSscConsultQryDTO queryDTO = new DycProSscConsultQryDTO();
        queryDTO.setConsultId(reqBO.getConsultId());
        DycProSscConsultDTO dycProSscConsultDTO = this.dycProSscConsultRepository.queryConsultDetailById(queryDTO);
        log.info("submitQuoteTurn getSupplierInfoList =" + JSON.toJSONString(reqBO.getSupplierInfoList()));
        for (DycProSscConsultSupplierInfoDTO supplierInfoBO : dycProSscConsultDTO.getSupplierInfoList()) {
            dycProSscCutPointReqBO = new DycProSscCutPointReqBO();
            dycProSscCutPointReqBO.setConsultId(reqBO.getConsultId());
            dycProSscCutPointReqBO.setSupplierId(supplierInfoBO.getSupplierId());
            if (DycProSscConstants.ConsultType.CONSULT_TYPE_XJ.equals(dycProSscConsultDTO.getConsultType())) {
                dycProSscCutPointReqBO.setTodoType("SscXjQuoteTurn");
            } else if (DycProSscConstants.ConsultType.CONSULT_TYPE_JJ.equals(dycProSscConsultDTO.getConsultType())) {
                dycProSscCutPointReqBO.setTodoType("SscJjQuote");
            } else if (DycProSscConstants.ConsultType.CONSULT_TYPE_YJ.equals(dycProSscConsultDTO.getConsultType())) {
                dycProSscCutPointReqBO.setTodoType("SendYjTurn");
            }
            dycProSscCutPointReqBO.setCenter("SSC");
            dycProSscCutPointReqBO.setShareId(dycProSscCutPointReqBO.getConsultId());
            dycProSscCutPointReqBO.setObjId(dycProSscCutPointReqBO.getConsultId());
            dycProSscCutPointReqBO.setObjType("2");
            dycProSscCutPointReqBO.setBusiType(dycProSscCutPointReqBO.getTodoType());
            log.info("submitQuoteTurn dycProSscCutPointReqBO =" + JSON.toJSONString((Object)((Object)dycProSscCutPointReqBO)));
            this.dycProSscCutPointService.todoCutPoint(dycProSscCutPointReqBO);
        }
        for (DycProSscConsultSupplierInfoDTO supplierInfoBO : dycProSscConsultDTO.getSupplierInfoList()) {
            dycProSscCutPointReqBO = new DycProSscCutPointReqBO();
            dycProSscCutPointReqBO.setConsultId(reqBO.getConsultId());
            dycProSscCutPointReqBO.setSupplierId(supplierInfoBO.getSupplierId());
            dycProSscCutPointReqBO.setUserId(supplierInfoBO.getSupplierId());
            dycProSscCutPointReqBO.setTodoType("QuoteOver");
            dycProSscCutPointReqBO.setCenter("SSC");
            dycProSscCutPointReqBO.setShareId(dycProSscCutPointReqBO.getConsultId());
            dycProSscCutPointReqBO.setObjId(dycProSscCutPointReqBO.getConsultId());
            dycProSscCutPointReqBO.setObjType("2");
            dycProSscCutPointReqBO.setBusiType(dycProSscCutPointReqBO.getTodoType());
            log.info("submitQuoteTurn dycProSscCutPointReqBO =" + JSON.toJSONString((Object)((Object)dycProSscCutPointReqBO)));
            this.dycProSscCutPointService.todoCutPoint(dycProSscCutPointReqBO);
        }
        return new DycProSscSubmitQuoteTurnRspBO();
    }
}

