/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.consult.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.dmc.constant.DycProSscConstants;
import com.tydic.dyc.pro.dmc.repository.api.DycProSscConsultRepository;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultHandleDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultQryDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultSupplierInfoDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscFileInfoDTO;
import com.tydic.dyc.pro.dmc.service.consult.api.DycProSscCutPointService;
import com.tydic.dyc.pro.dmc.service.consult.api.DycProSscEndConsultService;
import com.tydic.dyc.pro.dmc.service.consult.bo.DycProSscCutPointReqBO;
import com.tydic.dyc.pro.dmc.service.consult.bo.DycProSscEndConsultReqBO;
import com.tydic.dyc.pro.dmc.service.consult.bo.DycProSscEndConsultRspBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.consult.api.DycProSscEndConsultService"})
public class DycProSscEndConsultServiceImpl
implements DycProSscEndConsultService {
    private static final Logger log = LoggerFactory.getLogger(DycProSscEndConsultServiceImpl.class);
    @Autowired
    private DycProSscConsultRepository dycProSscConsultRepository;
    @Autowired
    private DycProSscCutPointService dycProSscCutPointService;

    @Override
    @PostMapping(value={"endConsult"})
    public DycProSscEndConsultRspBO endConsult(@RequestBody DycProSscEndConsultReqBO reqBO) {
        if (reqBO == null || reqBO.getConsultId() == null) {
            throw new ZTBusinessException("\u534f\u5546\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getStopReason())) {
            throw new ZTBusinessException("\u7ec8\u6b62\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DycProSscConsultDTO consultDTO = new DycProSscConsultDTO();
        consultDTO.setConsultId(reqBO.getConsultId());
        consultDTO.setStopTime(new Date());
        consultDTO.setStopUserId(reqBO.getUserId());
        consultDTO.setStopUserName(reqBO.getName());
        consultDTO.setStopOrgId(reqBO.getOrgId());
        consultDTO.setStopOrgName(reqBO.getOrgName());
        consultDTO.setStopOrgPath(reqBO.getOrgPath());
        consultDTO.setStopCompanyId(reqBO.getCompanyId());
        consultDTO.setStopCompanyName(reqBO.getCompanyName());
        consultDTO.setStopReason(reqBO.getStopReason());
        consultDTO.setConsultStatus(DycProSscConstants.ConsultStatus.QUOTATION_TERMINATED);
        if (reqBO.getStopType() == null) {
            consultDTO.setStopType("2");
        } else {
            consultDTO.setStopType(reqBO.getStopType());
        }
        this.dycProSscConsultRepository.updateConsultBaseInfoById(consultDTO);
        if (!CollectionUtils.isEmpty(reqBO.getFileInfoList())) {
            DycProSscConsultHandleDTO consultHandleDTO = new DycProSscConsultHandleDTO();
            consultHandleDTO.setFileInfoList(JSON.parseArray((String)JSON.toJSONString(reqBO.getFileInfoList()), DycProSscFileInfoDTO.class));
            consultHandleDTO.setObjId(consultDTO.getConsultId());
            consultHandleDTO.setObjType(DycProSscConstants.SscFileObjType.CONSULT_STOP);
            this.dycProSscConsultRepository.createFile(consultHandleDTO);
        }
        DycProSscConsultQryDTO queryDTO = new DycProSscConsultQryDTO();
        queryDTO.setConsultId(reqBO.getConsultId());
        DycProSscConsultDTO dycProSscConsultDTO = this.dycProSscConsultRepository.queryConsultDetailById(queryDTO);
        List supplierList = dycProSscConsultDTO.getSupplierInfoList();
        if (DycProSscConstants.ConsultType.CONSULT_TYPE_YJ.equals(dycProSscConsultDTO.getConsultType())) {
            for (DycProSscConsultSupplierInfoDTO supplier : supplierList) {
                DycProSscCutPointReqBO dycProSscCutPointReqBO = new DycProSscCutPointReqBO();
                dycProSscCutPointReqBO.setConsultId(reqBO.getConsultId());
                dycProSscCutPointReqBO.setSupplierId(supplier.getSupplierId());
                dycProSscCutPointReqBO.setTodoType("OverYj");
                dycProSscCutPointReqBO.setCenter("SSC");
                dycProSscCutPointReqBO.setShareId(dycProSscCutPointReqBO.getConsultId());
                dycProSscCutPointReqBO.setObjId(dycProSscCutPointReqBO.getConsultId());
                dycProSscCutPointReqBO.setObjType("2");
                dycProSscCutPointReqBO.setBusiType(dycProSscCutPointReqBO.getTodoType());
                this.dycProSscCutPointService.todoCutPoint(dycProSscCutPointReqBO);
            }
        }
        log.info("\u7ec8\u6b62\u534f\u5546\u5355 \u6d88\u9664\u5f85\u529e ");
        for (DycProSscConsultSupplierInfoDTO supplier : supplierList) {
            ArrayList<Long> userIds = new ArrayList<Long>();
            userIds.add(supplier.getSupplierId());
            DycProSscCutPointReqBO dycProSscCutPointReqBO = new DycProSscCutPointReqBO();
            dycProSscCutPointReqBO.setConsultId(reqBO.getConsultId());
            dycProSscCutPointReqBO.setSupplierId(supplier.getSupplierId());
            dycProSscCutPointReqBO.setAuditCancelUserIds(userIds);
            dycProSscCutPointReqBO.setTodoType("QuoteOver");
            dycProSscCutPointReqBO.setCenter("SSC");
            dycProSscCutPointReqBO.setShareId(dycProSscCutPointReqBO.getConsultId());
            dycProSscCutPointReqBO.setObjId(dycProSscCutPointReqBO.getConsultId());
            dycProSscCutPointReqBO.setObjType("2");
            dycProSscCutPointReqBO.setBusiType(dycProSscCutPointReqBO.getTodoType());
            log.info("\u7ec8\u6b62\u534f\u5546\u5355 \u6d88\u9664\u5f85\u529e dycProSscCutPointReqBO =" + JSON.toJSONString((Object)((Object)dycProSscCutPointReqBO)));
            this.dycProSscCutPointService.todoCutPoint(dycProSscCutPointReqBO);
        }
        return new DycProSscEndConsultRspBO();
    }
}

