/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.insporder.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtil;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilOrderCompletionReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilOrderCompletionRspBO;
import com.tydic.dyc.pro.egc.repository.insporder.api.DycProOrderInspOrderRepository;
import com.tydic.dyc.pro.egc.repository.insporder.dto.DycProOrderInspOrderDTO;
import com.tydic.dyc.pro.egc.repository.insporder.dto.DycProOrderInspOrderHandleDTO;
import com.tydic.dyc.pro.egc.repository.insporder.dto.DycProOrderInspOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.insporder.dto.DycProOrderOrderAccessoryDTO;
import com.tydic.dyc.pro.egc.repository.insporder.dto.DycProOrderShipInspRelDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemQryDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.api.DycProOrderShipOrderRepository;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderItemQryDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderQryDTO;
import com.tydic.dyc.pro.egc.service.constants.DycProOrderApiServiceConstant;
import com.tydic.dyc.pro.egc.service.insporder.api.DycProOrderCreateInspOrderService;
import com.tydic.dyc.pro.egc.service.insporder.bo.DycProOrderCreateInspOrderReqBO;
import com.tydic.dyc.pro.egc.service.insporder.bo.DycProOrderCreateInspOrderRspBO;
import com.tydic.dyc.pro.egc.service.insporder.bo.DycProOrderInspApiBO;
import com.tydic.dyc.pro.egc.service.insporder.bo.DycProOrderInspItemApiBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.insporder.api.DycProOrderCreateInspOrderService"})
public class DycProOrderCreateInspOrderServiceImpl
implements DycProOrderCreateInspOrderService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderCreateInspOrderServiceImpl.class);
    @Value(value="${call.esb.url.orderCompletion}")
    private String callEsbUrlOrderCompletion;
    @Autowired
    private Environment environment;
    @Autowired
    private DycProOrderInspOrderRepository dycProOrderInspOrderRepository;
    @Autowired
    private DycProOrderShipOrderRepository dycProOrderShipOrderRepository;
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;

    @PostMapping(value={"createAcceptOrder"})
    public DycProOrderCreateInspOrderRspBO createAcceptOrder(@RequestBody DycProOrderCreateInspOrderReqBO reqBO) {
        ArrayList<DycProOrderShipOrderQryDTO> updateShipOrderDtoList;
        ArrayList<Long> shipOrderIdList = new ArrayList<Long>();
        ArrayList<Long> saleOrderItemList = new ArrayList<Long>();
        HashMap<Long, BigDecimal> shipOrderItemInspCountMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> saleOrderItemInspCountMap = new HashMap<Long, BigDecimal>();
        DycProOrderSaleOrderDTO salOrderDetail = this.qrySalOrderDetail(reqBO.getSaleOrderId());
        this.verifyParam(reqBO);
        if (DycProOrderApiServiceConstant.OrderSource.E_ORDER.equals(reqBO.getOrderSource())) {
            String hsn = this.environment.getProperty("SUPPLIER_ID_" + reqBO.getSupplierId());
            DycProBaseCallEsbUtilOrderCompletionReqBO callEsbReqBo = new DycProBaseCallEsbUtilOrderCompletionReqBO();
            callEsbReqBo.setHsn(hsn);
            callEsbReqBo.setUrl(this.callEsbUrlOrderCompletion);
            callEsbReqBo.setOrderId(reqBO.getSaleOrderNoExt());
            DycProBaseCallEsbUtilOrderCompletionRspBO callEsbRspBO = DycProBaseCallEsbUtil.orderCompletion((DycProBaseCallEsbUtilOrderCompletionReqBO)callEsbReqBo);
            if (!callEsbRspBO.getSuccess().booleanValue() || !"0000".equals(callEsbRspBO.getResultCode())) {
                throw new ZTBusinessException(callEsbRspBO.getResultMessage());
            }
        }
        DycProOrderInspOrderHandleDTO addInspOrderDto = new DycProOrderInspOrderHandleDTO();
        addInspOrderDto.setModelSettle(reqBO.getModelSettle());
        addInspOrderDto.setSaleOrderId(reqBO.getSaleOrderId());
        addInspOrderDto.setOrderId(reqBO.getOrderId());
        addInspOrderDto.setInspOper(reqBO.getName());
        addInspOrderDto.setInspOperPhone(reqBO.getRegMobile());
        addInspOrderDto.setCreateOperId(String.valueOf(reqBO.getUserId()));
        addInspOrderDto.setRemark(reqBO.getRemark());
        ArrayList<DycProOrderInspOrderItemDTO> inspItemList = new ArrayList<DycProOrderInspOrderItemDTO>();
        for (Object dycProOrderInspApiBo : reqBO.getInspOrderList()) {
            for (DycProOrderInspItemApiBO dycProOrderInspItemApiBo : dycProOrderInspApiBo.getAcceptItemList()) {
                DycProOrderInspOrderItemDTO inspOrderItemDto = new DycProOrderInspOrderItemDTO();
                inspOrderItemDto.setOrderId(reqBO.getOrderId());
                inspOrderItemDto.setSaleOrderId(reqBO.getSaleOrderId());
                inspOrderItemDto.setSaleOrderItemId(dycProOrderInspItemApiBo.getSaleOrderItemId());
                inspOrderItemDto.setShipOrderItemId(dycProOrderInspItemApiBo.getShipOrderItemId());
                inspOrderItemDto.setInspCount(dycProOrderInspItemApiBo.getInspCount());
                inspOrderItemDto.setInitInspCount(dycProOrderInspItemApiBo.getInspCount());
                inspOrderItemDto.setRemainInspCount(dycProOrderInspItemApiBo.getInspCount());
                inspOrderItemDto.setShipOrderNo(dycProOrderInspApiBo.getShipOrderNo());
                inspItemList.add(inspOrderItemDto);
                shipOrderIdList.add(dycProOrderInspApiBo.getShipOrderId());
                saleOrderItemList.add(dycProOrderInspItemApiBo.getSaleOrderItemId());
                if (shipOrderItemInspCountMap.containsKey(dycProOrderInspItemApiBo.getShipOrderItemId())) {
                    BigDecimal shipOrderItemInspCount = (BigDecimal)shipOrderItemInspCountMap.get(dycProOrderInspItemApiBo.getShipOrderItemId());
                    shipOrderItemInspCount = shipOrderItemInspCount.add(dycProOrderInspItemApiBo.getInspCount());
                    shipOrderItemInspCountMap.put(dycProOrderInspItemApiBo.getShipOrderItemId(), shipOrderItemInspCount);
                } else {
                    shipOrderItemInspCountMap.put(dycProOrderInspItemApiBo.getShipOrderItemId(), dycProOrderInspItemApiBo.getInspCount());
                }
                if (saleOrderItemInspCountMap.containsKey(dycProOrderInspItemApiBo.getSaleOrderItemId())) {
                    BigDecimal saleOrderItemInspCount = (BigDecimal)saleOrderItemInspCountMap.get(dycProOrderInspItemApiBo.getSaleOrderItemId());
                    saleOrderItemInspCount = saleOrderItemInspCount.add(dycProOrderInspItemApiBo.getInspCount());
                    saleOrderItemInspCountMap.put(dycProOrderInspItemApiBo.getSaleOrderItemId(), saleOrderItemInspCount);
                    continue;
                }
                saleOrderItemInspCountMap.put(dycProOrderInspItemApiBo.getSaleOrderItemId(), dycProOrderInspItemApiBo.getInspCount());
            }
        }
        addInspOrderDto.setInspItemList(inspItemList);
        ArrayList<DycProOrderOrderAccessoryDTO> inspOrderAccessoryList = new ArrayList<DycProOrderOrderAccessoryDTO>();
        for (Object accessoryApiBo : reqBO.getInspOrderAccessoryList()) {
            DycProOrderOrderAccessoryDTO accessoryDto = new DycProOrderOrderAccessoryDTO();
            BeanUtils.copyProperties((Object)accessoryApiBo, (Object)accessoryDto);
            accessoryDto.setObjType(DycProOrderApiServiceConstant.AccessoryObjType.INSP_ORDER_FILE);
            inspOrderAccessoryList.add(accessoryDto);
        }
        addInspOrderDto.setInspOrderAccessoryList(inspOrderAccessoryList);
        ArrayList<DycProOrderOrderAccessoryDTO> inspOrderPicList = new ArrayList<DycProOrderOrderAccessoryDTO>();
        for (Object accessoryApiBo : reqBO.getInspOrderPicList()) {
            DycProOrderOrderAccessoryDTO accessoryPicDto = new DycProOrderOrderAccessoryDTO();
            BeanUtils.copyProperties((Object)accessoryApiBo, (Object)accessoryPicDto);
            accessoryPicDto.setObjType(DycProOrderApiServiceConstant.AccessoryObjType.INSP_ORDER_PIC);
            inspOrderPicList.add(accessoryPicDto);
        }
        addInspOrderDto.setInspOrderPicList(inspOrderPicList);
        ArrayList<DycProOrderShipInspRelDTO> shipOrderInspRelList = new ArrayList<DycProOrderShipInspRelDTO>();
        for (Object dycProOrderInspApiBo : reqBO.getInspOrderList()) {
            DycProOrderShipInspRelDTO addShipInspRelDto = new DycProOrderShipInspRelDTO();
            addShipInspRelDto.setOrderId(reqBO.getOrderId());
            addShipInspRelDto.setSaleOrderId(reqBO.getSaleOrderId());
            addShipInspRelDto.setShipOrderId(dycProOrderInspApiBo.getShipOrderId());
            shipOrderInspRelList.add(addShipInspRelDto);
        }
        addInspOrderDto.setShipOrderInspRelList(shipOrderInspRelList);
        DycProOrderInspOrderDTO resultInspOrderDTO = this.dycProOrderInspOrderRepository.createInspOrderAllInfoAndSyncNosql(addInspOrderDto, salOrderDetail);
        for (DycProOrderInspApiBO dycProOrderInspApiBo : reqBO.getInspOrderList()) {
            DycProOrderShipOrderItemQryDTO queryShipOrderItemReqBo = new DycProOrderShipOrderItemQryDTO();
            queryShipOrderItemReqBo.setShipOrderId(dycProOrderInspApiBo.getShipOrderId());
            List shipOrderItemDtoList = this.dycProOrderShipOrderRepository.queryShipOrderItemByCondition(queryShipOrderItemReqBo);
            if (CollectionUtils.isEmpty((Collection)shipOrderItemDtoList)) continue;
            DycProOrderShipOrderQryDTO updateShipOrderDto = new DycProOrderShipOrderQryDTO();
            updateShipOrderDto.setShipOrderId(dycProOrderInspApiBo.getShipOrderId());
            ArrayList<DycProOrderShipOrderItemDTO> updateShipOrderItemDtoList = new ArrayList<DycProOrderShipOrderItemDTO>();
            Iterator iterator = shipOrderItemDtoList.iterator();
            while (iterator.hasNext()) {
                DycProOrderShipOrderItemDTO dycProOrderShipOrderItemDto = (DycProOrderShipOrderItemDTO)iterator.next();
                DycProOrderShipOrderItemDTO updateShipOrderItemDto = new DycProOrderShipOrderItemDTO();
                updateShipOrderItemDto.setShipOrderItemId(dycProOrderShipOrderItemDto.getShipOrderItemId());
                BigDecimal shipOrderItemInspCount = (BigDecimal)shipOrderItemInspCountMap.get(dycProOrderShipOrderItemDto.getShipOrderItemId());
                if (null == shipOrderItemInspCount) {
                    shipOrderItemInspCount = BigDecimal.ZERO;
                }
                updateShipOrderItemDto.setInspCount(shipOrderItemInspCount.add(dycProOrderShipOrderItemDto.getInspCount()));
                updateShipOrderItemDtoList.add(updateShipOrderItemDto);
            }
            updateShipOrderDto.setShipItemList(updateShipOrderItemDtoList);
            this.dycProOrderShipOrderRepository.updateShipOrderItemBatchByIdsAndSyncNosql((DycProOrderShipOrderDTO)updateShipOrderDto);
        }
        DycProOrderSaleOrderItemQryDTO querySaleOrderItemReqDto = new DycProOrderSaleOrderItemQryDTO();
        querySaleOrderItemReqDto.setSaleOrderItemIdList(saleOrderItemList);
        List saleOrderItemDtoList = this.dycProOrderSaleOrderRepository.querySaleOrderItemListByCondition(querySaleOrderItemReqDto);
        ArrayList<DycProOrderSaleOrderItemDTO> updateSaleOrderItemDtoList = new ArrayList<DycProOrderSaleOrderItemDTO>();
        if (!CollectionUtils.isEmpty((Collection)saleOrderItemDtoList)) {
            for (DycProOrderSaleOrderItemDTO dycProOrderSaleOrderItemDto : saleOrderItemDtoList) {
                BigDecimal saleOrderItemInspCount = (BigDecimal)saleOrderItemInspCountMap.get(dycProOrderSaleOrderItemDto.getSaleOrderItemId());
                if (null == saleOrderItemInspCount) continue;
                DycProOrderSaleOrderItemDTO updateSaleOrderItemDto = new DycProOrderSaleOrderItemDTO();
                updateSaleOrderItemDto.setSaleOrderItemId(dycProOrderSaleOrderItemDto.getSaleOrderItemId());
                updateSaleOrderItemDto.setAcceptanceCount(saleOrderItemInspCount.add(dycProOrderSaleOrderItemDto.getAcceptanceCount()));
                updateSaleOrderItemDto.setSalePrice(dycProOrderSaleOrderItemDto.getSalePrice());
                updateSaleOrderItemDto.setPurchasePrice(dycProOrderSaleOrderItemDto.getPurchasePrice());
                updateSaleOrderItemDtoList.add(updateSaleOrderItemDto);
            }
            this.dycProOrderSaleOrderRepository.updateSaleOrderItemBatchById(updateSaleOrderItemDtoList);
        }
        DycProOrderSaleOrderDTO updateSaleOrderDto = new DycProOrderSaleOrderDTO();
        updateSaleOrderDto.setSaleOrderId(reqBO.getSaleOrderId());
        if (DycProOrderApiServiceConstant.OrderSource.E_ORDER.equals(reqBO.getOrderSource())) {
            updateShipOrderDtoList = new ArrayList<DycProOrderShipOrderQryDTO>();
            for (Long shipOrderId : shipOrderIdList) {
                DycProOrderShipOrderQryDTO updateShipOrderDto = new DycProOrderShipOrderQryDTO();
                updateShipOrderDto.setShipOrderId(shipOrderId);
                updateShipOrderDto.setShipOrderState("FH_FH_YS");
                updateShipOrderDtoList.add(updateShipOrderDto);
            }
            updateSaleOrderDto.setShiporderList(updateShipOrderDtoList);
            this.dycProOrderShipOrderRepository.updateShipOrderBatchByIdsAndSyncNosql(updateShipOrderDtoList);
        } else {
            updateShipOrderDtoList = new ArrayList();
            for (DycProOrderInspApiBO dycProOrderInspApiBo : reqBO.getInspOrderList()) {
                DycProOrderShipOrderItemQryDTO queryShipOrderItemReqDto = new DycProOrderShipOrderItemQryDTO();
                queryShipOrderItemReqDto.setShipOrderId(dycProOrderInspApiBo.getShipOrderId());
                List shipOrderItemDTOList = this.dycProOrderShipOrderRepository.queryShipOrderItemByCondition(queryShipOrderItemReqDto);
                Object shipOrderInspFinish = true;
                if (!CollectionUtils.isEmpty((Collection)shipOrderItemDTOList)) {
                    for (DycProOrderShipOrderItemDTO shipOrderItemDto : shipOrderItemDTOList) {
                        if (shipOrderItemDto.getInspCount().compareTo(shipOrderItemDto.getArriveCount()) >= 0) continue;
                        shipOrderInspFinish = false;
                        break;
                    }
                }
                if (!((Boolean)shipOrderInspFinish).booleanValue()) continue;
                DycProOrderShipOrderQryDTO updateShipOrderDto = new DycProOrderShipOrderQryDTO();
                updateShipOrderDto.setShipOrderId(dycProOrderInspApiBo.getShipOrderId());
                updateShipOrderDto.setShipOrderState("FH_FH_YS");
                updateShipOrderDtoList.add(updateShipOrderDto);
            }
            if (!CollectionUtils.isEmpty(updateShipOrderDtoList)) {
                updateSaleOrderDto.setShiporderList(updateShipOrderDtoList);
                this.dycProOrderShipOrderRepository.updateShipOrderBatchByIdsAndSyncNosql(updateShipOrderDtoList);
            }
        }
        Boolean saleOrderInspFinish = true;
        Boolean saleOrderHaveRefuse = false;
        List allSaleOrderItemDtoList = new ArrayList();
        if ("XS_DH_DH".equals(salOrderDetail.getSaleOrderState()) || "XS_DH_BFDH".equals(salOrderDetail.getSaleOrderState())) {
            DycProOrderSaleOrderItemQryDTO queryUpdateSaleOrderItemReqDto = new DycProOrderSaleOrderItemQryDTO();
            queryUpdateSaleOrderItemReqDto.setSaleOrderId(reqBO.getSaleOrderId());
            List resultSaleOrderItemDtoList = this.dycProOrderSaleOrderRepository.querySaleOrderItemListByCondition(queryUpdateSaleOrderItemReqDto);
            allSaleOrderItemDtoList = resultSaleOrderItemDtoList;
            log.debug("\u6821\u9a8c\u6574\u4e2a\u9a8c\u6536\u5355\u662f\u5426\u5df2\u9a8c\u6536updateSaleOrderItemDtoList:{}", (Object)JSON.toJSONString((Object)resultSaleOrderItemDtoList));
            for (DycProOrderSaleOrderItemDTO saleOrderItemDto : resultSaleOrderItemDtoList) {
                if (Optional.ofNullable(saleOrderItemDto.getRefuseCount()).orElse(BigDecimal.ZERO).compareTo(BigDecimal.ZERO) > 0) {
                    saleOrderHaveRefuse = true;
                }
                if (saleOrderItemDto.getArriveCount().compareTo(saleOrderItemDto.getAcceptanceCount()) <= 0) continue;
                saleOrderInspFinish = false;
                break;
            }
        } else {
            saleOrderInspFinish = false;
        }
        log.debug("\u6821\u9a8c\u6574\u4e2a\u9a8c\u6536\u5355\u662f\u5426\u5df2\u9a8c\u6536saleOrderInspFinish:{}", (Object)saleOrderInspFinish);
        log.debug("\u6821\u9a8c\u6574\u4e2a\u9a8c\u6536\u5355\u662f\u5426\u5df2\u9a8c\u6536saleOrderHaveRefuse:{}", (Object)saleOrderHaveRefuse);
        DycProOrderCreateInspOrderRspBO rspBO = new DycProOrderCreateInspOrderRspBO();
        updateSaleOrderDto.setInspOrderList(Collections.singletonList(resultInspOrderDTO));
        if (saleOrderInspFinish.booleanValue()) {
            BigDecimal totalInspSaleFee = BigDecimal.ZERO;
            BigDecimal totalInspPurchaseFee = BigDecimal.ZERO;
            for (DycProOrderSaleOrderItemDTO inspSaleItem : allSaleOrderItemDtoList) {
                BigDecimal inspSaleFee = inspSaleItem.getSalePrice().multiply(inspSaleItem.getAcceptanceCount()).setScale(2, RoundingMode.HALF_UP);
                inspSaleItem.setSaleFee(inspSaleFee);
                totalInspSaleFee = totalInspSaleFee.add(inspSaleFee);
                BigDecimal inspPurchaseFee = inspSaleItem.getPurchasePrice().multiply(inspSaleItem.getAcceptanceCount()).setScale(2, RoundingMode.HALF_UP);
                inspSaleItem.setPurchaseFee(inspPurchaseFee);
                totalInspPurchaseFee = totalInspPurchaseFee.add(inspPurchaseFee);
            }
            updateSaleOrderDto.setTotalInspSaleFee(totalInspSaleFee);
            updateSaleOrderDto.setTotalInspPurchaseFee(totalInspPurchaseFee);
            updateSaleOrderDto.setInspSaleOrderItemDtoList(allSaleOrderItemDtoList);
            if (saleOrderHaveRefuse.booleanValue()) {
                updateSaleOrderDto.setSaleOrderState("XS_YS_BFYS");
                updateSaleOrderDto.setOrderStage(DycProOrderApiServiceConstant.ORDER_STAPE.TRADE_SUCCESS);
                this.dycProOrderSaleOrderRepository.updateSaleOrderByCondition(updateSaleOrderDto, true);
                rspBO.setNeedDealProcess(Boolean.valueOf(true));
            } else {
                updateSaleOrderDto.setSaleOrderState("XS_YS_YS");
                updateSaleOrderDto.setOrderStage(DycProOrderApiServiceConstant.ORDER_STAPE.TRADE_SUCCESS);
                this.dycProOrderSaleOrderRepository.updateSaleOrderByCondition(updateSaleOrderDto, true);
                rspBO.setNeedDealProcess(Boolean.valueOf(true));
            }
        } else {
            this.dycProOrderSaleOrderRepository.updateSaleOrderNosqlForIncr(updateSaleOrderDto);
        }
        return rspBO;
    }

    private DycProOrderSaleOrderDTO qrySalOrderDetail(Long saleOrderId) {
        DycProOrderSaleOrderDTO saleOrderDetailApiReqBO = new DycProOrderSaleOrderDTO();
        saleOrderDetailApiReqBO.setSaleOrderId(saleOrderId);
        DycProOrderSaleOrderDTO saleOrderDTO = this.dycProOrderSaleOrderRepository.querySaleOrderOneByCondition(saleOrderDetailApiReqBO);
        if (saleOrderDTO == null) {
            throw new ZTBusinessException("\u67e5\u8be2\u9500\u552e\u5355\u8be6\u60c5\u5931\u8d25\uff0c\u9500\u552e\u5355id\u4e3a\uff1a" + saleOrderId);
        }
        DycProOrderSaleOrderDTO reqDto = new DycProOrderSaleOrderDTO();
        reqDto.setStakeholderId(saleOrderDTO.getStakeholderId());
        DycProOrderSaleOrderDTO result = this.dycProOrderSaleOrderRepository.querySaleOrderStakeholderByCondition(reqDto);
        saleOrderDTO.setSaleStakeholder(result.getSaleStakeholder());
        DycProOrderSaleOrderItemQryDTO saleOrderItemQryDTO = new DycProOrderSaleOrderItemQryDTO();
        saleOrderItemQryDTO.setSaleOrderId(saleOrderId);
        List saleOrderItemList = this.dycProOrderSaleOrderRepository.getSaleOrderItemList(saleOrderItemQryDTO);
        saleOrderDTO.setSaleItemList(saleOrderItemList);
        return saleOrderDTO;
    }

    private void verifyParam(DycProOrderCreateInspOrderReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSaleOrderId()) {
            throw new ZTBusinessException("\u9500\u552e\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new ZTBusinessException("\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSupplierId()) {
            throw new ZTBusinessException("\u4f9b\u5e94\u5546id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderSource()) {
            throw new ZTBusinessException("\u8ba2\u5355\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

