/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.shiporder.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.flow.repository.api.DycProPublicTaskInstRepository;
import com.tydic.dyc.pro.egc.repository.budget.api.DycProOrderBudgetRepository;
import com.tydic.dyc.pro.egc.repository.budget.dto.DycProOrderBudgetUsedRecordDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderQueryIndexDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderQueryIndexQryDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemQryDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.api.DycProOrderShipOrderRepository;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderItemQryDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderQryDTO;
import com.tydic.dyc.pro.egc.service.constants.DycProOrderApiServiceConstant;
import com.tydic.dyc.pro.egc.service.shiporder.api.DycProOrderDealVoteShipOrderMsgApiService;
import com.tydic.dyc.pro.egc.service.shiporder.bo.DycProOrderDealVoteShipOrderMsgApiReqBO;
import com.tydic.dyc.pro.egc.service.shiporder.bo.DycProOrderDealVoteShipOrderMsgApiRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.shiporder.api.DycProOrderDealVoteShipOrderMsgApiService"})
public class DycProOrderDealVoteShipOrderMsgApiServiceImpl
implements DycProOrderDealVoteShipOrderMsgApiService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderDealVoteShipOrderMsgApiServiceImpl.class);
    @Autowired
    private DycProOrderSaleOrderRepository saleOrderRepository;
    @Autowired
    private DycProOrderShipOrderRepository shipOrderRepository;
    @Autowired
    private DycProPublicTaskInstRepository dycProPublicTaskInstRepository;
    @Autowired
    private DycProOrderBudgetRepository dycProOrderBudgetRepository;

    @PostMapping(value={"dealVoteShipOrderMsg"})
    public DycProOrderDealVoteShipOrderMsgApiRspBO dealVoteShipOrderMsg(@RequestBody DycProOrderDealVoteShipOrderMsgApiReqBO reqBO) {
        DycProOrderDealVoteShipOrderMsgApiRspBO rspBO = new DycProOrderDealVoteShipOrderMsgApiRspBO();
        this.validateParam(reqBO);
        DycProOrderShipOrderDTO shipOrderDTO = this.checkState(reqBO);
        DycProOrderSaleOrderDTO querySaleOrderDTO = new DycProOrderSaleOrderDTO();
        querySaleOrderDTO.setSaleOrderId(shipOrderDTO.getSaleOrderId());
        DycProOrderSaleOrderDTO resultSaleOrderDTO = this.saleOrderRepository.querySaleOrderOneByCondition(querySaleOrderDTO);
        DycProOrderShipOrderDTO updateShipOrderDTO = this.updateVoteCount(shipOrderDTO, reqBO, resultSaleOrderDTO);
        this.judgeIsAllReceive(updateShipOrderDTO, resultSaleOrderDTO);
        return rspBO;
    }

    private DycProOrderShipOrderDTO checkState(DycProOrderDealVoteShipOrderMsgApiReqBO reqBO) {
        DycProOrderOrderQueryIndexQryDTO queryIndexQryDTO = new DycProOrderOrderQueryIndexQryDTO();
        queryIndexQryDTO.setOutObjId(reqBO.getResult().getOrderId());
        queryIndexQryDTO.setObjType(DycProOrderApiServiceConstant.OBJ_TYPE.SHIP);
        List uocOrderQueryIndexList = this.saleOrderRepository.qryOrderQueryIndexList(queryIndexQryDTO);
        if (CollectionUtils.isEmpty((Collection)uocOrderQueryIndexList) || uocOrderQueryIndexList.size() != 1) {
            throw new ZTBusinessException("\u67e5\u8be2\u5916\u90e8\u8ba2\u5355" + reqBO.getResult().getOrderId() + "\u5173\u8054\u8868\u9519\u8bef");
        }
        DycProOrderShipOrderQryDTO queryShipOrderQryDTO = new DycProOrderShipOrderQryDTO();
        queryShipOrderQryDTO.setShipOrderId(((DycProOrderOrderQueryIndexDTO)uocOrderQueryIndexList.get(0)).getObjId());
        log.info("\u53d1\u8d27\u5355\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)queryShipOrderQryDTO));
        List shipOrderDTOS = this.shipOrderRepository.getListShipOrder(queryShipOrderQryDTO);
        log.info("\u53d1\u8d27\u5355\u67e5\u8be2\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)shipOrderDTOS));
        if (CollectionUtils.isEmpty((Collection)shipOrderDTOS) || shipOrderDTOS.size() != 1) {
            throw new ZTBusinessException("\u67e5\u8be2\u53d1\u8d27\u5355\u8868\u9519\u8bef");
        }
        if (!"FH_FH_FH".equals(((DycProOrderShipOrderDTO)shipOrderDTOS.get(0)).getShipOrderState())) {
            throw new ZTBusinessException("\u8be5\u53d1\u8d27\u5355\u4e0d\u662f\u53d1\u8d27\u72b6\u6001\uff01\u4e0d\u80fd\u59a5\u6295");
        }
        return (DycProOrderShipOrderDTO)shipOrderDTOS.get(0);
    }

    private void judgeIsAllReceive(DycProOrderShipOrderDTO shipOrderDTO, DycProOrderSaleOrderDTO resultSaleOrderDTO) {
        DycProOrderSaleOrderDTO saleOrderDTO = new DycProOrderSaleOrderDTO();
        saleOrderDTO.setOrderId(shipOrderDTO.getOrderId());
        saleOrderDTO.setSaleOrderId(shipOrderDTO.getSaleOrderId());
        saleOrderDTO.setShiporderList(Collections.singletonList(shipOrderDTO));
        if (!"XS_FH_FHWC".equals(resultSaleOrderDTO.getSaleOrderState())) {
            this.saleOrderRepository.updateSaleOrderNosqlForIncr(saleOrderDTO);
            return;
        }
        DycProOrderShipOrderQryDTO queryShipOrderQryDTO = new DycProOrderShipOrderQryDTO();
        queryShipOrderQryDTO.setSaleOrderId(shipOrderDTO.getSaleOrderId());
        log.debug("\u6821\u9a8c\u662f\u5426\u5168\u90e8\u59a5\u6295\u5165\u53c2\uff1a" + JSON.toJSONString((Object)queryShipOrderQryDTO));
        List shipOrderDTOS = this.shipOrderRepository.getListShipOrder(queryShipOrderQryDTO);
        log.debug("\u6821\u9a8c\u662f\u5426\u5168\u90e8\u59a5\u6295\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)shipOrderDTOS));
        if (shipOrderDTOS.stream().anyMatch(bo -> "FH_FH_FH".equals(bo.getShipOrderState()))) {
            this.saleOrderRepository.updateSaleOrderNosqlForIncr(saleOrderDTO);
            return;
        }
        if (shipOrderDTOS.stream().allMatch(bo -> "FH_FH_YDH".equals(bo.getShipOrderState()))) {
            saleOrderDTO.setSaleOrderState("XS_DH_DH");
        } else if (shipOrderDTOS.stream().allMatch(bo -> "FH_FH_JS".equals(bo.getShipOrderState()))) {
            saleOrderDTO.setOrderStage(DycProOrderApiServiceConstant.ORDER_STAPE.TRADE_CLOSE);
            saleOrderDTO.setSaleOrderState("XS_DH_JS");
        } else if (shipOrderDTOS.stream().anyMatch(bo -> "FH_FH_YDH".equals(bo.getShipOrderState())) && shipOrderDTOS.stream().anyMatch(bo -> "FH_FH_JS".equals(bo.getShipOrderState()))) {
            saleOrderDTO.setSaleOrderState("XS_DH_BFDH");
        } else if (shipOrderDTOS.stream().noneMatch(bo -> "FH_FH_JS".equals(bo.getShipOrderState()))) {
            saleOrderDTO.setSaleOrderState("XS_DH_DH");
        } else {
            DycProOrderSaleOrderItemQryDTO queryUpdateSaleOrderItemReqDto = new DycProOrderSaleOrderItemQryDTO();
            queryUpdateSaleOrderItemReqDto.setSaleOrderId(shipOrderDTO.getSaleOrderId());
            List allSaleOrderItemDtoList = this.saleOrderRepository.querySaleOrderItemListByCondition(queryUpdateSaleOrderItemReqDto);
            BigDecimal totalInspSaleFee = BigDecimal.ZERO;
            BigDecimal totalInspPurchaseFee = BigDecimal.ZERO;
            for (DycProOrderSaleOrderItemDTO inspSaleItem : allSaleOrderItemDtoList) {
                BigDecimal inspSaleFee = inspSaleItem.getSalePrice().multiply(inspSaleItem.getAcceptanceCount()).setScale(2, RoundingMode.HALF_UP);
                inspSaleItem.setSaleFee(inspSaleFee);
                totalInspSaleFee = totalInspSaleFee.add(inspSaleFee);
                BigDecimal inspPurchaseFee = inspSaleItem.getPurchasePrice().multiply(inspSaleItem.getAcceptanceCount()).setScale(2, RoundingMode.HALF_UP);
                inspSaleItem.setPurchaseFee(inspPurchaseFee);
                totalInspPurchaseFee = totalInspPurchaseFee.add(inspPurchaseFee);
            }
            saleOrderDTO.setTotalInspSaleFee(totalInspSaleFee);
            saleOrderDTO.setTotalInspPurchaseFee(totalInspPurchaseFee);
            saleOrderDTO.setInspSaleOrderItemDtoList(allSaleOrderItemDtoList);
            saleOrderDTO.setOrderStage(DycProOrderApiServiceConstant.ORDER_STAPE.TRADE_SUCCESS);
            saleOrderDTO.setSaleOrderState("XS_YS_BFYS");
        }
        this.saleOrderRepository.updateSaleOrderByCondition(saleOrderDTO, true);
    }

    private DycProOrderShipOrderDTO updateVoteCount(DycProOrderShipOrderDTO dycProOrderShipOrderDTO, DycProOrderDealVoteShipOrderMsgApiReqBO reqBO, DycProOrderSaleOrderDTO resultSaleOrderDTO) {
        DycProOrderShipOrderDTO updateShipOrderDTO = new DycProOrderShipOrderDTO();
        updateShipOrderDTO.setShipOrderId(dycProOrderShipOrderDTO.getShipOrderId());
        DycProOrderShipOrderItemQryDTO dycProOrderShipOrderItemDTO = new DycProOrderShipOrderItemQryDTO();
        dycProOrderShipOrderItemDTO.setShipOrderId(dycProOrderShipOrderDTO.getShipOrderId());
        List shipOrderItemList = this.shipOrderRepository.queryShipOrderItemByCondition(dycProOrderShipOrderItemDTO);
        DycProOrderSaleOrderItemQryDTO dycProOrderSaleOrderItemQryDTO = new DycProOrderSaleOrderItemQryDTO();
        dycProOrderSaleOrderItemQryDTO.setSaleOrderId(dycProOrderShipOrderDTO.getSaleOrderId());
        List saleOrderItemDTOList = this.saleOrderRepository.getSaleOrderItemList(dycProOrderSaleOrderItemQryDTO);
        Map saleOrderItemMap = saleOrderItemDTOList.stream().collect(Collectors.toMap(DycProOrderSaleOrderItemDTO::getSaleOrderItemId, Function.identity()));
        ArrayList<DycProOrderShipOrderItemDTO> updateShipOrderItemList = new ArrayList<DycProOrderShipOrderItemDTO>();
        DycProOrderSaleOrderDTO saleOrderDTO = new DycProOrderSaleOrderDTO();
        ArrayList<DycProOrderSaleOrderItemDTO> updateSaleItemList = new ArrayList<DycProOrderSaleOrderItemDTO>();
        saleOrderDTO.setSaleItemList(updateSaleItemList);
        HashMap<Long, List<DycProOrderShipOrderItemDTO>> budgetShipItemMap = new HashMap<Long, List<DycProOrderShipOrderItemDTO>>();
        for (DycProOrderShipOrderItemDTO shipOrderItemDTO : shipOrderItemList) {
            DycProOrderSaleOrderItemDTO saleOrderItemDTO = (DycProOrderSaleOrderItemDTO)saleOrderItemMap.get(shipOrderItemDTO.getSaleOrderItemId());
            ArrayList<DycProOrderShipOrderItemDTO> budgetShipItemList = (ArrayList<DycProOrderShipOrderItemDTO>)budgetShipItemMap.get(shipOrderItemDTO.getShipOrderId());
            if (CollectionUtils.isEmpty((Collection)budgetShipItemList)) {
                budgetShipItemList = new ArrayList<DycProOrderShipOrderItemDTO>();
            }
            DycProOrderShipOrderItemDTO budgetShipOrderItemDTO = new DycProOrderShipOrderItemDTO();
            budgetShipOrderItemDTO.setShipOrderId(shipOrderItemDTO.getShipOrderId());
            budgetShipOrderItemDTO.setSendCount(shipOrderItemDTO.getSendCount());
            BigDecimal shipSaleFee = saleOrderItemDTO.getSalePrice().multiply(shipOrderItemDTO.getSendCount()).setScale(2, RoundingMode.HALF_UP);
            budgetShipOrderItemDTO.setShipSaleFee(shipSaleFee);
            budgetShipItemList.add(budgetShipOrderItemDTO);
            budgetShipItemMap.put(shipOrderItemDTO.getShipOrderId(), budgetShipItemList);
            DycProOrderSaleOrderItemDTO updateSaleOrderItemDTO = new DycProOrderSaleOrderItemDTO();
            updateSaleOrderItemDTO.setSaleOrderItemId(shipOrderItemDTO.getSaleOrderItemId());
            DycProOrderShipOrderItemDTO updateShipOrderItemDTO = new DycProOrderShipOrderItemDTO();
            updateShipOrderItemDTO.setShipOrderItemId(shipOrderItemDTO.getShipOrderItemId());
            log.debug("saleOrderItemDTO.getRefuseCount():{}", (Object)Optional.ofNullable(saleOrderItemDTO.getRefuseCount()).orElse(BigDecimal.ZERO));
            log.debug("saleOrderItemDTO.getArriveCount():{}", (Object)Optional.ofNullable(saleOrderItemDTO.getArriveCount()).orElse(BigDecimal.ZERO));
            log.debug("shipOrderItemDTO.getSendCount():{}", (Object)shipOrderItemDTO.getSendCount());
            if (reqBO.getResult().getState().equals(2)) {
                updateSaleOrderItemDTO.setRefuseCount(Optional.ofNullable(saleOrderItemDTO.getRefuseCount()).orElse(BigDecimal.ZERO).add(shipOrderItemDTO.getSendCount()));
                updateShipOrderItemDTO.setRefuseCount(shipOrderItemDTO.getSendCount());
                updateShipOrderDTO.setShipOrderState("FH_FH_JS");
            } else if (reqBO.getResult().getState().equals(1)) {
                updateSaleOrderItemDTO.setArriveCount(Optional.ofNullable(saleOrderItemDTO.getArriveCount()).orElse(BigDecimal.ZERO).add(shipOrderItemDTO.getSendCount()));
                updateShipOrderItemDTO.setArriveCount(shipOrderItemDTO.getSendCount());
                updateShipOrderDTO.setShipOrderState("FH_FH_YDH");
            }
            updateShipOrderItemList.add(updateShipOrderItemDTO);
            updateSaleItemList.add(updateSaleOrderItemDTO);
        }
        if (reqBO.getResult().getState().equals(2) && null != resultSaleOrderDTO.getBudgetId()) {
            this.deductBudget(budgetShipItemMap, resultSaleOrderDTO.getBudgetId());
        }
        updateShipOrderDTO.setArriveTime(new Date());
        this.shipOrderRepository.updateShipOrderItem(updateShipOrderItemList);
        this.saleOrderRepository.updateSaleItemBatch(saleOrderDTO);
        this.shipOrderRepository.updateShipOrderAndSysnNoSql(updateShipOrderDTO, Boolean.valueOf(true));
        updateShipOrderDTO.setOrderId(dycProOrderShipOrderDTO.getOrderId());
        updateShipOrderDTO.setSaleOrderId(dycProOrderShipOrderDTO.getSaleOrderId());
        return updateShipOrderDTO;
    }

    private void deductBudget(Map<Long, List<DycProOrderShipOrderItemDTO>> budgetShipItemMap, Long budgetId) {
        log.debug("\u7535\u5546\u62d2\u6536\u91ca\u653e\u9884\u7b97\u6570\u636e: " + JSON.toJSONString(budgetShipItemMap));
        for (Map.Entry<Long, List<DycProOrderShipOrderItemDTO>> entry : budgetShipItemMap.entrySet()) {
            DycProOrderShipOrderDTO shipOrderQryDTO = new DycProOrderShipOrderDTO();
            shipOrderQryDTO.setShipOrderId(entry.getKey());
            DycProOrderShipOrderDTO shipOrderDTO = this.shipOrderRepository.queryShipOrderOneByCondition(shipOrderQryDTO);
            DycProOrderBudgetUsedRecordDTO dycProOrderBudgetUsedRecordDTO = new DycProOrderBudgetUsedRecordDTO();
            dycProOrderBudgetUsedRecordDTO.setBudgetId(budgetId);
            BigDecimal deductAmount = entry.getValue().stream().map(DycProOrderShipOrderItemDTO::getShipSaleFee).reduce(BigDecimal.ZERO, BigDecimal::add);
            dycProOrderBudgetUsedRecordDTO.setOccupyAmount(deductAmount.negate());
            dycProOrderBudgetUsedRecordDTO.setObjId(shipOrderDTO.getShipOrderId());
            dycProOrderBudgetUsedRecordDTO.setObjNo(shipOrderDTO.getShipOrderNo());
            dycProOrderBudgetUsedRecordDTO.setOccupyType(Integer.valueOf(3));
            log.debug("\u7535\u5546\u62d2\u6536\u91ca\u653e\u9884\u7b97\u5165\u53c2: " + JSON.toJSONString((Object)dycProOrderBudgetUsedRecordDTO));
            this.dycProOrderBudgetRepository.deductBudget(dycProOrderBudgetUsedRecordDTO);
        }
    }

    private void validateParam(DycProOrderDealVoteShipOrderMsgApiReqBO reqBO) {
        if (StringUtils.isBlank((CharSequence)reqBO.getResult().getOrderId())) {
            throw new ZTBusinessException("\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5c5e\u6027\u3010result.orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getResult().getState()) {
            throw new ZTBusinessException("\u7535\u5b50\u8d85\u5e02\u8ba2\u5355\u59a5\u6295\u62d2\u6536\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5c5e\u6027\u3010result.state\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

