/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.saleorder.impl;

import com.alibaba.fastjson.JSONArray;
import com.alipay.sofa.sofamq.com.shade.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.flow.repository.api.DycProPublicTaskInstRepository;
import com.tydic.dyc.pro.base.core.flow.repository.dto.DycProPublicTaskInstHandleDTO;
import com.tydic.dyc.pro.egc.repository.order.api.DycProOrderOrderRepository;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderAccessoryDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemQryDTO;
import com.tydic.dyc.pro.egc.service.constants.DycProOrderApiServiceConstant;
import com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderDealRejectSaleOrderService;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderDealRejectSaleOrderReqBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderDealRejectSaleOrderRspBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderSaleOrderItemApiBO;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderDealRejectSaleOrderService"})
public class DycProOrderDealRejectSaleOrderServiceImpl
implements DycProOrderDealRejectSaleOrderService {
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;
    @Autowired
    private DycProPublicTaskInstRepository dycProPublicTaskInstRepository;
    @Autowired
    private DycProOrderOrderRepository dycProOrderOrderRepository;

    @PostMapping(value={"dealRejectSaleOrder"})
    public DycProOrderDealRejectSaleOrderRspBO dealRejectSaleOrder(@RequestBody DycProOrderDealRejectSaleOrderReqBO reqBO) {
        this.verifyParam(reqBO);
        DycProOrderSaleOrderDTO querySaleOrderDto = new DycProOrderSaleOrderDTO();
        querySaleOrderDto.setSaleOrderId(reqBO.getSaleOrderId());
        DycProOrderSaleOrderDTO saleOrderDto = this.dycProOrderSaleOrderRepository.querySaleOrderOneByCondition(querySaleOrderDto);
        if (null != saleOrderDto) {
            if (reqBO.getOperType().equals(0)) {
                DycProOrderSaleOrderDTO updateSaleOrderDto = new DycProOrderSaleOrderDTO();
                updateSaleOrderDto.setSaleOrderId(reqBO.getSaleOrderId());
                updateSaleOrderDto.setSaleOrderState("XS_QX_QX");
                updateSaleOrderDto.setCancelReason(saleOrderDto.getRejectReason());
                updateSaleOrderDto.setCancelReasonFlag(DycProOrderApiServiceConstant.CancelReasonFlag.VENDOR_CANCEL);
                this.dycProOrderSaleOrderRepository.updateSaleOrderByCondition(updateSaleOrderDto, true);
            } else {
                DycProOrderOrderAccessoryDTO dycProOrderOrderAccessoryDTO = new DycProOrderOrderAccessoryDTO();
                dycProOrderOrderAccessoryDTO.setObjId(saleOrderDto.getSaleOrderId());
                dycProOrderOrderAccessoryDTO.setObjType(DycProOrderApiServiceConstant.AccessoryObjType.SALE_ORDER_CONFIRM_OR_REFUSE);
                this.dycProOrderOrderRepository.deleteAccessoryByCondition(dycProOrderOrderAccessoryDTO);
            }
            DycProOrderDealRejectSaleOrderRspBO rspBO = new DycProOrderDealRejectSaleOrderRspBO();
            if (reqBO.getOperType().equals(0)) {
                DycProOrderSaleOrderItemQryDTO querySaleItemReqDto = new DycProOrderSaleOrderItemQryDTO();
                querySaleItemReqDto.setSaleOrderId(reqBO.getSaleOrderId());
                List dycProOrderSaleOrderItemDTOS = this.dycProOrderSaleOrderRepository.querySaleOrderItemListByCondition(querySaleItemReqDto);
                if (!CollectionUtils.isEmpty((Collection)dycProOrderSaleOrderItemDTOS)) {
                    List saleItemList = JSONArray.parseArray((String)JSON.toJSONString((Object)dycProOrderSaleOrderItemDTOS)).toJavaList(DycProOrderSaleOrderItemApiBO.class);
                    rspBO.setSaleItemList(saleItemList);
                }
            }
            DycProPublicTaskInstHandleDTO flowTaskInstHandleDto = new DycProPublicTaskInstHandleDTO();
            flowTaskInstHandleDto.setTaskInstId(reqBO.getTaskId());
            this.dycProPublicTaskInstRepository.completeBusiFlowTask(flowTaskInstHandleDto);
            return rspBO;
        }
        throw new ZTBusinessException("\u8be5\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728");
    }

    private void verifyParam(DycProOrderDealRejectSaleOrderReqBO reqBO) {
        if (null == reqBO.getSaleOrderId()) {
            throw new ZTBusinessException("\u9500\u552e\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOperType()) {
            throw new ZTBusinessException("\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

