/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.purchaseapply.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.dictionary.enums.ZLEgcPurApplyItemStatus;
import com.tydic.dyc.pro.base.core.dictionary.enums.ZLEgcPurApplyStatus;
import com.tydic.dyc.pro.egc.repository.order.api.DycProOrderOrderRepository;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderDTO;
import com.tydic.dyc.pro.egc.repository.purchaseapply.api.DycProOrderPurchaseApplyRepository;
import com.tydic.dyc.pro.egc.repository.purchaseapply.dto.DycProOrderZlPurchaseApplyDTO;
import com.tydic.dyc.pro.egc.repository.purchaseapply.dto.DycProOrderZlPurchaseApplyItemDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemQryDTO;
import com.tydic.dyc.pro.egc.service.purchaseapply.api.DycProOrderUpdatePurchaseApplyItemApiService;
import com.tydic.dyc.pro.egc.service.purchaseapply.bo.DycProOrderUpdatePurchaseApplyItemApiReqBO;
import com.tydic.dyc.pro.egc.service.purchaseapply.bo.DycProOrderUpdatePurchaseApplyItemApiRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.purchaseapply.api.DycProOrderUpdatePurchaseApplyItemApiService"})
public class DycProOrderUpdatePurchaseApplyItemApiServiceImpl
implements DycProOrderUpdatePurchaseApplyItemApiService {
    @Autowired
    private DycProOrderPurchaseApplyRepository dycProOrderPurchaseApplyRepository;
    @Autowired
    private DycProOrderOrderRepository dycProOrderOrderRepository;

    @PostMapping(value={"updatePurchaseApplyItem"})
    public DycProOrderUpdatePurchaseApplyItemApiRspBO updatePurchaseApplyItem(@RequestBody DycProOrderUpdatePurchaseApplyItemApiReqBO reqBO) {
        if (null == reqBO || null == reqBO.getOrderId()) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DycProOrderOrderDTO queryOrderBO = new DycProOrderOrderDTO();
        queryOrderBO.setOrderId(reqBO.getOrderId());
        DycProOrderOrderDTO orderMainInfo = this.dycProOrderOrderRepository.queryOrderAllInfo(queryOrderBO);
        DycProOrderSaleOrderItemQryDTO queryOrderItemDto = new DycProOrderSaleOrderItemQryDTO();
        queryOrderItemDto.setOrderId(reqBO.getOrderId());
        List orderItemList = this.dycProOrderOrderRepository.qryOrderItemList(queryOrderItemDto);
        if (CollectionUtils.isEmpty((Collection)orderItemList)) {
            return new DycProOrderUpdatePurchaseApplyItemApiRspBO();
        }
        Map<Long, DycProOrderSaleOrderItemDTO> purOrderItemMap = orderItemList.stream().collect(Collectors.toMap(DycProOrderSaleOrderItemDTO::getPurApplyItemId, item -> item));
        DycProOrderZlPurchaseApplyItemDTO queryApplyItemDTO = new DycProOrderZlPurchaseApplyItemDTO();
        List purItemIds = orderItemList.stream().distinct().map(DycProOrderSaleOrderItemDTO::getPurApplyItemId).collect(Collectors.toList());
        queryApplyItemDTO.setPurApplyItemIds(purItemIds);
        List queryItemList = this.dycProOrderPurchaseApplyRepository.queryPurchaseApplyItemListByCondition(queryApplyItemDTO);
        if (CollectionUtils.isEmpty((Collection)queryItemList)) {
            return new DycProOrderUpdatePurchaseApplyItemApiRspBO();
        }
        ArrayList<DycProOrderZlPurchaseApplyItemDTO> updateItemList = new ArrayList<DycProOrderZlPurchaseApplyItemDTO>();
        for (DycProOrderZlPurchaseApplyItemDTO dycProOrderZlPurchaseApplyItemDTO : queryItemList) {
            DycProOrderSaleOrderItemDTO dycProOrderOrderItemDTO = purOrderItemMap.get(dycProOrderZlPurchaseApplyItemDTO.getPurApplyItemId());
            if (null == dycProOrderOrderItemDTO) continue;
            DycProOrderZlPurchaseApplyItemDTO updateItem = new DycProOrderZlPurchaseApplyItemDTO();
            BeanUtils.copyProperties((Object)dycProOrderZlPurchaseApplyItemDTO, (Object)updateItem);
            updateItem.setOccupyAmount(BigDecimal.ZERO);
            updateItem.setRemainAmount(dycProOrderOrderItemDTO.getPurchaseCount());
            if (dycProOrderZlPurchaseApplyItemDTO.getOccupyAmount().compareTo(dycProOrderZlPurchaseApplyItemDTO.getApplyAmount()) == 0) {
                updateItem.setPurApplyItemStatus(Integer.valueOf(Integer.parseInt(ZLEgcPurApplyItemStatus.PENDING_EXECUTION.getCode())));
            }
            updateItemList.add(updateItem);
        }
        this.dycProOrderPurchaseApplyRepository.updateBatchPurchaseApplyItemByIds(updateItemList);
        DycProOrderZlPurchaseApplyItemDTO queryExecutedApplyItemDTO = new DycProOrderZlPurchaseApplyItemDTO();
        List executedPurApplyItemIds = updateItemList.stream().distinct().map(DycProOrderZlPurchaseApplyItemDTO::getPurApplyItemId).collect(Collectors.toList());
        queryExecutedApplyItemDTO.setPurApplyItemIds(executedPurApplyItemIds);
        List executedApplyItemList = this.dycProOrderPurchaseApplyRepository.queryPurchaseApplyItemListByCondition(queryExecutedApplyItemDTO);
        List executedPurApplyIds = executedApplyItemList.stream().distinct().map(DycProOrderZlPurchaseApplyItemDTO::getPurApplyId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(executedPurApplyIds)) {
            DycProOrderZlPurchaseApplyItemDTO queryNewItemDTO = new DycProOrderZlPurchaseApplyItemDTO();
            queryNewItemDTO.setPurApplyIds(executedPurApplyIds);
            List dycProOrderZlPurchaseApplyItemDTOS = this.dycProOrderPurchaseApplyRepository.queryPurchaseApplyItemListByCondition(queryNewItemDTO);
            Map<Long, List<DycProOrderZlPurchaseApplyItemDTO>> groupedByPurApplyId = dycProOrderZlPurchaseApplyItemDTOS.stream().collect(Collectors.groupingBy(DycProOrderZlPurchaseApplyItemDTO::getPurApplyId));
            for (Long purApplyId : executedPurApplyIds) {
                List<DycProOrderZlPurchaseApplyItemDTO> items = groupedByPurApplyId.get(purApplyId);
                boolean allPendingExecuted = items.stream().allMatch(item -> Integer.parseInt(ZLEgcPurApplyItemStatus.PENDING_EXECUTION.getCode()) == item.getPurApplyItemStatus());
                if (!allPendingExecuted) continue;
                DycProOrderZlPurchaseApplyDTO updatePurchaseApplyDTO = new DycProOrderZlPurchaseApplyDTO();
                updatePurchaseApplyDTO.setPurApplyId(purApplyId);
                updatePurchaseApplyDTO.setPurApplyStatus(Integer.valueOf(Integer.parseInt(ZLEgcPurApplyStatus.PENDING.getCode())));
                this.dycProOrderPurchaseApplyRepository.updatePurchaseApplyById(updatePurchaseApplyDTO);
            }
        }
        return new DycProOrderUpdatePurchaseApplyItemApiRspBO();
    }
}

