/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.saleorder.impl;

import com.alibaba.fastjson.JSONArray;
import com.alipay.sofa.sofamq.com.shade.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.core.flow.repository.api.DycProPublicProcInstRepository;
import com.tydic.dyc.pro.base.core.flow.repository.api.DycProPublicTaskInstRepository;
import com.tydic.dyc.pro.base.core.flow.repository.dto.DycProPublicProcInstDTO;
import com.tydic.dyc.pro.base.core.flow.repository.dto.DycProPublicTaskInstDTO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtil;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilCancelReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilCancelRspBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilDeleteContractForTyReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilDeleteContractForTyRspBO;
import com.tydic.dyc.pro.egc.constant.DycProOrderRepositoryConstant;
import com.tydic.dyc.pro.egc.repository.approve.api.DycProOrderApproveRepository;
import com.tydic.dyc.pro.egc.repository.approve.dto.DycProOrderApprovalObjDTO;
import com.tydic.dyc.pro.egc.repository.budget.api.DycProOrderBudgetRepository;
import com.tydic.dyc.pro.egc.repository.budget.dto.DycProOrderBudgetUsedRecordDTO;
import com.tydic.dyc.pro.egc.repository.order.api.DycProOrderOrderRepository;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderAccessoryDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderQueryIndexDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderQueryIndexQryDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderAdjustPurApplyItemCountDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderInterLogDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemQryDTO;
import com.tydic.dyc.pro.egc.service.constants.DycProOrderApiServiceConstant;
import com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderCancelSaleOrderService;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderAccessoryApiBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderCancelSaleOrderReqBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderCancelSaleOrderRspBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderSaleOrderItemApiBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderCancelSaleOrderService"})
public class DycProOrderCancelSaleOrderServiceImpl
implements DycProOrderCancelSaleOrderService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderCancelSaleOrderServiceImpl.class);
    @Value(value="${call.esb.url.cancel}")
    private String callEsbUrlCancel;
    @Value(value="${call.ty.url.deleteContractUrlForTy}")
    private String deleteContractUrlForTy;
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;
    @Autowired
    private DycProPublicProcInstRepository dycProPublicProcInstRepository;
    @Autowired
    private DycProOrderSaleOrderRepository saleOrderRepository;
    @Autowired
    private DycProPublicTaskInstRepository dycProPublicTaskInstRepository;
    @Autowired
    private DycProOrderOrderRepository dycProOrderOrderRepository;
    @Autowired
    private DycProOrderBudgetRepository dycProOrderBudgetRepository;
    @Autowired
    private DycProOrderApproveRepository dycProOrderApproveRepository;
    @Autowired
    private Environment environment;

    @PostMapping(value={"cancelSaleOrder"})
    public DycProOrderCancelSaleOrderRspBO cancelSaleOrder(@RequestBody DycProOrderCancelSaleOrderReqBO reqBO) {
        DycProOrderCancelSaleOrderRspBO rspBO = new DycProOrderCancelSaleOrderRspBO();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{reqBO.getSetSaleOrderNoExt()})) {
            this.getSaleOrderId(reqBO);
        }
        DycProOrderSaleOrderDTO querySaleOrderDto = new DycProOrderSaleOrderDTO();
        querySaleOrderDto.setSaleOrderId(reqBO.getSaleOrderId());
        DycProOrderSaleOrderDTO saleOrderDto = this.dycProOrderSaleOrderRepository.querySaleOrderOneByCondition(querySaleOrderDto);
        this.verifyParam(reqBO, saleOrderDto);
        if (null != saleOrderDto) {
            if (DycProOrderApiServiceConstant.OrderSource.E_ORDER.equals(reqBO.getOrderSource())) {
                DycProOrderSaleOrderDTO queryStakeholderDto = new DycProOrderSaleOrderDTO();
                queryStakeholderDto.setStakeholderId(saleOrderDto.getStakeholderId());
                DycProOrderSaleOrderDTO saleOrderStakeholderDto = this.dycProOrderSaleOrderRepository.querySaleOrderStakeholderByCondition(queryStakeholderDto);
                if (null != saleOrderStakeholderDto) {
                    DycProBaseCallEsbUtilCancelReqBO callEsbReqBo = new DycProBaseCallEsbUtilCancelReqBO();
                    callEsbReqBo.setUrl(this.callEsbUrlCancel);
                    String hsn = this.environment.getProperty("SUPPLIER_ID_" + saleOrderStakeholderDto.getSaleStakeholder().getSupId());
                    callEsbReqBo.setHsn(hsn);
                    if ("jd".equals(hsn) || "jdvop".equals(hsn)) {
                        callEsbReqBo.setJdOrderId(saleOrderDto.getSaleOrderNoExt());
                        callEsbReqBo.setCancelReason(reqBO.getCancelReason());
                    } else {
                        callEsbReqBo.setOrderId(saleOrderDto.getSaleOrderNoExt());
                    }
                    DycProBaseCallEsbUtilCancelRspBO callEsbRspBo = DycProBaseCallEsbUtil.cancel((DycProBaseCallEsbUtilCancelReqBO)callEsbReqBo);
                    log.debug("\u53d6\u6d88\u7535\u5546\u8ba2\u5355\u7ed3\u679c: " + JSON.toJSONString((Object)callEsbRspBo));
                    if (!callEsbRspBo.getSuccess().booleanValue() || !"0000".equals(callEsbRspBo.getResultCode()) && !"0002".equals(callEsbRspBo.getResultCode())) {
                        throw new ZTBusinessException("\u53d6\u6d88\u9500\u552e\u8ba2\u5355|\u53d6\u6d88\u7535\u5546\u8ba2\u5355\u5931\u8d25|\u8fd4\u56de\u7f16\u7801: " + callEsbRspBo.getResultCode() + " \u8fd4\u56de\u63cf\u8ff0: " + callEsbRspBo.getResultMessage());
                    }
                } else {
                    throw new ZTBusinessException("\u8be5\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728\u4e09\u65b9\u4fe1\u606f");
                }
            }
            DycProOrderSaleOrderDTO updateSaleOrderDto = new DycProOrderSaleOrderDTO();
            updateSaleOrderDto.setSaleOrderState("XS_QX_QX");
            updateSaleOrderDto.setSaleOrderId(reqBO.getSaleOrderId());
            if (null != reqBO.getCancelReasonFlag()) {
                updateSaleOrderDto.setCancelReasonFlag(reqBO.getCancelReasonFlag());
            } else if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{reqBO.getSetSaleOrderNoExt()})) {
                updateSaleOrderDto.setCancelReasonFlag(DycProOrderApiServiceConstant.CancelReasonFlag.COMMERCE_CANCEL);
            } else {
                updateSaleOrderDto.setCancelReasonFlag(DycProOrderApiServiceConstant.CancelReasonFlag.USER_CANCEL);
            }
            updateSaleOrderDto.setCancelTime(new Date());
            updateSaleOrderDto.setCancelOperId(String.valueOf(reqBO.getUserId()));
            updateSaleOrderDto.setCancelOperName(reqBO.getName());
            updateSaleOrderDto.setCancelReason(reqBO.getCancelReason());
            updateSaleOrderDto.setOrderStage(DycProOrderApiServiceConstant.ORDER_STAPE.TRADE_CLOSE);
            this.dycProOrderSaleOrderRepository.updateSaleOrderByCondition(updateSaleOrderDto, true);
            if (!CollectionUtils.isEmpty((Collection)reqBO.getCancelOrderFileList())) {
                ArrayList<DycProOrderOrderAccessoryDTO> cancelOrderFileList = new ArrayList<DycProOrderOrderAccessoryDTO>();
                for (DycProOrderAccessoryApiBO accessoryBO : reqBO.getCancelOrderFileList()) {
                    DycProOrderOrderAccessoryDTO addAccessoryDTO = new DycProOrderOrderAccessoryDTO();
                    BeanUtils.copyProperties((Object)accessoryBO, (Object)addAccessoryDTO);
                    addAccessoryDTO.setObjId(reqBO.getSaleOrderId());
                    addAccessoryDTO.setOrderId(reqBO.getSaleOrderId());
                    addAccessoryDTO.setObjType(DycProOrderApiServiceConstant.AccessoryObjType.SALE_ORDER_CANCEL);
                    cancelOrderFileList.add(addAccessoryDTO);
                }
                this.dycProOrderOrderRepository.addAllKindsAccessoryBatch(cancelOrderFileList);
            }
            if (null == saleOrderDto.getUpperOrderId()) {
                DycProPublicProcInstDTO cancelFlowProcInstDto = new DycProPublicProcInstDTO();
                cancelFlowProcInstDto.setProcInstId(reqBO.getProcInstId());
                this.dycProPublicProcInstRepository.cancelFlow(cancelFlowProcInstDto);
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getSetSaleOrderNoExt()) || DycProOrderApiServiceConstant.CancelReasonFlag.AUTO_CANCEL.equals(reqBO.getCancelReasonFlag())) {
                DycProOrderSaleOrderDTO queryOrderDto = new DycProOrderSaleOrderDTO();
                queryOrderDto.setOrderId(saleOrderDto.getOrderId());
                List allSaleOrderList = this.dycProOrderSaleOrderRepository.querySaleOrderListByCondition(queryOrderDto);
                if (allSaleOrderList.stream().allMatch(bo -> "XS_QX_QX".equals(bo.getSaleOrderState()) || "XS_XD_SB".equals(bo.getSaleOrderState()))) {
                    DycProOrderApprovalObjDTO dycProOrderApprovalObjDTO = new DycProOrderApprovalObjDTO();
                    dycProOrderApprovalObjDTO.setObjId(saleOrderDto.getOrderId().toString());
                    dycProOrderApprovalObjDTO.setObjType(DycProOrderApiServiceConstant.ObjType.ORDER);
                    dycProOrderApprovalObjDTO.setObjBusiType(DycProOrderApiServiceConstant.OBJ_BUSI_TYPE.ORDER);
                    DycProOrderApprovalObjDTO approvalObjDTO = this.dycProOrderApproveRepository.queryApprovalObjOneByCondition(dycProOrderApprovalObjDTO);
                    if (null == approvalObjDTO) {
                        throw new ZTBusinessException("\u67e5\u8be2\u5ba1\u6279\u5bf9\u8c61\u4e3a\u7a7a\uff01");
                    }
                    rspBO.setAuditOrderId(approvalObjDTO.getAuditOrderId());
                    DycProPublicTaskInstDTO taskInstDTO = new DycProPublicTaskInstDTO();
                    taskInstDTO.setObjId(approvalObjDTO.getAuditOrderId());
                    taskInstDTO.setObjType("auditOrder");
                    taskInstDTO.setFinishTag(Integer.valueOf(0));
                    List dycProPublicTaskInstDTOS = this.dycProPublicTaskInstRepository.queryFlowTaskList(taskInstDTO);
                    if (!CollectionUtils.isEmpty((Collection)dycProPublicTaskInstDTOS)) {
                        DycProPublicProcInstDTO cancelFlowProcInstDto = new DycProPublicProcInstDTO();
                        cancelFlowProcInstDto.setProcInstId(((DycProPublicTaskInstDTO)dycProPublicTaskInstDTOS.get(0)).getProcInstId());
                        this.dycProPublicProcInstRepository.cancelFlow(cancelFlowProcInstDto);
                        rspBO.setAuditProcInstId(((DycProPublicTaskInstDTO)dycProPublicTaskInstDTOS.get(0)).getProcInstId());
                    }
                }
            }
            if (DycProOrderApiServiceConstant.OrderSource.AGR_ORDER.equals(reqBO.getOrderSource())) {
                DycProOrderSaleOrderItemQryDTO querySaleOrderItemDto = new DycProOrderSaleOrderItemQryDTO();
                querySaleOrderItemDto.setSaleOrderId(reqBO.getSaleOrderId());
                List saleOrderItemDtoList = this.dycProOrderSaleOrderRepository.querySaleOrderItemListByCondition(querySaleOrderItemDto);
                if (!CollectionUtils.isEmpty((Collection)saleOrderItemDtoList)) {
                    List saleOrderItemList = JSONArray.parseArray((String)JSON.toJSONString((Object)saleOrderItemDtoList)).toJavaList(DycProOrderSaleOrderItemApiBO.class);
                    rspBO.setSaleOrderItemList(saleOrderItemList);
                }
            }
            rspBO.setProcInstId(reqBO.getProcInstId());
            if (null != saleOrderDto.getBudgetId()) {
                this.deductBudget(saleOrderDto);
            }
            if (DycProOrderApiServiceConstant.OrderType.MALL_PUR_APPLY.equals(saleOrderDto.getOrderType())) {
                this.returnPurApply(saleOrderDto);
            }
            if ("1".equals(saleOrderDto.getProfessionalCompanyType()) && DycProOrderApiServiceConstant.PurchaseType.MRO_CENTRALIZED_PROCUREMENT.equals(saleOrderDto.getPurchaseType())) {
                this.pushAfterReturnForTy(saleOrderDto);
            }
            return rspBO;
        }
        throw new ZTBusinessException("\u8be5\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728");
    }

    private void deductBudget(DycProOrderSaleOrderDTO saleOrder) {
        DycProOrderBudgetUsedRecordDTO dycProOrderBudgetUsedRecordDTO = new DycProOrderBudgetUsedRecordDTO();
        dycProOrderBudgetUsedRecordDTO.setBudgetId(saleOrder.getBudgetId());
        dycProOrderBudgetUsedRecordDTO.setOccupyAmount(saleOrder.getTotalSaleFee().negate());
        dycProOrderBudgetUsedRecordDTO.setObjId(saleOrder.getSaleOrderId());
        dycProOrderBudgetUsedRecordDTO.setObjNo(saleOrder.getSaleOrderNo());
        dycProOrderBudgetUsedRecordDTO.setOccupyType(Integer.valueOf(2));
        this.dycProOrderBudgetRepository.deductBudget(dycProOrderBudgetUsedRecordDTO);
    }

    private void getSaleOrderId(DycProOrderCancelSaleOrderReqBO reqBO) {
        DycProOrderOrderQueryIndexQryDTO queryIndexQryDTO = new DycProOrderOrderQueryIndexQryDTO();
        queryIndexQryDTO.setOutObjId(reqBO.getSetSaleOrderNoExt());
        queryIndexQryDTO.setObjType(DycProOrderApiServiceConstant.OBJ_TYPE.SALE);
        List uocOrderQueryIndexList = this.saleOrderRepository.qryOrderQueryIndexList(queryIndexQryDTO);
        if (CollectionUtils.isEmpty((Collection)uocOrderQueryIndexList) || uocOrderQueryIndexList.size() != 1) {
            throw new ZTBusinessException("\u67e5\u8be2\u5916\u90e8\u8ba2\u5355" + reqBO.getSetSaleOrderNoExt() + "\u5173\u8054\u8868\u9519\u8bef");
        }
        reqBO.setSaleOrderId(((DycProOrderOrderQueryIndexDTO)uocOrderQueryIndexList.get(0)).getObjId());
        DycProOrderSaleOrderDTO querySaleOrderDto = new DycProOrderSaleOrderDTO();
        querySaleOrderDto.setSaleOrderId(reqBO.getSaleOrderId());
        DycProOrderSaleOrderDTO saleOrderDto = this.dycProOrderSaleOrderRepository.querySaleOrderOneByCondition(querySaleOrderDto);
        DycProOrderSaleOrderDTO reqDto = new DycProOrderSaleOrderDTO();
        reqDto.setStakeholderId(saleOrderDto.getStakeholderId());
        DycProOrderSaleOrderDTO saleStakeholder = this.saleOrderRepository.querySaleOrderStakeholderByCondition(reqDto);
        reqBO.setName(saleStakeholder.getSaleStakeholder().getSupName());
        if (null == saleOrderDto.getUpperOrderId()) {
            DycProPublicTaskInstDTO taskInstDTO = new DycProPublicTaskInstDTO();
            taskInstDTO.setObjId(reqBO.getSaleOrderId());
            taskInstDTO.setObjType("salesOrder");
            taskInstDTO.setFinishTag(Integer.valueOf(0));
            List dycProPublicTaskInstDTOS = this.dycProPublicTaskInstRepository.queryFlowTaskList(taskInstDTO);
            if (CollectionUtils.isEmpty((Collection)dycProPublicTaskInstDTOS) || dycProPublicTaskInstDTOS.size() != 1) {
                throw new ZTBusinessException("\u67e5\u8be2\u6d41\u7a0b\u4efb\u52a1\u5b9e\u4f8b\u9519\u8bef!");
            }
            reqBO.setProcInstId(((DycProPublicTaskInstDTO)dycProPublicTaskInstDTOS.get(0)).getProcInstId());
        }
        reqBO.setOrderSource(DycProOrderApiServiceConstant.OrderSource.AGR_ORDER);
    }

    private void returnPurApply(DycProOrderSaleOrderDTO saleOrderDTO) {
        DycProOrderSaleOrderItemQryDTO querySaleOrderItemDTO = new DycProOrderSaleOrderItemQryDTO();
        querySaleOrderItemDTO.setSaleOrderId(saleOrderDTO.getSaleOrderId());
        List saleOrderItemDTOList = this.dycProOrderSaleOrderRepository.querySaleOrderItemListByCondition(querySaleOrderItemDTO);
        for (DycProOrderSaleOrderItemDTO saleOrderItemDTO : saleOrderItemDTOList) {
            DycProOrderAdjustPurApplyItemCountDTO adjustPurApplyItemCountDTO = new DycProOrderAdjustPurApplyItemCountDTO();
            adjustPurApplyItemCountDTO.setPurApplyItemId(saleOrderItemDTO.getPurApplyItemId());
            adjustPurApplyItemCountDTO.setOccupyNum(saleOrderItemDTO.getPurchaseCount().negate());
            adjustPurApplyItemCountDTO.setOccupyType(Integer.valueOf(4));
            this.dycProOrderSaleOrderRepository.adjustPurchaseApplyItemCounts(adjustPurApplyItemCountDTO);
        }
    }

    private void pushAfterReturnForTy(DycProOrderSaleOrderDTO saleOrderDTO) {
        DycProOrderSaleOrderItemQryDTO querySaleOrderItemDTO = new DycProOrderSaleOrderItemQryDTO();
        querySaleOrderItemDTO.setSaleOrderId(saleOrderDTO.getSaleOrderId());
        List saleOrderItemDTOList = this.dycProOrderSaleOrderRepository.querySaleOrderItemListByCondition(querySaleOrderItemDTO);
        for (DycProOrderSaleOrderItemDTO saleOrderItemDTO : saleOrderItemDTOList) {
            DycProOrderInterLogDTO dycProOrderInterLogDTO = new DycProOrderInterLogDTO();
            dycProOrderInterLogDTO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            dycProOrderInterLogDTO.setObjId(saleOrderDTO.getSaleOrderId());
            dycProOrderInterLogDTO.setObjType(DycProOrderRepositoryConstant.ObjType.SALE);
            dycProOrderInterLogDTO.setOrderId(saleOrderDTO.getOrderId());
            dycProOrderInterLogDTO.setInterSn(this.deleteContractUrlForTy);
            DycProBaseCallEsbUtilDeleteContractForTyReqBO dycProBaseCallEsbUtilDeleteContractForTyReqBO = new DycProBaseCallEsbUtilDeleteContractForTyReqBO();
            dycProBaseCallEsbUtilDeleteContractForTyReqBO.setUrl(this.deleteContractUrlForTy);
            dycProBaseCallEsbUtilDeleteContractForTyReqBO.setId(saleOrderDTO.getSaleOrderId());
            dycProBaseCallEsbUtilDeleteContractForTyReqBO.setGoodsName(saleOrderItemDTO.getSkuName());
            dycProBaseCallEsbUtilDeleteContractForTyReqBO.setGoodsNum(saleOrderItemDTO.getPurchaseCount());
            dycProBaseCallEsbUtilDeleteContractForTyReqBO.setSku(saleOrderItemDTO.getSkuCode());
            dycProBaseCallEsbUtilDeleteContractForTyReqBO.setSourceType(null);
            dycProBaseCallEsbUtilDeleteContractForTyReqBO.setYctOrderCode(null);
            dycProBaseCallEsbUtilDeleteContractForTyReqBO.setServiceCode(saleOrderDTO.getSaleOrderNo());
            dycProBaseCallEsbUtilDeleteContractForTyReqBO.setCreateDate(saleOrderDTO.getCreateTime());
            dycProBaseCallEsbUtilDeleteContractForTyReqBO.setTimeStampForTy(Long.valueOf(new Date().getTime()));
            dycProBaseCallEsbUtilDeleteContractForTyReqBO.setMaterialType(null);
            dycProBaseCallEsbUtilDeleteContractForTyReqBO.setMaterialCode(saleOrderItemDTO.getMCode());
            dycProOrderInterLogDTO.setInContent(com.alibaba.fastjson.JSON.toJSONString((Object)dycProBaseCallEsbUtilDeleteContractForTyReqBO));
            try {
                DycProBaseCallEsbUtilDeleteContractForTyRspBO dycProBaseCallEsbUtilDeleteContractForTyRspBO = DycProBaseCallEsbUtil.deleteContractForTy((DycProBaseCallEsbUtilDeleteContractForTyReqBO)dycProBaseCallEsbUtilDeleteContractForTyReqBO);
                dycProOrderInterLogDTO.setOutContent(JSON.toJSONString((Object)dycProBaseCallEsbUtilDeleteContractForTyRspBO));
                if (null == dycProBaseCallEsbUtilDeleteContractForTyRspBO.getSuccess() || !dycProBaseCallEsbUtilDeleteContractForTyRspBO.getSuccess().booleanValue() || !"0000".equals(dycProBaseCallEsbUtilDeleteContractForTyRspBO.getResultCode())) {
                    log.debug("\u63a8\u9001\u7cd6\u4e1a\u552e\u540e\u670d\u52a1\u9000\u8d27\u5931\u8d25: {}" + dycProBaseCallEsbUtilDeleteContractForTyRspBO.getResultMessage());
                    dycProOrderInterLogDTO.setErrDetail(dycProBaseCallEsbUtilDeleteContractForTyRspBO.getResultMessage());
                    throw new ZTBusinessException("\u63a8\u9001\u7cd6\u4e1a\u552e\u540e\u670d\u52a1\u9000\u8d27\u5931\u8d25: {}" + dycProBaseCallEsbUtilDeleteContractForTyRspBO.getResultMessage());
                }
            }
            catch (Exception e) {
                log.debug("\u63a8\u9001\u7cd6\u4e1a\u552e\u540e\u670d\u52a1\u9000\u8d27\u5f02\u5e38: {}", (Object)e.getMessage());
                dycProOrderInterLogDTO.setErrDetail(e.getMessage());
            }
            this.dycProOrderSaleOrderRepository.saveOutSysCallLog(dycProOrderInterLogDTO);
        }
    }

    private void verifyParam(DycProOrderCancelSaleOrderReqBO reqBO, DycProOrderSaleOrderDTO saleOrderDto) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == saleOrderDto.getUpperOrderId() && StringUtils.isBlank((CharSequence)reqBO.getProcInstId())) {
            throw new ZTBusinessException("\u6d41\u7a0b\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSaleOrderId()) {
            throw new ZTBusinessException("\u9500\u552e\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderSource()) {
            throw new ZTBusinessException("\u8ba2\u5355\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

