/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.saleorder.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.core.encode.service.api.DycProEncodeSerialService;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialReqBO;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialRspBO;
import com.tydic.dyc.pro.egc.repository.approve.api.DycProOrderApproveRepository;
import com.tydic.dyc.pro.egc.repository.approve.dto.DycProOrderApprovalObjDTO;
import com.tydic.dyc.pro.egc.repository.approve.dto.DycProOrderAuditOrderDTO;
import com.tydic.dyc.pro.egc.repository.budget.api.DycProOrderBudgetRepository;
import com.tydic.dyc.pro.egc.repository.budget.dto.DycProOrderBudgetUsedRecordDTO;
import com.tydic.dyc.pro.egc.repository.order.api.DycProOrderOrderRepository;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderAgreementDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrdInvoiceDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrdLogisticsRelaDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderAccessoryDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.service.constants.DycProOrderApiServiceConstant;
import com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderCreateMainOrderOnlyService;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderCreateOrderServiceReqBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderCreateOrderServiceRspBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderCreateMainOrderOnlyService"})
public class DycProOrderCreateMainOrderOnlyServiceImpl
implements DycProOrderCreateMainOrderOnlyService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderCreateMainOrderOnlyServiceImpl.class);
    @Autowired
    private DycProOrderOrderRepository dycProOrderOrderRepository;
    @Autowired
    private DycProOrderBudgetRepository dycProOrderBudgetRepository;
    @Autowired
    private DycProOrderApproveRepository dycProOrderApproveRepository;
    @Autowired
    private DycProEncodeSerialService encodeSerialService;
    @Value(value="${isLimitPrice:true}")
    private boolean limitPrice;

    @PostMapping(value={"createOrder"})
    public DycProOrderCreateOrderServiceRspBO createOrder(@RequestBody DycProOrderCreateOrderServiceReqBO reqBO) {
        DycProOrderCreateOrderServiceRspBO rspBo = new DycProOrderCreateOrderServiceRspBO();
        DycProOrderOrderDTO orderResult = this.dealCreateOrder(reqBO);
        Long auditId = this.createApprove(orderResult.getOrderId(), reqBO);
        rspBo.setTotalSaleFee(orderResult.getTotalSaleFee());
        rspBo.setTotalPurchaseFee(orderResult.getTotalPurchaseFee());
        rspBo.setOrderId(orderResult.getOrderId());
        rspBo.setOrderNo(orderResult.getOrderNo());
        rspBo.setAuditId(auditId);
        return rspBo;
    }

    private void deductBudget(DycProOrderSaleOrderDTO saleOrder) {
        DycProOrderBudgetUsedRecordDTO dycProOrderBudgetUsedRecordDTO = new DycProOrderBudgetUsedRecordDTO();
        dycProOrderBudgetUsedRecordDTO.setBudgetId(saleOrder.getBudgetId());
        dycProOrderBudgetUsedRecordDTO.setOccupyAmount(saleOrder.getTotalSaleFee());
        dycProOrderBudgetUsedRecordDTO.setObjId(saleOrder.getSaleOrderId());
        dycProOrderBudgetUsedRecordDTO.setObjNo(saleOrder.getSaleOrderNo());
        dycProOrderBudgetUsedRecordDTO.setOccupyType(Integer.valueOf(1));
        this.dycProOrderBudgetRepository.deductBudget(dycProOrderBudgetUsedRecordDTO);
    }

    private Long createApprove(Long orderId, DycProOrderCreateOrderServiceReqBO reqBO) {
        Long auditId = Sequence.getInstance().nextId();
        DycProOrderAuditOrderDTO auditDo = new DycProOrderAuditOrderDTO();
        auditDo.setAuditOrderId(auditId);
        auditDo.setCreateOperId(reqBO.getUserId().toString());
        auditDo.setCreateOperName(reqBO.getName());
        auditDo.setOrderId(orderId);
        auditDo.setAuditOrderStatus("2");
        ArrayList<DycProOrderApprovalObjDTO> objList = new ArrayList<DycProOrderApprovalObjDTO>();
        auditDo.setApprovalObjs(objList);
        DycProOrderApprovalObjDTO approvalObj = new DycProOrderApprovalObjDTO();
        objList.add(approvalObj);
        approvalObj.setObjId(orderId.toString());
        approvalObj.setId(Long.valueOf(Sequence.getInstance().nextId()));
        approvalObj.setAuditOrderId(auditDo.getAuditOrderId());
        approvalObj.setOrderId(orderId);
        approvalObj.setObjType(DycProOrderApiServiceConstant.ObjType.PURCHASE);
        approvalObj.setObjBusiType(DycProOrderApiServiceConstant.OBJ_BUSI_TYPE.PURCHASE);
        this.dycProOrderApproveRepository.saveAudit(auditDo);
        return auditId;
    }

    private DycProOrderOrderDTO dealCreateOrder(DycProOrderCreateOrderServiceReqBO reqBO) {
        Long orderId = Sequence.getInstance().nextId();
        DycProOrderOrderDTO orderDTO = (DycProOrderOrderDTO)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), DycProOrderOrderDTO.class);
        orderDTO.setCreateOperId(String.valueOf(reqBO.getUserId()));
        orderDTO.setCreateOperName(reqBO.getName());
        orderDTO.setCreateTime(new Date());
        orderDTO.setOrderId(orderId);
        orderDTO.setPurchaseApplyId(reqBO.getPurchaseApplyId());
        this.setAddressInfo(orderDTO);
        this.setOrderInfo(orderDTO);
        this.setInvoiceInfo(orderDTO);
        this.setOrderAccessoryInfo(orderDTO);
        this.setOrderItemInfo(orderDTO);
        this.setAgrInfo(orderDTO);
        return this.dycProOrderOrderRepository.saveOrder(orderDTO);
    }

    private void setAgrInfo(DycProOrderOrderDTO orderDTO) {
        List agrInfoList = orderDTO.getAgrInfoList();
        for (DycProOrderAgreementDTO agrInfo : agrInfoList) {
            agrInfo.setId(Long.valueOf(Sequence.getInstance().nextId()));
            agrInfo.setOrderId(orderDTO.getOrderId());
        }
    }

    private void setOrderItemInfo(DycProOrderOrderDTO orderDTO) {
        List orderItems = orderDTO.getOrderItems();
        for (DycProOrderOrderItemDTO orderItem : orderItems) {
            orderItem.setOrderItemId(Long.valueOf(Sequence.getInstance().nextId()));
            orderItem.setOrderId(orderDTO.getOrderId());
            orderItem.setCreateTime(orderDTO.getCreateTime());
            orderItem.setCreateOperId(orderDTO.getCreateOperId());
            orderItem.setPurchaseFee(orderItem.getPurchasePrice().multiply(orderItem.getPurchaseCount()));
            orderItem.setSaleFee(orderItem.getSalePrice().multiply(orderItem.getPurchaseCount()));
            orderItem.setMaterialType(orderItem.getMaterialType());
        }
    }

    private void setOrderAccessoryInfo(DycProOrderOrderDTO orderDTO) {
        List accessoryList = orderDTO.getAccessoryList();
        for (DycProOrderOrderAccessoryDTO uocOrderAccessory : accessoryList) {
            uocOrderAccessory.setId(Long.valueOf(Sequence.getInstance().nextId()));
            uocOrderAccessory.setOrderId(orderDTO.getOrderId());
            uocOrderAccessory.setCreateTime(orderDTO.getCreateTime());
            uocOrderAccessory.setObjType(DycProOrderApiServiceConstant.AccessoryObjType.CREATE_ORDER_FILE);
            uocOrderAccessory.setObjId(orderDTO.getOrderId());
            if (ObjectUtil.isEmpty((Object)uocOrderAccessory.getAttachmentType())) continue;
            uocOrderAccessory.setObjType(uocOrderAccessory.getAttachmentType());
        }
    }

    private void setInvoiceInfo(DycProOrderOrderDTO orderDTO) {
        DycProOrderOrdInvoiceDTO uocOrdInvoice = orderDTO.getUocOrdInvoice();
        if (ObjectUtil.isNotEmpty((Object)uocOrdInvoice)) {
            uocOrdInvoice.setId(Long.valueOf(Sequence.getInstance().nextId()));
            uocOrdInvoice.setOrderId(orderDTO.getOrderId());
            uocOrdInvoice.setContactId(orderDTO.getInvoiceAddress().getContactId());
            uocOrdInvoice.setCreateOperId(orderDTO.getCreateOperId());
            uocOrdInvoice.setCreateTime(orderDTO.getCreateTime());
        }
    }

    private void setOrderInfo(DycProOrderOrderDTO orderDTO) {
        if (ObjectUtil.isNotEmpty((Object)orderDTO.getUocOrdInvoice())) {
            orderDTO.setNeedInvoiceTag(DycProOrderApiServiceConstant.NEED_INVOICED.NEED_INVOICED_Y);
        } else {
            orderDTO.setNeedInvoiceTag(DycProOrderApiServiceConstant.NEED_INVOICED.NEED_INVOICED_N);
        }
        orderDTO.setContactId(orderDTO.getReceiverAddress() != null ? orderDTO.getReceiverAddress().getContactId() : null);
        DycProEncodeSerialReqBO encodeSerialReqBO = new DycProEncodeSerialReqBO();
        encodeSerialReqBO.setCenterCode("UOC");
        encodeSerialReqBO.setEncodeRuleCode("orderOrderCode");
        encodeSerialReqBO.setNum(Long.valueOf(1L));
        DycProEncodeSerialRspBO encode = this.encodeSerialService.getEncode(encodeSerialReqBO);
        orderDTO.setOrderNo((String)encode.getSerialNoList().get(0));
    }

    private void setAddressInfo(DycProOrderOrderDTO orderDTO) {
        DycProOrderOrdLogisticsRelaDTO receiverAddress;
        DycProOrderOrdLogisticsRelaDTO invoiceAddress = orderDTO.getInvoiceAddress();
        if (invoiceAddress != null) {
            invoiceAddress.setOrderId(orderDTO.getOrderId());
            invoiceAddress.setContactId(Long.valueOf(Sequence.getInstance().nextId()));
            invoiceAddress.setCreateOperId(orderDTO.getCreateOperId());
            invoiceAddress.setCreateTime(orderDTO.getCreateTime());
        }
        if ((receiverAddress = orderDTO.getReceiverAddress()) != null) {
            receiverAddress.setOrderId(orderDTO.getOrderId());
            receiverAddress.setContactId(Long.valueOf(Sequence.getInstance().nextId()));
            receiverAddress.setCreateOperId(orderDTO.getCreateOperId());
            receiverAddress.setCreateTime(orderDTO.getCreateTime());
        }
    }
}

