/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.saleorder.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.core.encode.service.api.DycProEncodeSerialService;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialReqBO;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialRspBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtil;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilCreateContractForTyReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilCreateContractForTyRspBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilSendApprovalOrderForLgReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilSendApprovalOrderForLgRspBO;
import com.tydic.dyc.pro.egc.constant.DycProOrderRepositoryConstant;
import com.tydic.dyc.pro.egc.repository.approve.api.DycProOrderApproveRepository;
import com.tydic.dyc.pro.egc.repository.approve.dto.DycProOrderApprovalObjDTO;
import com.tydic.dyc.pro.egc.repository.approve.dto.DycProOrderAuditOrderDTO;
import com.tydic.dyc.pro.egc.repository.budget.api.DycProOrderBudgetRepository;
import com.tydic.dyc.pro.egc.repository.budget.dto.DycProOrderBudgetUsedRecordDTO;
import com.tydic.dyc.pro.egc.repository.order.api.DycProOrderOrderRepository;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderAgreementDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderConfSupplierDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrdInvoiceDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrdLogisticsRelaDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderAccessoryDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderAgreementDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderAdjustPurApplyItemCountDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderCostUseRecordDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderInterLogDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleAfterTakeTypeDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleStakeholderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderZlSysnStateTyDTO;
import com.tydic.dyc.pro.egc.service.constants.DycProOrderApiServiceConstant;
import com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderCreateOrderServiceService;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderCreateOrderServiceReqBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderCreateOrderServiceRspBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderCreateOrderServiceRspSaleOrderBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderCreateOrderServiceRspSaleOrderItemBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderCreateOrderServiceService"})
public class DycProOrderCreateOrderServiceServiceImpl
implements DycProOrderCreateOrderServiceService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderCreateOrderServiceServiceImpl.class);
    @Autowired
    private DycProOrderOrderRepository dycProOrderOrderRepository;
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;
    @Autowired
    private DycProOrderApproveRepository dycProOrderApproveRepository;
    @Autowired
    private DycProOrderBudgetRepository dycProOrderBudgetRepository;
    @Autowired
    private DycProEncodeSerialService encodeSerialService;
    @Value(value="${isLimitPrice:true}")
    private boolean limitPrice;
    @Value(value="${call.lg.url.sendApprovalOrderUrlForLg}")
    private String sendApprovalOrderUrlForLg;
    @Value(value="${call.ty.url.createContractUrlForTy}")
    private String createContractUrlForTy;

    @PostMapping(value={"createOrder"})
    public DycProOrderCreateOrderServiceRspBO createOrder(@RequestBody DycProOrderCreateOrderServiceReqBO reqBO) {
        DycProOrderOrderDTO orderResult = this.dealCreateOrder(reqBO);
        List saleItemList = JSONArray.parseArray((String)JSON.toJSONString((Object)orderResult.getOrderItems())).toJavaList(DycProOrderSaleOrderItemDTO.class);
        List<DycProOrderSaleOrderDTO> createSaleOrderList = this.splitSaleOrderNew(orderResult, saleItemList);
        ArrayList<DycProOrderCreateOrderServiceRspSaleOrderBO> saleOrderResultList = new ArrayList<DycProOrderCreateOrderServiceRspSaleOrderBO>();
        for (DycProOrderSaleOrderDTO saleOrderDo : createSaleOrderList) {
            DycProOrderSaleOrderDTO saleOrder = this.createSaleOrder(saleOrderDo);
            if (null != reqBO.getBudgetId()) {
                this.deductBudget(saleOrderDo);
            }
            if ("2".equals(reqBO.getProfessionalCompanyType())) {
                this.pushApprovalOrderFroLg(saleOrderDo);
            }
            if ("1".equals(reqBO.getProfessionalCompanyType())) {
                this.pushApprovalOrderFroTy(saleOrderDo);
            }
            if (DycProOrderApiServiceConstant.OrderType.MALL_PUR_APPLY.equals(saleOrderDo.getOrderType())) {
                this.occupyPurApply(saleOrderDo);
            }
            DycProOrderCreateOrderServiceRspSaleOrderBO orderItemRspData = new DycProOrderCreateOrderServiceRspSaleOrderBO();
            BeanUtils.copyProperties((Object)saleOrder, (Object)orderItemRspData);
            BeanUtils.copyProperties((Object)saleOrder.getSaleStakeholder(), (Object)orderItemRspData);
            orderItemRspData.setSaleOrderId(saleOrder.getSaleOrderId());
            List itemList = JSON.parseArray((String)JSON.toJSONString((Object)saleOrder.getSaleItemList()), DycProOrderCreateOrderServiceRspSaleOrderItemBO.class);
            orderItemRspData.setItemBoList(itemList);
            orderItemRspData.setSaleOrderNo(saleOrder.getSaleOrderNo());
            orderItemRspData.setOrderSource(saleOrder.getOrderSource());
            orderItemRspData.setAgrId(saleOrder.getAgreementId());
            orderItemRspData.setModelSettle(saleOrder.getModelSettle());
            orderItemRspData.setPayType(saleOrder.getPayType() != null ? Integer.valueOf(saleOrder.getPayType()) : null);
            saleOrderResultList.add(orderItemRspData);
        }
        Long auditId = null;
        if (!("1".equals(reqBO.getProfessionalCompanyType()) || "2".equals(reqBO.getProfessionalCompanyType()) || "3".equals(reqBO.getProfessionalCompanyType()) || null != reqBO.getPurchaseApplyId())) {
            auditId = this.createApprove(orderResult.getOrderId(), reqBO);
        }
        DycProOrderCreateOrderServiceRspBO rspBo = new DycProOrderCreateOrderServiceRspBO();
        rspBo.setTotalSaleFee(orderResult.getTotalSaleFee());
        rspBo.setTotalPurchaseFee(orderResult.getTotalPurchaseFee());
        rspBo.setOrderId(orderResult.getOrderId());
        rspBo.setOrderNo(orderResult.getOrderNo());
        rspBo.setSaleOrderList(saleOrderResultList);
        rspBo.setAuditId(auditId);
        return rspBo;
    }

    private void pushApprovalOrderFroLg(DycProOrderSaleOrderDTO saleOrderDo) {
        DycProOrderInterLogDTO dycProOrderInterLogDTO = new DycProOrderInterLogDTO();
        dycProOrderInterLogDTO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        dycProOrderInterLogDTO.setObjId(saleOrderDo.getSaleOrderId());
        dycProOrderInterLogDTO.setObjType(DycProOrderRepositoryConstant.ObjType.SALE);
        dycProOrderInterLogDTO.setOrderId(saleOrderDo.getOrderId());
        dycProOrderInterLogDTO.setInterSn(this.sendApprovalOrderUrlForLg);
        DycProBaseCallEsbUtilSendApprovalOrderForLgReqBO dycProBaseCallEsbUtilSendApprovalOrderForLgReqBO = new DycProBaseCallEsbUtilSendApprovalOrderForLgReqBO();
        dycProBaseCallEsbUtilSendApprovalOrderForLgReqBO.setUrl(this.sendApprovalOrderUrlForLg);
        dycProBaseCallEsbUtilSendApprovalOrderForLgReqBO.setOrderNo(saleOrderDo.getSaleOrderNo());
        dycProOrderInterLogDTO.setInContent(JSON.toJSONString((Object)dycProBaseCallEsbUtilSendApprovalOrderForLgReqBO));
        try {
            DycProBaseCallEsbUtilSendApprovalOrderForLgRspBO dycProBaseCallEsbUtilSendApprovalOrderForLgRspBO = DycProBaseCallEsbUtil.sendApprovalOrder((DycProBaseCallEsbUtilSendApprovalOrderForLgReqBO)dycProBaseCallEsbUtilSendApprovalOrderForLgReqBO);
            dycProOrderInterLogDTO.setOutContent(JSON.toJSONString((Object)dycProBaseCallEsbUtilSendApprovalOrderForLgRspBO));
            if (dycProBaseCallEsbUtilSendApprovalOrderForLgRspBO.getSuccess() == null || !dycProBaseCallEsbUtilSendApprovalOrderForLgRspBO.getSuccess().booleanValue() || !"0000".equals(dycProBaseCallEsbUtilSendApprovalOrderForLgRspBO.getResultCode())) {
                log.info("\u63a8\u9001\u7cae\u8c37\u5e26\u5ba1\u6279\u8ba2\u5355\u5f02\u5e38\uff1a{}", (Object)dycProBaseCallEsbUtilSendApprovalOrderForLgRspBO.getResultMessage());
                dycProOrderInterLogDTO.setErrDetail(dycProBaseCallEsbUtilSendApprovalOrderForLgRspBO.getResultMessage());
                throw new ZTBusinessException("\u63a8\u9001\u7cae\u8c37\u5e26\u5ba1\u6279\u8ba2\u5355\u5f02\u5e38\uff1a{" + dycProBaseCallEsbUtilSendApprovalOrderForLgRspBO.getResultMessage() + "}");
            }
        }
        catch (Exception e) {
            log.info("\u63a8\u9001\u7cae\u8c37\u5e26\u5ba1\u6279\u8ba2\u5355\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            dycProOrderInterLogDTO.setErrDetail(e.getMessage());
        }
        this.dycProOrderSaleOrderRepository.saveOutSysCallLog(dycProOrderInterLogDTO);
    }

    private void pushApprovalOrderFroTy(DycProOrderSaleOrderDTO saleOrderDTO) {
        List saleOrderItemDTOList = saleOrderDTO.getSaleItemList();
        DycProOrderSaleStakeholderDTO saleOrderStakeholderDTO = saleOrderDTO.getSaleStakeholder();
        DycProOrderOrdLogisticsRelaDTO ordLogisticsRelaDTO = saleOrderDTO.getReceiverAddress();
        List orderCmpAccessoryDTOList = Optional.ofNullable(saleOrderDTO.getAccessoryList()).orElse(Collections.emptyList()).stream().filter(accessory -> accessory.getObjType().equals(DycProOrderRepositoryConstant.OrderAccessoryObjType.PRICE_COMPARISON)).collect(Collectors.toList());
        DycProOrderInterLogDTO dycProOrderInterLogDTO = new DycProOrderInterLogDTO();
        dycProOrderInterLogDTO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        dycProOrderInterLogDTO.setObjId(saleOrderDTO.getSaleOrderId());
        dycProOrderInterLogDTO.setObjType(DycProOrderRepositoryConstant.ObjType.SALE);
        dycProOrderInterLogDTO.setOrderId(saleOrderDTO.getOrderId());
        dycProOrderInterLogDTO.setInterSn(this.createContractUrlForTy);
        DycProBaseCallEsbUtilCreateContractForTyReqBO dycProBaseCallEsbUtilCreateContractForTyReqBO = new DycProBaseCallEsbUtilCreateContractForTyReqBO();
        dycProBaseCallEsbUtilCreateContractForTyReqBO.setUrl(this.createContractUrlForTy);
        dycProBaseCallEsbUtilCreateContractForTyReqBO.setOrderId(saleOrderDTO.getSaleOrderId());
        dycProBaseCallEsbUtilCreateContractForTyReqBO.setOrderCode(saleOrderDTO.getSaleOrderNo());
        dycProBaseCallEsbUtilCreateContractForTyReqBO.setCreateCompanyID(saleOrderStakeholderDTO.getPurCompanyId());
        dycProBaseCallEsbUtilCreateContractForTyReqBO.setOrderStatus(Integer.valueOf(21));
        dycProBaseCallEsbUtilCreateContractForTyReqBO.setPayType(String.valueOf(101));
        dycProBaseCallEsbUtilCreateContractForTyReqBO.setOrderAmount(saleOrderDTO.getTotalSaleFee());
        dycProBaseCallEsbUtilCreateContractForTyReqBO.setOrderTaxPrice(null);
        dycProBaseCallEsbUtilCreateContractForTyReqBO.setOrderNakedPrice(null);
        dycProBaseCallEsbUtilCreateContractForTyReqBO.setCreateId(saleOrderDTO.getCreateOperId());
        dycProBaseCallEsbUtilCreateContractForTyReqBO.setCreateDate(saleOrderDTO.getCreateTime());
        dycProBaseCallEsbUtilCreateContractForTyReqBO.setOrderDesc(saleOrderDTO.getRemark());
        dycProBaseCallEsbUtilCreateContractForTyReqBO.setUserAddressName(ordLogisticsRelaDTO.getContactName());
        dycProBaseCallEsbUtilCreateContractForTyReqBO.setUserAddressMail(ordLogisticsRelaDTO.getContactEmail());
        dycProBaseCallEsbUtilCreateContractForTyReqBO.setUserAddressPhone(ordLogisticsRelaDTO.getContactMobile());
        dycProBaseCallEsbUtilCreateContractForTyReqBO.setReceiveInfo(ordLogisticsRelaDTO.getContactProvinceName() + ordLogisticsRelaDTO.getContactCityName() + ordLogisticsRelaDTO.getContactCountyName() + ordLogisticsRelaDTO.getContactTown() + ordLogisticsRelaDTO.getContactAddress());
        dycProBaseCallEsbUtilCreateContractForTyReqBO.setCreateTimeStamp(null);
        dycProBaseCallEsbUtilCreateContractForTyReqBO.setSourceType(null);
        dycProBaseCallEsbUtilCreateContractForTyReqBO.setOrderType(null);
        dycProBaseCallEsbUtilCreateContractForTyReqBO.setContractCode(null);
        dycProBaseCallEsbUtilCreateContractForTyReqBO.setStoreCode(null);
        ArrayList<DycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO> orderDetails = new ArrayList<DycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO>(1);
        for (DycProOrderSaleOrderItemDTO saleOrderItemDTO : saleOrderItemDTOList) {
            DycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO dycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO = new DycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO();
            dycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO.setOrderDetailId(saleOrderItemDTO.getSaleOrderItemId());
            dycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO.setProductionId(Long.valueOf(saleOrderItemDTO.getSkuId()));
            dycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO.setProductionName(saleOrderItemDTO.getSkuName());
            dycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO.setProductionDesc(null);
            dycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO.setPrice(saleOrderItemDTO.getSalePrice());
            dycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO.setProductionNum(saleOrderItemDTO.getPurchaseCount());
            dycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO.setMaterialCode(saleOrderItemDTO.getMCode());
            dycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO.setSku(saleOrderItemDTO.getSkuCode());
            dycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO.setTax(null);
            String allOrderCmpAccessoryUrl = CollectionUtils.isEmpty(orderCmpAccessoryDTOList) ? null : orderCmpAccessoryDTOList.stream().map(DycProOrderOrderAccessoryDTO::getAccessoryUrl).collect(Collectors.joining(","));
            dycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO.setExtField03(allOrderCmpAccessoryUrl);
            dycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO.setUnit(saleOrderStakeholderDTO.getPurCompanyId());
            dycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO.setConfigureData(null);
            orderDetails.add(dycProBaseCallEsbUtilCreateContractOrderDetailsForTyBO);
        }
        dycProBaseCallEsbUtilCreateContractForTyReqBO.setOrderDetails(orderDetails);
        dycProOrderInterLogDTO.setInContent(JSON.toJSONString((Object)dycProBaseCallEsbUtilCreateContractForTyReqBO));
        try {
            DycProBaseCallEsbUtilCreateContractForTyRspBO dycProBaseCallEsbUtilCreateContractForTyRspBO = DycProBaseCallEsbUtil.createContractForTy((DycProBaseCallEsbUtilCreateContractForTyReqBO)dycProBaseCallEsbUtilCreateContractForTyReqBO);
            dycProOrderInterLogDTO.setOutContent(JSON.toJSONString((Object)dycProBaseCallEsbUtilCreateContractForTyRspBO));
            if (null == dycProBaseCallEsbUtilCreateContractForTyRspBO.getSuccess() || !dycProBaseCallEsbUtilCreateContractForTyRspBO.getSuccess().booleanValue() || !"0000".equals(dycProBaseCallEsbUtilCreateContractForTyRspBO.getResultCode())) {
                log.debug("\u63a8\u9001\u7cd6\u4e1a\u5f85\u5ba1\u6279\u8ba2\u5355\u5f02\u5e38: {}", (Object)dycProBaseCallEsbUtilCreateContractForTyRspBO.getResultMessage());
                dycProOrderInterLogDTO.setErrDetail(dycProBaseCallEsbUtilCreateContractForTyRspBO.getResultMessage());
                throw new ZTBusinessException("\u63a8\u9001\u7cae\u8c37\u5e26\u5ba1\u6279\u8ba2\u5355\u5f02\u5e38: {}" + dycProBaseCallEsbUtilCreateContractForTyRspBO.getResultMessage());
            }
        }
        catch (Exception e) {
            log.debug("\u63a8\u9001\u7cd6\u4e1a\u5f85\u5ba1\u6279\u8ba2\u5355\u5f02\u5e38: {}", (Object)e.getMessage());
            dycProOrderInterLogDTO.setErrDetail(e.getMessage());
        }
        this.dycProOrderSaleOrderRepository.saveOutSysCallLog(dycProOrderInterLogDTO);
        DycProOrderZlSysnStateTyDTO addZlSysnStateTyDTO = new DycProOrderZlSysnStateTyDTO();
        addZlSysnStateTyDTO.setSysnStsteId(Long.valueOf(Sequence.getInstance().nextId()));
        addZlSysnStateTyDTO.setObjType(DycProOrderRepositoryConstant.ObjType.SALE);
        addZlSysnStateTyDTO.setObjId(saleOrderDTO.getSaleOrderId());
        addZlSysnStateTyDTO.setFinishFlag(Integer.valueOf(0));
        addZlSysnStateTyDTO.setCreateTime(new Date());
        this.dycProOrderSaleOrderRepository.addZlSysnStateTy(addZlSysnStateTyDTO);
    }

    private void deductBudget(DycProOrderSaleOrderDTO saleOrder) {
        DycProOrderBudgetUsedRecordDTO dycProOrderBudgetUsedRecordDTO = new DycProOrderBudgetUsedRecordDTO();
        dycProOrderBudgetUsedRecordDTO.setBudgetId(saleOrder.getBudgetId());
        dycProOrderBudgetUsedRecordDTO.setOccupyAmount(saleOrder.getTotalSaleFee());
        dycProOrderBudgetUsedRecordDTO.setObjId(saleOrder.getSaleOrderId());
        dycProOrderBudgetUsedRecordDTO.setObjNo(saleOrder.getSaleOrderNo());
        dycProOrderBudgetUsedRecordDTO.setOccupyType(Integer.valueOf(1));
        this.dycProOrderBudgetRepository.deductBudget(dycProOrderBudgetUsedRecordDTO);
    }

    private Long createApprove(Long orderId, DycProOrderCreateOrderServiceReqBO reqBO) {
        Long auditId = Sequence.getInstance().nextId();
        DycProOrderAuditOrderDTO auditDo = new DycProOrderAuditOrderDTO();
        auditDo.setAuditOrderId(auditId);
        auditDo.setCreateOperId(reqBO.getUserId().toString());
        auditDo.setCreateOperName(reqBO.getName());
        auditDo.setOrderId(orderId);
        auditDo.setAuditOrderStatus("2");
        ArrayList<DycProOrderApprovalObjDTO> objList = new ArrayList<DycProOrderApprovalObjDTO>();
        auditDo.setApprovalObjs(objList);
        DycProOrderApprovalObjDTO approvalObj = new DycProOrderApprovalObjDTO();
        objList.add(approvalObj);
        approvalObj.setObjId(orderId.toString());
        approvalObj.setId(Long.valueOf(Sequence.getInstance().nextId()));
        approvalObj.setAuditOrderId(auditDo.getAuditOrderId());
        approvalObj.setOrderId(orderId);
        approvalObj.setObjType(DycProOrderApiServiceConstant.ObjType.ORDER);
        approvalObj.setObjBusiType(DycProOrderApiServiceConstant.OBJ_BUSI_TYPE.ORDER);
        this.dycProOrderApproveRepository.saveAudit(auditDo);
        return auditId;
    }

    private DycProOrderSaleOrderDTO createSaleOrder(DycProOrderSaleOrderDTO saleOrderDo) {
        if (ObjectUtil.isEmpty((Object)saleOrderDo.getSaleOrderNo())) {
            DycProEncodeSerialReqBO encodeSerialReqBO = new DycProEncodeSerialReqBO();
            encodeSerialReqBO.setCenterCode("UOC");
            encodeSerialReqBO.setEncodeRuleCode("orderSaleOrderCode");
            encodeSerialReqBO.setNum(Long.valueOf(1L));
            DycProEncodeSerialRspBO encode = this.encodeSerialService.getEncode(encodeSerialReqBO);
            saleOrderDo.setSaleOrderNo((String)encode.getSerialNoList().get(0));
        }
        saleOrderDo.setContactId(saleOrderDo.getReceiverAddress() != null ? saleOrderDo.getReceiverAddress().getContactId() : null);
        if (ObjectUtil.isEmpty((Object)saleOrderDo.getSaleOrderId())) {
            saleOrderDo.setSaleOrderId(Long.valueOf(Sequence.getInstance().nextId()));
        }
        if (ObjectUtil.isEmpty((Object)saleOrderDo.getSaleOrderState())) {
            saleOrderDo.setSaleOrderState(null);
        }
        this.setSaleOrderAccessoryInfo(saleOrderDo);
        this.setSaleItems(saleOrderDo);
        this.setAfterTakeType(saleOrderDo);
        if (this.limitPrice) {
            BigDecimal totalSale = saleOrderDo.getTotalSaleFee();
            totalSale = totalSale.multiply(new BigDecimal(10000));
            String supNo = saleOrderDo.getSaleStakeholder().getSupId();
            String supName = saleOrderDo.getSaleStakeholder().getSupName();
            log.info("\u4f9b\u5e94\u5546 {}\uff0c\u4e0b\u5355\u91d1\u989d\u4e3a {}", (Object)supNo, (Object)totalSale);
            DycProOrderConfSupplierDTO uocConfSupplier = new DycProOrderConfSupplierDTO();
            uocConfSupplier.setSupNo(supNo);
            uocConfSupplier.setLimitStatus(Integer.valueOf(0));
            uocConfSupplier = this.dycProOrderOrderRepository.getConfSupplierModelBy(uocConfSupplier);
            DycProOrderConfSupplierDTO uocConfSupplier1 = new DycProOrderConfSupplierDTO();
            uocConfSupplier1.setSupNo("0");
            uocConfSupplier1.setLimitStatus(Integer.valueOf(0));
            uocConfSupplier1.setBusinessTypeCode(String.valueOf(saleOrderDo.getOrderSource()));
            uocConfSupplier1 = this.dycProOrderOrderRepository.getConfSupplierModelBy(uocConfSupplier1);
            DycProOrderConfSupplierDTO dycProOrderConfSupplierDTO = uocConfSupplier = Objects.nonNull(uocConfSupplier) ? uocConfSupplier : uocConfSupplier1;
            if (ObjectUtil.isNotEmpty((Object)uocConfSupplier)) {
                Long limit = Long.valueOf(uocConfSupplier.getOrderLimit());
                log.info("\u8ba2\u5355\u9650\u989d\uff1a{}", (Object)limit);
                if (limit != null && limit > 0L && limit > totalSale.longValue()) {
                    String money = null;
                    try {
                        money = this.long2BigDecimal(limit).toString();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    throw new ZTBusinessException(supName + "\u4e0b\u7684\u8ba2\u5355\u4e0d\u6ee1\u8db3" + money + "\u5143\uff0c\u4e0d\u5141\u8bb8\u4e0b\u5355\u3002");
                }
            }
        }
        return this.dycProOrderSaleOrderRepository.createSaleOrderAndSyncNoSql(saleOrderDo);
    }

    private Object long2BigDecimal(Long amount) {
        if (amount != null) {
            try {
                BigDecimal bd = new BigDecimal("10000");
                BigDecimal bAmount = new BigDecimal(amount);
                return bAmount.divide(bd, 2, 1);
            }
            catch (Exception var3) {
                throw new ZTBusinessException("Long2BigDecimal\u6570\u636e\u8f6c\u6362\u9519\u8bef: " + var3);
            }
        }
        return null;
    }

    private void setAfterTakeType(DycProOrderSaleOrderDTO saleOrderDo) {
        List saleOrderItems = saleOrderDo.getSaleItemList();
        for (DycProOrderSaleOrderItemDTO saleOrderItem : saleOrderItems) {
            List returnTypeList = saleOrderItem.getServerReturnTypeList();
            ArrayList afterTakeTypeList = new ArrayList();
            if (ObjectUtil.isNotEmpty((Object)returnTypeList)) {
                returnTypeList.forEach(e -> {
                    DycProOrderSaleAfterTakeTypeDTO afterTakeTypeBo = new DycProOrderSaleAfterTakeTypeDTO();
                    afterTakeTypeBo.setAfterTakeType(e);
                    afterTakeTypeBo.setAfterTakeId(Long.valueOf(Sequence.getInstance().nextId()));
                    afterTakeTypeBo.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
                    afterTakeTypeBo.setCommodityId(saleOrderItem.getCommodityId());
                    afterTakeTypeList.add(afterTakeTypeBo);
                });
            }
            saleOrderItem.setAfterTakeTypeList(afterTakeTypeList);
        }
    }

    private void setSaleItems(DycProOrderSaleOrderDTO saleOrderDo) {
        List saleOrderItems = saleOrderDo.getSaleItemList();
        for (DycProOrderSaleOrderItemDTO saleOrderItem : saleOrderItems) {
            List priceComparisonAttachBos;
            saleOrderItem.setOrderId(saleOrderDo.getOrderId());
            if (ObjectUtil.isEmpty((Object)saleOrderItem.getSaleOrderItemId())) {
                saleOrderItem.setSaleOrderItemId(Long.valueOf(Sequence.getInstance().nextId()));
            }
            saleOrderItem.setSaleOrderId(saleOrderDo.getSaleOrderId());
            saleOrderItem.setCreateOperId(saleOrderDo.getCreateOperId());
            saleOrderItem.setCreateTime(saleOrderDo.getCreateTime());
            saleOrderItem.setPurchaseFee(saleOrderItem.getPurchasePrice().multiply(saleOrderItem.getPurchaseCount()));
            saleOrderItem.setSaleFee(saleOrderItem.getSalePrice().multiply(saleOrderItem.getPurchaseCount()));
            if (ObjectUtil.isEmpty((Object)saleOrderItem.getCmpOrderNo())) {
                saleOrderItem.setCmpOrderNo(null);
            }
            if (ObjectUtil.isNotEmpty((Object)(priceComparisonAttachBos = saleOrderItem.getPriceComparisonAttachBos()))) {
                for (DycProOrderOrderAccessoryDTO accessory : priceComparisonAttachBos) {
                    accessory.setId(Long.valueOf(Sequence.getInstance().nextId()));
                    accessory.setObjId(saleOrderItem.getSaleOrderItemId());
                    accessory.setObjType(DycProOrderApiServiceConstant.AccessoryObjType.PRICE_COMPARISON);
                    accessory.setOrderId(saleOrderDo.getSaleOrderId());
                    accessory.setCreateTime(saleOrderDo.getCreateTime());
                    accessory.setCreateOperId(saleOrderDo.getCreateOperId());
                }
            }
            if (CollectionUtils.isEmpty((Collection)saleOrderItem.getCostUseRecordList())) continue;
            for (DycProOrderCostUseRecordDTO costRecord : saleOrderItem.getCostUseRecordList()) {
                costRecord.setCostUseRecordId(Long.valueOf(Sequence.getInstance().nextId()));
                costRecord.setObjType(DycProOrderApiServiceConstant.OBJ_TYPE.SALE);
                costRecord.setObjId(saleOrderDo.getSaleOrderId());
                costRecord.setObjItemId(saleOrderItem.getSaleOrderItemId());
                costRecord.setUseType(Integer.valueOf(1));
            }
        }
    }

    private void setSaleOrderAccessoryInfo(DycProOrderSaleOrderDTO saleOrderDo) {
        List saleOrderAccessoryList = saleOrderDo.getAccessoryList();
        if (ObjectUtil.isNotEmpty((Object)saleOrderAccessoryList)) {
            for (DycProOrderOrderAccessoryDTO accessory : saleOrderAccessoryList) {
                accessory.setId(Long.valueOf(Sequence.getInstance().nextId()));
                accessory.setObjId(saleOrderDo.getSaleOrderId());
                accessory.setObjType(DycProOrderApiServiceConstant.OBJ_TYPE.SALE);
                accessory.setOrderId(saleOrderDo.getOrderId());
                accessory.setCreateTime(saleOrderDo.getCreateTime());
                accessory.setCreateOperId(saleOrderDo.getCreateOperId());
            }
        }
    }

    private List<DycProOrderSaleOrderDTO> splitSaleOrderNew(DycProOrderOrderDTO orderInfo, List<DycProOrderSaleOrderItemDTO> saleItemList) {
        ArrayList<DycProOrderSaleOrderDTO> saleOrderList = new ArrayList<DycProOrderSaleOrderDTO>();
        List<DycProOrderSaleOrderDTO> splitSaleOrderResultList = this.splitOrder(saleItemList);
        List agrInfoList = orderInfo.getAgrInfoList();
        Map<Object, Object> agrInfoMap = new HashMap();
        if (ObjectUtil.isNotEmpty((Object)agrInfoList)) {
            agrInfoMap = agrInfoList.stream().collect(Collectors.toMap(DycProOrderAgreementDTO::getAgreementId, item -> item));
        }
        Map<String, DycProOrderSaleStakeholderDTO> orderStakeholderMap = orderInfo.getSaleStakeholderInfoList().stream().collect(Collectors.toMap(DycProOrderSaleStakeholderDTO::getSupId, item -> item));
        Map<String, DycProOrderSaleOrderItemDTO> saleOrderItemMap = saleItemList.stream().collect(Collectors.toMap(DycProOrderSaleOrderItemDTO::getSkuId, o -> o));
        for (DycProOrderSaleOrderDTO saleOrderDo : splitSaleOrderResultList) {
            DycProOrderSaleOrderDTO createSaleOrderDo = (DycProOrderSaleOrderDTO)JSON.parseObject((String)JSON.toJSONString((Object)orderInfo), DycProOrderSaleOrderDTO.class);
            saleOrderList.add(createSaleOrderDo);
            List saleOrderItems = saleOrderDo.getSaleItemList();
            for (DycProOrderSaleOrderItemDTO each : saleOrderItems) {
                BeanUtils.copyProperties((Object)saleOrderItemMap.get(each.getSkuId()), (Object)each);
                each.setAgreementName(((DycProOrderAgreementDTO)agrInfoMap.get(each.getAgreementId())).getAgreementName());
                each.setAgreementInfo((DycProOrderOrderAgreementDTO)JSON.parseObject((String)JSON.toJSONString((Object)agrInfoMap.get(each.getAgreementId())), DycProOrderOrderAgreementDTO.class));
            }
            createSaleOrderDo.setDeliveryAddress(orderInfo.getReceiverAddress());
            createSaleOrderDo.setSaleItemList(saleOrderItems);
            createSaleOrderDo.setAccessoryList(orderInfo.getAccessoryList());
            createSaleOrderDo.setOrderSource(((DycProOrderSaleOrderItemDTO)saleOrderItems.get(0)).getSkuSource());
            createSaleOrderDo.setStakeholderId(orderStakeholderMap.get(((DycProOrderSaleOrderItemDTO)saleOrderItems.get(0)).getSupplierId()).getStakeholderId());
            createSaleOrderDo.setSaleStakeholder(orderStakeholderMap.get(((DycProOrderSaleOrderItemDTO)saleOrderItems.get(0)).getSupplierId()));
            createSaleOrderDo.setTotalSaleFee(this.computeSaleOrderTotalSaleFee(saleOrderItems, saleOrderItemMap));
            createSaleOrderDo.setTotalPurchaseFee(this.computeSaleOrderTotalPurchaseFee(saleOrderItems, saleOrderItemMap));
            createSaleOrderDo.setCreatedResult(DycProOrderApiServiceConstant.CREATED_RESULT.SUCCESS);
            if (DycProOrderApiServiceConstant.OrderSource.E_ORDER.equals(((DycProOrderSaleOrderItemDTO)saleOrderItems.get(0)).getSkuSource())) {
                createSaleOrderDo.setCreatedResult(DycProOrderApiServiceConstant.CREATED_RESULT.PROCESSING);
            }
            createSaleOrderDo.setPurchaseType(((DycProOrderSaleOrderItemDTO)saleOrderItems.get(0)).getPurchaseType());
            createSaleOrderDo.setMaterialType(((DycProOrderSaleOrderItemDTO)saleOrderItems.get(0)).getMaterialType());
            createSaleOrderDo.setOrderNo(orderInfo.getOrderNo());
            createSaleOrderDo.setPayState(DycProOrderApiServiceConstant.PayState.PAY_FAILED);
            createSaleOrderDo.setModelSettle(DycProOrderApiServiceConstant.ModelSettle.MATCH);
            createSaleOrderDo.setReceiverAddress(orderInfo.getReceiverAddress());
            createSaleOrderDo.setInvoice(orderInfo.getUocOrdInvoice());
        }
        return saleOrderList;
    }

    private BigDecimal computeSaleOrderTotalPurchaseFee(List<DycProOrderSaleOrderItemDTO> saleOrderItems, Map<String, DycProOrderSaleOrderItemDTO> saleOrderItemMap) {
        BigDecimal saleFee = new BigDecimal(0);
        for (DycProOrderSaleOrderItemDTO uocOrderItem : saleOrderItems) {
            saleFee = saleFee.add(uocOrderItem.getPurchaseCount().multiply(saleOrderItemMap.get(uocOrderItem.getSkuId()).getPurchasePrice()));
        }
        return saleFee;
    }

    private BigDecimal computeSaleOrderTotalSaleFee(List<DycProOrderSaleOrderItemDTO> saleOrderItems, Map<String, DycProOrderSaleOrderItemDTO> saleOrderItemMap) {
        BigDecimal totalSaleFee = new BigDecimal(0);
        for (DycProOrderSaleOrderItemDTO uocOrderItem : saleOrderItems) {
            totalSaleFee = totalSaleFee.add(uocOrderItem.getPurchaseCount().multiply(saleOrderItemMap.get(uocOrderItem.getSkuId()).getSalePrice()));
        }
        return totalSaleFee;
    }

    private List<DycProOrderSaleOrderDTO> splitOrder(List<DycProOrderSaleOrderItemDTO> saleItemList) {
        ArrayList<DycProOrderSaleOrderDTO> saleOrderDoList = new ArrayList<DycProOrderSaleOrderDTO>();
        ArrayList<List<Object>> retList = new ArrayList<List<Object>>();
        Map<String, List<DycProOrderSaleOrderItemDTO>> supMap = saleItemList.stream().collect(Collectors.groupingBy(DycProOrderSaleOrderItemDTO::getSupplierId));
        for (Map.Entry<String, List<DycProOrderSaleOrderItemDTO>> entry : supMap.entrySet()) {
            Map<Integer, List<DycProOrderSaleOrderItemDTO>> agrMap = entry.getValue().stream().collect(Collectors.groupingBy(DycProOrderSaleOrderItemDTO::getMaterialType));
            for (Map.Entry<Integer, List<DycProOrderSaleOrderItemDTO>> agrEntry : agrMap.entrySet()) {
                List planList;
                List noPlanList = agrEntry.getValue().stream().filter(item -> ObjectUtil.isEmpty((Object)item.getPlanId())).collect(Collectors.toList());
                if (ObjectUtil.isNotEmpty(noPlanList)) {
                    retList.add(noPlanList);
                }
                if (!ObjectUtil.isNotEmpty(planList = agrEntry.getValue().stream().filter(item -> !ObjectUtil.isEmpty((Object)item.getPlanId())).collect(Collectors.toList()))) continue;
                retList.addAll(planList.stream().collect(Collectors.groupingBy(DycProOrderSaleOrderItemDTO::getPlanId)).values());
            }
        }
        for (List list : retList) {
            DycProOrderSaleOrderDTO createSaleOrderDo = new DycProOrderSaleOrderDTO();
            createSaleOrderDo.setSaleItemList(list);
            saleOrderDoList.add(createSaleOrderDo);
        }
        return saleOrderDoList;
    }

    private DycProOrderOrderDTO dealCreateOrder(DycProOrderCreateOrderServiceReqBO reqBO) {
        Long orderId = Sequence.getInstance().nextId();
        DycProOrderOrderDTO orderDTO = (DycProOrderOrderDTO)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), DycProOrderOrderDTO.class);
        orderDTO.setCreateOperId(String.valueOf(reqBO.getUserId()));
        orderDTO.setCreateOperName(reqBO.getName());
        orderDTO.setCreateTime(new Date());
        orderDTO.setOrderId(orderId);
        this.setAddressInfo(orderDTO);
        this.setOrderInfo(orderDTO);
        this.setInvoiceInfo(orderDTO);
        this.setOrderAccessoryInfo(orderDTO);
        this.setOrderItemInfo(orderDTO);
        this.setAgrInfo(orderDTO);
        return this.dycProOrderOrderRepository.saveOrder(orderDTO);
    }

    private void setAgrInfo(DycProOrderOrderDTO orderDTO) {
        List agrInfoList = orderDTO.getAgrInfoList();
        for (DycProOrderAgreementDTO agrInfo : agrInfoList) {
            agrInfo.setId(Long.valueOf(Sequence.getInstance().nextId()));
            agrInfo.setOrderId(orderDTO.getOrderId());
        }
    }

    private void setOrderItemInfo(DycProOrderOrderDTO orderDTO) {
        List orderItems = orderDTO.getOrderItems();
        for (DycProOrderOrderItemDTO orderItem : orderItems) {
            orderItem.setOrderItemId(Long.valueOf(Sequence.getInstance().nextId()));
            orderItem.setOrderId(orderDTO.getOrderId());
            orderItem.setCreateTime(orderDTO.getCreateTime());
            orderItem.setCreateOperId(orderDTO.getCreateOperId());
            orderItem.setPurchaseFee(orderItem.getPurchasePrice().multiply(orderItem.getPurchaseCount()));
            orderItem.setSaleFee(orderItem.getSalePrice().multiply(orderItem.getPurchaseCount()));
        }
    }

    private void setOrderAccessoryInfo(DycProOrderOrderDTO orderDTO) {
        List accessoryList = orderDTO.getAccessoryList();
        for (DycProOrderOrderAccessoryDTO uocOrderAccessory : accessoryList) {
            uocOrderAccessory.setId(Long.valueOf(Sequence.getInstance().nextId()));
            uocOrderAccessory.setOrderId(orderDTO.getOrderId());
            uocOrderAccessory.setCreateTime(orderDTO.getCreateTime());
            uocOrderAccessory.setObjType(DycProOrderApiServiceConstant.AccessoryObjType.CREATE_ORDER_FILE);
            uocOrderAccessory.setObjId(orderDTO.getOrderId());
            if (ObjectUtil.isEmpty((Object)uocOrderAccessory.getAttachmentType())) continue;
            uocOrderAccessory.setObjType(uocOrderAccessory.getAttachmentType());
        }
    }

    private void setInvoiceInfo(DycProOrderOrderDTO orderDTO) {
        DycProOrderOrdInvoiceDTO uocOrdInvoice = orderDTO.getUocOrdInvoice();
        if (ObjectUtil.isNotEmpty((Object)uocOrdInvoice)) {
            uocOrdInvoice.setId(Long.valueOf(Sequence.getInstance().nextId()));
            uocOrdInvoice.setOrderId(orderDTO.getOrderId());
            uocOrdInvoice.setContactId(orderDTO.getInvoiceAddress().getContactId());
            uocOrdInvoice.setCreateOperId(orderDTO.getCreateOperId());
            uocOrdInvoice.setCreateTime(orderDTO.getCreateTime());
        }
    }

    private void setOrderInfo(DycProOrderOrderDTO orderDTO) {
        if (ObjectUtil.isNotEmpty((Object)orderDTO.getUocOrdInvoice())) {
            orderDTO.setNeedInvoiceTag(DycProOrderApiServiceConstant.NEED_INVOICED.NEED_INVOICED_Y);
        } else {
            orderDTO.setNeedInvoiceTag(DycProOrderApiServiceConstant.NEED_INVOICED.NEED_INVOICED_N);
        }
        orderDTO.setContactId(orderDTO.getReceiverAddress() != null ? orderDTO.getReceiverAddress().getContactId() : null);
        DycProEncodeSerialReqBO encodeSerialReqBO = new DycProEncodeSerialReqBO();
        encodeSerialReqBO.setCenterCode("UOC");
        encodeSerialReqBO.setEncodeRuleCode("orderOrderCode");
        encodeSerialReqBO.setNum(Long.valueOf(1L));
        DycProEncodeSerialRspBO encode = this.encodeSerialService.getEncode(encodeSerialReqBO);
        orderDTO.setOrderNo((String)encode.getSerialNoList().get(0));
    }

    private void setAddressInfo(DycProOrderOrderDTO orderDTO) {
        DycProOrderOrdLogisticsRelaDTO receiverAddress;
        DycProOrderOrdLogisticsRelaDTO invoiceAddress = orderDTO.getInvoiceAddress();
        if (invoiceAddress != null) {
            invoiceAddress.setOrderId(orderDTO.getOrderId());
            invoiceAddress.setContactId(Long.valueOf(Sequence.getInstance().nextId()));
            invoiceAddress.setCreateOperId(orderDTO.getCreateOperId());
            invoiceAddress.setCreateTime(orderDTO.getCreateTime());
        }
        if ((receiverAddress = orderDTO.getReceiverAddress()) != null) {
            receiverAddress.setOrderId(orderDTO.getOrderId());
            receiverAddress.setContactId(Long.valueOf(Sequence.getInstance().nextId()));
            receiverAddress.setCreateOperId(orderDTO.getCreateOperId());
            receiverAddress.setCreateTime(orderDTO.getCreateTime());
        }
    }

    private void occupyPurApply(DycProOrderSaleOrderDTO saleOrderDTO) {
        DycProOrderAdjustPurApplyItemCountDTO adjustPurApplyItemCountDTO;
        for (DycProOrderSaleOrderItemDTO saleOrderItemDTO : saleOrderDTO.getSaleItemList()) {
            adjustPurApplyItemCountDTO = new DycProOrderAdjustPurApplyItemCountDTO();
            adjustPurApplyItemCountDTO.setPurApplyItemId(saleOrderItemDTO.getPurApplyItemId());
            adjustPurApplyItemCountDTO.setOccupyNum(saleOrderItemDTO.getPurchaseCount());
            adjustPurApplyItemCountDTO.setOccupyType(Integer.valueOf(1));
            this.dycProOrderSaleOrderRepository.adjustPurchaseApplyItemCounts(adjustPurApplyItemCountDTO);
        }
        for (DycProOrderSaleOrderItemDTO saleOrderItemDTO : saleOrderDTO.getSaleItemList()) {
            adjustPurApplyItemCountDTO = new DycProOrderAdjustPurApplyItemCountDTO();
            adjustPurApplyItemCountDTO.setPurApplyItemId(saleOrderItemDTO.getPurApplyItemId());
            adjustPurApplyItemCountDTO.setOccupyNum(saleOrderItemDTO.getPurchaseCount());
            adjustPurApplyItemCountDTO.setOccupyType(Integer.valueOf(3));
            this.dycProOrderSaleOrderRepository.adjustPurchaseApplyItemCounts(adjustPurApplyItemCountDTO);
        }
    }
}

