/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.saleorder.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.core.encode.service.api.DycProEncodeSerialService;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialReqBO;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialRspBO;
import com.tydic.dyc.pro.base.core.flow.repository.api.DycProPublicTaskInstRepository;
import com.tydic.dyc.pro.base.core.flow.repository.dto.DycProPublicTaskInstDTO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtil;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilOrderChildSaleOrderBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilOrderQrySubOrderReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilOrderQrySubOrderRspBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilOrderSkuBO;
import com.tydic.dyc.pro.egc.repository.order.api.DycProOrderOrderRepository;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrdLogisticsRelaDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderQueryIndexDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderQueryIndexQryDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderCostUseRecordDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemQryDTO;
import com.tydic.dyc.pro.egc.service.constants.DycProOrderApiServiceConstant;
import com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderDealJdSplitOrderMsgApiService;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderDealJdSplitOrderMsgApiReqBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderDealJdSplitOrderMsgApiRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderDealJdSplitOrderMsgApiService"})
public class DycProOrderDealJdSplitOrderMsgApiServiceImpl
implements DycProOrderDealJdSplitOrderMsgApiService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderDealJdSplitOrderMsgApiServiceImpl.class);
    @Autowired
    private DycProOrderSaleOrderRepository saleOrderRepository;
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;
    @Autowired
    private DycProOrderOrderRepository dycProOrderOrderRepository;
    @Autowired
    private DycProPublicTaskInstRepository dycProPublicTaskInstRepository;
    @Value(value="${call.esb.url.qrySubOrder}")
    private String qrySubOrderUrl;
    @Autowired
    private Environment environment;
    @Autowired
    private DycProEncodeSerialService encodeSerialService;

    @PostMapping(value={"dealJdSplitOrderMsg"})
    public DycProOrderDealJdSplitOrderMsgApiRspBO dealJdSplitOrderMsg(@RequestBody DycProOrderDealJdSplitOrderMsgApiReqBO reqBO) {
        DycProOrderDealJdSplitOrderMsgApiRspBO rspBO = new DycProOrderDealJdSplitOrderMsgApiRspBO();
        DycProOrderSaleOrderDTO salOrderDetail = this.qrySalOrderDetail(reqBO.getResult().getPOrder());
        DycProBaseCallEsbUtilOrderQrySubOrderRspBO qrySubOrderRspBO = this.getExtOrderInfo(reqBO, salOrderDetail);
        this.createSubSaleOrder(qrySubOrderRspBO, salOrderDetail);
        this.updateParSaleOrder(salOrderDetail.getSaleOrderId());
        return rspBO;
    }

    private void updateParSaleOrder(Long saleOrderId) {
        DycProOrderSaleOrderDTO dycProOrderSaleOrderDTO = new DycProOrderSaleOrderDTO();
        dycProOrderSaleOrderDTO.setSaleOrderId(saleOrderId);
        dycProOrderSaleOrderDTO.setSaleOrderState("XS_SPLIT");
        this.saleOrderRepository.updateSaleOrderByCondition(dycProOrderSaleOrderDTO, true);
    }

    private void createSubSaleOrder(DycProBaseCallEsbUtilOrderQrySubOrderRspBO qrySubOrderRspBO, DycProOrderSaleOrderDTO salOrderDetail) {
        for (DycProBaseCallEsbUtilOrderChildSaleOrderBO childOrder : qrySubOrderRspBO.getResult().getCOrder()) {
            Long subSaleOrderId = Sequence.getInstance().nextId();
            DycProOrderSaleOrderDTO subSaleOrderDTO = new DycProOrderSaleOrderDTO();
            BeanUtils.copyProperties((Object)salOrderDetail, (Object)subSaleOrderDTO);
            DycProEncodeSerialReqBO encodeSerialReqBO = new DycProEncodeSerialReqBO();
            encodeSerialReqBO.setCenterCode("UOC");
            encodeSerialReqBO.setEncodeRuleCode("orderSaleOrderCode");
            encodeSerialReqBO.setNum(Long.valueOf(1L));
            DycProEncodeSerialRspBO encode = this.encodeSerialService.getEncode(encodeSerialReqBO);
            subSaleOrderDTO.setSaleOrderNo((String)encode.getSerialNoList().get(0));
            subSaleOrderDTO.setSaleOrderId(subSaleOrderId);
            subSaleOrderDTO.setUpperOrderId(salOrderDetail.getSaleOrderId());
            if (ObjectUtil.isNotEmpty((Object)childOrder.getJdOrderId())) {
                subSaleOrderDTO.setSaleOrderNoExt(String.valueOf(childOrder.getJdOrderId()));
            }
            if (ObjectUtil.isNotEmpty((Object)childOrder.getOrderId())) {
                subSaleOrderDTO.setSaleOrderNoExt(String.valueOf(childOrder.getOrderId()));
            }
            subSaleOrderDTO.setSaleOrderState("XS_FH_DFH");
            this.setSaleItems(childOrder, subSaleOrderDTO, salOrderDetail);
            DycProPublicTaskInstDTO taskInfo = this.setTaskId(subSaleOrderDTO);
            subSaleOrderDTO.setBusiTaskInstId(taskInfo.getTaskInstId());
            subSaleOrderDTO.setBusiProcInstId(taskInfo.getProcInstId());
            String jdParentOrderNo = salOrderDetail.getSaleOrderNo();
            if (StringUtils.isNotBlank((CharSequence)salOrderDetail.getJdParentOrderNo())) {
                jdParentOrderNo = salOrderDetail.getJdParentOrderNo();
            }
            subSaleOrderDTO.setJdParentOrderNo(jdParentOrderNo);
            this.dycProOrderSaleOrderRepository.createSaleOrderAndSyncNoSql(subSaleOrderDTO);
            DycProOrderOrderQueryIndexDTO index = new DycProOrderOrderQueryIndexDTO();
            index.setId(Long.valueOf(Sequence.getInstance().nextId()));
            index.setOrderId(subSaleOrderDTO.getOrderId());
            index.setObjType(DycProOrderApiServiceConstant.OBJ_TYPE.SALE);
            index.setObjId(subSaleOrderDTO.getSaleOrderId());
            index.setOutObjId(subSaleOrderDTO.getSaleOrderNoExt());
            this.saleOrderRepository.addOrderQueryIndex(index);
        }
    }

    private DycProPublicTaskInstDTO setTaskId(DycProOrderSaleOrderDTO subSaleOrderDTO) {
        DycProPublicTaskInstDTO taskInstDTO = new DycProPublicTaskInstDTO();
        taskInstDTO.setObjId(subSaleOrderDTO.getUpperOrderId());
        taskInstDTO.setObjType("salesOrder");
        taskInstDTO.setFinishTag(Integer.valueOf(0));
        List dycProPublicTaskInstDTOS = this.dycProPublicTaskInstRepository.queryFlowTaskList(taskInstDTO);
        if (CollectionUtils.isEmpty((Collection)dycProPublicTaskInstDTOS)) {
            DycProOrderSaleOrderDTO parentSaleOrderQryDTO = new DycProOrderSaleOrderDTO();
            parentSaleOrderQryDTO.setSaleOrderId(subSaleOrderDTO.getUpperOrderId());
            DycProOrderSaleOrderDTO parentSaleOrderDTO = this.saleOrderRepository.querySaleOrderOneByCondition(parentSaleOrderQryDTO);
            if (null == parentSaleOrderDTO) {
                throw new ZTBusinessException("\u67e5\u8be2\u7236\u9500\u552e\u5355[" + subSaleOrderDTO.getUpperOrderId() + "]\u9519\u8bef");
            }
            return this.setTaskId(parentSaleOrderDTO);
        }
        if (dycProPublicTaskInstDTOS.size() != 1) {
            throw new ZTBusinessException("\u67e5\u8be2\u6d41\u7a0b\u4efb\u52a1\u5b9e\u4f8b\u9519\u8bef!");
        }
        return (DycProPublicTaskInstDTO)dycProPublicTaskInstDTOS.get(0);
    }

    private void setSaleItems(DycProBaseCallEsbUtilOrderChildSaleOrderBO childOrder, DycProOrderSaleOrderDTO subSaleOrderDTO, DycProOrderSaleOrderDTO salOrderDetail) {
        Map saleOrderItemDTOMap = salOrderDetail.getSaleItemList().stream().collect(Collectors.toMap(DycProOrderSaleOrderItemDTO::getSkuExtSkuId, Function.identity()));
        ArrayList<DycProOrderSaleOrderItemDTO> saleItemList = new ArrayList<DycProOrderSaleOrderItemDTO>();
        BigDecimal totalSaleFee = BigDecimal.ZERO;
        BigDecimal totalPurchaseFee = BigDecimal.ZERO;
        for (DycProBaseCallEsbUtilOrderSkuBO sku : childOrder.getSku()) {
            Long subSaleOrderItemId = Sequence.getInstance().nextId();
            DycProOrderSaleOrderItemDTO saleOrderItemDTO = (DycProOrderSaleOrderItemDTO)saleOrderItemDTOMap.get(sku.getSkuId());
            if (null == saleOrderItemDTO) {
                throw new ZTBusinessException("\u5546\u54c1id[" + sku.getSkuId() + "]\u4e0d\u5b58\u5728\u4e8e\u7236\u8ba2\u5355\u4e2d\uff01");
            }
            DycProOrderSaleOrderItemDTO subSaleOrderItemDTO = new DycProOrderSaleOrderItemDTO();
            BeanUtils.copyProperties((Object)saleOrderItemDTO, (Object)subSaleOrderItemDTO);
            subSaleOrderItemDTO.setPurchaseCount(new BigDecimal(sku.getNum()));
            BigDecimal saleFee = subSaleOrderItemDTO.getSalePrice().multiply(subSaleOrderItemDTO.getPurchaseCount()).setScale(2, RoundingMode.HALF_UP);
            BigDecimal purchaseFee = subSaleOrderItemDTO.getPurchasePrice().multiply(subSaleOrderItemDTO.getPurchaseCount()).setScale(2, RoundingMode.HALF_UP);
            subSaleOrderItemDTO.setSaleFee(saleFee);
            subSaleOrderItemDTO.setPurchaseFee(purchaseFee);
            subSaleOrderItemDTO.setSaleOrderId(subSaleOrderDTO.getSaleOrderId());
            subSaleOrderItemDTO.setSaleOrderItemId(subSaleOrderItemId);
            saleItemList.add(subSaleOrderItemDTO);
            totalSaleFee = totalSaleFee.add(saleFee);
            totalPurchaseFee = totalPurchaseFee.add(purchaseFee);
            List costUseRecordList = saleOrderItemDTO.getCostUseRecordList();
            for (DycProOrderCostUseRecordDTO costUseRecordDTO : costUseRecordList) {
                costUseRecordDTO.setCostUseRecordId(Long.valueOf(Sequence.getInstance().nextId()));
                costUseRecordDTO.setObjId(subSaleOrderDTO.getSaleOrderId());
                costUseRecordDTO.setObjItemId(subSaleOrderItemId);
            }
        }
        subSaleOrderDTO.setTotalSaleFee(totalSaleFee);
        subSaleOrderDTO.setTotalPurchaseFee(totalPurchaseFee);
        subSaleOrderDTO.setSaleItemList(saleItemList);
    }

    private DycProBaseCallEsbUtilOrderQrySubOrderRspBO getExtOrderInfo(DycProOrderDealJdSplitOrderMsgApiReqBO reqBO, DycProOrderSaleOrderDTO salOrderDetail) {
        DycProBaseCallEsbUtilOrderChildSaleOrderBO childSaleOrderBO;
        List filterSku;
        DycProBaseCallEsbUtilOrderQrySubOrderReqBO qrySubOrderReqBO = new DycProBaseCallEsbUtilOrderQrySubOrderReqBO();
        qrySubOrderReqBO.setOrderId(reqBO.getResult().getPOrder());
        if (DycProOrderApiServiceConstant.ModelSettle.TRADE.equals(salOrderDetail.getModelSettle())) {
            qrySubOrderReqBO.setOrgId(salOrderDetail.getSaleStakeholder().getProId());
        } else {
            qrySubOrderReqBO.setOrgId(salOrderDetail.getSaleStakeholder().getPurOrgId());
        }
        qrySubOrderReqBO.setUrl(this.qrySubOrderUrl);
        qrySubOrderReqBO.setHsn(this.environment.getProperty("SUPPLIER_ID_" + salOrderDetail.getSaleStakeholder().getSupId()));
        log.debug("\u4eac\u4e1c\u62c6\u5355\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)qrySubOrderReqBO));
        DycProBaseCallEsbUtilOrderQrySubOrderRspBO qrySubOrderRspBO = DycProBaseCallEsbUtil.qrySubOrder((DycProBaseCallEsbUtilOrderQrySubOrderReqBO)qrySubOrderReqBO);
        log.debug("\u4eac\u4e1c\u62c6\u5355\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)qrySubOrderRspBO));
        if (qrySubOrderRspBO.getSuccess() == null || !qrySubOrderRspBO.getSuccess().booleanValue() || !"0000".equals(qrySubOrderRspBO.getResultCode())) {
            log.debug("\u5916\u90e8\u8ba2\u5355\uff1a{}\u67e5\u8be2\u7b2c\u4e09\u65b9\u5916\u90e8\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38\uff1a{}", (Object)reqBO.getResult().getPOrder(), (Object)qrySubOrderRspBO.getResultMessage());
            throw new ZTBusinessException("\u5916\u90e8\u8ba2\u5355:" + reqBO.getResult().getPOrder() + "\u67e5\u8be2\u7b2c\u4e09\u65b9\u5916\u90e8\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38:" + qrySubOrderRspBO.getResultMessage());
        }
        if (CollectionUtils.isEmpty((Collection)qrySubOrderRspBO.getResult().getCOrder())) {
            log.debug("\u5916\u90e8\u8ba2\u5355{}\u6ca1\u6709\u67e5\u5230\u5bf9\u5e94\u7684\u62c6\u5355\u4fe1\u606f", (Object)reqBO.getResult().getPOrder());
            throw new ZTBusinessException("\u5916\u90e8\u8ba2\u5355" + reqBO.getResult().getPOrder() + "\u6ca1\u6709\u67e5\u5230\u5bf9\u5e94\u7684\u62c6\u5355\u4fe1\u606f");
        }
        ArrayList<DycProBaseCallEsbUtilOrderChildSaleOrderBO> filterCOrder = new ArrayList<DycProBaseCallEsbUtilOrderChildSaleOrderBO>();
        Iterator iterator = qrySubOrderRspBO.getResult().getCOrder().iterator();
        while (iterator.hasNext() && !CollectionUtils.isEmpty(filterSku = (childSaleOrderBO = (DycProBaseCallEsbUtilOrderChildSaleOrderBO)iterator.next()).getSku().stream().filter(sku -> sku.getType() == 0).collect(Collectors.toList()))) {
            DycProBaseCallEsbUtilOrderChildSaleOrderBO dycProBaseCallEsbUtilOrderChildSaleOrderBO = new DycProBaseCallEsbUtilOrderChildSaleOrderBO();
            BeanUtils.copyProperties((Object)childSaleOrderBO, (Object)dycProBaseCallEsbUtilOrderChildSaleOrderBO);
            dycProBaseCallEsbUtilOrderChildSaleOrderBO.setSku(filterSku);
            filterCOrder.add(dycProBaseCallEsbUtilOrderChildSaleOrderBO);
        }
        if (CollectionUtils.isEmpty(filterCOrder)) {
            log.debug("\u5916\u90e8\u8ba2\u5355{}\u6ca1\u6709\u6b63\u5e38\u5546\u54c1\u7684\u62c6\u5355\u4fe1\u606f", (Object)reqBO.getResult().getPOrder());
            throw new ZTBusinessException("\u5916\u90e8\u8ba2\u5355" + reqBO.getResult().getPOrder() + "\u6ca1\u6709\u6b63\u5e38\u5546\u54c1\u7684\u62c6\u5355\u4fe1\u606f");
        }
        qrySubOrderRspBO.getResult().setCOrder(filterCOrder);
        return qrySubOrderRspBO;
    }

    private DycProOrderSaleOrderDTO qrySalOrderDetail(String pOrder) {
        DycProOrderOrderQueryIndexQryDTO queryIndexQryDTO = new DycProOrderOrderQueryIndexQryDTO();
        queryIndexQryDTO.setOutObjId(pOrder);
        queryIndexQryDTO.setObjType(DycProOrderApiServiceConstant.OBJ_TYPE.SALE);
        List uocOrderQueryIndexList = this.saleOrderRepository.qryOrderQueryIndexList(queryIndexQryDTO);
        if (CollectionUtils.isEmpty((Collection)uocOrderQueryIndexList) || uocOrderQueryIndexList.size() != 1) {
            throw new ZTBusinessException("\u67e5\u8be2\u5916\u90e8\u8ba2\u5355" + pOrder + "\u5173\u8054\u8868\u9519\u8bef");
        }
        DycProOrderSaleOrderDTO saleOrderDetailApiReqBO = new DycProOrderSaleOrderDTO();
        saleOrderDetailApiReqBO.setSaleOrderId(((DycProOrderOrderQueryIndexDTO)uocOrderQueryIndexList.get(0)).getObjId());
        DycProOrderSaleOrderDTO saleOrderDTO = this.saleOrderRepository.querySaleOrderOneByCondition(saleOrderDetailApiReqBO);
        if (saleOrderDTO == null) {
            throw new ZTBusinessException("\u67e5\u8be2\u9500\u552e\u5355\u8be6\u60c5\u5931\u8d25\uff0c\u9500\u552e\u5355id\u4e3a\uff1a" + ((DycProOrderOrderQueryIndexDTO)uocOrderQueryIndexList.get(0)).getObjId());
        }
        if (!"XS_FH_DFH".equals(saleOrderDTO.getSaleOrderState())) {
            throw new ZTBusinessException("\u8be5\u9500\u552e\u5355\u4e0d\u4e3a\u5f85\u53d1\u8d27\u72b6\u6001\uff0c\u4e0d\u80fd\u8fdb\u884c\u62c6\u5355\u64cd\u4f5c\uff0c\u9500\u552e\u5355id\u4e3a\uff1a" + saleOrderDTO.getSaleOrderId());
        }
        DycProOrderSaleOrderDTO dycProOrderSaleOrderDTO = new DycProOrderSaleOrderDTO();
        dycProOrderSaleOrderDTO.setStakeholderId(saleOrderDTO.getStakeholderId());
        DycProOrderSaleOrderDTO stakeholder = this.saleOrderRepository.querySaleOrderStakeholderByCondition(dycProOrderSaleOrderDTO);
        saleOrderDTO.setSaleStakeholder(stakeholder.getSaleStakeholder());
        DycProOrderSaleOrderItemQryDTO dycProOrderSaleOrderItemDTO = new DycProOrderSaleOrderItemQryDTO();
        dycProOrderSaleOrderItemDTO.setSaleOrderId(saleOrderDTO.getSaleOrderId());
        List saleOrderItemDTOList = this.saleOrderRepository.querySaleOrderItemListByCondition(dycProOrderSaleOrderItemDTO);
        saleOrderDTO.setSaleItemList(saleOrderItemDTOList);
        DycProOrderCostUseRecordDTO useRecordDTO = new DycProOrderCostUseRecordDTO();
        useRecordDTO.setObjId(saleOrderDTO.getSaleOrderId());
        useRecordDTO.setObjType(DycProOrderApiServiceConstant.OBJ_TYPE.SALE);
        List costUseRecordList = this.saleOrderRepository.getCostUseRecordList(useRecordDTO);
        Map<Object, Object> costUseRecordMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)costUseRecordList)) {
            costUseRecordMap = costUseRecordList.stream().collect(Collectors.groupingBy(DycProOrderCostUseRecordDTO::getObjItemId));
        }
        for (DycProOrderSaleOrderItemDTO saleItem : saleOrderItemDTOList) {
            List costUseRecords = (List)costUseRecordMap.get(saleItem.getSaleOrderItemId());
            saleItem.setCostUseRecordList(costUseRecords);
        }
        DycProOrderOrdLogisticsRelaDTO dycProOrderOrdLogisticsRelaDTO = new DycProOrderOrdLogisticsRelaDTO();
        dycProOrderOrdLogisticsRelaDTO.setContactId(saleOrderDTO.getContactId());
        DycProOrderOrdLogisticsRelaDTO deliveryAddressDTO = this.dycProOrderSaleOrderRepository.getOrderLogisticsRela(dycProOrderOrdLogisticsRelaDTO);
        saleOrderDTO.setDeliveryAddress(deliveryAddressDTO);
        return saleOrderDTO;
    }
}

