/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.saleorder.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtil;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilSendApprovalOrderForLgReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilSendApprovalOrderForLgRspBO;
import com.tydic.dyc.pro.egc.constant.DycProOrderRepositoryConstant;
import com.tydic.dyc.pro.egc.constant.DycProOrderServiceConstant;
import com.tydic.dyc.pro.egc.repository.approve.api.DycProOrderApproveRepository;
import com.tydic.dyc.pro.egc.repository.budget.api.DycProOrderBudgetRepository;
import com.tydic.dyc.pro.egc.repository.budget.dto.DycProOrderBudgetUsedRecordDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderQueryIndexDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderAdjustPurApplyItemCountDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderInterLogDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemQryDTO;
import com.tydic.dyc.pro.egc.service.constants.DycProOrderApiServiceConstant;
import com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderResoveEsPreOrderForLgService;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderResoveEsPreOrderForLgServiceReqBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderResoveEsPreOrderForLgServiceRspBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderResoveEsPreOrderServiceReqSkuBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderResoveEsPreOrderForLgService"})
public class DycProOrderResoveEsPreOrderForLgServiceImpl
implements DycProOrderResoveEsPreOrderForLgService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderResoveEsPreOrderForLgServiceImpl.class);
    @Autowired
    private DycProOrderSaleOrderRepository saleOrderRepository;
    @Autowired
    private DycProOrderApproveRepository dycProOrderApproveRepository;
    @Autowired
    private DycProOrderBudgetRepository dycProOrderBudgetRepository;
    @Value(value="${call.lg.url.sendApprovalOrderUrlForLg}")
    private String sendApprovalOrderUrlForLg;

    @PostMapping(value={"dealEsPreOrderForLg"})
    public DycProOrderResoveEsPreOrderForLgServiceRspBO dealEsPreOrderForLg(@RequestBody DycProOrderResoveEsPreOrderForLgServiceReqBO reqBo) {
        DycProOrderResoveEsPreOrderForLgServiceRspBO rspBo = new DycProOrderResoveEsPreOrderForLgServiceRspBO();
        if (DycProOrderServiceConstant.CREATED_RESULT.FAILED.equals(reqBo.getCreatedResult())) {
            DycProOrderSaleOrderDTO updateExtOrderIdDo = new DycProOrderSaleOrderDTO();
            updateExtOrderIdDo.setOrderId(reqBo.getOrderId());
            updateExtOrderIdDo.setSaleOrderId(reqBo.getSaleOrderId());
            updateExtOrderIdDo.setCreatedResult(reqBo.getCreatedResult());
            updateExtOrderIdDo.setSaleOrderState("XS_XD_SB");
            updateExtOrderIdDo.setCancelReason(reqBo.getCancelReason());
            updateExtOrderIdDo.setOrderStage(DycProOrderRepositoryConstant.ORDER_STAPE.TRADE_CLOSE);
            this.saleOrderRepository.updateSaleOrderByCondition(updateExtOrderIdDo, true);
            DycProOrderSaleOrderDTO querySaleOrderDTO = new DycProOrderSaleOrderDTO();
            querySaleOrderDTO.setSaleOrderId(reqBo.getSaleOrderId());
            DycProOrderSaleOrderDTO saleOrderDTO = this.saleOrderRepository.querySaleOrderOneByCondition(querySaleOrderDTO);
            if (null != saleOrderDTO.getBudgetId()) {
                this.deductBudget(saleOrderDTO);
            }
            if (DycProOrderApiServiceConstant.OrderType.MALL_PUR_APPLY.equals(saleOrderDTO.getOrderType())) {
                this.returnPurApply(saleOrderDTO);
            }
        } else {
            DycProOrderSaleOrderDTO saleOrderDTO = this.assembleUpdateDo(reqBo);
            this.saleOrderRepository.updateSaleItemBatch(saleOrderDTO);
            DycProOrderOrderQueryIndexDTO index = new DycProOrderOrderQueryIndexDTO();
            index.setId(Long.valueOf(Sequence.getInstance().nextId()));
            index.setOrderId(reqBo.getOrderId());
            index.setObjType(DycProOrderApiServiceConstant.OBJ_TYPE.SALE);
            index.setObjId(reqBo.getSaleOrderId());
            index.setOutObjId(reqBo.getOutOrderId());
            this.saleOrderRepository.addOrderQueryIndex(index);
            DycProOrderSaleOrderDTO updateExtOrderIdDo = new DycProOrderSaleOrderDTO();
            updateExtOrderIdDo.setOrderId(reqBo.getOrderId());
            updateExtOrderIdDo.setSaleOrderId(reqBo.getSaleOrderId());
            updateExtOrderIdDo.setSaleOrderNoExt(reqBo.getOutOrderId());
            updateExtOrderIdDo.setCreatedResult(reqBo.getCreatedResult());
            this.saleOrderRepository.updateSaleOrderByCondition(updateExtOrderIdDo, true);
            this.pushApprovalOrder(reqBo);
        }
        rspBo.setOrderId(reqBo.getOrderId());
        rspBo.setSaleOrderId(reqBo.getSaleOrderId());
        rspBo.setOutOrderId(reqBo.getOutOrderId());
        return rspBo;
    }

    private void pushApprovalOrder(DycProOrderResoveEsPreOrderForLgServiceReqBO reqBO) {
        DycProOrderInterLogDTO dycProOrderInterLogDTO = new DycProOrderInterLogDTO();
        dycProOrderInterLogDTO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        dycProOrderInterLogDTO.setObjId(reqBO.getSaleOrderId());
        dycProOrderInterLogDTO.setObjType(DycProOrderRepositoryConstant.ObjType.SALE);
        dycProOrderInterLogDTO.setOrderId(reqBO.getOrderId());
        dycProOrderInterLogDTO.setInterSn(this.sendApprovalOrderUrlForLg);
        DycProBaseCallEsbUtilSendApprovalOrderForLgReqBO dycProBaseCallEsbUtilSendApprovalOrderForLgReqBO = new DycProBaseCallEsbUtilSendApprovalOrderForLgReqBO();
        dycProBaseCallEsbUtilSendApprovalOrderForLgReqBO.setUrl(this.sendApprovalOrderUrlForLg);
        dycProBaseCallEsbUtilSendApprovalOrderForLgReqBO.setOrderNo(reqBO.getSaleOrderNo());
        dycProOrderInterLogDTO.setInContent(JSON.toJSONString((Object)dycProBaseCallEsbUtilSendApprovalOrderForLgReqBO));
        try {
            DycProBaseCallEsbUtilSendApprovalOrderForLgRspBO dycProBaseCallEsbUtilSendApprovalOrderForLgRspBO = DycProBaseCallEsbUtil.sendApprovalOrder((DycProBaseCallEsbUtilSendApprovalOrderForLgReqBO)dycProBaseCallEsbUtilSendApprovalOrderForLgReqBO);
            dycProOrderInterLogDTO.setOutContent(JSON.toJSONString((Object)dycProBaseCallEsbUtilSendApprovalOrderForLgRspBO));
            if (dycProBaseCallEsbUtilSendApprovalOrderForLgRspBO.getSuccess() == null || !dycProBaseCallEsbUtilSendApprovalOrderForLgRspBO.getSuccess().booleanValue() || !"0000".equals(dycProBaseCallEsbUtilSendApprovalOrderForLgRspBO.getResultCode())) {
                log.info("\u63a8\u9001\u7cae\u8c37\u5e26\u5ba1\u6279\u8ba2\u5355\u5f02\u5e38\uff1a{}", (Object)dycProBaseCallEsbUtilSendApprovalOrderForLgRspBO.getResultMessage());
                dycProOrderInterLogDTO.setErrDetail(dycProBaseCallEsbUtilSendApprovalOrderForLgRspBO.getResultMessage());
                throw new ZTBusinessException("\u63a8\u9001\u7cae\u8c37\u5e26\u5ba1\u6279\u8ba2\u5355\u5f02\u5e38\uff1a{" + dycProBaseCallEsbUtilSendApprovalOrderForLgRspBO.getResultMessage() + "}");
            }
        }
        catch (Exception e) {
            log.info("\u63a8\u9001\u7cae\u8c37\u5e26\u5ba1\u6279\u8ba2\u5355\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            dycProOrderInterLogDTO.setErrDetail(e.getMessage());
        }
        this.saleOrderRepository.saveOutSysCallLog(dycProOrderInterLogDTO);
    }

    private DycProOrderSaleOrderDTO assembleUpdateDo(DycProOrderResoveEsPreOrderForLgServiceReqBO reqBo) {
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8ba2\u5355id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleOrderId())) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u9500\u552e\u5355id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DycProOrderSaleOrderDTO saleOrderDTO = new DycProOrderSaleOrderDTO();
        saleOrderDTO.setOrderId(reqBo.getOrderId());
        saleOrderDTO.setSaleOrderId(reqBo.getSaleOrderId());
        List sku = reqBo.getSku();
        ArrayList<DycProOrderSaleOrderItemDTO> saleItemList = new ArrayList<DycProOrderSaleOrderItemDTO>();
        saleOrderDTO.setSaleItemList(saleItemList);
        for (DycProOrderResoveEsPreOrderServiceReqSkuBO skuBo : sku) {
            if (ObjectUtil.isEmpty((Object)skuBo.getSkuId())) {
                throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[SkuExtSkuId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)skuBo.getNakedPrice())) {
                throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[NakedPrice]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)skuBo.getTax())) {
                throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[Tax]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)skuBo.getTaxPrice())) {
                throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[TaxPrice]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            DycProOrderSaleOrderItemDTO item = new DycProOrderSaleOrderItemDTO();
            item.setSkuExtSkuId(skuBo.getSkuId());
            item.setOrderId(reqBo.getOrderId());
            item.setSaleOrderId(reqBo.getSaleOrderId());
            item.setTax(new BigDecimal(skuBo.getTax()));
            item.setTaxPrice(skuBo.getTaxPrice());
            item.setNakedPrice(skuBo.getNakedPrice());
            saleItemList.add(item);
        }
        return saleOrderDTO;
    }

    private void deductBudget(DycProOrderSaleOrderDTO saleOrderDTO) {
        DycProOrderBudgetUsedRecordDTO dycProOrderBudgetUsedRecordDTO = new DycProOrderBudgetUsedRecordDTO();
        dycProOrderBudgetUsedRecordDTO.setBudgetId(saleOrderDTO.getBudgetId());
        dycProOrderBudgetUsedRecordDTO.setOccupyAmount(saleOrderDTO.getTotalSaleFee().negate());
        dycProOrderBudgetUsedRecordDTO.setObjId(saleOrderDTO.getSaleOrderId());
        dycProOrderBudgetUsedRecordDTO.setObjNo(saleOrderDTO.getSaleOrderNo());
        dycProOrderBudgetUsedRecordDTO.setOccupyType(Integer.valueOf(6));
        this.dycProOrderBudgetRepository.deductBudget(dycProOrderBudgetUsedRecordDTO);
    }

    private void returnPurApply(DycProOrderSaleOrderDTO saleOrderDTO) {
        DycProOrderSaleOrderItemQryDTO querySaleOrderItemDTO = new DycProOrderSaleOrderItemQryDTO();
        querySaleOrderItemDTO.setSaleOrderId(saleOrderDTO.getSaleOrderId());
        List saleOrderItemDTOList = this.saleOrderRepository.querySaleOrderItemListByCondition(querySaleOrderItemDTO);
        for (DycProOrderSaleOrderItemDTO saleOrderItemDTO : saleOrderItemDTOList) {
            DycProOrderAdjustPurApplyItemCountDTO adjustPurApplyItemCountDTO = new DycProOrderAdjustPurApplyItemCountDTO();
            adjustPurApplyItemCountDTO.setPurApplyItemId(saleOrderItemDTO.getPurApplyItemId());
            adjustPurApplyItemCountDTO.setOccupyNum(saleOrderItemDTO.getPurchaseCount().negate());
            adjustPurApplyItemCountDTO.setOccupyType(Integer.valueOf(4));
            this.saleOrderRepository.adjustPurchaseApplyItemCounts(adjustPurApplyItemCountDTO);
        }
    }
}

