/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.purchaseapply.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.egc.repository.purchaseapply.api.DycProOrderPurchaseApplyRepository;
import com.tydic.dyc.pro.egc.repository.purchaseapply.dto.DycProOrderExtPurchaseSyncLogsDTO;
import com.tydic.dyc.pro.egc.repository.purchaseapply.dto.DycProOrderExtPurchaseSyncTempDTO;
import com.tydic.dyc.pro.egc.service.purchaseapply.api.DycProOrderExtPurchaseApplyTempService;
import com.tydic.dyc.pro.egc.service.purchaseapply.bo.DycProOrderExtPurchaseApplyMigrateReqBO;
import com.tydic.dyc.pro.egc.service.purchaseapply.bo.DycProOrderExtPurchaseApplyTempReqBO;
import com.tydic.dyc.pro.egc.service.purchaseapply.bo.DycProOrderExtPurchaseApplyTempRspBO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.purchaseapply.api.DycProOrderExtPurchaseApplyTempService"})
public class DycProOrderExtPurchaseApplyTempServiceImpl
implements DycProOrderExtPurchaseApplyTempService {
    private static final Logger log = LoggerFactory.getLogger(DycProOrderExtPurchaseApplyTempServiceImpl.class);
    @Autowired
    private DycProOrderPurchaseApplyRepository dycProOrderPurchaseApplyRepository;

    @PostMapping(value={"insertExtPurchaseApplyTemp"})
    public DycProOrderExtPurchaseApplyTempRspBO insertExtPurchaseApplyTemp(@RequestBody DycProOrderExtPurchaseApplyTempReqBO reqBO) {
        Long id = Sequence.getInstance().nextId();
        DycProOrderExtPurchaseSyncTempDTO extPurchaseSyncTempDTO = new DycProOrderExtPurchaseSyncTempDTO();
        extPurchaseSyncTempDTO.setExtOriginalData(reqBO.getExtOriginalData());
        extPurchaseSyncTempDTO.setExtObjId(reqBO.getExtObjId());
        extPurchaseSyncTempDTO.setBatchId(String.valueOf(id));
        extPurchaseSyncTempDTO.setId(id);
        extPurchaseSyncTempDTO.setDealResult(Integer.valueOf(2));
        extPurchaseSyncTempDTO.setCurrentDealCount(Integer.valueOf(0));
        extPurchaseSyncTempDTO.setReceiveTime(new Date());
        this.dycProOrderPurchaseApplyRepository.createExtPurchaseTempData(extPurchaseSyncTempDTO);
        DycProOrderExtPurchaseApplyTempRspBO rspBO = new DycProOrderExtPurchaseApplyTempRspBO();
        rspBO.setTempId(id);
        rspBO.setExtObjId(reqBO.getExtObjId());
        rspBO.setExtOriginalData(reqBO.getExtOriginalData());
        return rspBO;
    }

    @PostMapping(value={"migrateTempToLogsAndDelete"})
    public void migrateTempToLogsAndDelete(@RequestBody DycProOrderExtPurchaseApplyMigrateReqBO reqBO) {
        DycProOrderExtPurchaseSyncTempDTO tempDTO = this.dycProOrderPurchaseApplyRepository.getExtPurchaseTempById(reqBO.getTempId());
        if (tempDTO == null) {
            log.warn("\u4e34\u65f6\u8868\u6570\u636e\u4e0d\u5b58\u5728\uff0ctempId={}", (Object)reqBO.getTempId());
            return;
        }
        DycProOrderExtPurchaseSyncLogsDTO extPurchaseSyncLogsDTO = new DycProOrderExtPurchaseSyncLogsDTO();
        extPurchaseSyncLogsDTO.setLogId(Long.valueOf(Sequence.getInstance().nextId()));
        extPurchaseSyncLogsDTO.setId(tempDTO.getId());
        extPurchaseSyncLogsDTO.setBatchId(tempDTO.getBatchId());
        extPurchaseSyncLogsDTO.setExtObjId(tempDTO.getExtObjId());
        extPurchaseSyncLogsDTO.setExtOriginalData(tempDTO.getExtOriginalData());
        extPurchaseSyncLogsDTO.setReceiveTime(tempDTO.getReceiveTime());
        extPurchaseSyncLogsDTO.setDealTime(new Date());
        extPurchaseSyncLogsDTO.setDealResult(reqBO.getDealResult());
        extPurchaseSyncLogsDTO.setCurrentDealCount(Integer.valueOf(tempDTO.getCurrentDealCount() + 1));
        extPurchaseSyncLogsDTO.setDealResultDesc(reqBO.getDealResultDesc());
        this.dycProOrderPurchaseApplyRepository.createExtPurchaseLogsData(extPurchaseSyncLogsDTO);
        DycProOrderExtPurchaseSyncTempDTO deleteTempDTO = new DycProOrderExtPurchaseSyncTempDTO();
        deleteTempDTO.setId(reqBO.getTempId());
        this.dycProOrderPurchaseApplyRepository.deleteExtPurchaseTempData(deleteTempDTO);
    }
}

