/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.purchaseapply.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.egc.repository.purchaseapply.api.DycProOrderPurchaseApplyRepository;
import com.tydic.dyc.pro.egc.repository.purchaseapply.dto.DycProOrderPurchaseOrderDTO;
import com.tydic.dyc.pro.egc.service.purchaseapply.api.DycProOrderDeleteOrderService;
import com.tydic.dyc.pro.egc.service.purchaseapply.bo.DycProOrderDeleteOrderReqBO;
import com.tydic.dyc.pro.egc.service.purchaseapply.bo.DycProOrderDeletePurchaseOrderRspBO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.purchaseapply.api.DycProOrderDeleteOrderService"})
public class DycProOrderDeleteOrderServiceImpl
implements DycProOrderDeleteOrderService {
    @Autowired
    private DycProOrderPurchaseApplyRepository purchaseApplyRepository;

    @Override
    @PostMapping(value={"deletePurchaseOrder"})
    public DycProOrderDeletePurchaseOrderRspBO deletePurchaseOrder(@RequestBody DycProOrderDeleteOrderReqBO reqBO) {
        this.checkParam(reqBO);
        try {
            DycProOrderPurchaseOrderDTO dto = new DycProOrderPurchaseOrderDTO();
            dto.setOrderId(reqBO.getOrderId());
            boolean result = this.purchaseApplyRepository.logicalDeleteOrderAndItems(dto);
            DycProOrderDeletePurchaseOrderRspBO rspBO = new DycProOrderDeletePurchaseOrderRspBO();
            rspBO.setBusiCode(result ? "0" : "1");
            rspBO.setBusiMsg(result ? "\u5220\u9664\u6210\u529f" : "\u5220\u9664\u5931\u8d25");
            return rspBO;
        }
        catch (Exception e) {
            DycProOrderDeletePurchaseOrderRspBO rspBO = new DycProOrderDeletePurchaseOrderRspBO();
            rspBO.setBusiCode("1");
            rspBO.setBusiMsg("\u5220\u9664\u5931\u8d25\uff1a" + e.getMessage());
            return rspBO;
        }
    }

    private void checkParam(DycProOrderDeleteOrderReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5220\u9664\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrderId() == null) {
            throw new ZTBusinessException("\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

