/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.saleorder.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.dictionary.utils.DictionaryFrameworkUtils;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderQuerySaleOrderDetailForProfessionalCompanyService;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderQuerySaleOrderDetailForProfessionalCompanyReqBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderQuerySaleOrderDetailForProfessionalCompanyRspBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderSaleOrderItemBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderShipOrderBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderShipOrderItemBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.ZlUocOutApprovalRecordBO;
import java.math.RoundingMode;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderQuerySaleOrderDetailForProfessionalCompanyService"})
public class DycProOrderQuerySaleOrderDetailForProfessionalCompanyServiceImpl
implements DycProOrderQuerySaleOrderDetailForProfessionalCompanyService {
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;

    @Override
    @PostMapping(value={"querySaleOrderDetailForProfessionalCompany"})
    public DycProOrderQuerySaleOrderDetailForProfessionalCompanyRspBO querySaleOrderDetailForProfessionalCompany(@RequestBody DycProOrderQuerySaleOrderDetailForProfessionalCompanyReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getSaleOrderNo())) {
            throw new ZTBusinessException("\u9500\u552e\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getProfessionalCompanyType())) {
            throw new ZTBusinessException("\u4e13\u4e1a\u516c\u53f8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DycProOrderQuerySaleOrderDetailForProfessionalCompanyRspBO rspBO = new DycProOrderQuerySaleOrderDetailForProfessionalCompanyRspBO();
        DycProOrderSaleOrderDTO reqDto = new DycProOrderSaleOrderDTO();
        reqDto.setSaleOrderNo(reqBO.getSaleOrderNo());
        reqDto.setProfessionalCompanyType(reqBO.getProfessionalCompanyType());
        DycProOrderSaleOrderDTO saleOrderDto = this.dycProOrderSaleOrderRepository.querySaleOrderAllInfoByCondition(reqDto);
        if (null != saleOrderDto) {
            rspBO = (DycProOrderQuerySaleOrderDetailForProfessionalCompanyRspBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)saleOrderDto), DycProOrderQuerySaleOrderDetailForProfessionalCompanyRspBO.class));
            if (!CollectionUtils.isEmpty(rspBO.getShiporderList())) {
                this.initShipInfo(rspBO);
            }
            rspBO.setSaleOrderStateStr(DictionaryFrameworkUtils.getDicDataByCode((String)"EgcSaleOrderSaleOrderState", (String)rspBO.getSaleOrderState()));
            if (null != rspBO.getPurchaseType()) {
                rspBO.setPurchaseTypeStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcCommManageCatalogInfoPurchaseType", (String)rspBO.getPurchaseType().toString()));
            }
            if (null != rspBO.getMaterialType()) {
                rspBO.setMaterialTypeStr(DictionaryFrameworkUtils.getDicDataByCode((String)"DmcCommManageCatalogInfoMaterialType", (String)rspBO.getMaterialType().toString()));
            }
            if (!CollectionUtils.isEmpty(rspBO.getOutApprovalRecordList())) {
                for (ZlUocOutApprovalRecordBO approvalReecordBO : rspBO.getOutApprovalRecordList()) {
                    if (1 == approvalReecordBO.getApproverResult()) {
                        approvalReecordBO.setApproverResultStr("\u5ba1\u6279\u901a\u8fc7");
                        continue;
                    }
                    approvalReecordBO.setApproverResultStr("\u5ba1\u6279\u9a73\u56de");
                }
            }
        }
        return rspBO;
    }

    private void initShipInfo(DycProOrderQuerySaleOrderDetailForProfessionalCompanyRspBO rspBO) {
        Map saleOrderItemBOMap = rspBO.getSaleItemList().stream().collect(Collectors.toMap(DycProOrderSaleOrderItemBO::getSaleOrderItemId, Function.identity()));
        for (DycProOrderShipOrderBO shipOrderBO : rspBO.getShiporderList()) {
            shipOrderBO.setShipOrderStateStr(DictionaryFrameworkUtils.getDicDataByCode((String)"EgcShipOrderShipOrderState", (String)shipOrderBO.getShipOrderState()));
            for (DycProOrderShipOrderItemBO shipOrderItemBO : shipOrderBO.getShipItemList()) {
                DycProOrderSaleOrderItemBO saleOrderItemBO = (DycProOrderSaleOrderItemBO)saleOrderItemBOMap.get(shipOrderItemBO.getSaleOrderItemId());
                shipOrderItemBO.setSkuId(saleOrderItemBO.getSkuId());
                shipOrderItemBO.setSkuCode(saleOrderItemBO.getSkuCode());
                shipOrderItemBO.setSkuName(saleOrderItemBO.getSkuName());
                shipOrderItemBO.setPurchaseCount(saleOrderItemBO.getPurchaseCount());
                shipOrderItemBO.setSkuMaterialCode(saleOrderItemBO.getSkuMaterialCode());
                shipOrderItemBO.setSkuExtSkuId(saleOrderItemBO.getSkuExtSkuId());
                shipOrderItemBO.setSkuMaterialName(saleOrderItemBO.getSkuMaterialName());
                shipOrderItemBO.setSkuMaterialTypeName(saleOrderItemBO.getSkuMaterialTypeName());
                shipOrderItemBO.setSpec(saleOrderItemBO.getSpec());
                shipOrderItemBO.setModel(saleOrderItemBO.getModel());
                shipOrderItemBO.setSkuMainPicUrl(saleOrderItemBO.getSkuMainPicUrl());
                shipOrderItemBO.setTax(saleOrderItemBO.getTax());
                shipOrderItemBO.setPurchasePrice(saleOrderItemBO.getPurchasePrice());
                shipOrderItemBO.setSalePrice(saleOrderItemBO.getSalePrice());
                shipOrderItemBO.setSaleFee(saleOrderItemBO.getSaleFee());
                shipOrderItemBO.setPurchaseFee(saleOrderItemBO.getPurchaseFee());
                shipOrderItemBO.setUnitDigit(saleOrderItemBO.getUnitDigit());
                shipOrderItemBO.setReferencePrice(saleOrderItemBO.getReferencePrice());
                shipOrderItemBO.setReferencePriceRate(saleOrderItemBO.getReferencePriceRate());
                shipOrderItemBO.setMCode(saleOrderItemBO.getMCode());
                shipOrderItemBO.setMName(saleOrderItemBO.getMName());
                shipOrderItemBO.setMajorCompanyCatalogCode(saleOrderItemBO.getMajorCompanyCatalogCode());
                shipOrderItemBO.setUpcCode(saleOrderItemBO.getUpcCode());
                shipOrderItemBO.setAgreementName(saleOrderItemBO.getAgreementName());
                if (!StringUtils.isNotBlank((CharSequence)shipOrderItemBO.getUnitDigit())) continue;
                if (null != shipOrderItemBO.getPurchaseCount()) {
                    shipOrderItemBO.setPurchaseCount(shipOrderItemBO.getPurchaseCount().setScale(Integer.parseInt(shipOrderItemBO.getUnitDigit()), RoundingMode.DOWN));
                }
                if (null != shipOrderItemBO.getSendCount()) {
                    shipOrderItemBO.setSendCount(shipOrderItemBO.getSendCount().setScale(Integer.parseInt(shipOrderItemBO.getUnitDigit()), RoundingMode.DOWN));
                }
                if (null != shipOrderItemBO.getArriveCount()) {
                    shipOrderItemBO.setArriveCount(shipOrderItemBO.getArriveCount().setScale(Integer.parseInt(shipOrderItemBO.getUnitDigit()), RoundingMode.DOWN));
                }
                if (null != shipOrderItemBO.getRefuseCount()) {
                    shipOrderItemBO.setRefuseCount(shipOrderItemBO.getRefuseCount().setScale(Integer.parseInt(shipOrderItemBO.getUnitDigit()), RoundingMode.DOWN));
                }
                if (null != shipOrderItemBO.getInspCount()) {
                    shipOrderItemBO.setInspCount(shipOrderItemBO.getInspCount().setScale(Integer.parseInt(shipOrderItemBO.getUnitDigit()), RoundingMode.DOWN));
                }
                if (null != shipOrderItemBO.getReturnCount()) {
                    shipOrderItemBO.setReturnCount(shipOrderItemBO.getReturnCount().setScale(Integer.parseInt(shipOrderItemBO.getUnitDigit()), RoundingMode.DOWN));
                }
                if (null == shipOrderItemBO.getAfterServingCount()) continue;
                shipOrderItemBO.setAfterServingCount(shipOrderItemBO.getAfterServingCount().setScale(Integer.parseInt(shipOrderItemBO.getUnitDigit()), RoundingMode.DOWN));
            }
        }
    }
}

