/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.shiporder.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.pro.egc.repository.shiporder.api.DycProOrderShipOrderRepository;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderQryDTO;
import com.tydic.dyc.pro.egc.service.shiporder.api.DycProOrderQueryShipOrderDetailService;
import com.tydic.dyc.pro.egc.service.shiporder.bo.DycProOrderQueryShipOrderDetailRspBO;
import com.tydic.dyc.pro.egc.service.shiporder.bo.DycProOrderQueryShipOrderDetailsReqBO;
import com.tydic.dyc.pro.egc.service.shiporder.bo.DycProOrderShipOrderItemBO;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.shiporder.api.DycProOrderQueryShipOrderDetailService"})
public class DycProOrderQueryShipOrderDetailServiceImpl
implements DycProOrderQueryShipOrderDetailService {
    @Autowired
    private DycProOrderShipOrderRepository dycProOrderShipOrderRepository;

    @Override
    @PostMapping(value={"queryShipOrderDetail"})
    public DycProOrderQueryShipOrderDetailRspBO queryShipOrderDetail(@RequestBody DycProOrderQueryShipOrderDetailsReqBO reqBO) {
        this.paramVerify(reqBO);
        DycProOrderShipOrderQryDTO reqDTO = new DycProOrderShipOrderQryDTO();
        reqDTO.setShipOrderId(reqBO.getShipOrderId());
        reqDTO.setShipOrderItemIdList(reqBO.getShipOrderItemIdList());
        DycProOrderShipOrderDTO dycProOrderShipOrderDTO = this.dycProOrderShipOrderRepository.queryShipOrderAllInfoById(reqDTO);
        DycProOrderQueryShipOrderDetailRspBO rspBO = (DycProOrderQueryShipOrderDetailRspBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)dycProOrderShipOrderDTO), DycProOrderQueryShipOrderDetailRspBO.class));
        this.buildShipOrderDetailData(rspBO);
        return rspBO;
    }

    private void buildShipOrderDetailData(DycProOrderQueryShipOrderDetailRspBO rspBO) {
        if (null == rspBO) {
            return;
        }
        if (!CollectionUtils.isEmpty(rspBO.getShipItemList())) {
            for (DycProOrderShipOrderItemBO shipOrderItemBO : rspBO.getShipItemList()) {
                if (null != shipOrderItemBO.getAfterServingCount()) continue;
                shipOrderItemBO.setAfterServingCount(BigDecimal.ZERO);
            }
        }
    }

    private void paramVerify(DycProOrderQueryShipOrderDetailsReqBO reqBO) {
        if (null == reqBO) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getShipOrderId()) {
            throw new IllegalArgumentException("\u53d1\u8d27\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

