/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.common.sub.UmcAccessory;
import com.tydic.dyc.umc.model.common.sub.UmcOrderProcInst;
import com.tydic.dyc.umc.model.common.sub.UmcOrderProcInstRspBo;
import com.tydic.dyc.umc.model.common.sub.UmcOrderTaskDeal;
import com.tydic.dyc.umc.model.common.sub.UmcOrderTaskDealList;
import com.tydic.dyc.umc.model.common.sub.UmcOrderTaskInst;
import com.tydic.dyc.umc.model.common.sub.UmcOrderTaskInstList;
import com.tydic.dyc.umc.model.common.sub.UmcOrderTaskInstRspBo;
import com.tydic.dyc.umc.model.common.sub.UserDownloadRecord;
import com.tydic.dyc.umc.repository.UmcCommonRepository;
import com.tydic.dyc.umc.repository.dao.UmcAccessoryMapper;
import com.tydic.dyc.umc.repository.dao.UocApprovalObjMapper;
import com.tydic.dyc.umc.repository.dao.UocOrderProcInstMapper;
import com.tydic.dyc.umc.repository.dao.UocOrderTaskDealMapper;
import com.tydic.dyc.umc.repository.dao.UocOrderTaskInstLogMapper;
import com.tydic.dyc.umc.repository.dao.UocOrderTaskInstMapper;
import com.tydic.dyc.umc.repository.dao.UserDownloadRecordMapper;
import com.tydic.dyc.umc.repository.po.UmcAccessoryPO;
import com.tydic.dyc.umc.repository.po.UocOrderProcInstPo;
import com.tydic.dyc.umc.repository.po.UocOrderTaskDealPo;
import com.tydic.dyc.umc.repository.po.UocOrderTaskInstLogPo;
import com.tydic.dyc.umc.repository.po.UocOrderTaskInstPo;
import com.tydic.dyc.umc.repository.po.UserDownloadRecordPo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UmcCommonRepositoryImpl
implements UmcCommonRepository {
    @Autowired
    private UserDownloadRecordMapper userDownloadRecordMapper;
    @Autowired
    private UocOrderTaskInstMapper uocOrderTaskInstMapper;
    @Autowired
    private UocOrderTaskInstLogMapper uocOrderTaskInstLogMapper;
    @Autowired
    private UocOrderProcInstMapper uocOrderProcInstMapper;
    @Autowired
    private UocOrderTaskDealMapper uocOrderTaskDealMapper;
    @Autowired
    private UocApprovalObjMapper uocApprovalObjMapper;
    @Autowired
    private UmcAccessoryMapper umcAccessoryMapper;

    public void updateFileNameByTaskId(UserDownloadRecord userDownloadRecord) {
        UserDownloadRecordPo set = new UserDownloadRecordPo();
        set.setFileName(userDownloadRecord.getFileName());
        set.setDownloadTaskId(userDownloadRecord.getNewTaskId());
        if (!StringUtils.isEmpty((Object)userDownloadRecord.getTaskStatus())) {
            set.setTaskStatus(Integer.parseInt(userDownloadRecord.getTaskStatus()));
        }
        UserDownloadRecordPo where = new UserDownloadRecordPo();
        where.setDownloadTaskId(userDownloadRecord.getTaskId());
        this.userDownloadRecordMapper.updateBy(set, where);
    }

    public void updateToFinished(UmcOrderTaskInstList uocOrderTaskInstList) {
        for (UmcOrderTaskInst uocOrderTaskInst : uocOrderTaskInstList.getUocOrderTaskInstList()) {
            UocOrderTaskInstPo updateSetPo = new UocOrderTaskInstPo();
            updateSetPo.setFinishTag(UmcCommConstant.PROC_TASK_FINISHED.FINISHED);
            updateSetPo.setFinishTime(new Date());
            updateSetPo.setDealOperId(uocOrderTaskInst.getDealOperId());
            updateSetPo.setDealOperName(uocOrderTaskInst.getDealOperName());
            updateSetPo.setDealResult(uocOrderTaskInst.getDealResult());
            updateSetPo.setDealRemark(uocOrderTaskInst.getDealRemark());
            UocOrderTaskInstPo updateWherePo = new UocOrderTaskInstPo();
            updateWherePo.setOrderId(uocOrderTaskInst.getOrderId());
            updateWherePo.setTaskInstId(uocOrderTaskInst.getTaskInstId());
            this.uocOrderTaskInstMapper.updateBy(updateSetPo, updateWherePo);
        }
    }

    public void saveProcTaskInst(UmcOrderTaskInstList saveTaskList) {
        if (ObjectUtil.isNotEmpty((Object)saveTaskList.getUocOrderTaskInstList())) {
            this.uocOrderTaskInstMapper.insertBatch(UmcRu.jsl((List)saveTaskList.getUocOrderTaskInstList(), UocOrderTaskInstPo.class));
        }
    }

    public UmcOrderProcInst createProInst(UmcOrderProcInst inst) {
        this.uocOrderProcInstMapper.insert((UocOrderProcInstPo)UmcRu.js((Object)inst, UocOrderProcInstPo.class));
        return inst;
    }

    public UmcOrderProcInstRspBo qryProcInsList(UmcOrderProcInst inst) {
        List uocOrderProcInsts = UmcRu.jsl(this.uocOrderProcInstMapper.getList((UocOrderProcInstPo)UmcRu.js((Object)inst, UocOrderProcInstPo.class)), UmcOrderProcInst.class);
        UmcOrderProcInstRspBo uocOrderProcInstRspBo = new UmcOrderProcInstRspBo();
        uocOrderProcInstRspBo.setUocOrderProcInstList(uocOrderProcInsts);
        return uocOrderProcInstRspBo;
    }

    public void saveOrderTaskDealList(UmcOrderTaskDealList dealList) {
        if (null != dealList && ObjectUtil.isNotEmpty((Object)dealList.getDealList())) {
            this.uocOrderTaskDealMapper.insertBatch(UmcRu.jsl((List)dealList.getDealList(), UocOrderTaskDealPo.class));
        }
    }

    public UmcOrderTaskInstRspBo qryTaskInstList(UmcOrderTaskInst taskInst) {
        UmcOrderTaskInstRspBo rspBo = new UmcOrderTaskInstRspBo();
        if (ObjectUtil.isNotEmpty((Object)taskInst)) {
            List instList = UmcRu.jsl(this.uocOrderTaskInstMapper.getList((UocOrderTaskInstPo)UmcRu.js((Object)taskInst, UocOrderTaskInstPo.class)), UmcOrderTaskInst.class);
            rspBo.setRows(instList);
            return rspBo;
        }
        return rspBo;
    }

    public UmcOrderProcInst updateProInst(UmcOrderProcInst inst) {
        UocOrderProcInstPo set = (UocOrderProcInstPo)UmcRu.js((Object)inst, UocOrderProcInstPo.class);
        UocOrderProcInstPo where = new UocOrderProcInstPo();
        where.setOrderId(inst.getOrderId());
        where.setObjId(inst.getObjId());
        where.setObjType(inst.getObjType());
        where.setProcInstId(inst.getProcInstId());
        this.uocOrderProcInstMapper.updateBy(set, where);
        return inst;
    }

    public void updateTaskInst(UmcOrderTaskInst inst) {
        UocOrderTaskInstPo set = (UocOrderTaskInstPo)UmcRu.js((Object)inst, UocOrderTaskInstPo.class);
        UocOrderTaskInstPo where = new UocOrderTaskInstPo();
        where.setTaskInstId(inst.getTaskInstId());
        where.setOrderId(inst.getOrderId());
        where.setObjId(inst.getObjId());
        where.setObjType(inst.getObjType());
        where.setId(inst.getId());
        where.setProcState(inst.getProcState());
        this.uocOrderTaskInstMapper.updateBy(set, where);
    }

    public void deleteTaskInstByStepIdAndFinshTag(UmcOrderTaskInst taskInst) {
        UocOrderTaskInstPo where = new UocOrderTaskInstPo();
        where.setOrderId(taskInst.getOrderId());
        where.setProcState(taskInst.getProcState());
        this.uocOrderTaskInstMapper.deleteTaskInstByStepIdAndFinshTag(where);
    }

    public void saveProcTaskInstLog(UmcOrderTaskInstList saveTaskList) {
        List uocOrderTaskInstLogPos = UmcRu.jsl((List)saveTaskList.getUocOrderTaskInstList(), UocOrderTaskInstLogPo.class);
        if (!CollectionUtils.isEmpty((Collection)uocOrderTaskInstLogPos)) {
            this.uocOrderTaskInstLogMapper.insertBatch(uocOrderTaskInstLogPos);
        }
    }

    public void deleteProcTaskInstByIds(UmcOrderTaskInst taskInst) {
        UocOrderTaskInstPo where = new UocOrderTaskInstPo();
        where.setOrderId(taskInst.getOrderId());
        where.setIds(taskInst.getIds());
        this.uocOrderTaskInstMapper.deleteProcTaskInstByIds(where);
    }

    public void updateTaskDeal(UmcOrderTaskDeal taskDeal) {
        UocOrderTaskDealPo set = new UocOrderTaskDealPo();
        set.setDealId(taskDeal.getDealId());
        set.setDealName(taskDeal.getDealName());
        set.setDelTag(taskDeal.getDelTag());
        UocOrderTaskDealPo where = new UocOrderTaskDealPo();
        where.setTaskInstId(taskDeal.getTaskInstId());
        this.uocOrderTaskDealMapper.updateBy(set, where);
    }

    public UmcOrderTaskInstRspBo qryTaskDel(UmcOrderTaskInst uocOrderTaskInst) {
        UocOrderTaskDealPo js = (UocOrderTaskDealPo)UmcRu.js((Object)uocOrderTaskInst, UocOrderTaskDealPo.class);
        List<UocOrderTaskDealPo> list = this.uocOrderTaskDealMapper.getList(js);
        UmcOrderTaskInstRspBo rspBo = new UmcOrderTaskInstRspBo();
        ArrayList<UmcOrderTaskInst> taskInsts = new ArrayList<UmcOrderTaskInst>();
        if (!CollectionUtils.isEmpty(list)) {
            for (UocOrderTaskDealPo po : list) {
                UmcOrderTaskInst taskInst = new UmcOrderTaskInst();
                taskInst.setTaskInstId(po.getTaskInstId());
                taskInst.setOrderId(po.getOrderId());
                taskInst.setDealOperId(po.getDealId());
                taskInst.setDealOperName(po.getDealName());
                taskInsts.add(taskInst);
            }
        }
        rspBo.setRows(taskInsts);
        return rspBo;
    }

    public void insertAccessory(List<UmcAccessory> accessoryList) {
        this.umcAccessoryMapper.insertBatch(UmcRu.jsl(accessoryList, UmcAccessoryPO.class));
    }

    public void deleteAccessory(UmcAccessory accessory) {
        this.umcAccessoryMapper.deleteBy((UmcAccessoryPO)UmcRu.js((Object)accessory, UmcAccessoryPO.class));
    }
}

