/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.alert.strategy;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.apache.shenyu.alert.DingTalkProp;
import org.apache.shenyu.alert.strategy.AlertStrategy;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.spi.Join;

@Join
public class DingTalkStrategy
implements AlertStrategy {
    private static final OkHttpClient OK_HTTP_CLIENT = new OkHttpClient().newBuilder().connectTimeout(50L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).build();

    @Override
    public void execute(String handle) throws Exception {
        DingTalkProp dingTalkProp = (DingTalkProp)GsonUtils.getInstance().fromJson(handle, DingTalkProp.class);
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)this.toJson(dingTalkProp));
        Request request = new Request.Builder().url(dingTalkProp.getUrl()).post(body).build();
        OK_HTTP_CLIENT.newCall(request).execute();
    }

    private String toJson(DingTalkProp prop) {
        HashMap<String, String> contentMap = new HashMap<String, String>(4);
        contentMap.put("content", prop.getContent());
        HashMap<String, Object> atMap = new HashMap<String, Object>(8);
        atMap.put("atMobiles", prop.getAtMobiles());
        atMap.put("atUserIds", prop.getAtUserIds());
        atMap.put("isAtAll", prop.getAtAll());
        HashMap<String, Object> body = new HashMap<String, Object>(8);
        body.put("at", atMap);
        body.put("msgtype", "text");
        body.put("text", contentMap);
        return GsonUtils.getInstance().toJson(body);
    }
}

