/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.alert.strategy;

import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.shenyu.alert.EmailProp;
import org.apache.shenyu.alert.strategy.AlertStrategy;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.spi.Join;

@Join
public class EmailStrategy
implements AlertStrategy {
    @Override
    public void execute(String handle) throws Exception {
        EmailProp email = (EmailProp)GsonUtils.getInstance().fromJson(handle, EmailProp.class);
        Properties props = this.props(email);
        Session session = this.session(email, props);
        MimeMessage message = this.message(email, session);
        Transport.send((Message)message);
    }

    private Properties props(EmailProp emailProp) {
        Properties props = new Properties();
        props.put("mail.smtp.host", emailProp.getHost());
        props.put("mail.smtp.port", emailProp.getPort());
        props.put("mail.smtp.auth", emailProp.getAuth());
        props.put("mail.smtp.starttls.enable", emailProp.getEnableTls());
        return props;
    }

    private Session session(final EmailProp emailProp, Properties props) {
        return Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(emailProp.getUserName(), emailProp.getPassword());
            }
        });
    }

    private MimeMessage message(EmailProp prop, Session session) throws MessagingException {
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(prop.getFrom()));
        message.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(prop.getTo()));
        message.setSubject(prop.getSubject(), "UTF-8");
        message.setText(prop.getText(), "UTF-8");
        return message;
    }
}

