/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.matedata.init;

import com.alibaba.fastjson.JSON;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.client.core.disruptor.ShenyuClientRegisterEventPublisher;
import org.apache.shenyu.client.core.exception.ShenyuClientIllegalArgumentException;
import org.apache.shenyu.client.matedata.model.MetadataHandlerParam;
import org.apache.shenyu.client.matedata.model.MetadataItem;
import org.apache.shenyu.client.matedata.model.MetadataRegisterInfo;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.UriUtils;
import org.apache.shenyu.register.client.api.ShenyuClientRegisterRepository;
import org.apache.shenyu.register.common.config.PropertiesConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.type.DataTypeParent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class MetadataClientRegister {
    private static final String PATH_SEPARATOR = "/";
    private static final Logger LOG = LoggerFactory.getLogger(MetadataClientRegister.class);
    private final ShenyuClientRegisterEventPublisher publisher = ShenyuClientRegisterEventPublisher.getInstance();
    private final String contextPath;
    private final String appName;

    public MetadataClientRegister(PropertiesConfig clientConfig, ShenyuClientRegisterRepository shenyuClientRegisterRepository) {
        Properties props = clientConfig.getProps();
        this.appName = props.getProperty("appName");
        this.contextPath = Optional.ofNullable(props.getProperty("contextPath")).map(UriUtils::repairData).orElse("");
        if (StringUtils.isBlank((CharSequence)this.appName) && StringUtils.isBlank((CharSequence)this.contextPath)) {
            String errorMsg = "http register param must config the appName or contextPath";
            LOG.error(errorMsg);
            throw new ShenyuClientIllegalArgumentException(errorMsg);
        }
        this.publisher.start(shenyuClientRegisterRepository);
    }

    public void doRegister(MetadataRegisterInfo metadataRegisterInfo) {
        if (ObjectUtils.isEmpty((Object)metadataRegisterInfo) || CollectionUtils.isEmpty(metadataRegisterInfo.getMetadataInfos())) {
            throw new NullPointerException("MetadataRegisterInfo can not be null");
        }
        for (MetadataItem item : metadataRegisterInfo.getMetadataInfos()) {
            this.handler(item);
        }
    }

    public void doRegister(MetadataItem metadata) {
        if (ObjectUtils.isEmpty((Object)metadata)) {
            return;
        }
        this.handler(metadata);
    }

    private void handler(MetadataItem metadata) {
        MetaDataRegisterDTO registerDTO = MetaDataRegisterDTO.builder().contextPath(this.contextPath).appName(this.appName).path(metadata.getRoute()).rpcType(RpcTypeEnum.HTTP.getName()).ruleName(metadata.getRoute()).handler(this.buildHandler(metadata)).enabled(true).registerMetaData(true).build();
        this.publisher.publishEvent((DataTypeParent)registerDTO);
    }

    private String buildHandler(MetadataItem metadata) {
        MetadataHandlerParam handlerParam = MetadataHandlerParam.builder().regex(metadata.getRoute()).replace(this.buildRealAddress(metadata)).extFields(metadata.getExtendField()).responseFields(metadata.getResponseParams()).build();
        return JSON.toJSONString((Object)handlerParam);
    }

    private String buildRealAddress(MetadataItem metadata) {
        StringBuilder result = new StringBuilder(PATH_SEPARATOR);
        result.append(metadata.getGroup()).append(PATH_SEPARATOR).append(metadata.getVersion()).append(PATH_SEPARATOR).append(metadata.getService()).append(PATH_SEPARATOR).append(metadata.getMethod());
        return result.toString();
    }

    public String getContextPath() {
        return StringUtils.isBlank((CharSequence)this.contextPath) ? this.appName : this.contextPath;
    }
}

