/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.sofa;

import com.alipay.sofa.runtime.service.component.Service;
import com.alipay.sofa.runtime.spring.factory.ServiceFactoryBean;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.client.core.disruptor.ShenyuClientRegisterEventPublisher;
import org.apache.shenyu.client.core.exception.ShenyuClientIllegalArgumentException;
import org.apache.shenyu.client.sofa.common.annotation.ShenyuSofaClient;
import org.apache.shenyu.client.sofa.common.dto.SofaRpcExt;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.IpUtils;
import org.apache.shenyu.register.client.api.ShenyuClientRegisterRepository;
import org.apache.shenyu.register.common.config.PropertiesConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.type.DataTypeParent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.NonNull;
import org.springframework.util.ReflectionUtils;

public class SofaServiceBeanPostProcessor
implements BeanPostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SofaServiceBeanPostProcessor.class);
    private static final String PATH_SEPARATOR = "/";
    private final ShenyuClientRegisterEventPublisher publisher = ShenyuClientRegisterEventPublisher.getInstance();
    private final ExecutorService executorService;
    private final String contextPath;
    private final String appName;
    private final String host;
    private final String port;

    public SofaServiceBeanPostProcessor(PropertiesConfig clientConfig, ShenyuClientRegisterRepository shenyuClientRegisterRepository) {
        Properties props = clientConfig.getProps();
        String contextPath = props.getProperty("contextPath");
        String appName = props.getProperty("appName");
        if (StringUtils.isEmpty((CharSequence)contextPath)) {
            throw new ShenyuClientIllegalArgumentException("sofa client must config the contextPath");
        }
        this.contextPath = contextPath;
        this.appName = appName;
        this.host = props.getProperty("host");
        this.port = props.getProperty("port");
        this.executorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("shenyu-sofa-client-thread-pool-%d").build());
        this.publisher.start(shenyuClientRegisterRepository);
    }

    public Object postProcessAfterInitialization(@NonNull Object bean, String beanName) throws BeansException {
        if (bean instanceof ServiceFactoryBean) {
            this.executorService.execute(() -> this.handler((ServiceFactoryBean)bean));
        }
        return bean;
    }

    private void handler(ServiceFactoryBean serviceBean) {
        Method[] methods;
        ShenyuSofaClient beanSofaClient;
        String superPath;
        Class clazz;
        Object targetProxy;
        try {
            targetProxy = ((Service)Objects.requireNonNull(serviceBean.getObject())).getTarget();
            clazz = targetProxy.getClass();
        }
        catch (Exception e) {
            LOG.error("failed to get sofa target class", (Throwable)e);
            return;
        }
        if (AopUtils.isAopProxy((Object)targetProxy)) {
            clazz = AopUtils.getTargetClass((Object)targetProxy);
        }
        if ((superPath = this.buildApiSuperPath(beanSofaClient = (ShenyuSofaClient)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)clazz, ShenyuSofaClient.class))).contains("*")) {
            Method[] declaredMethods;
            for (Method declaredMethod : declaredMethods = ReflectionUtils.getDeclaredMethods((Class)clazz)) {
                if (!Objects.nonNull(beanSofaClient)) continue;
                this.publisher.publishEvent((DataTypeParent)this.buildMetaDataDTO(serviceBean, beanSofaClient, declaredMethod, ""));
            }
            return;
        }
        for (Method method : methods = ReflectionUtils.getUniqueDeclaredMethods((Class)clazz)) {
            ShenyuSofaClient methodSofaClient = (ShenyuSofaClient)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ShenyuSofaClient.class);
            if (!Objects.nonNull(methodSofaClient)) continue;
            this.publisher.publishEvent((DataTypeParent)this.buildMetaDataDTO(serviceBean, methodSofaClient, method, superPath));
        }
    }

    private String buildApiSuperPath(ShenyuSofaClient shenyuSofaClient) {
        if (Objects.nonNull(shenyuSofaClient) && !StringUtils.isBlank((CharSequence)shenyuSofaClient.path())) {
            return shenyuSofaClient.path();
        }
        return "";
    }

    private MetaDataRegisterDTO buildMetaDataDTO(ServiceFactoryBean serviceBean, ShenyuSofaClient shenyuSofaClient, Method method, String superPath) {
        String appName = this.appName;
        String path = this.pathJoin(this.contextPath, superPath, shenyuSofaClient.path());
        String desc = shenyuSofaClient.desc();
        String serviceName = serviceBean.getInterfaceClass().getName();
        String host = IpUtils.isCompleteHost((String)this.host) ? this.host : IpUtils.getHost((String)this.host);
        int port = StringUtils.isBlank((CharSequence)this.port) ? -1 : Integer.parseInt(this.port);
        String configRuleName = shenyuSofaClient.ruleName();
        String ruleName = "".equals(configRuleName) ? path : configRuleName;
        String methodName = method.getName();
        String parameterTypes = Arrays.stream(method.getParameters()).map(parameter -> {
            StringBuilder result = new StringBuilder(parameter.getType().getName());
            Type type = parameter.getParameterizedType();
            if (type instanceof ParameterizedType) {
                Type[] actualTypeArguments;
                for (Type actualTypeArgument : actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments()) {
                    result.append("#").append(actualTypeArgument.getTypeName());
                }
            }
            return result.toString();
        }).collect(Collectors.joining(","));
        return MetaDataRegisterDTO.builder().appName(appName).serviceName(serviceName).methodName(methodName).contextPath(this.contextPath).host(host).port(Integer.valueOf(port)).path(path).ruleName(ruleName).pathDesc(desc).parameterTypes(parameterTypes).rpcType(RpcTypeEnum.SOFA.getName()).rpcExt(this.buildRpcExt(shenyuSofaClient)).enabled(shenyuSofaClient.enabled()).build();
    }

    private String buildRpcExt(ShenyuSofaClient shenyuSofaClient) {
        SofaRpcExt build = SofaRpcExt.builder().loadbalance(shenyuSofaClient.loadBalance()).retries(shenyuSofaClient.retries()).timeout(shenyuSofaClient.timeout()).build();
        return GsonUtils.getInstance().toJson((Object)build);
    }

    private String pathJoin(String ... path) {
        StringBuilder result = new StringBuilder(PATH_SEPARATOR);
        for (String p : path) {
            if (!result.toString().endsWith(PATH_SEPARATOR)) {
                result.append(PATH_SEPARATOR);
            }
            result.append(p.startsWith(PATH_SEPARATOR) ? p.replaceFirst(PATH_SEPARATOR, "") : p);
        }
        return result.toString();
    }
}

