/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.spring.websocket.init;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.client.core.disruptor.ShenyuClientRegisterEventPublisher;
import org.apache.shenyu.client.core.exception.ShenyuClientIllegalArgumentException;
import org.apache.shenyu.client.spring.websocket.annotation.ShenyuSpringWebSocketClient;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.register.client.api.ShenyuClientRegisterRepository;
import org.apache.shenyu.register.common.config.PropertiesConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.type.DataTypeParent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;

public class SpringWebSocketClientBeanPostProcessor
implements BeanPostProcessor {
    private static final String PATH_SEPARATOR = "/";
    private static final Logger LOG = LoggerFactory.getLogger(SpringWebSocketClientBeanPostProcessor.class);
    private final ShenyuClientRegisterEventPublisher publisher = ShenyuClientRegisterEventPublisher.getInstance();
    private final String contextPath;
    private final String appName;
    private final Boolean isFull;
    private final List<Class<? extends Annotation>> mappingAnnotation = new ArrayList<Class<? extends Annotation>>(7);
    private final String[] pathAttributeNames = new String[]{"path", "value"};

    public SpringWebSocketClientBeanPostProcessor(PropertiesConfig clientConfig, ShenyuClientRegisterRepository shenyuClientRegisterRepository) {
        Properties props = clientConfig.getProps();
        this.appName = props.getProperty("appName");
        this.contextPath = props.getProperty("contextPath", "");
        if (StringUtils.isBlank((CharSequence)this.appName) && StringUtils.isBlank((CharSequence)this.contextPath)) {
            String errorMsg = "websocket register param must config the appName or contextPath";
            LOG.error(errorMsg);
            throw new ShenyuClientIllegalArgumentException(errorMsg);
        }
        this.isFull = Boolean.parseBoolean(props.getProperty("isFull", Boolean.FALSE.toString()));
        this.mappingAnnotation.add(ShenyuSpringWebSocketClient.class);
        this.publisher.start(shenyuClientRegisterRepository);
    }

    public Object postProcessAfterInitialization(@NonNull Object bean, @NonNull String beanName) throws BeansException {
        Method[] methods;
        Class clazz = bean.getClass();
        if (AopUtils.isAopProxy((Object)bean)) {
            clazz = AopUtils.getTargetClass((Object)bean);
        }
        String superPath = this.buildApiSuperPath(clazz);
        if (Boolean.TRUE.equals(this.isFull) || !this.hasAnnotation(clazz, ShenyuSpringWebSocketClient.class)) {
            return bean;
        }
        ShenyuSpringWebSocketClient beanShenyuClient = (ShenyuSpringWebSocketClient)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)clazz, ShenyuSpringWebSocketClient.class);
        if (Objects.nonNull(beanShenyuClient) && superPath.contains("*")) {
            this.publisher.publishEvent((DataTypeParent)this.buildMetaDataDTO(beanShenyuClient, this.pathJoin(this.contextPath, superPath)));
            return bean;
        }
        for (Method method : methods = ReflectionUtils.getUniqueDeclaredMethods((Class)clazz)) {
            ShenyuSpringWebSocketClient webSocketClient = (ShenyuSpringWebSocketClient)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ShenyuSpringWebSocketClient.class);
            ShenyuSpringWebSocketClient shenyuSpringWebSocketClient = webSocketClient = Objects.isNull(webSocketClient) ? beanShenyuClient : webSocketClient;
            if (!Objects.nonNull(webSocketClient)) continue;
            this.publisher.publishEvent((DataTypeParent)this.buildMetaDataDTO(webSocketClient, this.buildApiPath(method, superPath)));
        }
        return bean;
    }

    private <A extends Annotation> boolean hasAnnotation(@NonNull Class<?> clazz, @NonNull Class<A> annotationType) {
        return Objects.nonNull(AnnotatedElementUtils.findMergedAnnotation(clazz, annotationType));
    }

    private String buildApiPath(@NonNull Method method, @NonNull String superPath) {
        ShenyuSpringWebSocketClient webSocketClient = (ShenyuSpringWebSocketClient)AnnotationUtils.findAnnotation((Method)method, ShenyuSpringWebSocketClient.class);
        if (Objects.nonNull(webSocketClient) && StringUtils.isNotBlank((CharSequence)webSocketClient.path())) {
            return this.pathJoin(this.contextPath, superPath, webSocketClient.path());
        }
        String path = this.getPathByMethod(method);
        if (StringUtils.isNotBlank((CharSequence)path)) {
            return this.pathJoin(this.contextPath, superPath, path);
        }
        return this.pathJoin(this.contextPath, superPath);
    }

    private String getPathByMethod(@NonNull Method method) {
        for (Class<? extends Annotation> mapping : this.mappingAnnotation) {
            String pathByAnnotation = this.getPathByAnnotation(AnnotationUtils.findAnnotation((Method)method, mapping), this.pathAttributeNames);
            if (!StringUtils.isNotBlank((CharSequence)pathByAnnotation)) continue;
            return pathByAnnotation;
        }
        return null;
    }

    private String getPathByAnnotation(@Nullable Annotation annotation, String ... pathAttributeName) {
        if (Objects.isNull(annotation)) {
            return null;
        }
        for (String s : pathAttributeName) {
            Object value = AnnotationUtils.getValue((Annotation)annotation, (String)s);
            if (value instanceof String && StringUtils.isNotBlank((CharSequence)((String)value))) {
                return (String)value;
            }
            if (!(value instanceof String[]) || !ArrayUtils.isNotEmpty((Object[])((String[])value)) || !StringUtils.isNotBlank((CharSequence)((String[])value)[0])) continue;
            return ((String[])value)[0];
        }
        return null;
    }

    private String buildApiSuperPath(@NonNull Class<?> method) {
        ShenyuSpringWebSocketClient webSocketClient = (ShenyuSpringWebSocketClient)AnnotatedElementUtils.findMergedAnnotation(method, ShenyuSpringWebSocketClient.class);
        if (Objects.nonNull(webSocketClient) && StringUtils.isNotBlank((CharSequence)webSocketClient.path())) {
            return webSocketClient.path();
        }
        return "";
    }

    private String pathJoin(String ... path) {
        StringBuilder result = new StringBuilder(PATH_SEPARATOR);
        for (String p : path) {
            if (!result.toString().endsWith(PATH_SEPARATOR)) {
                result.append(PATH_SEPARATOR);
            }
            result.append(p.startsWith(PATH_SEPARATOR) ? p.replaceFirst(PATH_SEPARATOR, "") : p);
        }
        return result.toString();
    }

    private MetaDataRegisterDTO buildMetaDataDTO(@NonNull ShenyuSpringWebSocketClient webSocketClient, String path) {
        return MetaDataRegisterDTO.builder().contextPath(this.contextPath).appName(this.appName).path(path).pathDesc(webSocketClient.desc()).rpcType(RpcTypeEnum.WEB_SOCKET.getName()).enabled(webSocketClient.enabled()).ruleName((String)StringUtils.defaultIfBlank((CharSequence)webSocketClient.ruleName(), (CharSequence)path)).registerMetaData(webSocketClient.registerMetaData()).build();
    }
}

