/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.springmvc.init;

import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.client.core.disruptor.ShenyuClientRegisterEventPublisher;
import org.apache.shenyu.client.core.exception.ShenyuClientIllegalArgumentException;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.IpUtils;
import org.apache.shenyu.common.utils.PathUtils;
import org.apache.shenyu.common.utils.PortUtils;
import org.apache.shenyu.common.utils.UriUtils;
import org.apache.shenyu.register.common.config.PropertiesConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.type.DataTypeParent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.lang.NonNull;

public class ContextRegisterListener
implements ApplicationListener<ContextRefreshedEvent>,
BeanFactoryAware {
    private static final Logger LOG = LoggerFactory.getLogger(ContextRegisterListener.class);
    private final ShenyuClientRegisterEventPublisher publisher = ShenyuClientRegisterEventPublisher.getInstance();
    private final AtomicBoolean registered = new AtomicBoolean(false);
    private final String contextPath;
    private final String appName;
    private final String protocol;
    private final String host;
    private final Integer port;
    private final Boolean isFull;
    private BeanFactory beanFactory;

    public ContextRegisterListener(PropertiesConfig clientConfig) {
        Properties props = clientConfig.getProps();
        this.isFull = Boolean.parseBoolean(props.getProperty("isFull", Boolean.FALSE.toString()));
        this.contextPath = Optional.ofNullable(props.getProperty("contextPath")).map(UriUtils::repairData).orElse(null);
        if (Boolean.TRUE.equals(this.isFull) && StringUtils.isBlank((CharSequence)this.contextPath)) {
            String errorMsg = "http register param must config the contextPath";
            LOG.error("http register param must config the contextPath");
            throw new ShenyuClientIllegalArgumentException("http register param must config the contextPath");
        }
        this.port = Integer.parseInt(Optional.ofNullable(props.getProperty("port")).orElseGet(() -> "-1"));
        this.appName = props.getProperty("appName");
        this.protocol = props.getProperty("protocol", "http://");
        this.host = props.getProperty("host");
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void onApplicationEvent(@NonNull ContextRefreshedEvent contextRefreshedEvent) {
        if (!this.registered.compareAndSet(false, true)) {
            return;
        }
        if (Boolean.TRUE.equals(this.isFull)) {
            this.publisher.publishEvent((DataTypeParent)this.buildMetaDataDTO());
        }
        try {
            int mergedPort = this.port <= 0 ? PortUtils.findPort((BeanFactory)this.beanFactory) : this.port;
            this.publisher.publishEvent((DataTypeParent)this.buildURIRegisterDTO(mergedPort));
        }
        catch (ShenyuException e) {
            throw new ShenyuException(e.getMessage() + "please config ${shenyu.client.http.props.port} in xml/yml !");
        }
    }

    private URIRegisterDTO buildURIRegisterDTO(int port) {
        return URIRegisterDTO.builder().contextPath(this.contextPath).appName(this.appName).protocol(this.protocol).host(IpUtils.isCompleteHost((String)this.host) ? this.host : IpUtils.getHost((String)this.host)).port(Integer.valueOf(port)).rpcType(RpcTypeEnum.HTTP.getName()).build();
    }

    private MetaDataRegisterDTO buildMetaDataDTO() {
        return MetaDataRegisterDTO.builder().contextPath(this.contextPath).appName(this.appName).path(PathUtils.decoratorPath((String)this.contextPath)).rpcType(RpcTypeEnum.HTTP.getName()).enabled(true).ruleName(this.contextPath).build();
    }
}

