/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.springmvc.init;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.client.core.disruptor.ShenyuClientRegisterEventPublisher;
import org.apache.shenyu.client.core.exception.ShenyuClientIllegalArgumentException;
import org.apache.shenyu.client.springmvc.annotation.ShenyuSpringMvcClient;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.UriUtils;
import org.apache.shenyu.register.client.api.ShenyuClientRegisterRepository;
import org.apache.shenyu.register.common.config.PropertiesConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.type.DataTypeParent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Controller;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;

public class SpringMvcClientEventListener
implements ApplicationListener<ContextRefreshedEvent> {
    private static final String PATH_SEPARATOR = "/";
    private static final Logger LOG = LoggerFactory.getLogger(SpringMvcClientEventListener.class);
    private final ShenyuClientRegisterEventPublisher publisher = ShenyuClientRegisterEventPublisher.getInstance();
    private final String contextPath;
    private final String appName;
    private final Boolean isFull;
    private final List<Class<? extends Annotation>> mappingAnnotation = new ArrayList<Class<? extends Annotation>>(7);
    private final String[] pathAttributeNames = new String[]{"path", "value"};

    public SpringMvcClientEventListener(PropertiesConfig clientConfig, ShenyuClientRegisterRepository shenyuClientRegisterRepository) {
        Properties props = clientConfig.getProps();
        this.appName = props.getProperty("appName");
        this.contextPath = Optional.ofNullable(props.getProperty("contextPath")).map(UriUtils::repairData).orElse("");
        if (StringUtils.isBlank((CharSequence)this.appName) && StringUtils.isBlank((CharSequence)this.contextPath)) {
            String errorMsg = "http register param must config the appName or contextPath";
            LOG.error(errorMsg);
            throw new ShenyuClientIllegalArgumentException(errorMsg);
        }
        this.isFull = Boolean.parseBoolean(props.getProperty("isFull", Boolean.FALSE.toString()));
        this.mappingAnnotation.add(ShenyuSpringMvcClient.class);
        this.mappingAnnotation.add(PostMapping.class);
        this.mappingAnnotation.add(GetMapping.class);
        this.mappingAnnotation.add(DeleteMapping.class);
        this.mappingAnnotation.add(PutMapping.class);
        this.mappingAnnotation.add(RequestMapping.class);
        this.publisher.start(shenyuClientRegisterRepository);
    }

    public void onApplicationEvent(ContextRefreshedEvent event) throws BeansException {
        if (Boolean.TRUE.equals(this.isFull)) {
            return;
        }
        Map controllerBeans = event.getApplicationContext().getBeansWithAnnotation(Controller.class);
        for (Map.Entry entry : controllerBeans.entrySet()) {
            this.handler(entry.getValue());
        }
    }

    private void handler(@NonNull Object bean) {
        Method[] methods;
        Class clazz = bean.getClass();
        if (AopUtils.isAopProxy((Object)bean)) {
            clazz = AopUtils.getTargetClass((Object)bean);
        }
        ShenyuSpringMvcClient beanShenyuClient = (ShenyuSpringMvcClient)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)clazz, ShenyuSpringMvcClient.class);
        String superPath = this.buildApiSuperPath(clazz);
        if (Objects.nonNull(beanShenyuClient) && superPath.contains("*")) {
            this.publisher.publishEvent((DataTypeParent)this.buildMetaDataDTO(beanShenyuClient, this.pathJoin(this.contextPath, superPath)));
            return;
        }
        for (Method method : methods = ReflectionUtils.getUniqueDeclaredMethods((Class)clazz)) {
            RequestMapping requestMapping = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, RequestMapping.class);
            ShenyuSpringMvcClient methodShenyuClient = (ShenyuSpringMvcClient)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ShenyuSpringMvcClient.class);
            ShenyuSpringMvcClient shenyuSpringMvcClient = methodShenyuClient = Objects.isNull(methodShenyuClient) ? beanShenyuClient : methodShenyuClient;
            if (!Objects.nonNull(methodShenyuClient) || !Objects.nonNull(requestMapping)) continue;
            this.publisher.publishEvent((DataTypeParent)this.buildMetaDataDTO(methodShenyuClient, this.buildApiPath(method, superPath)));
        }
    }

    private String buildApiPath(@NonNull Method method, @NonNull String superPath) {
        ShenyuSpringMvcClient shenyuSpringMvcClient = (ShenyuSpringMvcClient)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ShenyuSpringMvcClient.class);
        if (Objects.nonNull(shenyuSpringMvcClient) && StringUtils.isNotBlank((CharSequence)shenyuSpringMvcClient.path())) {
            return this.pathJoin(this.contextPath, superPath, shenyuSpringMvcClient.path());
        }
        String path = this.getPathByMethod(method);
        if (StringUtils.isNotBlank((CharSequence)path)) {
            return this.pathJoin(this.contextPath, superPath, path);
        }
        return this.pathJoin(this.contextPath, superPath);
    }

    private String getPathByMethod(@NonNull Method method) {
        for (Class<? extends Annotation> mapping : this.mappingAnnotation) {
            String pathByAnnotation = this.getPathByAnnotation(AnnotationUtils.findAnnotation((Method)method, mapping), this.pathAttributeNames);
            if (!StringUtils.isNotBlank((CharSequence)pathByAnnotation)) continue;
            return pathByAnnotation;
        }
        return null;
    }

    private String getPathByAnnotation(@Nullable Annotation annotation, String ... pathAttributeName) {
        if (Objects.isNull(annotation)) {
            return null;
        }
        for (String s : pathAttributeName) {
            Object value = AnnotationUtils.getValue((Annotation)annotation, (String)s);
            if (value instanceof String && StringUtils.isNotBlank((CharSequence)((String)value))) {
                return (String)value;
            }
            if (!(value instanceof String[]) || !ArrayUtils.isNotEmpty((Object[])((String[])value)) || !StringUtils.isNotBlank((CharSequence)((String[])value)[0])) continue;
            return ((String[])value)[0];
        }
        return null;
    }

    private String buildApiSuperPath(@NonNull Class<?> method) {
        ShenyuSpringMvcClient shenyuSpringMvcClient = (ShenyuSpringMvcClient)AnnotatedElementUtils.findMergedAnnotation(method, ShenyuSpringMvcClient.class);
        if (Objects.nonNull(shenyuSpringMvcClient) && StringUtils.isNotBlank((CharSequence)shenyuSpringMvcClient.path())) {
            return shenyuSpringMvcClient.path();
        }
        RequestMapping requestMapping = (RequestMapping)AnnotationUtils.findAnnotation(method, RequestMapping.class);
        if (Objects.nonNull(requestMapping) && ArrayUtils.isNotEmpty((Object[])requestMapping.path()) && StringUtils.isNotBlank((CharSequence)requestMapping.path()[0])) {
            return requestMapping.path()[0];
        }
        return "";
    }

    private String pathJoin(String ... path) {
        StringBuilder result = new StringBuilder(PATH_SEPARATOR);
        for (String p : path) {
            if (!result.toString().endsWith(PATH_SEPARATOR)) {
                result.append(PATH_SEPARATOR);
            }
            result.append(p.startsWith(PATH_SEPARATOR) ? p.replaceFirst(PATH_SEPARATOR, "") : p);
        }
        return result.toString();
    }

    private MetaDataRegisterDTO buildMetaDataDTO(@NonNull ShenyuSpringMvcClient shenyuSpringMvcClient, String path) {
        return MetaDataRegisterDTO.builder().contextPath(this.contextPath).appName(this.appName).path(path).pathDesc(shenyuSpringMvcClient.desc()).rpcType(RpcTypeEnum.HTTP.getName()).enabled(shenyuSpringMvcClient.enabled()).ruleName((String)StringUtils.defaultIfBlank((CharSequence)shenyuSpringMvcClient.ruleName(), (CharSequence)path)).registerMetaData(shenyuSpringMvcClient.registerMetaData()).build();
    }
}

