/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.tars;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.client.core.disruptor.ShenyuClientRegisterEventPublisher;
import org.apache.shenyu.client.core.exception.ShenyuClientIllegalArgumentException;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.register.common.config.PropertiesConfig;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.type.DataTypeParent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class TarsContextRefreshedEventListener
implements ApplicationListener<ContextRefreshedEvent> {
    private final ShenyuClientRegisterEventPublisher publisher = ShenyuClientRegisterEventPublisher.getInstance();
    private final AtomicBoolean registered = new AtomicBoolean(false);
    private final String contextPath;
    private final String ipAndPort;
    private final String host;
    private final int port;

    public TarsContextRefreshedEventListener(PropertiesConfig clientConfig) {
        Properties props = clientConfig.getProps();
        String contextPath = props.getProperty("contextPath");
        this.host = props.getProperty("host");
        String port = props.getProperty("port");
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{contextPath, this.host, port})) {
            throw new ShenyuClientIllegalArgumentException("tars client must config the contextPath, ipAndPort");
        }
        this.contextPath = contextPath;
        this.ipAndPort = this.host + ":" + port;
        this.port = Integer.parseInt(port);
    }

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        if (!this.registered.compareAndSet(false, true)) {
            return;
        }
        this.publisher.publishEvent((DataTypeParent)this.buildURIRegisterDTO());
    }

    private URIRegisterDTO buildURIRegisterDTO() {
        return URIRegisterDTO.builder().contextPath(this.contextPath).appName(this.ipAndPort).rpcType(RpcTypeEnum.TARS.getName()).host(this.host).port(Integer.valueOf(this.port)).build();
    }
}

