/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.timer;

import java.util.Iterator;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.shenyu.common.timer.TaskEntity;
import org.apache.shenyu.common.timer.Timer;
import org.apache.shenyu.common.timer.TimerTask;

public class TimerTaskList
implements Delayed,
Iterable<TimerTask> {
    private final TimerTaskEntry root;
    private final AtomicInteger taskCounter;
    private final AtomicLong expiration = new AtomicLong(-1L);

    public TimerTaskList(AtomicInteger taskCounter) {
        this.taskCounter = taskCounter;
        this.root = new TimerTaskEntry(null, null, -1L);
        this.root.next = this.root;
        this.root.prev = this.root;
    }

    public boolean setExpiration(long expirationMs) {
        return this.expiration.getAndSet(expirationMs) != expirationMs;
    }

    public long getExpiration() {
        return this.expiration.get();
    }

    synchronized void flush(Consumer<TimerTaskEntry> consumer) {
        TimerTaskEntry head = this.root.next;
        while (head != this.root) {
            this.remove(head);
            consumer.accept(head);
            head = this.root.next;
        }
        this.expiration.set(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TimerTaskEntry timerTaskEntry) {
        boolean done = false;
        while (!done) {
            timerTaskEntry.remove();
            TimerTaskList timerTaskList = this;
            synchronized (timerTaskList) {
                if (timerTaskEntry.list == null) {
                    TimerTaskEntry tail = this.root.prev;
                    timerTaskEntry.next = this.root;
                    timerTaskEntry.prev = tail;
                    timerTaskEntry.list = this;
                    tail.next = timerTaskEntry;
                    this.root.prev = timerTaskEntry;
                    this.taskCounter.incrementAndGet();
                    done = true;
                }
            }
        }
    }

    public synchronized void foreach(Consumer<TimerTask> consumer) {
        TimerTaskEntry entry = this.root.next;
        while (entry != this.root) {
            TimerTaskEntry next = entry.next;
            if (!entry.cancelled()) {
                consumer.accept(entry.timerTask);
            }
            entry = next;
        }
    }

    @Override
    public long getDelay(TimeUnit unit) {
        long millis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
        return unit.convert(Math.max(this.getExpiration() - millis, 0L), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed delayed) {
        boolean other = delayed instanceof TimerTaskList;
        if (other) {
            long expiration = ((TimerTaskList)delayed).getExpiration();
            return Long.compare(this.getExpiration(), expiration);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(TimerTaskEntry timerTaskEntry) {
        TimerTaskList timerTaskList = this;
        synchronized (timerTaskList) {
            if (timerTaskEntry.list == this) {
                timerTaskEntry.next.prev = timerTaskEntry.prev;
                timerTaskEntry.prev.next = timerTaskEntry.next;
                timerTaskEntry.next = null;
                timerTaskEntry.prev = null;
                timerTaskEntry.list = null;
                this.taskCounter.decrementAndGet();
            }
        }
    }

    @Override
    public Iterator<TimerTask> iterator() {
        return new Itr(this.root.next);
    }

    public static class TimerTaskEntry
    implements TaskEntity,
    Comparable<TimerTaskEntry> {
        private final Timer timer;
        private final TimerTask timerTask;
        private final Long expirationMs;
        private TimerTaskList list;
        private TimerTaskEntry next;
        private TimerTaskEntry prev;

        public TimerTaskEntry(Timer timer, TimerTask timerTask, Long expirationMs) {
            this.timerTask = timerTask;
            this.expirationMs = expirationMs;
            this.timer = timer;
            if (timerTask != null) {
                timerTask.setTimerTaskEntry(this);
            }
        }

        @Override
        public boolean cancelled() {
            return this.timerTask.getTimerTaskEntry() != this;
        }

        @Override
        public void cancel() {
            this.timerTask.cancel();
        }

        public Long getExpirationMs() {
            return this.expirationMs;
        }

        @Override
        public Timer getTimer() {
            return this.timer;
        }

        @Override
        public TimerTask getTimerTask() {
            return this.timerTask;
        }

        void remove() {
            TimerTaskList currentList = this.list;
            while (currentList != null) {
                currentList.remove(this);
                currentList = this.list;
            }
        }

        @Override
        public int compareTo(TimerTaskEntry timerTaskEntry) {
            return Long.compare(this.expirationMs, timerTaskEntry.expirationMs);
        }
    }

    private class Itr
    implements Iterator<TimerTask> {
        private TimerTaskEntry entry;

        Itr(TimerTaskEntry entry) {
            this.entry = entry;
        }

        @Override
        public boolean hasNext() {
            if (this.entry != TimerTaskList.this.root) {
                return !this.entry.cancelled();
            }
            return false;
        }

        @Override
        public TimerTask next() {
            TimerTask timerTask = null;
            if (this.entry != TimerTaskList.this.root) {
                TimerTaskEntry nextEntry = this.entry.next;
                if (!this.entry.cancelled()) {
                    timerTask = this.entry.timerTask;
                }
                this.entry = nextEntry;
            }
            return timerTask;
        }

        @Override
        public void remove() {
            this.entry.remove();
        }
    }
}

