/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.loadbalancer.spi;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.shenyu.loadbalancer.entity.Upstream;
import org.apache.shenyu.loadbalancer.spi.AbstractLoadBalancer;
import org.apache.shenyu.spi.Join;

@Join
public class RoundRobinLoadBalancer
extends AbstractLoadBalancer {
    private final int recyclePeriod = 60000;
    private final ConcurrentMap<String, ConcurrentMap<String, WeightedRoundRobin>> methodWeightMap = new ConcurrentHashMap<String, ConcurrentMap<String, WeightedRoundRobin>>(16);
    private final AtomicBoolean updateLock = new AtomicBoolean();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Upstream doSelect(List<Upstream> upstreamList, String ip) {
        String key = upstreamList.get(0).getUrl();
        ConcurrentMap map = (ConcurrentMap)this.methodWeightMap.get(key);
        if (Objects.isNull(map)) {
            this.methodWeightMap.putIfAbsent(key, new ConcurrentHashMap(16));
            map = (ConcurrentMap)this.methodWeightMap.get(key);
        }
        int totalWeight = 0;
        long maxCurrent = Long.MIN_VALUE;
        long now = System.currentTimeMillis();
        Upstream selectedInvoker = null;
        WeightedRoundRobin selectedWeightedRoundRobin = null;
        for (Upstream upstream : upstreamList) {
            String rKey = upstream.getUrl();
            WeightedRoundRobin weightedRoundRobin = (WeightedRoundRobin)map.get(rKey);
            int weight = this.getWeight(upstream);
            if (Objects.isNull(weightedRoundRobin)) {
                weightedRoundRobin = new WeightedRoundRobin();
                weightedRoundRobin.setWeight(weight);
                map.putIfAbsent(rKey, weightedRoundRobin);
            }
            if (weight != weightedRoundRobin.getWeight()) {
                weightedRoundRobin.setWeight(weight);
            }
            long cur = weightedRoundRobin.increaseCurrent();
            weightedRoundRobin.setLastUpdate(now);
            if (cur > maxCurrent) {
                maxCurrent = cur;
                selectedInvoker = upstream;
                selectedWeightedRoundRobin = weightedRoundRobin;
            }
            totalWeight += weight;
        }
        if (!this.updateLock.get() && upstreamList.size() != map.size() && this.updateLock.compareAndSet(false, true)) {
            try {
                ConcurrentHashMap newMap = new ConcurrentHashMap(map);
                newMap.entrySet().removeIf(item -> now - ((WeightedRoundRobin)item.getValue()).getLastUpdate() > 60000L);
                this.methodWeightMap.put(key, newMap);
            }
            finally {
                this.updateLock.set(false);
            }
        }
        if (Objects.nonNull(selectedInvoker)) {
            selectedWeightedRoundRobin.sel(totalWeight);
            return selectedInvoker;
        }
        return upstreamList.get(0);
    }

    protected static class WeightedRoundRobin {
        private int weight;
        private final AtomicLong current = new AtomicLong(0L);
        private long lastUpdate;

        protected WeightedRoundRobin() {
        }

        int getWeight() {
            return this.weight;
        }

        void setWeight(int weight) {
            this.weight = weight;
            this.current.set(0L);
        }

        long increaseCurrent() {
            return this.current.addAndGet(this.weight);
        }

        void sel(int total) {
            this.current.addAndGet(-1 * total);
        }

        long getLastUpdate() {
            return this.lastUpdate;
        }

        void setLastUpdate(long lastUpdate) {
            this.lastUpdate = lastUpdate;
        }
    }
}

