/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.api.utils;

import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.api.utils.RequestQueryCodecUtil;
import org.springframework.web.server.ServerWebExchange;

public final class RequestUrlUtils {
    private RequestUrlUtils() {
    }

    public static URI buildRequestUri(ServerWebExchange exchange, String domain) {
        String path = domain;
        String rewriteUri = (String)exchange.getAttributes().get("rewrite_uri");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{rewriteUri})) {
            path = path + rewriteUri;
        } else {
            ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
            assert (shenyuContext != null);
            String realUrl = shenyuContext.getRealUrl();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{realUrl})) {
                path = path + realUrl;
            }
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{exchange.getRequest().getURI().getQuery()})) {
            path = String.join((CharSequence)"?", path, RequestQueryCodecUtil.getCodecQuery(exchange));
        }
        return URI.create(path);
    }
}

