/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.base;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.SelectorTypeEnum;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.base.cache.BaseDataCache;
import org.apache.shenyu.plugin.base.condition.strategy.MatchStrategyFactory;
import org.apache.shenyu.plugin.base.utils.Profiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class AbstractShenyuPlugin
implements ShenyuPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractShenyuPlugin.class);
    private static Pattern autoPattern = Pattern.compile("/auto[0-9]{4}");

    protected abstract Mono<Void> doExecute(ServerWebExchange var1, ShenyuPluginChain var2, SelectorData var3, RuleData var4);

    public Mono<Void> execute(ServerWebExchange exchange, ShenyuPluginChain chain) {
        Profiler.begin();
        String pluginName = this.named();
        PluginData pluginData = BaseDataCache.getInstance().obtainPluginData(pluginName);
        if (pluginData != null && pluginData.getEnabled().booleanValue()) {
            if (PluginEnum.RESPONSE_FILTER.getName().equals(pluginName)) {
                return this.doExecute(exchange, chain, null, null);
            }
            List<SelectorData> selectors = BaseDataCache.getInstance().obtainSelectorData(pluginName);
            if (CollectionUtils.isEmpty(selectors)) {
                return this.handleSelectorIfNull(pluginName, exchange, chain);
            }
            SelectorData selectorData = this.matchSelector(exchange, selectors);
            if (Objects.isNull(selectorData)) {
                return this.handleSelectorIfNull(pluginName, exchange, chain);
            }
            this.selectorLog(selectorData, pluginName);
            List<RuleData> rules = BaseDataCache.getInstance().obtainRuleData(selectorData.getId());
            if (CollectionUtils.isEmpty(rules)) {
                return this.handleRuleIfNull(pluginName, exchange, chain);
            }
            RuleData rule = selectorData.getType().intValue() == SelectorTypeEnum.FULL_FLOW.getCode() ? rules.get(rules.size() - 1) : this.matchRule(exchange, rules, pluginData.getName());
            if (Objects.isNull(rule)) {
                return this.handleRuleIfNull(pluginName, exchange, chain);
            }
            this.ruleLog(rule, pluginName);
            return this.doExecute(exchange, chain, selectorData, rule);
        }
        return chain.execute(exchange);
    }

    protected Mono<Void> handleSelectorIfNull(String pluginName, ServerWebExchange exchange, ShenyuPluginChain chain) {
        return chain.execute(exchange);
    }

    protected Mono<Void> handleRuleIfNull(String pluginName, ServerWebExchange exchange, ShenyuPluginChain chain) {
        return chain.execute(exchange);
    }

    private SelectorData matchSelector(ServerWebExchange exchange, Collection<SelectorData> selectors) {
        return selectors.stream().filter(selector -> selector.getEnabled() != false && this.filterSelector((SelectorData)selector, exchange) != false).findFirst().orElse(null);
    }

    private Boolean filterSelector(SelectorData selector, ServerWebExchange exchange) {
        if (selector.getType().intValue() == SelectorTypeEnum.CUSTOM_FLOW.getCode()) {
            if (CollectionUtils.isEmpty((Collection)selector.getConditionList())) {
                return false;
            }
            return MatchStrategyFactory.match(selector.getMatchMode(), selector.getConditionList(), exchange);
        }
        return true;
    }

    private RuleData matchRule(ServerWebExchange exchange, Collection<RuleData> rules, String pluginName) {
        String url;
        Matcher matcher;
        RuleData ruleData = rules.stream().filter(rule -> this.filterRule((RuleData)rule, exchange)).findFirst().orElse(null);
        if (null == ruleData && PluginEnum.getCanMatchNames().contains(pluginName) && (matcher = autoPattern.matcher(url = exchange.getRequest().getURI().getPath())).find()) {
            ruleData = rules.stream().filter(rule -> this.filterRuleNoAuto((RuleData)rule, url)).findFirst().orElse(null);
        }
        return ruleData;
    }

    private boolean filterRuleNoAuto(RuleData ruleData, String url) {
        return ruleData.getConditionDataList().stream().allMatch(conditionData -> conditionData.getParamValue().equals(url.replaceAll("/auto[0-9]{4}", "")));
    }

    private Boolean filterRule(RuleData ruleData, ServerWebExchange exchange) {
        return ruleData.getEnabled() != false && MatchStrategyFactory.match(ruleData.getMatchMode(), ruleData.getConditionDataList(), exchange);
    }

    private void selectorLog(SelectorData selectorData, String pluginName) {
        if (selectorData.getLogged().booleanValue()) {
            // empty if block
        }
    }

    private void ruleLog(RuleData ruleData, String pluginName) {
        if (ruleData.getLoged().booleanValue()) {
            // empty if block
        }
    }
}

