/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.base.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ToStringSerializer;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.github.wnameless.json.flattener.JsonFlattener;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shenyu.plugin.base.model.BaseExtendFieldBo;

public class ParamStructureConvertUtil {
    private static final String EXTEND_FIELD_NAME = "extFields";
    private static final String FIELD_VALUE = "fieldValue";
    private static final String FIELD_CODE = "fieldCode";
    private static final String POINT = ".";
    private static final FastJsonConfig FAST_JSON_CONFIG;

    public static SerializerFeature[] getSerializerFeature() {
        return FAST_JSON_CONFIG.getSerializerFeatures();
    }

    public static String toJSONString(Object obj) {
        String jsonString = JSON.toJSONString((Object)obj, (SerializeConfig)FAST_JSON_CONFIG.getSerializeConfig(), (SerializerFeature[])FAST_JSON_CONFIG.getSerializerFeatures());
        return jsonString;
    }

    public static Object flatExtField(Object obj) {
        if (obj instanceof JSONArray || obj instanceof ArrayList) {
            JSONArray objArray = JSON.parseArray((String)ParamStructureConvertUtil.toJSONString(obj));
            for (int i = 0; i < objArray.size(); ++i) {
                objArray.set(i, ParamStructureConvertUtil.flatExtField(objArray.get(i)));
            }
            obj = objArray;
        } else if (obj instanceof JSONObject) {
            JSONObject jsonObject = JSON.parseObject((String)ParamStructureConvertUtil.toJSONString(obj));
            JSONObject extJsonObj = new JSONObject();
            Iterator keyIterator = jsonObject.keySet().iterator();
            while (keyIterator.hasNext()) {
                String key = keyIterator.next().toString();
                Object value = jsonObject.get((Object)key);
                if (EXTEND_FIELD_NAME.equals(key)) {
                    JSONArray extBoList = JSON.parseArray((String)ParamStructureConvertUtil.toJSONString(value));
                    for (int i = 0; i < extBoList.size(); ++i) {
                        JSONObject extBoJSONObj = (JSONObject)extBoList.get(i);
                        extJsonObj.put(extBoJSONObj.getString(FIELD_CODE), extBoJSONObj.get((Object)FIELD_VALUE));
                    }
                    continue;
                }
                if (value instanceof JSONArray || value instanceof ArrayList) {
                    JSONArray jsonArray = JSON.parseArray((String)ParamStructureConvertUtil.toJSONString(value));
                    value = ParamStructureConvertUtil.flatExtField(jsonArray);
                } else if (value instanceof JSONObject) {
                    value = ParamStructureConvertUtil.flatExtField(value);
                }
                jsonObject.put(key, value);
            }
            jsonObject.putAll((Map)extJsonObj);
            jsonObject.remove((Object)EXTEND_FIELD_NAME);
            obj = jsonObject;
        }
        return obj;
    }

    public static List<BaseExtendFieldBo> flatAndFilter(Map<String, String> extFieldMap, JSONObject jsonObject) {
        Map<String, Object> paramExtFieldMap = JsonFlattener.flattenAsMap((String)ParamStructureConvertUtil.toJSONString(jsonObject));
        Set<String> extFieldMapKeySet = extFieldMap.keySet();
        paramExtFieldMap = paramExtFieldMap.entrySet().stream().filter(item -> extFieldMapKeySet.contains(item.getKey()) || extFieldMapKeySet.contains(((String)item.getKey()).substring(((String)item.getKey()).lastIndexOf(POINT) + 1))).collect(Collectors.toMap(item -> (String)item.getKey(), item -> item.getValue()));
        ArrayList<BaseExtendFieldBo> extFieldDataList = new ArrayList<BaseExtendFieldBo>();
        paramExtFieldMap.entrySet().forEach(item -> {
            BaseExtendFieldBo dataBo = new BaseExtendFieldBo();
            dataBo.setFieldCode((String)item.getKey());
            dataBo.setFieldValue(item.getValue().toString());
            dataBo.setFieldName((String)extFieldMap.get(((String)item.getKey()).substring(((String)item.getKey()).lastIndexOf(POINT) + 1)));
            extFieldDataList.add(dataBo);
        });
        return extFieldDataList;
    }

    static {
        FastJsonConfig fastJsonConfig = new FastJsonConfig();
        JSON.DEFFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
        fastJsonConfig.setSerializerFeatures(new SerializerFeature[]{SerializerFeature.BrowserCompatible, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.PrettyFormat, SerializerFeature.WriteDateUseDateFormat, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteMapNullValue, SerializerFeature.DisableCircularReferenceDetect});
        SerializeConfig serializeConfig = SerializeConfig.globalInstance;
        serializeConfig.put(BigInteger.class, (ObjectSerializer)ToStringSerializer.instance);
        serializeConfig.put(Long.class, (ObjectSerializer)ToStringSerializer.instance);
        serializeConfig.put(Long.TYPE, (ObjectSerializer)ToStringSerializer.instance);
        fastJsonConfig.setSerializeConfig(serializeConfig);
        fastJsonConfig.getFeatures();
        FAST_JSON_CONFIG = fastJsonConfig;
    }
}

