/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.cache.memory;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.shenyu.plugin.cache.ICache;

public final class MemoryCache
implements ICache {
    private final Map<String, Cache<String, byte[]>> mainCache = new ConcurrentHashMap<String, Cache<String, byte[]>>();

    public boolean cacheData(String key, byte[] bytes, long timeoutSeconds) {
        Cache cache = CacheBuilder.newBuilder().expireAfterWrite(timeoutSeconds, TimeUnit.SECONDS).build();
        cache.put((Object)key, (Object)bytes);
        this.mainCache.put(key, (Cache<String, byte[]>)cache);
        return true;
    }

    public boolean isExist(String key) {
        Cache<String, byte[]> cache = this.mainCache.get(key);
        if (Objects.isNull(cache) || !cache.asMap().containsKey(key)) {
            this.mainCache.remove(key);
            return false;
        }
        return true;
    }

    public byte[] getData(String key) {
        if (!this.isExist(key)) {
            return null;
        }
        return (byte[])this.mainCache.get(key).asMap().get(key);
    }

    public void close() {
        this.mainCache.clear();
    }
}

