/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.context.path;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.impl.ContextMappingRuleHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.context.path.handler.ContextPathPluginDataHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ContextPathPlugin
extends AbstractShenyuPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(ContextPathPlugin.class);

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
        assert (shenyuContext != null);
        ContextMappingRuleHandle contextMappingRuleHandle = (ContextMappingRuleHandle)ContextPathPluginDataHandler.CACHED_HANDLE.get().obtainHandle((Object)CacheKeyUtils.INST.getKey(rule));
        if (Objects.isNull(contextMappingRuleHandle)) {
            LOG.error("context path rule configuration is null \uff1a{}", (Object)rule);
            return chain.execute(exchange);
        }
        String contextPath = contextMappingRuleHandle.getContextPath();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{contextPath}) && !shenyuContext.getPath().startsWith(contextPath)) {
            LOG.error("the context path '{}' is invalid.", (Object)contextPath);
            Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (int)ShenyuResultEnum.CONTEXT_PATH_ERROR.getCode(), (String)String.format("%s [invalid context path:'%s']", ShenyuResultEnum.CONTEXT_PATH_ERROR.getMsg(), contextPath), null);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        this.buildContextPath(shenyuContext, contextMappingRuleHandle);
        return chain.execute(exchange);
    }

    public int getOrder() {
        return PluginEnum.CONTEXT_PATH.getCode();
    }

    public String named() {
        return PluginEnum.CONTEXT_PATH.getName();
    }

    public boolean skip(ServerWebExchange exchange) {
        return this.skip(exchange, new RpcTypeEnum[]{RpcTypeEnum.DUBBO, RpcTypeEnum.GRPC, RpcTypeEnum.TARS, RpcTypeEnum.MOTAN, RpcTypeEnum.SOFA});
    }

    private void buildContextPath(ShenyuContext context, ContextMappingRuleHandle handle) {
        String addPrefix;
        String realURI = "";
        String contextPath = handle.getContextPath();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{contextPath})) {
            context.setContextPath(contextPath);
            context.setModule(contextPath);
            realURI = context.getPath().substring(contextPath.length());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{addPrefix = handle.getAddPrefix()})) {
            realURI = StringUtils.isNotBlank((CharSequence)realURI) ? addPrefix + realURI : addPrefix + context.getPath();
        }
        context.setRealUrl(realURI);
    }
}

