/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.divide;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.buffer.ByteBufAllocator;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.impl.DivideRuleHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.PathMatchUtils;
import org.apache.shenyu.loadbalancer.cache.UpstreamCacheManager;
import org.apache.shenyu.loadbalancer.entity.Upstream;
import org.apache.shenyu.loadbalancer.factory.LoadBalancerFactory;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.base.utils.JsonReturnValueUtil;
import org.apache.shenyu.plugin.base.utils.ParamStructureConvertUtil;
import org.apache.shenyu.plugin.base.utils.ResponseUtils;
import org.apache.shenyu.plugin.divide.handler.DividePluginDataHandler;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.NonNull;

public class DividePlugin
extends AbstractShenyuPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(DividePlugin.class);
    private static final Integer LOG_MAX_LENGTH = 2048;
    private final DataBufferFactory dataBufferFactory = new NettyDataBufferFactory(ByteBufAllocator.DEFAULT);
    @Autowired
    private ObjectMapper objectMapper;

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        long headerSize;
        ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
        assert (shenyuContext != null);
        DivideRuleHandle ruleHandle = (DivideRuleHandle)DividePluginDataHandler.CACHED_HANDLE.get().obtainHandle((Object)CacheKeyUtils.INST.getKey(rule));
        this.doReWrite(exchange, ruleHandle);
        if (ruleHandle.getHeaderMaxSize() > 0L && (headerSize = exchange.getRequest().getHeaders().values().stream().flatMap(Collection::stream).mapToLong(header -> header.getBytes(StandardCharsets.UTF_8).length).sum()) > ruleHandle.getHeaderMaxSize()) {
            LOG.error("request header is too large");
            Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.REQUEST_HEADER_TOO_LARGE);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        if (ruleHandle.getRequestMaxSize() > 0L && exchange.getRequest().getHeaders().getContentLength() > ruleHandle.getRequestMaxSize()) {
            LOG.error("request entity is too large");
            Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.REQUEST_ENTITY_TOO_LARGE);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        List upstreamList = UpstreamCacheManager.getInstance().findUpstreamListBySelectorId(selector.getId());
        if (CollectionUtils.isEmpty((Collection)upstreamList)) {
            LOG.error("divide upstream configuration error\uff1a {}", (Object)rule);
            Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.CANNOT_FIND_HEALTHY_UPSTREAM_URL);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        String ip = Objects.requireNonNull(exchange.getRequest().getRemoteAddress()).getAddress().getHostAddress();
        Upstream upstream = LoadBalancerFactory.selector((List)upstreamList, (String)ruleHandle.getLoadBalance(), (String)ip);
        if (Objects.isNull(upstream)) {
            LOG.error("divide has no upstream");
            Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.CANNOT_FIND_HEALTHY_UPSTREAM_URL);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        String domain = upstream.buildDomain();
        exchange.getAttributes().put("httpDomain", domain);
        exchange.getAttributes().put("httpTimeOut", ruleHandle.getTimeout());
        exchange.getAttributes().put("httpRetry", ruleHandle.getRetry());
        exchange.getAttributes().put("retryStrategy", ruleHandle.getRetryStrategy());
        exchange.getAttributes().put("loadBalance", ruleHandle.getLoadBalance());
        exchange.getAttributes().put("divideSelectorId", selector.getId());
        if (StringUtils.isEmpty((CharSequence)ruleHandle.getExtFields()) || !"POST".equals(exchange.getRequest().getMethodValue())) {
            return chain.execute(exchange.mutate().response((ServerHttpResponse)new ModifyResponseDecorator(exchange, ruleHandle.getResponseFields())).build());
        }
        return this.reBuildReqParaAndAddRespDecorator(chain, exchange, ruleHandle);
    }

    private Mono<Void> reBuildReqParaAndAddRespDecorator(ShenyuPluginChain chain, ServerWebExchange exchange, DivideRuleHandle ruleHandle) {
        return DataBufferUtils.join((Publisher)exchange.getRequest().getBody()).flatMap(dataBuffer -> {
            byte[] bytes = new byte[dataBuffer.readableByteCount()];
            dataBuffer.read(bytes);
            DataBufferUtils.release((DataBuffer)dataBuffer);
            String bodyString = new String(bytes, StandardCharsets.UTF_8);
            JSONObject requestPramJSON = JSONObject.parseObject((String)bodyString);
            Map extFieldMap = (Map)JSON.parseObject((String)ruleHandle.getExtFields(), Map.class);
            List extendFieldBos = ParamStructureConvertUtil.flatAndFilter((Map)extFieldMap, (JSONObject)requestPramJSON);
            if (CollectionUtils.isNotEmpty((Collection)extendFieldBos)) {
                requestPramJSON.put("extFields", (Object)extendFieldBos);
            }
            LOG.info("\u91cd\u65b0\u6784\u5efa\u540e\u7684\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)(requestPramJSON.toJSONString().length() > LOG_MAX_LENGTH ? requestPramJSON.toJSONString().substring(0, LOG_MAX_LENGTH) : requestPramJSON.toJSONString()));
            final Flux cachedFlux = Flux.defer(() -> {
                DataBuffer buffer = exchange.getResponse().bufferFactory().wrap(requestPramJSON.toJSONString().getBytes(StandardCharsets.UTF_8));
                return Mono.just((Object)buffer);
            });
            final HttpHeaders headers = new HttpHeaders();
            headers.putAll((Map)exchange.getRequest().getHeaders());
            headers.remove((Object)"Content-Length");
            headers.set("Transfer-Encoding", "chunked");
            ServerHttpRequestDecorator mutatedRequest = new ServerHttpRequestDecorator(exchange.getRequest()){

                public HttpHeaders getHeaders() {
                    HttpHeaders httpHeaders = new HttpHeaders();
                    httpHeaders.putAll((Map)headers);
                    return httpHeaders;
                }

                public Flux<DataBuffer> getBody() {
                    return cachedFlux;
                }
            };
            return chain.execute(exchange.mutate().request((ServerHttpRequest)mutatedRequest).response((ServerHttpResponse)new ModifyResponseDecorator(exchange, ruleHandle.getResponseFields())).build());
        });
    }

    private void doReWrite(ServerWebExchange exchange, DivideRuleHandle ruleHandle) {
        if (Objects.isNull(ruleHandle)) {
            return;
        }
        String rewriteUri = exchange.getRequest().getURI().getPath();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{ruleHandle.getRegex(), ruleHandle.getReplace()})) {
            rewriteUri = ruleHandle.getReplace().contains("{") ? PathMatchUtils.replaceAll((String)ruleHandle.getReplace(), (String)ruleHandle.getRegex().substring(ruleHandle.getRegex().indexOf("{")), (String)rewriteUri.substring(ruleHandle.getRegex().indexOf("{") + 1)) : rewriteUri.replaceAll(ruleHandle.getRegex(), ruleHandle.getReplace());
            exchange.getAttributes().put("rewrite_uri", rewriteUri);
        }
        LOG.info("divide execute has rewrite\uff0cnew url: {}", (Object)rewriteUri);
    }

    public String named() {
        return PluginEnum.DIVIDE.getName();
    }

    public boolean skip(ServerWebExchange exchange) {
        return this.skipExcept(exchange, new RpcTypeEnum[]{RpcTypeEnum.HTTP});
    }

    public int getOrder() {
        return PluginEnum.DIVIDE.getCode();
    }

    protected Mono<Void> handleSelectorIfNull(String pluginName, ServerWebExchange exchange, ShenyuPluginChain chain) {
        return WebFluxResultUtils.noSelectorResult((String)pluginName, (ServerWebExchange)exchange);
    }

    protected Mono<Void> handleRuleIfNull(String pluginName, ServerWebExchange exchange, ShenyuPluginChain chain) {
        return WebFluxResultUtils.noRuleResult((String)pluginName, (ServerWebExchange)exchange);
    }

    static class ModifyResponseDecorator
    extends ServerHttpResponseDecorator {
        private final ServerWebExchange exchange;
        private final String responseFields;

        ModifyResponseDecorator(ServerWebExchange exchange, String responseFields) {
            super(exchange.getResponse());
            this.exchange = exchange;
            this.responseFields = responseFields;
        }

        @NonNull
        public Mono<Void> writeWith(@NonNull Publisher<? extends DataBuffer> body) {
            ClientResponse clientResponse = this.buildModifiedResponse(body);
            Mono modifiedBody = clientResponse.bodyToMono(byte[].class).flatMap(originalBody -> Mono.just((Object)this.modifyBody((byte[])originalBody)));
            return ResponseUtils.writeWith((ClientResponse)clientResponse, (ServerWebExchange)this.exchange, (Publisher)modifiedBody, byte[].class);
        }

        private ClientResponse buildModifiedResponse(Publisher<? extends DataBuffer> body) {
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.addAll((MultiValueMap)this.getHeaders());
            ClientResponse clientResponse = ResponseUtils.buildClientResponse((ServerHttpResponse)this.getDelegate(), body);
            HttpStatus statusCode = clientResponse.statusCode();
            this.getDelegate().getHeaders().clear();
            this.getDelegate().getHeaders().putAll((Map)httpHeaders);
            int rowStatusCode = clientResponse.rawStatusCode();
            return ClientResponse.create((HttpStatus)statusCode).rawStatusCode(rowStatusCode).headers(headers -> headers.addAll((MultiValueMap)httpHeaders)).body(Flux.from(body)).build();
        }

        private byte[] modifyBody(byte[] responseBody) {
            try {
                String bodyStr = this.modifyBody(new String(responseBody, StandardCharsets.UTF_8));
                LOG.info("the body string {}", (Object)(bodyStr.length() > LOG_MAX_LENGTH ? bodyStr.substring(0, LOG_MAX_LENGTH) : bodyStr));
                return bodyStr.getBytes(StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                LOG.error("modify response error", (Throwable)e);
                throw new ShenyuException(String.format("response modify failure. %s", e.getLocalizedMessage()));
            }
        }

        private String modifyBody(String jsonValue) {
            String newJsonValue = ParamStructureConvertUtil.toJSONString((Object)JSON.parseObject((String)jsonValue));
            if (StringUtils.isEmpty((CharSequence)this.responseFields)) {
                return JsonReturnValueUtil.buildUnifiedFormat((String)jsonValue);
            }
            Set includes = (Set)JSON.parseObject((String)this.responseFields, Set.class);
            includes.add("busiCode");
            includes.add("busiMsg");
            PropertyPreFilter propertyPreFilter = (serializer, object, name) -> {
                String replaceAll = serializer.getContext().toString().replace("$.", "").replaceAll("\\[.*]\\.", ".").replaceAll("\\[.*]", "");
                return includes.contains(name) || includes.contains(replaceAll + "." + name);
            };
            Object retObj = ParamStructureConvertUtil.flatExtField((Object)JSON.parseObject((String)newJsonValue));
            return JsonReturnValueUtil.buildUnifiedFormat((String)JSON.toJSONString((Object)retObj, (SerializeFilter)propertyPreFilter, (SerializerFeature[])new SerializerFeature[0]));
        }
    }
}

