/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.global;

import cn.hutool.extra.emoji.EmojiUtil;
import java.nio.charset.StandardCharsets;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.api.context.ShenyuContextBuilder;
import org.apache.shenyu.plugin.api.result.CustomizeShenyuEntity;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class GlobalPlugin
implements ShenyuPlugin {
    private final ShenyuContextBuilder builder;

    public GlobalPlugin(ShenyuContextBuilder builder) {
        this.builder = builder;
    }

    public Mono<Void> execute(ServerWebExchange exchange, ShenyuPluginChain chain) {
        ShenyuContext shenyuContext = this.builder.build(exchange);
        exchange.getAttributes().put("context", shenyuContext);
        return this.illegalCharacterFilter(exchange, chain);
    }

    private Mono<Void> illegalCharacterFilter(ServerWebExchange exchange, ShenyuPluginChain chain) {
        if (exchange.getRequest().getMethod().equals((Object)HttpMethod.GET)) {
            return chain.execute(exchange);
        }
        return Mono.from((Publisher)DataBufferUtils.join((Publisher)exchange.getRequest().getBody()).flatMap(body -> {
            String param = this.resolveBodyFromRequest((DataBuffer)body);
            if (EmojiUtil.containsEmoji((String)param)) {
                System.out.println("\u53c2\u6570\u6709\u975e\u6cd5\u5b57\u7b26\uff0c\u5c31\u5230\u8fd9\u4e86\uff0c\u518d\u89c1\u3002");
                CustomizeShenyuEntity shenyuRsp = new CustomizeShenyuEntity(String.valueOf(ShenyuResultEnum.FAIL.getCode()), "\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u7b26\u53f7\uff0c\u8bf7\u5220\u9664\u540e\u91cd\u8bd5\u3002", null);
                return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)shenyuRsp);
            }
            final Flux cachedFlux = Flux.defer(() -> {
                DataBuffer buffer = exchange.getResponse().bufferFactory().wrap(param.getBytes(StandardCharsets.UTF_8));
                return Mono.just((Object)buffer);
            });
            ServerHttpRequestDecorator mutatedRequest = new ServerHttpRequestDecorator(exchange.getRequest()){

                public Flux<DataBuffer> getBody() {
                    return cachedFlux;
                }
            };
            return chain.execute(exchange.mutate().request((ServerHttpRequest)mutatedRequest).build());
        }));
    }

    private String resolveBodyFromRequest(DataBuffer dataBuffer) {
        byte[] bytes = new byte[dataBuffer.readableByteCount()];
        dataBuffer.read(bytes);
        DataBufferUtils.release((DataBuffer)dataBuffer);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public int getOrder() {
        return PluginEnum.GLOBAL.getCode();
    }

    public String named() {
        return PluginEnum.GLOBAL.getName();
    }
}

