/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.httpclient;

import com.google.common.collect.Sets;
import io.netty.channel.ConnectTimeoutException;
import io.netty.handler.timeout.ReadTimeoutException;
import java.net.URI;
import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.enums.RetryEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.loadbalancer.cache.UpstreamCacheManager;
import org.apache.shenyu.loadbalancer.entity.Upstream;
import org.apache.shenyu.loadbalancer.factory.LoadBalancerFactory;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.RequestUrlUtils;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;
import reactor.util.retry.RetryBackoffSpec;

public abstract class AbstractHttpClientPlugin<R>
implements ShenyuPlugin {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractHttpClientPlugin.class);

    public final Mono<Void> execute(ServerWebExchange exchange, ShenyuPluginChain chain) {
        ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
        assert (shenyuContext != null);
        URI uri = (URI)exchange.getAttribute("httpUri");
        if (Objects.isNull(uri)) {
            Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.CANNOT_FIND_URL);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        long timeout = (Long)Optional.ofNullable(exchange.getAttribute("httpTimeOut")).orElse(3000L);
        Duration duration = Duration.ofMillis(timeout);
        int retryTimes = (Integer)Optional.ofNullable(exchange.getAttribute("httpRetry")).orElse(0);
        String retryStrategy = (String)Optional.ofNullable(exchange.getAttribute("retryStrategy")).orElseGet(() -> ((RetryEnum)RetryEnum.CURRENT).getName());
        LOG.info("The request urlPath is {}, retryTimes is {}, retryStrategy is {}", new Object[]{uri.toASCIIString(), retryTimes, retryStrategy});
        HttpHeaders httpHeaders = this.buildHttpHeaders(exchange);
        Mono response = this.doRequest(exchange, exchange.getRequest().getMethodValue(), uri, httpHeaders, (Flux<DataBuffer>)exchange.getRequest().getBody()).timeout(duration, Mono.error((Throwable)new TimeoutException("Response took longer than timeout: " + duration))).doOnError(e -> LOG.error(e.getMessage(), e));
        if (RetryEnum.CURRENT.getName().equals(retryStrategy)) {
            RetryBackoffSpec retryBackoffSpec = Retry.backoff((long)retryTimes, (Duration)Duration.ofMillis(20L)).maxBackoff(Duration.ofSeconds(20L)).transientErrors(true).jitter(0.5).filter(t -> t instanceof TimeoutException || t instanceof ConnectTimeoutException || t instanceof ReadTimeoutException || t instanceof IllegalStateException);
            return response.retryWhen((Retry)retryBackoffSpec).onErrorMap(TimeoutException.class, th -> new ResponseStatusException(HttpStatus.GATEWAY_TIMEOUT, th.getMessage(), (Throwable)th)).flatMap(o -> chain.execute(exchange));
        }
        HashSet exclude = Sets.newHashSet((Object[])new URI[]{uri});
        return this.resend(response, exchange, duration, httpHeaders, exclude, retryTimes).onErrorMap(TimeoutException.class, th -> new ResponseStatusException(HttpStatus.GATEWAY_TIMEOUT, th.getMessage(), (Throwable)th)).flatMap(o -> chain.execute(exchange));
    }

    private Mono<R> resend(Mono<R> clientResponse, ServerWebExchange exchange, Duration duration, HttpHeaders httpHeaders, Set<URI> exclude, int retryTimes) {
        Mono<R> result = clientResponse;
        for (int i = 0; i < retryTimes; ++i) {
            result = this.resend(result, exchange, duration, httpHeaders, exclude);
        }
        return result;
    }

    private Mono<R> resend(Mono<R> response, ServerWebExchange exchange, Duration duration, HttpHeaders httpHeaders, Set<URI> exclude) {
        return response.onErrorResume(th -> {
            String selectorId = (String)exchange.getAttribute("divideSelectorId");
            String loadBalance = (String)exchange.getAttribute("loadBalance");
            List upstreamList = UpstreamCacheManager.getInstance().findUpstreamListBySelectorId(selectorId).stream().filter(data -> {
                String trimUri = data.getUrl().trim();
                for (URI needToExclude : exclude) {
                    if (!(needToExclude.getHost() + ":" + needToExclude.getPort()).equals(trimUri)) continue;
                    return false;
                }
                return true;
            }).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(upstreamList)) {
                return Mono.error((Throwable)new ShenyuException(ShenyuResultEnum.CANNOT_FIND_HEALTHY_UPSTREAM_URL_AFTER_FAILOVER.getMsg()));
            }
            String ip = Objects.requireNonNull(exchange.getRequest().getRemoteAddress()).getAddress().getHostAddress();
            Upstream upstream = LoadBalancerFactory.selector(upstreamList, (String)loadBalance, (String)ip);
            if (Objects.isNull(upstream)) {
                return Mono.error((Throwable)new ShenyuException(ShenyuResultEnum.CANNOT_FIND_HEALTHY_UPSTREAM_URL_AFTER_FAILOVER.getMsg()));
            }
            URI newUri = RequestUrlUtils.buildRequestUri((ServerWebExchange)exchange, (String)upstream.buildDomain());
            exclude.add(newUri);
            return this.doRequest(exchange, exchange.getRequest().getMethodValue(), newUri, httpHeaders, (Flux<DataBuffer>)exchange.getRequest().getBody()).timeout(duration, Mono.error((Throwable)new TimeoutException("Response took longer than timeout: " + duration))).doOnError(e -> LOG.error(e.getMessage(), e));
        });
    }

    private HttpHeaders buildHttpHeaders(ServerWebExchange exchange) {
        HttpHeaders headers = new HttpHeaders();
        headers.addAll((MultiValueMap)exchange.getRequest().getHeaders());
        List acceptEncoding = headers.get((Object)"Accept-Encoding");
        if (CollectionUtils.isNotEmpty((Collection)acceptEncoding)) {
            acceptEncoding = Stream.of(String.join((CharSequence)",", acceptEncoding).split(",")).collect(Collectors.toList());
            acceptEncoding.remove("gzip");
            headers.set("Accept-Encoding", String.join((CharSequence)",", acceptEncoding));
        }
        return headers;
    }

    protected abstract Mono<R> doRequest(ServerWebExchange var1, String var2, URI var3, HttpHeaders var4, Flux<DataBuffer> var5);
}

