/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.httpclient;

import java.net.URI;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.ResultEnum;
import org.apache.shenyu.plugin.httpclient.AbstractHttpClientPlugin;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class WebClientPlugin
extends AbstractHttpClientPlugin<ClientResponse> {
    private final WebClient webClient;

    public WebClientPlugin(WebClient webClient) {
        this.webClient = webClient;
    }

    @Override
    protected Mono<ClientResponse> doRequest(ServerWebExchange exchange, String httpMethod, URI uri, HttpHeaders httpHeaders, Flux<DataBuffer> body) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.method(HttpMethod.valueOf((String)httpMethod)).uri(uri)).headers(headers -> headers.addAll((MultiValueMap)httpHeaders))).body(BodyInserters.fromDataBuffers(body)).exchangeToMono(res -> res.bodyToMono(String.class).map(responseBody -> ClientResponse.create((HttpStatus)res.statusCode()).headers(headers -> headers.addAll((MultiValueMap)res.headers().asHttpHeaders())).body(responseBody).build())).doOnSuccess(res -> {
            if (res.statusCode().is2xxSuccessful()) {
                exchange.getAttributes().put("webHandlerClientResponseResultType", ResultEnum.SUCCESS.getName());
            } else {
                exchange.getAttributes().put("webHandlerClientResponseResultType", ResultEnum.ERROR.getName());
            }
            exchange.getResponse().setStatusCode(res.statusCode());
            exchange.getAttributes().put("webHandlerClientResponse", res);
        });
    }

    public int getOrder() {
        return PluginEnum.WEB_CLIENT.getCode();
    }

    public String named() {
        return PluginEnum.WEB_CLIENT.getName();
    }

    public boolean skip(ServerWebExchange exchange) {
        return this.skipExceptHttpLike(exchange);
    }
}

