/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.jwt;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.impl.JwtRuleHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.Md5Utils;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.jwt.config.JwtConfig;
import org.apache.shenyu.plugin.jwt.entity.ShenyuUmcDataEntity;
import org.apache.shenyu.plugin.jwt.entity.ShenyuUmcRspEntity;
import org.apache.shenyu.plugin.jwt.enums.JwtEnum;
import org.apache.shenyu.plugin.jwt.exception.ThrowingFunction;
import org.apache.shenyu.plugin.jwt.util.RegexUtils;
import org.apache.shenyu.springboot.starter.redis.cache.CacheClient;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class JwtPlugin
extends AbstractShenyuPlugin {
    private static final Logger log = LoggerFactory.getLogger(JwtPlugin.class);
    private static final String RESP_CODE_SUCCESS = "0000";
    private static final String AUTH2_TOKEN = "Bearer";
    private static final String APPLICATION_JSON_UTF8_VALUE = "json";
    @Resource
    private CacheClient cacheClient;

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        String token;
        JwtConfig jwtConfig = (JwtConfig)Singleton.INST.get(JwtConfig.class);
        boolean needToken = this.whetherNeedVerify(exchange.getRequest().getURI().toString(), jwtConfig.getStaticResources());
        if (!needToken) {
            return chain.execute(exchange);
        }
        String referer = exchange.getRequest().getHeaders().getFirst("Referer");
        if (StrUtil.isEmpty((CharSequence)referer)) {
            referer = exchange.getRequest().getHeaders().getFirst("referer");
        }
        boolean isCsr = true;
        for (String vReferer : jwtConfig.getVerifyReferers()) {
            if (referer != null && !referer.trim().startsWith(vReferer)) continue;
            isCsr = false;
            break;
        }
        if (StrUtil.isEmpty((CharSequence)(token = exchange.getRequest().getHeaders().getFirst("auth-token"))) && ObjectUtil.isNotEmpty((Object)exchange.getRequest().getCookies())) {
            token = ((HttpCookie)exchange.getRequest().getCookies().getFirst((Object)"auth-token")).getValue();
        }
        if (StrUtil.isEmpty((CharSequence)token)) {
            return this.buildErrorResult(exchange, JwtEnum.TOKEN_VALIDATE_ERROR.getCode(), "\u767b\u5f55\u4fe1\u606f\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        if (StrUtil.isEmpty((CharSequence)jwtConfig.getSecretKey())) {
            log.error("\u8bf7\u5b8c\u5584JWT\u63d2\u4ef6\u914d\u7f6e\u9879\uff1asecretKey");
            return this.buildErrorResult(exchange, JwtEnum.TOKEN_VALIDATE_ERROR.getCode(), "\u767b\u5f55\u4fe1\u606f\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        String finalAuthorization = this.compatible(token, null);
        Map<String, Object> jwtBody = this.checkAuthorization(finalAuthorization, jwtConfig.getSecretKey());
        if (null == jwtBody) {
            return this.buildErrorResult(exchange, JwtEnum.TOKEN_VALIDATE_ERROR.getCode(), "\u767b\u5f55\u4fe1\u606f\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        if (isCsr && !referer.equals(jwtBody.get("referer").toString())) {
            String print = "<font size=6 color=red>\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u8bf7\u6c42\u975e\u6cd5\uff0c\u7cfb\u7edf\u62d2\u7edd\u54cd\u5e94!</font>";
            exchange.getResponse().getHeaders().setContentType(MediaType.TEXT_HTML);
            exchange.getResponse().setStatusCode(HttpStatus.FORBIDDEN);
            return exchange.getResponse().writeWith((Publisher)Mono.just((Object)exchange.getResponse().bufferFactory().wrap(print.getBytes(StandardCharsets.UTF_8))).doOnNext(data -> exchange.getResponse().getHeaders().setContentLength((long)data.readableByteCount())));
        }
        ShenyuUmcRspEntity umcRspEntity = this.getUserDetail(jwtConfig, jwtBody, token, exchange);
        if (ShenyuResultEnum.SUCCESS.getCode() != umcRspEntity.getCode().intValue()) {
            return this.buildErrorResult(exchange, String.valueOf(ShenyuResultEnum.FAIL.getCode()), "\u767b\u5f55\u4fe1\u606f\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        MediaType mediaType = exchange.getRequest().getHeaders().getContentType();
        if (ObjectUtil.isNotEmpty((Object)mediaType) && mediaType.toString().contains(APPLICATION_JSON_UTF8_VALUE)) {
            return this.injectUserInfo(chain, exchange, jwtBody, JSON.parseObject((String)umcRspEntity.getData().getUserDetails()), token);
        }
        return chain.execute(exchange);
    }

    private ShenyuUmcRspEntity getUserDetail(JwtConfig jwtConfig, Map<String, Object> jwtBody, String token, ServerWebExchange exchange) {
        Object userDetail;
        JSONObject umcReqJson = new JSONObject();
        umcReqJson.put("tagId", jwtBody.get("tagId"));
        umcReqJson.put("uri", (Object)exchange.getRequest().getURI());
        umcReqJson.put("appCode", jwtBody.get("appCode"));
        umcReqJson.put("userId", jwtBody.get("userId"));
        umcReqJson.put("token", (Object)token);
        umcReqJson.put("loginSource", jwtBody.get("loginSource"));
        Object loginExpTime = this.cacheClient.get(token + "LoginExpTime", true);
        if (ObjectUtil.isEmpty((Object)loginExpTime)) {
            return new ShenyuUmcRspEntity(ShenyuResultEnum.FAIL.getCode(), "\u767b\u5f55\u4fe1\u606f\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\u3002", null);
        }
        if (Long.parseLong(loginExpTime.toString()) - System.currentTimeMillis() < 60000L) {
            this.httpCompatible(jwtConfig.getUpdateLoginTimeService(), token, umcReqJson);
        }
        ShenyuUmcRspEntity umcRspEntity = ObjectUtil.isEmpty((Object)(userDetail = this.cacheClient.get(token, true))) ? this.httpCompatible(jwtConfig.getUserInfoService(), token, umcReqJson) : ShenyuUmcRspEntity.builder().code(ShenyuResultEnum.SUCCESS.getCode()).message(ShenyuResultEnum.SUCCESS.getMsg()).data(ShenyuUmcDataEntity.builder().userDetails(userDetail.toString()).build()).build();
        return umcRspEntity;
    }

    private ShenyuUmcRspEntity httpCompatible(String uri, String token, JSONObject requestParam) {
        JSONObject resultJson;
        ShenyuUmcRspEntity umcRspEntity;
        String result;
        try {
            result = ((HttpRequest)HttpRequest.post((String)uri).header("auth-token", token)).body(requestParam.toJSONString()).execute().body();
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            return ShenyuUmcRspEntity.builder().code(ShenyuResultEnum.FAIL.getCode()).message("\u8c03\u7528\u6743\u9650\u63a5\u53e3\u9519\u8bef").build();
        }
        if (StrUtil.isEmpty((CharSequence)result)) {
            return ShenyuUmcRspEntity.builder().code(ShenyuResultEnum.FAIL.getCode()).message("\u6743\u9650\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a").build();
        }
        try {
            umcRspEntity = (ShenyuUmcRspEntity)JSON.parseObject((String)result, ShenyuUmcRspEntity.class);
        }
        catch (Exception e) {
            return ShenyuUmcRspEntity.builder().code(ShenyuResultEnum.FAIL.getCode()).message("\u6743\u9650\u63a5\u53e3\u8fd4\u56de\u683c\u5f0f\u5f02\u5e38").build();
        }
        if (ObjectUtil.isEmpty((Object)umcRspEntity.getCode()) && RESP_CODE_SUCCESS.equals((resultJson = JSON.parseObject((String)result)).getString("respCode"))) {
            umcRspEntity.setCode(ShenyuResultEnum.SUCCESS.getCode());
            umcRspEntity.setData(ShenyuUmcDataEntity.builder().expTime(resultJson.getLong("expTime")).userDetails(resultJson.getString("userDetails")).build());
        }
        return umcRspEntity;
    }

    private Mono<Void> buildErrorResult(ServerWebExchange exchange, String code, String desc) {
        JSONObject respDataJson = new JSONObject();
        respDataJson.put("respCode", (Object)code);
        respDataJson.put("respDesc", (Object)desc);
        Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (int)ShenyuResultEnum.FAIL.getCode(), (String)desc, (Object)respDataJson);
        return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)JSON.toJSONString((Object)error).getBytes(StandardCharsets.UTF_8));
    }

    private boolean whetherNeedVerify(String uri, String staticResources) {
        boolean needToken = true;
        if (uri.contains("noauth")) {
            return false;
        }
        if (StrUtil.isNotEmpty((CharSequence)staticResources)) {
            String[] split;
            for (String staticResource : split = staticResources.split(";")) {
                if (!RegexUtils.wildcardEquals(staticResource, uri)) continue;
                needToken = false;
            }
        }
        if (RegexUtils.wildcardEquals("**/**/users/signup/**", uri)) {
            needToken = false;
        }
        if (RegexUtils.wildcardEquals("**/**/noauth/**", uri)) {
            needToken = false;
        }
        if (RegexUtils.wildcardEquals("**/**/**/noauth/**", uri)) {
            needToken = false;
        }
        if (RegexUtils.wildcardEquals("**/**/api/token/get", uri)) {
            needToken = false;
        }
        return needToken;
    }

    public String named() {
        return PluginEnum.JWT.getName();
    }

    public int getOrder() {
        return PluginEnum.JWT.getCode();
    }

    private String compatible(String token, String authorization) {
        String finalAuthorization;
        if (StrUtil.isNotEmpty((CharSequence)token)) {
            finalAuthorization = token;
        } else if (StrUtil.isNotEmpty((CharSequence)authorization)) {
            finalAuthorization = authorization;
        } else {
            return null;
        }
        return this.isAuth2(finalAuthorization) ? finalAuthorization.split(" ")[1] : finalAuthorization;
    }

    private boolean isAuth2(String authorization) {
        return authorization.contains(AUTH2_TOKEN);
    }

    private Map<String, Object> checkAuthorization(String authorization, String secretKey) {
        if (StrUtil.isEmpty((CharSequence)authorization)) {
            return null;
        }
        JwtParser jwtParser = Jwts.parser();
        if (jwtParser.isSigned(authorization)) {
            jwtParser.setSigningKey(secretKey.getBytes(StandardCharsets.UTF_8));
            Jwt jwt = ThrowingFunction.wrap(() -> jwtParser.parse(authorization));
            if (jwt == null) {
                return null;
            }
            return (Map)jwt.getBody();
        }
        return null;
    }

    private ServerWebExchange converter(ServerWebExchange exchange, Map<String, Object> jwtBody, List<JwtRuleHandle.Convert> converters) {
        ServerHttpRequest modifiedRequest = exchange.getRequest().mutate().headers(httpHeaders -> this.addHeader((HttpHeaders)httpHeaders, jwtBody, converters)).build();
        return exchange.mutate().request(modifiedRequest).build();
    }

    private Mono<Void> injectUserInfo(ShenyuPluginChain chain, ServerWebExchange exchange, Map<String, Object> jwtBody, JSONObject userInfoJson, String token) {
        return DataBufferUtils.join((Publisher)exchange.getRequest().getBody()).flatMap(dataBuffer -> {
            byte[] bytes = new byte[dataBuffer.readableByteCount()];
            dataBuffer.read(bytes);
            DataBufferUtils.release((DataBuffer)dataBuffer);
            String bodyString = new String(bytes, StandardCharsets.UTF_8);
            JSONObject originalParamJSON = JSONObject.parseObject((String)bodyString);
            JSONObject finalParam = new JSONObject(true);
            finalParam.putAll((Map)userInfoJson);
            finalParam.putAll((Map)originalParamJSON);
            finalParam.put("userId", userInfoJson.get((Object)"userId"));
            finalParam.put("memIdIn", userInfoJson.get((Object)"memIdIn"));
            finalParam.put("memIdExt", userInfoJson.get((Object)"memIdExt"));
            finalParam.put("orgId", userInfoJson.get((Object)"orgId"));
            finalParam.put("orgPath", userInfoJson.get((Object)"orgPath"));
            final Flux cachedFlux = Flux.defer(() -> {
                DataBuffer buffer = exchange.getResponse().bufferFactory().wrap(finalParam.toJSONString().getBytes(StandardCharsets.UTF_8));
                return Mono.just((Object)buffer);
            });
            final HttpHeaders headers = new HttpHeaders();
            headers.putAll((Map)exchange.getRequest().getHeaders());
            headers.remove((Object)"Content-Length");
            headers.set("Transfer-Encoding", "chunked");
            ServerHttpRequestDecorator mutatedRequest = new ServerHttpRequestDecorator(exchange.getRequest()){

                public HttpHeaders getHeaders() {
                    HttpHeaders httpHeaders = new HttpHeaders();
                    httpHeaders.putAll((Map)headers);
                    return httpHeaders;
                }

                public Flux<DataBuffer> getBody() {
                    return cachedFlux;
                }
            };
            ServerWebExchange exchangeNew = exchange.mutate().request((ServerHttpRequest)mutatedRequest).build();
            exchangeNew.getAttributes().put("userId", userInfoJson.get((Object)"userId"));
            exchangeNew.getAttributes().put("data", jwtBody);
            exchangeNew.getAttributes().put("auth-token", token);
            exchangeNew.getAttributes().put("verifyContent", this.getVerifyContent(bodyString));
            exchangeNew.getAttributes().put("originalParamJson", originalParamJSON.toJSONString());
            return chain.execute(exchangeNew);
        });
    }

    private Object getVerifyContent(String data) {
        return Md5Utils.md5((String)data.replaceAll("[^a-zA-Z0-9]", ""));
    }

    private void addHeader(HttpHeaders headers, Map<String, Object> body, List<JwtRuleHandle.Convert> converters) {
        for (JwtRuleHandle.Convert converter : converters) {
            if (converter.getJwtVal().contains(".")) {
                headers.add(converter.getHeaderVal(), this.parse(body, converter.getJwtVal().split("\\."), new AtomicInteger(0)));
                continue;
            }
            headers.add(converter.getHeaderVal(), String.valueOf(body.get(converter.getJwtVal())));
        }
    }

    private String parse(Map<String, Object> body, String[] split, AtomicInteger deep) {
        for (Map.Entry<String, Object> entry : body.entrySet()) {
            if (deep.get() == split.length - 1) {
                return String.valueOf(body.get(split[deep.get()]));
            }
            if (!entry.getKey().equals(split[deep.get()]) || !(entry.getValue() instanceof Map)) continue;
            deep.incrementAndGet();
            return this.parse((Map)entry.getValue(), split, deep);
        }
        return String.valueOf(body.get(split[deep.get()]));
    }
}

