/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.kafka;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.plugin.logging.common.AbstractLoggingPlugin;
import org.apache.shenyu.plugin.logging.common.collector.LogCollector;
import org.apache.shenyu.plugin.logging.common.entity.ShenyuRequestLog;
import org.apache.shenyu.plugin.logging.kafka.collector.KafkaLogCollector;
import org.apache.shenyu.springboot.starter.redis.cache.CacheClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.server.ServerWebExchange;

public class LoggingKafkaPlugin
extends AbstractLoggingPlugin<ShenyuRequestLog> {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingKafkaPlugin.class);
    @Resource
    private CacheClient cacheClient;

    protected LogCollector<ShenyuRequestLog> logCollector() {
        return KafkaLogCollector.getInstance();
    }

    public PluginEnum pluginEnum() {
        return PluginEnum.LOGGING_KAFKA;
    }

    protected ShenyuRequestLog doLogExecute(ServerWebExchange exchange, SelectorData selector, RuleData rule) {
        ShenyuRequestLog requestInfo = new ShenyuRequestLog();
        try {
            requestInfo.setUserId((String)exchange.getAttribute("userId"));
            requestInfo.setOriginalParamJson((String)exchange.getAttribute("originalParamJson"));
        }
        catch (Exception e) {
            LOG.info("kafka\u65e5\u5fd7\u83b7\u53d6jwt\u8fc7\u6ee4\u7684\u4fe1\u606f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e);
        }
        if (StringUtils.isNotBlank((CharSequence)rule.getHandle())) {
            JSONObject ruleJson = JSON.parseObject((String)rule.getHandle());
            String businessField = ruleJson.getString("businessField");
            List<String> keyFieldList = Arrays.asList(StringUtils.deleteWhitespace((String)businessField).split(","));
            requestInfo.setKeyFieldList(keyFieldList);
        }
        return requestInfo;
    }
}

