/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.metrics.prometheus;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.HTTPServer;
import io.prometheus.client.hotspot.DefaultExports;
import io.prometheus.jmx.JmxCollector;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MalformedObjectNameException;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.plugin.metrics.spi.MetricsRegister;
import org.apache.shenyu.plugin.metrics.spi.MetricsService;
import org.apache.shenyu.spi.Join;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join
public final class PrometheusMetricsService
implements MetricsService {
    private static final Logger LOG = LoggerFactory.getLogger(PrometheusMetricsService.class);
    private HTTPServer server;
    private final AtomicBoolean registered = new AtomicBoolean(false);

    @Override
    public void start(ShenyuConfig.MetricsConfig metricsConfig, MetricsRegister metricsRegister) {
        this.startServer(metricsConfig);
    }

    @Override
    public void stop() {
        Optional.ofNullable(this.server).ifPresent(server -> {
            server.stop();
            this.registered.set(false);
            CollectorRegistry.defaultRegistry.clear();
        });
    }

    public HTTPServer getServer() {
        return this.server;
    }

    public AtomicBoolean getRegistered() {
        return this.registered;
    }

    private void startServer(ShenyuConfig.MetricsConfig config) {
        this.register(config);
        int port = config.getPort();
        String host = config.getHost();
        InetSocketAddress inetSocketAddress = StringUtils.isEmpty((CharSequence)host) ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
        try {
            this.server = new HTTPServer(inetSocketAddress, CollectorRegistry.defaultRegistry, true);
            LOG.info(String.format("Prometheus metrics HTTP server `%s:%s` start success.", inetSocketAddress.getHostString(), inetSocketAddress.getPort()));
        }
        catch (IOException ex) {
            LOG.error("Prometheus metrics HTTP server start fail", (Throwable)ex);
        }
    }

    private void register(ShenyuConfig.MetricsConfig config) {
        boolean enabled;
        if (!this.registered.compareAndSet(false, true)) {
            return;
        }
        String jvmEnabled = String.valueOf(config.getProps().getProperty("jvm_enabled"));
        if (StringUtils.isNotEmpty((CharSequence)jvmEnabled) && (enabled = Boolean.parseBoolean(jvmEnabled))) {
            DefaultExports.initialize();
        }
        try {
            String jmxConfig = config.getJmxConfig();
            if (!"null".equals(jmxConfig) && StringUtils.isNotEmpty((CharSequence)jmxConfig)) {
                new JmxCollector(jmxConfig).register();
            }
        }
        catch (MalformedObjectNameException e) {
            LOG.error("init jmx collector error", (Throwable)e);
        }
    }
}

