/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.mock;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.StandardCharsets;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.StrGzipUtil;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.springboot.starter.redis.cache.CacheClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class MockPlugin
implements ShenyuPlugin {
    private static final Logger log = LoggerFactory.getLogger(MockPlugin.class);
    private static final String MOCK_FLAG = "mock";
    private static final String MOCK_TRUE = "1";
    private final CacheClient cacheClient;

    public MockPlugin(CacheClient cacheClient) {
        this.cacheClient = cacheClient;
    }

    public Mono<Void> execute(ServerWebExchange exchange, ShenyuPluginChain chain) {
        String requestPath = exchange.getRequest().getURI().getPath();
        requestPath = requestPath.replaceAll("/auto[0-9]{4}", "");
        String mockFlag = exchange.getRequest().getHeaders().getFirst(MOCK_FLAG);
        if (MOCK_TRUE.equals(mockFlag)) {
            log.info("mock\u8c03\u7528");
            Object mockInfo = this.cacheClient.get("SHENYU:MOCK:" + requestPath, false);
            return this.buildMockRspInfo(exchange, mockInfo);
        }
        return chain.execute(exchange);
    }

    private Mono<Void> buildMockRspInfo(ServerWebExchange exchange, Object mockInfo) {
        Object respInfo;
        if (ObjectUtil.isEmpty((Object)mockInfo)) {
            log.info("mock\u4fe1\u606f\u4e3a\u7a7a");
            JSONObject respDataJson = new JSONObject();
            respDataJson.put("respCode", (Object)"8888");
            respDataJson.put("respDesc", (Object)"\u672a\u83b7\u53d6\u5230mock\u4fe1\u606f");
            respInfo = ShenyuResultWrap.error((ServerWebExchange)exchange, (int)ShenyuResultEnum.FAIL.getCode(), (String)"\u672a\u83b7\u53d6\u5230mock\u4fe1\u606f", (Object)respDataJson);
        } else {
            try {
                respInfo = JSON.parseObject((String)StrGzipUtil.decodeAndDecompress((String)mockInfo.toString()));
            }
            catch (Exception e) {
                log.error("\u89e3\u538bmock\u62a5\u6587\u5f02\u5e38\uff1a{}", (Throwable)e);
                JSONObject respDataJson = new JSONObject();
                respDataJson.put("respCode", (Object)"8888");
                respDataJson.put("respDesc", (Object)"\u83b7\u53d6mock\u62a5\u6587\u5f02\u5e38\uff01");
                respInfo = ShenyuResultWrap.error((ServerWebExchange)exchange, (int)ShenyuResultEnum.FAIL.getCode(), (String)"\u83b7\u53d6mock\u62a5\u6587\u5f02\u5e38\uff01", (Object)respDataJson);
            }
        }
        return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)JSON.toJSONString((Object)respInfo).getBytes(StandardCharsets.UTF_8));
    }

    public String named() {
        return PluginEnum.MOCK.getName();
    }

    public int getOrder() {
        return PluginEnum.MOCK.getCode();
    }
}

