/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.motan.subscriber;

import com.google.common.collect.Maps;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.plugin.motan.cache.ApplicationConfigCache;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MotanMetaDataSubscriber
implements MetaDataSubscriber {
    private static final Logger LOG = LoggerFactory.getLogger(MotanMetaDataSubscriber.class);
    private static final ConcurrentMap<String, MetaData> META_DATA = Maps.newConcurrentMap();

    public void onSubscribe(MetaData metaData) {
        try {
            if (RpcTypeEnum.MOTAN.getName().equals(metaData.getRpcType())) {
                MetaData exist = (MetaData)META_DATA.get(metaData.getPath());
                if (Objects.isNull(exist) || Objects.isNull(ApplicationConfigCache.getInstance().get(exist.getPath()).getRef())) {
                    ApplicationConfigCache.getInstance().initRef(metaData);
                } else if (!exist.getServiceName().equals(metaData.getServiceName()) || !exist.getRpcExt().equals(metaData.getRpcExt())) {
                    ApplicationConfigCache.getInstance().build(metaData);
                }
                META_DATA.put(metaData.getPath(), metaData);
            }
        }
        catch (Exception e) {
            LOG.error("motan sync metadata is error [{}]", (Object)metaData, (Object)e);
        }
    }

    public void unSubscribe(MetaData metaData) {
        if (RpcTypeEnum.MOTAN.getName().equals(metaData.getRpcType())) {
            ApplicationConfigCache.getInstance().invalidate(metaData.getPath());
            META_DATA.remove(metaData.getPath());
        }
    }
}

