/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.sign.service;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.crypto.digest.MD5;
import com.alibaba.fastjson.JSON;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.sign.api.SignService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.server.HandlerStrategies;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultSignService
implements SignService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSignService.class);
    private static final String TOKEN = "auth-token";
    private static final String SIGN = "sign";
    private static final String PN = "pn";
    @Value(value="${shenyu.sign.delay:5}")
    private int delay;
    private static final List<HttpMessageReader<?>> MESSAGE_READERS = HandlerStrategies.builder().build().messageReaders();

    @Override
    public Mono<Void> signVerify(ServerWebExchange exchange, ShenyuPluginChain chain) {
        ServerRequest serverRequest = ServerRequest.create((ServerWebExchange)exchange, MESSAGE_READERS);
        if (HttpMethod.POST.equals((Object)serverRequest.method())) {
            return serverRequest.bodyToMono(String.class).flatMap(reqJson -> this.doVerify((String)reqJson, exchange, chain));
        }
        if (HttpMethod.GET.equals((Object)serverRequest.method())) {
            return Mono.just((Object)JSON.toJSONString((Object)serverRequest.exchange().getRequest().getQueryParams().toSingleValueMap())).flatMap(reqJson -> this.doVerify((String)reqJson, exchange, chain));
        }
        Object obj = ShenyuResultWrap.error((ServerWebExchange)exchange, (int)ShenyuResultEnum.ILLEGAL_REQUEST.getCode(), (String)ShenyuResultEnum.ILLEGAL_REQUEST.getMsg(), null);
        return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)obj);
    }

    private Mono<Void> doVerify(String reqJson, ServerWebExchange exchange, ShenyuPluginChain chain) {
        final HttpHeaders headers = exchange.getRequest().getHeaders();
        String token = "";
        if (StringUtils.hasLength((String)exchange.getRequest().getHeaders().getFirst(TOKEN))) {
            token = exchange.getRequest().getHeaders().getFirst(TOKEN);
        } else if (ObjectUtil.isNotEmpty((Object)exchange.getRequest().getCookies().getFirst((Object)TOKEN))) {
            token = ((HttpCookie)exchange.getRequest().getCookies().getFirst((Object)TOKEN)).getValue();
        }
        LOG.info("\u83b7\u53d6\u5230\u7684token\uff1a {}", (Object)token);
        String sourceSin = headers.getFirst(SIGN);
        LOG.info("\u83b7\u53d6\u5230\u7684\u7b7e\u540d\uff1a {}", (Object)sourceSin);
        String pn = headers.getFirst(PN);
        LOG.info("\u83b7\u53d6\u5230\u7684PN\uff1a {}", (Object)pn);
        if (!(StringUtils.hasLength((String)sourceSin) && StringUtils.hasLength((String)token) && StringUtils.hasLength((String)pn))) {
            Object obj = ShenyuResultWrap.error((ServerWebExchange)exchange, (int)ShenyuResultEnum.SIGN_IS_NOT_PASS.getCode(), (String)ShenyuResultEnum.SIGN_IS_NOT_PASS.getMsg(), null);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)obj);
        }
        String buildSign = this.buildSign(reqJson, token, pn);
        LOG.info("\u52a0\u5bc6\u540esign: {}", (Object)buildSign);
        if (sourceSin.equals(buildSign)) {
            LOG.info("\u9a8c\u7b7e\u901a\u8fc7");
            final Flux cachedFlux = Flux.defer(() -> {
                DataBuffer buffer = exchange.getResponse().bufferFactory().wrap(reqJson.getBytes(StandardCharsets.UTF_8));
                return Mono.just((Object)buffer);
            });
            ServerHttpRequestDecorator mutatedRequest = new ServerHttpRequestDecorator(exchange.getRequest()){

                public HttpHeaders getHeaders() {
                    HttpHeaders httpHeaders = new HttpHeaders();
                    httpHeaders.putAll((Map)headers);
                    return httpHeaders;
                }

                public Flux<DataBuffer> getBody() {
                    return cachedFlux;
                }
            };
            return chain.execute(exchange.mutate().request((ServerHttpRequest)mutatedRequest).build());
        }
        Object obj = ShenyuResultWrap.error((ServerWebExchange)exchange, (int)ShenyuResultEnum.SIGN_IS_NOT_PASS.getCode(), (String)ShenyuResultEnum.SIGN_IS_NOT_PASS.getMsg(), null);
        return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)obj);
    }

    public String buildSign(String body, String token, String pn) {
        return DefaultSignService.getSignature(body, token, pn);
    }

    public static String getSignature(String data, String authToken, String pn) {
        StringBuilder sb = new StringBuilder(data).append((CharSequence)new StringBuilder(data).reverse()).append(pn).append(authToken);
        LOG.info("sign\u52a0\u5bc6\u524d\uff1a {}", (Object)sb);
        return new MD5().digestHex(sb.toString(), StandardCharsets.UTF_8);
    }
}

