/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.sign;

import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.sign.api.SignService;
import org.springframework.http.HttpHeaders;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class SignPlugin
extends AbstractShenyuPlugin {
    private final SignService signService;
    private static final String LIC = "lic";
    private static final String LIC_VALUE = "lDZ1V4s20zOjiwpCIuB4qkPEm7gU5csr";

    public SignPlugin(SignService signService) {
        this.signService = signService;
    }

    public String named() {
        return PluginEnum.SIGN.getName();
    }

    public int getOrder() {
        return PluginEnum.SIGN.getCode();
    }

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        HttpHeaders headers = exchange.getRequest().getHeaders();
        String lic = headers.getFirst(LIC);
        if (lic != null && lic.equals(LIC_VALUE)) {
            return chain.execute(exchange);
        }
        return this.signService.signVerify(exchange, chain);
    }
}

